package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueChangeEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueChangeMapper;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueChangeService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 工厂月度实际产值
 * 
 * @author generator
 * 
 */
@Service("pcMonthActualOutputValueChangeService")
public class PcMonthActualOutputValueChangeServiceImpl extends BaseServiceImpl<PcMonthActualOutputValueChangeMapper, PcMonthActualOutputValueChangeEntity> implements IPcMonthActualOutputValueChangeService {

    @Autowired
    private IPcMonthActualOutputValueService pcMonthActualOutputValueService;
    @Autowired
    private IPcMonthActualOutputValueRecordService recordService;
    @Override
    public CommonResponse<PcMonthActualOutputValueChangeVO> saveChange(PcMonthActualOutputValueChangeVO saveorUpdateVO) {
        PcMonthActualOutputValueChangeEntity entity = BeanMapper.map(saveorUpdateVO, PcMonthActualOutputValueChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<PcMonthActualOutputValueChangeEntity> queryWrapper = new QueryWrapper<PcMonthActualOutputValueChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<PcMonthActualOutputValueChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前项目最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<PcMonthActualOutputValueEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", saveorUpdateVO.getProjectId());
        wrapper.eq("year", saveorUpdateVO.getYear());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("month");
        List<PcMonthActualOutputValueEntity> companyUndertakeQuotaList = pcMonthActualOutputValueService.list(wrapper);
        if(companyUndertakeQuotaList!=null && companyUndertakeQuotaList.size()>0){
            if(!saveorUpdateVO.getMonth().equals(companyUndertakeQuotaList.get(0).getMonth())){
                throw new BusinessException("只能变更该工厂最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);
        PcMonthActualOutputValueChangeVO vo = BeanMapper.map(entity, PcMonthActualOutputValueChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        PcMonthActualOutputValueEntity pcMonthActualOutputValueEntity = pcMonthActualOutputValueService.selectById(vo.getDataId());
        pcMonthActualOutputValueEntity.setChangeState("2");//状态改为变更中
        pcMonthActualOutputValueEntity.setChangeId(vo.getId());
        pcMonthActualOutputValueService.saveOrUpdate(pcMonthActualOutputValueEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<PcMonthActualOutputValueChangeVO> vos) {
        for(PcMonthActualOutputValueChangeVO vo : vos){
            PcMonthActualOutputValueChangeEntity entity = this.getById(vo.getId());
            PcMonthActualOutputValueEntity pcMonthActualOutputValueEntity = pcMonthActualOutputValueService.selectById(entity.getDataId());
            QueryWrapper<PcMonthActualOutputValueRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", pcMonthActualOutputValueEntity.getId());
            List<PcMonthActualOutputValueRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                pcMonthActualOutputValueEntity.setChangeState("3");//状态改为已变更
            }else{
                pcMonthActualOutputValueEntity.setChangeState("1");//状态改为未变更
            }
            pcMonthActualOutputValueEntity.setChangeId(null);
            pcMonthActualOutputValueService.saveOrUpdate(pcMonthActualOutputValueEntity, false);
        }
        this.removeByIds(vos.stream().map(PcMonthActualOutputValueChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
