package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.utils.OutputValueUtils;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("projectMonthActualOutputValue")
public class ProjectMonthActualOutputValueBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
	@Autowired
	private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
	@Autowired
	private ICompanyBusinessQuotaService companyBusinessQuotaService;
	@Autowired
	private IProjectSupplementService projectSupplementService;
	@Autowired
	private IZjkjProjectApi projectApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProjectMonthActualOutputValueEntity entity = projectMonthActualOutputValueService.selectById(billId);

		//获取大于当前月份的本项目当年的数据，并进行累计的更新
		QueryWrapper<ProjectMonthActualOutputValueEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("project_id", entity.getProjectId());
		wrapper.eq("year", entity.getYear());
		wrapper.gt("month", entity.getMonth());
		wrapper.orderByAsc("month");
		List<ProjectMonthActualOutputValueEntity> list = projectMonthActualOutputValueService.list(wrapper);
		if(list!=null && list.size()>0){
			if(!list.get(0).getId().equals(billId)){
				//获取本项目本年当前月份之前的累计数据
				Map<String,Object> param = new HashMap<>();
				param.put("projectId", entity.getProjectId());
				param.put("year", entity.getYear());
				param.put("months", OutputValueUtils.getMonths(entity.getMonth()));
				ProjectMonthActualOutputValueVO projectData = projectMonthActualOutputValueMapper.selectSumData(param);

				BigDecimal lastAllMonthActualOutputValue = projectData.getThisMonthActualOutputValue(); // 本年到上月项目累计完成产值（万元）
				BigDecimal lastAllMonthConfirmedOutputValue = projectData.getThisMonthConfirmedOutputValue(); // 本年到上月项目累计确认产值（万元）
				for(ProjectMonthActualOutputValueEntity en : list){
					lastAllMonthActualOutputValue = CommonUtils.addBigDecimal(lastAllMonthActualOutputValue, en.getThisMonthActualOutputValue());
					lastAllMonthConfirmedOutputValue = CommonUtils.addBigDecimal(lastAllMonthConfirmedOutputValue, en.getThisMonthConfirmedOutputValue());
					en.setThisYearAccumulateCompletedOutputValue(lastAllMonthActualOutputValue); // 本年累计完成产值（万元）
					en.setThisYearConfirmedOutputValue(lastAllMonthConfirmedOutputValue); // 本年累计确认产值（万元）
					en.setProjectAccumulatedCompletedOutputValue(lastAllMonthActualOutputValue); // 项目累计完成产值（万元）
					en.setProjectAccumulatedConfirmedOutputValue(lastAllMonthConfirmedOutputValue); // 项目累计确认产值（万元）
				}
				projectMonthActualOutputValueService.saveOrUpdateBatch(list, list.size(), false);
			}
		}

		//更新公司经营指标---先判断该组织是否存在单据，存在则修改
		companyBusinessQuotaService.updateProjectPcInfo(entity.getTwoOrgId(), entity.getYear());

		ProjectSupplementEntity projectSupplement = projectSupplementService.selectById(entity.getProjectId());
		if(!entity.getProjectImageProgress().equals(projectSupplement.getGraphicProgress())){
			projectSupplement.setGraphicProgress(entity.getProjectImageProgress());
			projectSupplementService.saveOrUpdate(projectSupplement, false);
			CommonResponse<ProjectVO> projectResponse = projectApi.queryDetailById(entity.getProjectId());
			if(projectResponse.isSuccess()&&projectResponse.getData()!=null){
				ProjectVO projectVO = projectResponse.getData();
				projectVO.setGraphicProgress(projectSupplement.getGraphicProgress()); // 形象进度
				CommonResponse<ProjectVO> saveback = projectApi.saveProject(projectVO);
				if(!saveback.isSuccess()){
					logger.info("反写项目信息失败----------------->"+saveback.getMsg());
				}
			}else{
				return CommonResponse.error("未查询到项目信息");
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
