package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.mapper.ProjectPcYearBusinessQuotaChangeMapper;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目/工厂年度经营指标（产值）
 * 
 * @author generator
 * 
 */
@Service("projectPcYearBusinessQuotaChangeService")
public class ProjectPcYearBusinessQuotaChangeServiceImpl extends BaseServiceImpl<ProjectPcYearBusinessQuotaChangeMapper, ProjectPcYearBusinessQuotaChangeEntity> implements IProjectPcYearBusinessQuotaChangeService {

    @Autowired
    private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;
    @Autowired
    private IProjectPcYearBusinessQuotaRecordService recordService;
    @Override
    public CommonResponse<ProjectPcYearBusinessQuotaChangeVO> saveChange(ProjectPcYearBusinessQuotaChangeVO saveorUpdateVO) {
        ProjectPcYearBusinessQuotaChangeEntity entity = BeanMapper.map(saveorUpdateVO, ProjectPcYearBusinessQuotaChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ProjectPcYearBusinessQuotaChangeEntity> queryWrapper = new QueryWrapper<ProjectPcYearBusinessQuotaChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ProjectPcYearBusinessQuotaChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前项目最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<ProjectPcYearBusinessQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", saveorUpdateVO.getProjectId());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("year");
        List<ProjectPcYearBusinessQuotaEntity> companyUndertakeQuotaList = projectPcYearBusinessQuotaService.list(wrapper);
        if(companyUndertakeQuotaList!=null && companyUndertakeQuotaList.size()>0){
            if(!saveorUpdateVO.getYear().equals(companyUndertakeQuotaList.get(0).getYear())){
                throw new BusinessException("只能变更该项目/工厂最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);
        ProjectPcYearBusinessQuotaChangeVO vo = BeanMapper.map(entity, ProjectPcYearBusinessQuotaChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity = projectPcYearBusinessQuotaService.selectById(vo.getDataId());
        projectPcYearBusinessQuotaEntity.setChangeState("2");//状态改为变更中
        projectPcYearBusinessQuotaEntity.setChangeId(vo.getId());
        projectPcYearBusinessQuotaService.saveOrUpdate(projectPcYearBusinessQuotaEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ProjectPcYearBusinessQuotaChangeVO> vos) {
        for(ProjectPcYearBusinessQuotaChangeVO vo : vos){
            ProjectPcYearBusinessQuotaChangeEntity entity = this.getById(vo.getId());
            ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity = projectPcYearBusinessQuotaService.selectById(entity.getDataId());
            QueryWrapper<ProjectPcYearBusinessQuotaRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", projectPcYearBusinessQuotaEntity.getId());
            List<ProjectPcYearBusinessQuotaRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                projectPcYearBusinessQuotaEntity.setChangeState("3");//状态改为已变更
            }else{
                projectPcYearBusinessQuotaEntity.setChangeState("1");//状态改为未变更
            }
            projectPcYearBusinessQuotaEntity.setChangeId(null);
            projectPcYearBusinessQuotaService.saveOrUpdate(projectPcYearBusinessQuotaEntity, false);
        }
        this.removeByIds(vos.stream().map(ProjectPcYearBusinessQuotaChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
