package com.ejianc.business.outputValue.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EasyExcelUtil {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //表头
    private String title;
    //各个列的表头
    private String[] heardList;
    //各个列的表头
    private List<List<String>> heardListData;
    //各个列的元素key值
    private List<String> heardKey;
    //需要填充的数据信息
    private List<JSONObject> data;
    //字体大小
    private int fontSize = 14;
    //行高
    private int rowHeight = 30;
    //列宽
    private int columWidth = 200;
    //工作表
    private String sheetName;
    private ExcelFillCellMerge mergePrevCol;
    private List<String> fieldFormat;

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");

    //字段格式化
    public List<String> getFieldFormat() {
        return fieldFormat;
    }

    public void setFieldFormat(List<String> fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getHeardList() {
        return heardList;
    }

    public void setHeardList(String[] heardList) {
        this.heardList = heardList;
    }

    public List<List<String>> getHeardListData() {
        return heardListData;
    }

    public void setHeardListData(List<List<String>> heardListData) {
        this.heardListData = heardListData;
    }

    public List<String> getHeardKey() {
        return heardKey;
    }

    public void setHeardKey(List<String> heardKey) {
        this.heardKey = heardKey;
    }

    public List<JSONObject> getData() {
        return data;
    }

    public void setData(List<JSONObject> data) {
        this.data = data;
    }

    public int getFontSize() {
        return fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getRowHeight() {
        return rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getColumWidth() {
        return columWidth;
    }

    public void setColumWidth(int columWidth) {
        this.columWidth = columWidth;
    }

    public ExcelFillCellMerge getMergePrevCol() {
        return mergePrevCol;
    }

    public void setMergePrevCol(ExcelFillCellMerge mergePrevCol) {
        this.mergePrevCol = mergePrevCol;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    /**
     * 开始导出数据信息
     *
     */
    public void exportExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        // 注意 simpleWrite在数据量不大的情况下可以使用（5000以内，具体也要看实际情况），数据量大参照 重复多次写入

        String fileName = System.currentTimeMillis() + ".xlsx";

        //设置Http响应头告诉浏览器下载这个附件
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment;Filename=" + fileName);
        response.flushBuffer();
        OutputStream outputStream = null;
        //合并
//        ExcelFillCellMerge mergePrevCol = new ExcelFillCellMerge();
//        mergePrevCol.addRow(3,4,2);//第4行，从第5列开始合并三行
//        mergePrevCol.addCol(5,5,2);//第6行，从第6列开始合并3列
//        mergePrevCol.addCol(5,6,3);//第6行，从第7列开始合并4列
//        mergePrevCol.addCol(5,7,4);//第6行，从第8列开始合并5列
//        mergePrevCol.addAll(11,3,4, 2);//第6行，从第8列开始合并5列
        try{
            outputStream = response.getOutputStream();
            EasyExcel.write(outputStream)
                    .head(head())
                    .autoCloseStream(false)
                    .sheet(sheetName)
                    .registerWriteHandler(new Custemhandler())
                    .registerWriteHandler(mergePrevCol)
                    .registerWriteHandler(getStyleStrategy()).registerWriteHandler(new AbstractColumnWidthStyleStrategy() {
                        @Override
                        protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {

                        }
                    }).doWrite(dataList());
        }catch (Exception e) {
            logger.info("导出数据错误：{}",e);
            throw new BusinessException("导出Excel出现异常");
            // 处理异常
        } finally {
            if(outputStream  != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }
    private List<List<String>> head() {
        List<List<String>> list = ListUtils.newArrayList();
        if(heardListData!=null && heardListData.size()>0){
            for (int i = 0; i < heardListData.size(); i++) {
                List<String> head = ListUtils.newArrayList();
                if(StringUtils.isNotBlank(sheetName)){
                    head.add(sheetName);
                }
                head.addAll(heardListData.get(i));
                list.add(head);
            }
        }else{
            for (int i = 0; i < heardList.length; i++) {
                List<String> head = ListUtils.newArrayList();
                if(StringUtils.isNotBlank(sheetName)){
                    head.add(sheetName);
                }
                head.add(heardList[i]);
                list.add(head);
            }
        }
        return list;
    }
    private List<List<Object>> dataList() {
        List<List<Object>> list = ListUtils.newArrayList();

        for (int i = 0; i < data.size(); i++) {
            List<Object> dat = ListUtils.newArrayList();
            JSONObject json = data.get(i);
            for (int j = 0; j < heardKey.size(); j++) {
                Object valueObject = json.get(heardKey.get(j));
                String value = null;
                if (valueObject == null) {
                    valueObject = "";
                }
                if (valueObject instanceof String) {
                    //取出的数据是字符串直接赋值
                    value = (String) json.get(heardKey.get(j));
                } else if (valueObject instanceof Integer) {
                    //取出的数据是Integer
                    value = String.valueOf(((Integer) (valueObject)).floatValue());
                } else if (valueObject instanceof Number) {
                    value = new BigDecimal(valueObject.toString()).toPlainString();
                } else {
                    value = valueObject.toString();
                }

                value = formatField(value, fieldFormat.get(j));
                if (valueObject instanceof Number) {
                    if(StringUtils.isNotEmpty(value)){
                        if (valueObject instanceof Integer) {
                            dat.add((Integer)valueObject);
                        }else {
                            String valueStr = value.replaceAll(",", ""); // 删除逗号
                            if(StringUtils.isEmpty(value)){
                                valueStr = "0.00";
                            }
                            dat.add(new Double(valueStr));
                        }
                    }else{
                        dat.add(json.get(heardKey.get(j)));
                    }
                }else {
                    dat.add(Strings.isNullOrEmpty(value) ? "" : value);
                }
            }
            list.add(dat);
        }
        return list;
    }

    private String formatField(String value, String format) {
        String result = null;
        if(StringUtils.isBlank(value) || StringUtils.isBlank(format)) {
            return value;
        }
        try {
            switch (format) {
                case "twoDecimalNumbers":
                    result = new BigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    break;
                case "threeDecimalNumbers":
                    result = new BigDecimal(value).setScale(3, BigDecimal.ROUND_HALF_UP).toString();
                    break;
                case "fourDecimalNumbers":
                    result = new BigDecimal(value).setScale(4, BigDecimal.ROUND_HALF_UP).toString();
                    break;
                case "integer":
                    result = new BigDecimal(value).setScale(0, BigDecimal.ROUND_HALF_UP).toString();
                    break;
                case "mnyFormat":
                    result = decimalFormat.format( new BigDecimal(value).setScale(6, BigDecimal.ROUND_HALF_UP));
                    break;
                case "yyyy-MM-dd":
//                    result = dateFormat.format(dateFormat.parse(value));
                    result = value;
                    break;
                case "yyyy-MM-dd HH:mm:ss":
                    result = dateTimeFormat.format(dateTimeFormat.parse(value));
                    break;
                case "string":
                default:
                    result = value;
                    break;
            }
        } catch (Exception e) {
            logger.error("依据模式[{}],格式化格式化[{}]异常：", format, value, e);
            return value;
        }
        return result;
    }

    //样式设置
    public static HorizontalCellStyleStrategy getStyleStrategy() {
        // 头的策略
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        // 背景设置
//        headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE1.getIndex());//白色
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints((short) 10);
        // 字体样式
        headWriteFont.setFontName("Arial Unicode MS");
//        headWriteFont.setBold(false); // 取消加粗
        // 字体设置成红色
        // headWriteFont.setColor(IndexedColors.RED.getIndex());
        headWriteCellStyle.setWriteFont(headWriteFont);
        // 自动换行
        headWriteCellStyle.setWrapped(true);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);//右边框
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);//左
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);//底
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        // 水平对齐方式
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        // 垂直对齐方式
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        // 内容的策略
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        // 这里需要指定 FillPatternType 为FillPatternType.SOLID_FOREGROUND 不然无法显示背景颜色.头默认了
        // FillPatternType所以可以不指定
        // contentWriteCellStyle.setFillPatternType(FillPatternType.SQUARES);
        // 背景白色
        contentWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        contentWriteCellStyle.setWrapped(true);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);//右边框
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);//左
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);//底
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        // 垂直对齐方式
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);

        WriteFont contentWriteFont = new WriteFont();

        // 字体大小
        contentWriteFont.setFontHeightInPoints((short) 10);
        // 字体样式
        contentWriteFont.setFontName("Arial Unicode MS");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}
