package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目月度计划产值
 *
 * @author generator
 *
 */
public class ProjectMonthActualOutputValueChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String changeReason; // 变更原因
    private Long dataId; // 项目补充信息id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long twoOrgId; // 二级组织
    private String twoOrgName; // 二级组织名称
    private String year; // 年度
    private String month; // 月份
    private String projectImageProgress; // 项目形象进度

    private Long thisMonthPresenceManagementPersonNum; //本月在场管理人员数量
    private Long thisMonthPresenceLaborPersonNum; // 本月在场劳务人员数量
    private BigDecimal nextMonthPlanCompletedOutputValue; // 下月计划完成产值（万元）
    private BigDecimal nextMonthConfirmedOutputValue; // 下月计划确认产值（万元）
    private BigDecimal thisMonthCommerceActualCompletedOutputValue; // 本月商务系统实际完成产值（万元）
    private BigDecimal thisMonthActualOutputValue; // 本月实际完成产值（万元）
    private BigDecimal thisMonthConfirmedOutputValue; // 本月确认产值（万元）
    private BigDecimal yearTargetOutputValue; // '年度目标产值'
    private BigDecimal yearTargetOutputValueMargin; // 年度目标产值余量
    private BigDecimal thisYearAccumulateCompletedOutputValue; // 本年累计完成产值（万元）
    private BigDecimal thisYearConfirmedOutputValue; // 本年累计确认产值（万元）
    private BigDecimal projectAccumulatedCompletedOutputValue; // 项目累计完成产值（万元）
    private BigDecimal projectAccumulatedConfirmedOutputValue; // 项目累计确认产值（万元）
    private String rewardPunishmentSituation; // '奖罚情况'
    private String remarks; // '备注'

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    /********额外计算字段********/
    private BigDecimal lastAllMonthActualOutputValue; // 本年到上月项目累计完成产值（万元）
    private BigDecimal lastAllMonthConfirmedOutputValue; // 本年到上月项目累计确认产值（万元）

    private List<ProjectMonthActualOutputValueRecordVO> recordList = new ArrayList<>();

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getProjectImageProgress() {
        return projectImageProgress;
    }

    public void setProjectImageProgress(String projectImageProgress) {
        this.projectImageProgress = projectImageProgress;
    }

    public Long getThisMonthPresenceManagementPersonNum() {
        return thisMonthPresenceManagementPersonNum;
    }

    public void setThisMonthPresenceManagementPersonNum(Long thisMonthPresenceManagementPersonNum) {
        this.thisMonthPresenceManagementPersonNum = thisMonthPresenceManagementPersonNum;
    }

    public Long getThisMonthPresenceLaborPersonNum() {
        return thisMonthPresenceLaborPersonNum;
    }

    public void setThisMonthPresenceLaborPersonNum(Long thisMonthPresenceLaborPersonNum) {
        this.thisMonthPresenceLaborPersonNum = thisMonthPresenceLaborPersonNum;
    }

    public BigDecimal getNextMonthPlanCompletedOutputValue() {
        return nextMonthPlanCompletedOutputValue;
    }

    public void setNextMonthPlanCompletedOutputValue(BigDecimal nextMonthPlanCompletedOutputValue) {
        this.nextMonthPlanCompletedOutputValue = nextMonthPlanCompletedOutputValue;
    }

    public BigDecimal getNextMonthConfirmedOutputValue() {
        return nextMonthConfirmedOutputValue;
    }

    public void setNextMonthConfirmedOutputValue(BigDecimal nextMonthConfirmedOutputValue) {
        this.nextMonthConfirmedOutputValue = nextMonthConfirmedOutputValue;
    }

    public BigDecimal getThisMonthCommerceActualCompletedOutputValue() {
        return thisMonthCommerceActualCompletedOutputValue;
    }

    public void setThisMonthCommerceActualCompletedOutputValue(BigDecimal thisMonthCommerceActualCompletedOutputValue) {
        this.thisMonthCommerceActualCompletedOutputValue = thisMonthCommerceActualCompletedOutputValue;
    }

    public BigDecimal getThisMonthActualOutputValue() {
        return thisMonthActualOutputValue;
    }

    public void setThisMonthActualOutputValue(BigDecimal thisMonthActualOutputValue) {
        this.thisMonthActualOutputValue = thisMonthActualOutputValue;
    }

    public BigDecimal getThisMonthConfirmedOutputValue() {
        return thisMonthConfirmedOutputValue;
    }

    public void setThisMonthConfirmedOutputValue(BigDecimal thisMonthConfirmedOutputValue) {
        this.thisMonthConfirmedOutputValue = thisMonthConfirmedOutputValue;
    }

    public BigDecimal getYearTargetOutputValue() {
        return yearTargetOutputValue;
    }

    public void setYearTargetOutputValue(BigDecimal yearTargetOutputValue) {
        this.yearTargetOutputValue = yearTargetOutputValue;
    }

    public BigDecimal getYearTargetOutputValueMargin() {
        return yearTargetOutputValueMargin;
    }

    public void setYearTargetOutputValueMargin(BigDecimal yearTargetOutputValueMargin) {
        this.yearTargetOutputValueMargin = yearTargetOutputValueMargin;
    }

    public BigDecimal getThisYearAccumulateCompletedOutputValue() {
        return thisYearAccumulateCompletedOutputValue;
    }

    public void setThisYearAccumulateCompletedOutputValue(BigDecimal thisYearAccumulateCompletedOutputValue) {
        this.thisYearAccumulateCompletedOutputValue = thisYearAccumulateCompletedOutputValue;
    }

    public BigDecimal getThisYearConfirmedOutputValue() {
        return thisYearConfirmedOutputValue;
    }

    public void setThisYearConfirmedOutputValue(BigDecimal thisYearConfirmedOutputValue) {
        this.thisYearConfirmedOutputValue = thisYearConfirmedOutputValue;
    }

    public BigDecimal getProjectAccumulatedCompletedOutputValue() {
        return projectAccumulatedCompletedOutputValue;
    }

    public void setProjectAccumulatedCompletedOutputValue(BigDecimal projectAccumulatedCompletedOutputValue) {
        this.projectAccumulatedCompletedOutputValue = projectAccumulatedCompletedOutputValue;
    }

    public BigDecimal getProjectAccumulatedConfirmedOutputValue() {
        return projectAccumulatedConfirmedOutputValue;
    }

    public void setProjectAccumulatedConfirmedOutputValue(BigDecimal projectAccumulatedConfirmedOutputValue) {
        this.projectAccumulatedConfirmedOutputValue = projectAccumulatedConfirmedOutputValue;
    }

    public String getRewardPunishmentSituation() {
        return rewardPunishmentSituation;
    }

    public void setRewardPunishmentSituation(String rewardPunishmentSituation) {
        this.rewardPunishmentSituation = rewardPunishmentSituation;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }

    public BigDecimal getLastAllMonthActualOutputValue() {
        return lastAllMonthActualOutputValue;
    }

    public void setLastAllMonthActualOutputValue(BigDecimal lastAllMonthActualOutputValue) {
        this.lastAllMonthActualOutputValue = lastAllMonthActualOutputValue;
    }

    public BigDecimal getLastAllMonthConfirmedOutputValue() {
        return lastAllMonthConfirmedOutputValue;
    }

    public void setLastAllMonthConfirmedOutputValue(BigDecimal lastAllMonthConfirmedOutputValue) {
        this.lastAllMonthConfirmedOutputValue = lastAllMonthConfirmedOutputValue;
    }

    public List<ProjectMonthActualOutputValueRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ProjectMonthActualOutputValueRecordVO> recordList) {
        this.recordList = recordList;
    }
}
