package com.ejianc.business.panhuo.cart.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.cart.bean.ShopCartEntity;
import com.ejianc.business.panhuo.cart.service.IShopCartService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.cart.vo.CartVO;
import com.ejianc.foundation.panhuo.cart.vo.ShopCartVO;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 购物车
 *
 * @author generator
 */
@Controller
@RequestMapping("shopCart")
public class ShopCartController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IShopCartService service;

    @Autowired
    private IGoodsService goodsService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShopCartVO> saveOrUpdate(@RequestBody ShopCartVO saveOrUpdateVO) {
        ShopCartEntity entity = BeanMapper.map(saveOrUpdateVO, ShopCartEntity.class);

        if(entity.getId() == null || entity.getId() == 0){
          QueryWrapper<ShopCartEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("market_id",entity.getMarketId());
            queryWrapper.eq("pur_user_id",entity.getPurUserId());
            int count = service.count(queryWrapper);
            if (count>0){
                throw new BusinessException("当前物资已加入购物车！");
            }
        }
        service.saveOrUpdate(entity, false);
        ShopCartVO vo = BeanMapper.map(entity, ShopCartVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @RequestMapping(value = "/queryGoodsByPurUserId", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<GoodsEntity>> queryGoodsByPurUserId(Long purUserId) {
        return service.queryGoodsByPurUserId(purUserId);
    }
    @RequestMapping(value = "/queryCountByPurUserId", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<Integer> queryCountByPurUserId(Long purUserId) {
        return service.queryCountByPurUserId(purUserId);
    }


    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShopCartVO> queryDetail(Long id) {
        ShopCartEntity entity = service.selectById(id);
        ShopCartVO vo = BeanMapper.map(entity, ShopCartVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShopCartVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShopCartVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ShopCartVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * 购物车提交接口
     */
    @RequestMapping(value = "/addAllotApply", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotApplyVO> addAllotApply(@RequestBody List<ShopCartVO> vos) {
        AllotApplyVO allotApplyVO = service.addAllotApply(vos);
        return CommonResponse.success(allotApplyVO);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<List<CartVO>>> queryList(@RequestBody QueryParam param) {
        QueryParam queryParam = new QueryParam();

        List<List<CartVO>> list = new ArrayList<>();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("pur_user_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));

        List<ShopCartEntity> shopCartEntities = service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(shopCartEntities)) {
            Map<Long, ShopCartEntity> collect = shopCartEntities.stream().collect(Collectors.toMap(ShopCartEntity::getMarketId, e -> e));
            List<Long> collect1 = shopCartEntities.stream().map(e -> e.getMarketId()).collect(Collectors.toList());
            //获取到对应的物资闲置
            QueryParam queryGoods = new QueryParam();
            queryGoods.setSearchText(param.getSearchText());
            List<String> fuzzyFields = queryGoods.getFuzzyFields();
            fuzzyFields.add("materialName");
            fuzzyFields.add("propertyValue");
            fuzzyFields.add("projectName");
            fuzzyFields.add("cloudStoreName");
            fuzzyFields.add("brandName");
            fuzzyFields.add("sellUserName");
            queryGoods.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryGoods.getParams().put("id", new Parameter(QueryParam.IN, collect1));
            List<GoodsEntity> goodsEntities = goodsService.queryList(queryGoods);
            if (CollectionUtils.isNotEmpty(goodsEntities)) {
                List<GoodsVO> goods = BeanMapper.mapList(goodsEntities, GoodsVO.class);
                //根据来源进行分组
                Map<Long, List<GoodsVO>> groupMap = goods.stream().collect(Collectors.groupingBy(GoodsVO::getOrgId));

                for (Map.Entry<Long, List<GoodsVO>> entity : groupMap.entrySet()) {
                    if (CollectionUtils.isNotEmpty(entity.getValue())) {
                        List<GoodsVO> value = entity.getValue();
                        List<CartVO> cartVos = BeanMapper.mapList(value, CartVO.class);
                        for (CartVO cartVo : cartVos) {
                            BigDecimal num = cartVo.getNum();//上架数量
                            BigDecimal allotedNum = cartVo.getAllotedNum();//已生效订单量
                            BigDecimal allotNum = cartVo.getAllotNum();//调拨中数量
                            BigDecimal decimal = ComputeUtil.safeSub(num, allotedNum);
                            decimal = ComputeUtil.safeSub(decimal, allotNum);
                            if (collect.containsKey(cartVo.getId())){
                                ShopCartEntity shopCartEntity = collect.get(cartVo.getId());
                                cartVo.setAllotNum(shopCartEntity.getAllotNum());
                                BigDecimal decimal1 = ComputeUtil.safeMultiply(shopCartEntity.getAllotNum(),cartVo.getTaxPrice());
                                cartVo.setOrderTaxMny(decimal1);
                                cartVo.setCartId(shopCartEntity.getId());
                            }
                            cartVo.setResSellNum(decimal);//可下单数量
                        }
                        list.add(cartVos);
                    }
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！", list);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ShopCartEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ShopCart-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refShopCartData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShopCartVO>> refShopCartData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ShopCartEntity> page = service.queryPage(param, false);
        IPage<ShopCartVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShopCartVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
