package com.ejianc.business.panhuo.order.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 调拨订单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_allot_order")
public class AllotOrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode;//订单编码
    @TableField(value="allot_apply_id")
    private Long allotApplyId; // 调拨申请id
    @TableField(value="in_project_id")
    private Long inProjectId; // 调入方项目id
    @TableField(value="in_project_name")
    private String inProjectName; // 调入方项目名称
    @TableField(value="in_project_code")
    private String inProjectCode; // 调入方项目编码
    @TableField(value = "in_project_address")
    private String inProjectAddress; // 调入项目地址
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入方单据组织id
    @TableField(value="in_org_name")
    private String inOrgName; // 调入方单据组织名称
    @TableField(value="in_org_code")
    private String inOrgCode; // 调入方单据组织编码
    @TableField(value="in_parent_org_id")
    private Long inParentOrgId; // 调入方上级组织id
    @TableField(value="in_parent_org_name")
    private String inParentOrgName; // 调入方上级组织名称
    @TableField(value="in_parent_org_code")
    private String inParentOrgCode; // 调入方上级组织编码
    @TableField(value="in_corp_id")
    private Long inCorpId; // 调入方执行单位id
    @TableField(value="in_corp_name")
    private String inCorpName; // 调入方执行单位名称
    @TableField(value="in_corp_code")
    private String inCorpCode; // 调入方执行单位编码
    @TableField(value="out_project_id")
    private Long outProjectId; // 调出方项目id
    @TableField(value="out_project_name")
    private String outProjectName; // 调出方项目名称
    @TableField(value="out_project_code")
    private String outProjectCode; // 调出方项目编码
    @TableField(value="out_org_id")
    private Long outOrgId; // 调出方单据组织id
    @TableField(value="out_org_name")
    private String outOrgName; // 调出方单据组织名称
    @TableField(value="out_org_code")
    private String outOrgCode; // 调出方单据组织编码
    @TableField(value="out_parent_org_id")
    private Long outParentOrgId; // 调出方上级组织id
    @TableField(value="out_parent_org_name")
    private String outParentOrgName; // 调出方上级组织名称
    @TableField(value="out_parent_org_code")
    private String outParentOrgCode; // 调出方上级组织编码
    @TableField(value = "store_type")
    private Integer storeType; //调出仓库类型：1-项目仓，2-大区仓
    @TableField(value="category_names")
    private String categoryNames; // 物资分类
    @TableField(value="pur_user_id")
    private Long purUserId; // 预订人id
    @TableField(value="pur_user_name")
    private String purUserName; // 预订人名称
    @TableField(value="pur_user_code")
    private String purUserCode; // 预订人编码
    @TableField(value="pur_user_phone")
    private String purUserPhone; // 预订人手机号
    @TableField(value="pur_time")
    private Date purTime; // 预订时间: 默认取调拨申请生效时间，不可编辑
    @TableField(value="business_status")
    private Integer businessStatus; // 1-调出方待确认，2-调入方洽商待确认，3-调入方洽商已确认，4-调出方审批中，5-调入方待收货，6-交易完成， 7-调出方取消，8-调入方取消
    @TableField(value="cancel_user_id")
    private Long cancelUserId; // 取消人id
    @TableField(value="cancel_user_name")
    private String cancelUserName; // 取消人名称
    @TableField(value="cancel_user_code")
    private String cancelUserCode; // 取消人编码
    @TableField(value="cancel_time")
    private Date cancelTime; // 取消时间
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="commit_user_id")
    private Long commitUserId; // 提交人主键
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人编码
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="effect_date")
    private Date effectDate; // 生效日期
    @TableField(value="edit_num")
    private Integer editNum; // 订单修订次数
    @TableField(value = "edit_user_id")
    private Long editUserId; //修改用户Id
    @TableField(value = "edit_user_name")
    private String editUserName; //修改用户名称
    @TableField(value="total_allot_tax_mny")
    private BigDecimal totalAllotTaxMny; // 调拨金额（含税）
    @TableField(value="total_allot_mny")
    private BigDecimal totalAllotMny; // 调拨金额
    @TableField(value="total_asset_tax_mny")
    private BigDecimal totalAssetTaxMny; // 资产金额（含税）
    @TableField(value="total_asset_mny")
    private BigDecimal totalAssetMny; // 资产金额
    @TableField(value = "in_store_id")
    private Long inStoreId; // 调入仓库Id
    @TableField(value = "in_store_name")
    private String inStoreName; // 调入仓库名称
    @TableField(value = "in_store_attr_flag")
    private Integer inStoreAttrFlag; // 调入仓库属性  1-主材库；2-临建材库，3-甲供材库，4-实际仓

    @TableField(exist=false)
    @SubEntity(serviceName="allotOrderDetailService", pidName = "orderId")
    private List<AllotOrderDetailEntity> allotOrderDetailList = new ArrayList<>(); // 调拨订单明细表

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Integer getInStoreAttrFlag() {
        return inStoreAttrFlag;
    }

    public void setInStoreAttrFlag(Integer inStoreAttrFlag) {
        this.inStoreAttrFlag = inStoreAttrFlag;
    }

    //导出使用
    @TableField(exist = false)
    private String businessStatusName; //订单状态显示名

    public String getInProjectAddress() {
        return inProjectAddress;
    }

    public void setInProjectAddress(String inProjectAddress) {
        this.inProjectAddress = inProjectAddress;
    }

    public Long getEditUserId() {
        return editUserId;
    }

    public void setEditUserId(Long editUserId) {
        this.editUserId = editUserId;
    }

    public String getEditUserName() {
        return editUserName;
    }

    public void setEditUserName(String editUserName) {
        this.editUserName = editUserName;
    }

    public String getBusinessStatusName() {
        return businessStatusName;
    }

    public void setBusinessStatusName(String businessStatusName) {
        this.businessStatusName = businessStatusName;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getAllotApplyId() {
        return allotApplyId;
    }

    public void setAllotApplyId(Long allotApplyId) {
        this.allotApplyId = allotApplyId;
    }
    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    public String getInProjectCode() {
        return inProjectCode;
    }

    public void setInProjectCode(String inProjectCode) {
        this.inProjectCode = inProjectCode;
    }
    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }
    public String getInParentOrgName() {
        return inParentOrgName;
    }

    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }
    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }
    public Long getInCorpId() {
        return inCorpId;
    }

    public void setInCorpId(Long inCorpId) {
        this.inCorpId = inCorpId;
    }
    public String getInCorpName() {
        return inCorpName;
    }

    public void setInCorpName(String inCorpName) {
        this.inCorpName = inCorpName;
    }
    public String getInCorpCode() {
        return inCorpCode;
    }

    public void setInCorpCode(String inCorpCode) {
        this.inCorpCode = inCorpCode;
    }
    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public String getOutProjectCode() {
        return outProjectCode;
    }

    public void setOutProjectCode(String outProjectCode) {
        this.outProjectCode = outProjectCode;
    }
    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }
    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }
    public Long getOutParentOrgId() {
        return outParentOrgId;
    }

    public void setOutParentOrgId(Long outParentOrgId) {
        this.outParentOrgId = outParentOrgId;
    }
    public String getOutParentOrgName() {
        return outParentOrgName;
    }

    public void setOutParentOrgName(String outParentOrgName) {
        this.outParentOrgName = outParentOrgName;
    }
    public String getOutParentOrgCode() {
        return outParentOrgCode;
    }

    public void setOutParentOrgCode(String outParentOrgCode) {
        this.outParentOrgCode = outParentOrgCode;
    }
    public String getCategoryNames() {
        return categoryNames;
    }

    public void setCategoryNames(String categoryNames) {
        this.categoryNames = categoryNames;
    }
    public Long getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(Long purUserId) {
        this.purUserId = purUserId;
    }
    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName;
    }
    public String getPurUserCode() {
        return purUserCode;
    }

    public void setPurUserCode(String purUserCode) {
        this.purUserCode = purUserCode;
    }
    public String getPurUserPhone() {
        return purUserPhone;
    }

    public void setPurUserPhone(String purUserPhone) {
        this.purUserPhone = purUserPhone;
    }
    public Date getPurTime() {
        return purTime;
    }

    public void setPurTime(Date purTime) {
        this.purTime = purTime;
    }
    public Integer getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(Integer businessStatus) {
        this.businessStatus = businessStatus;
    }
    public Long getCancelUserId() {
        return cancelUserId;
    }

    public void setCancelUserId(Long cancelUserId) {
        this.cancelUserId = cancelUserId;
    }
    public String getCancelUserName() {
        return cancelUserName;
    }

    public void setCancelUserName(String cancelUserName) {
        this.cancelUserName = cancelUserName;
    }
    public String getCancelUserCode() {
        return cancelUserCode;
    }

    public void setCancelUserCode(String cancelUserCode) {
        this.cancelUserCode = cancelUserCode;
    }
    public Date getCancelTime() {
        return cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public Integer getEditNum() {
        return editNum;
    }

    public void setEditNum(Integer editNum) {
        this.editNum = editNum;
    }
    public BigDecimal getTotalAllotTaxMny() {
        return totalAllotTaxMny;
    }

    public void setTotalAllotTaxMny(BigDecimal totalAllotTaxMny) {
        this.totalAllotTaxMny = totalAllotTaxMny;
    }
    public BigDecimal getTotalAssetTaxMny() {
        return totalAssetTaxMny;
    }

    public void setTotalAssetTaxMny(BigDecimal totalAssetTaxMny) {
        this.totalAssetTaxMny = totalAssetTaxMny;
    }

    public List<AllotOrderDetailEntity> getAllotOrderDetailList() {
        return allotOrderDetailList;
    }

    public void setAllotOrderDetailList(List<AllotOrderDetailEntity> allotOrderDetailList) {
        this.allotOrderDetailList = allotOrderDetailList;
    }

    public BigDecimal getTotalAllotMny() {
        return totalAllotMny;
    }

    public void setTotalAllotMny(BigDecimal totalAllotMny) {
        this.totalAllotMny = totalAllotMny;
    }

    public BigDecimal getTotalAssetMny() {
        return totalAssetMny;
    }

    public void setTotalAssetMny(BigDecimal totalAssetMny) {
        this.totalAssetMny = totalAssetMny;
    }
}
