package com.ejianc.business.panhuo.order.service;

import com.ejianc.business.panhuo.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderVO;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 调拨订单
 * 
 * @author generator
 * 
 */
public interface IAllotOrderService extends IBaseService<AllotOrderEntity> {

    /**
     * 根据调拨申请拆分生成新调拨订单
     *
     * @param allotApplyVO
     * @return
     */
    void saveNewOrderByApply(AllotApplyVO allotApplyVO);

    /**
     * 根据调拨申请撤回对应调拨订单信息
     *
     * @param allotApplyId
     */
    void deleteOrderByApply(Long allotApplyId);

    /**
     * 调出方编辑保存
     *
     * @param entity
     * @return
     */
    AllotOrderVO saveEditAllotOrderInfo(AllotOrderEntity entity);

    void cancelOrder(AllotOrderEntity order);

    /**
     * 调入方确认订单
     *
     * @param id
     */
    void confirmOrder(Long id);

    /**
     * 订单状态变化发送消息
     *
     * @param parameter
     * @param allotOrderId
     * @param oprMsg
     */
    void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg);

    /**
     * 调入方收货入库保存
     *
     * @param entity
     * @return
     */
    AllotOrderVO saveOrderInStore(AllotOrderEntity entity);

    void checkAllotableNum(List<AllotOrderDetailEntity> allotOrderDetailList);

    List<GoodsVO> getUpdateGoodList(List<AllotOrderDetailEntity> allotOrderDetailList, String oprType, String allotType);

    AllotOrderVO saveOrderInStoreEdit(AllotOrderEntity entity);

    void saveOrderOutStore(AllotOrderEntity orderEntity);

    //生成调拨单
    void saveTransfor(AllotOrderEntity entity);

    void sendOutStoreData(AllotOrderEntity entity);

//    void sendIdleStoreData(AllotOrderEntity entity);
}
