package com.ejianc.business.panhuo.order.service.impl;

import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.foundation.panhuo.constants.CommonConstants;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("allotOrder")
public class AllotOrderBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IAllotOrderService service;

	@Autowired
	private SessionManager sessionManager;

	@Value("${common.env.base-host}")
	private String BASE_HOST;

	@Autowired
	private IGoodsService goodsService;

    @Autowired
    private ITransferorderService transferorderService;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
//    @OperationLog(events = "订单提交审批", handlerName = "allotOrderOperationRecordService")
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		AllotOrderEntity orderEntity = service.selectById(billId);

		//设置单据提交人信息
		UserContext user = sessionManager.getUserContext();
		orderEntity.setCommitDate(new Date());
		orderEntity.setCommitUserCode(user.getUserCode());
		orderEntity.setCommitUserId(user.getUserId());
		orderEntity.setCommitUserName(user.getUserName());

		//设置订单状态
		logger.info("调出方审批中");
		orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方审批中.getCode());

		//生成出库流水
//		service.saveOrderOutStore(orderEntity);

		service.saveOrUpdate(orderEntity, false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
//	@OperationLog(events = "订单审批通过", handlerName = "allotOrderOperationRecordService")
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AllotOrderEntity orderEntity = service.selectById(billId);

		//设置订单状态
		logger.info("调入方待收货");
		orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方待收货.getCode());

		//可下单量校验
		service.checkAllotableNum(orderEntity.getAllotOrderDetailList());

        //生成出库流水
//        service.saveOrderOutStore(orderEntity);

        //生成调拨单
//        service.saveTransfor(orderEntity);

		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//设置单据提交人信息
			UserContext user = sessionManager.getUserContext();
			orderEntity.setCommitDate(new Date());
			orderEntity.setCommitUserCode(user.getUserCode());
			orderEntity.setCommitUserId(user.getUserId());
			orderEntity.setCommitUserName(user.getUserName());
		}
		service.saveOrUpdate(orderEntity, false);

		//调出方已确认，向调入方预定人发送消息
		//标题：【物资调拨】，【单据编号】，【时间】订单被调出方确认，请尽快处理！
		//内容：【单据编号】，【调入项目】申请调拨的物资已被调出方确认，请尽快处理！
		StringBuilder subject = new StringBuilder();
		StringBuilder content = new StringBuilder();
		subject.append("【物资调拨】,【").append(orderEntity.getBillCode())
				.append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调出方取消，请尽快处理！");
		content.append("【").append(orderEntity.getBillCode()).append("】，【")
				.append(orderEntity.getInProjectName()).append("】申请调拨的物资已被调出方确认，请尽快处理！");

		PushMsgParameter parameter = new PushMsgParameter();
		parameter.setReceivers(new String[]{orderEntity.getPurUserId().toString()});
		parameter.setPcUrl(BASE_HOST+ CommonConstants.调入订单PC详情+orderEntity.getId().toString());
		parameter.setContent(content.toString());
		parameter.setSubject(subject.toString());
		service.sendMsg(parameter, billId, "调出方订单确认，向调入方联系人发送消息");

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("调拨订单不允许弃审操作！");
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return saveDoBpmBack(billId);
	}

//    @OperationLog(events = "调出方订单审批驳回", handlerName = "allotOrderOperationRecordService")
//	@GlobalTransactional(name = "AllotOrderBpmServiceImpl_saveDoBpmBack", rollbackFor = Exception.class)
	private CommonResponse<String> saveDoBpmBack(Long billId) {

		AllotOrderEntity orderEntity = service.selectById(billId);
		orderEntity.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方取消.getCode());

		//生出生成的调出方出库流水和闲置
		//生成调出方出库流水
//		service.sendOutStoreData(orderEntity, true);
//		logger.info("调拨订单-{}撤回调出方出库流水成功！", orderEntity.getId());

		//生成调出方闲置流水
//		service.sendIdleStoreData(orderEntity, true);
//		logger.info("调拨订单-{}撤回调出方闲置流水成功！", orderEntity.getId());

		//向调入方联系人发消息：
		// 标题：【物资调拨】，【单据编号】，【时间】订单被调出方取消，请尽快处理！
		// 内容：【单据编号】，【调入项目】申请调拨的物资已被调出方取消，请尽快处理！
		StringBuilder subject = new StringBuilder();
		StringBuilder content = new StringBuilder();
		subject.append("【物资调拨】,【").append(orderEntity.getBillCode())
				.append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调出方取消，请尽快处理！");
		content.append("【").append(orderEntity.getBillCode()).append("】，【")
				.append(orderEntity.getInProjectName()).append("】申请调拨的物资已被调出方取消，请尽快处理！");

		PushMsgParameter parameter = new PushMsgParameter();
		parameter.setReceivers(new String[]{orderEntity.getPurUserId().toString()});
		parameter.setPcUrl(BASE_HOST+ CommonConstants.调入订单PC详情+orderEntity.getId().toString());
		parameter.setContent(content.toString());
		parameter.setSubject(subject.toString());
		service.sendMsg(parameter, billId, "调出方订单取消，向调入方联系人");

		//释放调拨中量
		goodsService.updateAllotNum(service.getUpdateGoodList(orderEntity.getAllotOrderDetailList(), "release", "allot"), false);
		service.saveOrUpdate(orderEntity, false);


		return CommonResponse.success("操作成功！");
	}

}
