package com.ejianc.business.panhuo.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderOperationRecordEntity;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.panhuo.order.mapper.AllotOrderOperationRecordMapper;
import com.ejianc.business.panhuo.order.service.IAllotOrderOperationRecordService;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderOperationRecordVO;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 调拨订单操作记录表
 * 
 * @author generator
 * 
 */
@Service("allotOrderOperationRecordService")
public class AllotOrderOperationRecordServiceImpl extends BaseServiceImpl<AllotOrderOperationRecordMapper, AllotOrderOperationRecordEntity>
        implements IAllotOrderOperationRecordService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAllotOrderService allotOrderService;

    @Autowired
    private SessionManager sessionManager;

//    @Override
//    public void handleOperationLog(String reqParam, AllotOrderOperationRecordVO recordVO) {
//        logger.info("订单操作记录，参数：{}, recordVo：{}", reqParam, JSONObject.toJSONString(recordVO, SerializerFeature.PrettyFormat));
//
//        JSONArray params = JSONObject.parseArray(reqParam);
//        AllotOrderEntity allotOrder = null;
//        StringBuilder sp = new StringBuilder();
//
//        UserContext user = sessionManager.getUserContext();
//
//        if(AllotOrderOperationRecordVO.EVENT_OUT_ORDER_COMMIT.equals(recordVO.getEvent())
//                || AllotOrderOperationRecordVO.EVENT_OUT_ORDER_PASTED.equals(recordVO.getEvent())
//                || AllotOrderOperationRecordVO.EVENT_OUT_ORDER_ABANDON.equals(recordVO.getEvent())) {
//            //审批事件，参数[billId, billState, billType]
//            allotOrder = allotOrderService.selectById(params.getLong(0));
//            sp.append("调出方【人员：").append(user.getEmployeeName())
//                    .append("，编号：").append(user.getUserCode()).append("】").append(recordVO.getEvent());
//            recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
//        } else {
//            //非审批事件，参数[{AllotOrderVO}]
//            AllotOrderVO orderVo = params.getObject(0, AllotOrderVO.class);
//            allotOrder = allotOrderService.selectById(orderVo.getId());
//
//            switch (recordVO.getEvent()) {
//                case AllotOrderOperationRecordVO.EVENT_ORDER_SAVE_EDIT:
//                    if(orderVo.getOprType().equals("saveEdit")) {
//                        //调出方编辑保存
//                        recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
//                        sp.append("订单调出方【人员：").append(user.getEmployeeName())
//                                .append("，编号：").append(user.getUserCode()).append("】编辑订单并推送调入方确认");
//                    } else {
//                        //调入方入库编辑保存
//                        recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
//                        sp.append("订单调入方【人员：").append(user.getEmployeeName())
//                                .append("，编号：").append(user.getUserCode()).append("】入库编辑保存");
//                    }
//                    break;
//                case AllotOrderOperationRecordVO.EVENT_ORDER_CANCEL: //调入方、调出方取消
//                    recordVO.setOprUseType(AllotOrderBusinessStatusEnums.调入方洽商待确认.getCode().equals(orderVo.getBusinessStatus())
//                            || AllotOrderBusinessStatusEnums.调入方待收货.getCode().equals(orderVo.getBusinessStatus()) ?
//                            AllotOrderOperationRecordVO.OPR_USER_TYPE_IN : AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
//
//                    sp.append(recordVO.getOprUseType() == 2 ? "订单调入方【人员：" : "订单调出方【人员：")
//                            .append(user.getEmployeeName())
//                            .append("，编号：").append(user.getUserCode()).append("】取消订单");
//                    break;
//                case AllotOrderOperationRecordVO.EVENT_IN_ORDER_COMFIRM: //调入方确认定单
//                    sp.append("订单调入方【人员：").append(user.getEmployeeName())
//                            .append("，编号：").append(user.getUserCode()).append("确认订单");
//                    recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
//                    break;
//                default:
//                    //调入方收货入库
//                    recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
//                    sp.append("订单调入方【人员：").append(user.getEmployeeName())
//                            .append("，编号：").append(user.getUserCode()).append("】收货入库");
//
//            }
//        }
//
//        recordVO.setOprUserCode(user.getUserCode());
//        recordVO.setOprUserName(user.getUserName());
//        recordVO.setOrderId(allotOrder.getId());
//        recordVO.setOrderCode(allotOrder.getBillCode());
//        recordVO.setBeforeBusinessStatus(allotOrder.getBusinessStatus());
//        recordVO.setOprDesc(sp.toString());
//
//        super.saveOrUpdate(BeanMapper.map(recordVO, AllotOrderOperationRecordEntity.class), false);
//        logger.info("订单[id-{},billCode-{}]操作记录更新成功！", recordVO.getOrderId(), recordVO.getOrderCode());
//    }

}
