package com.ejianc.business.panhuo.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.panhuo.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.foundation.panhuo.constants.CommonConstants;
import com.ejianc.business.panhuo.order.mapper.AllotOrderMapper;
import com.ejianc.business.panhuo.order.service.IAllotOrderDetailService;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyDetailVO;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderVO;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 调拨订单
 *
 * @author generator
 */
@Service("allotOrderService")
public class AllotOrderServiceImpl extends BaseServiceImpl<AllotOrderMapper, AllotOrderEntity> implements IAllotOrderService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "PANHUO_ORDER";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private AllotOrderMapper mapper;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IFlowmeterService flowmeterService;

    @Autowired
    private IAllotOrderDetailService detailService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IStoreService storeService;

    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;

    @Autowired
    private ITransferorderService transferorderService;
    @Autowired
    private ITransferorderdetailService transferorderdetailService;

    private static final String BILL_CODE_DB = "WZ_DBD";//调拨单


    @Override
    public void saveNewOrderByApply(AllotApplyVO allotApplyVO) {

        //本次新增的订单列表
        List<AllotOrderEntity> newOrderList = new ArrayList<>();
        List<AllotOrderDetailEntity> newOrderDetailList = new ArrayList<>();

        //1、将调拨申请子表按照调出方进行分组
        Map<Long, List<AllotApplyDetailVO>> applyDetailMap = allotApplyVO.getDetailList().stream()
                .collect(Collectors.groupingBy(AllotApplyDetailVO::getExceedOrgId, Collectors.toList()));

        List<Long> shelfDetailIds =  allotApplyVO.getDetailList().stream().map(AllotApplyDetailVO::getSourceId).collect(Collectors.toList());

        List<GoodsEntity> goods = goodsService.getAllByIds(shelfDetailIds);
        Map<Long,GoodsEntity> shelfDetailMap = goods.stream().collect(Collectors.toMap(GoodsEntity::getId, item -> item));

        //2、根据拆分的调拨申请子表，创建对应的调拨订单
        AllotOrderEntity tmp = null;
        for (Long outOrgId : applyDetailMap.keySet()) {
            tmp = generateOrderByApply(allotApplyVO, applyDetailMap.get(outOrgId), shelfDetailMap);
            newOrderDetailList.addAll(tmp.getAllotOrderDetailList());
            newOrderList.add(tmp);
        }

        //3、保存入库
        //保存订单子表
        detailService.saveOrUpdateBatch(newOrderDetailList, newOrderDetailList.size(), false);
        //保存订单主表
        super.saveOrUpdateBatch(newOrderList, newOrderList.size(), false);

        //发送消息
        //标题：【物资调拨】，【单据编号】，【时间】闲置物资被下单，请尽快处理！
        //内容：【单据编号】，【被下单物资分类】已被【调入项目】下单调拨，请尽快处理！
        List<Long> projectIdS = newOrderList.stream().map(AllotOrderEntity::getOutProjectId).collect(Collectors.toList());
        Map<Long, Long> projectManagerIdS = getProjectManagerIdS(projectIdS);

        List<Long> categoryIds = newOrderDetailList.stream().map(AllotOrderDetailEntity::getMaterialTypeId).collect(Collectors.toList());
//        List<MaterialCategoryVO> categtoryVOs = categoryService.queryCategoryListByChildren(categoryIds);

//        Map<Long, MaterialCategoryVO> categoryMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(categtoryVOs)) {
//            categoryMap = categtoryVOs.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
//        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        for (AllotOrderEntity order : newOrderList) {
            Long projectManagerId = null;
            List<String> userIds = new ArrayList<>();
//            Set<String> categoryNames = new HashSet<>();
            if (null!=order.getOutProjectId()&&projectManagerIdS.containsKey(order.getOutProjectId())) {
                projectManagerId = projectManagerIdS.get(order.getOutProjectId());
            }
            //去重记录对应的发布人
            for (AllotOrderDetailEntity detail : order.getAllotOrderDetailList()) {
                if (!userIds.contains(detail.getSellUserId().toString())) {
                    userIds.add(detail.getSellUserId().toString());
                }
//                if(categoryMap.containsKey(detail.getMaterialTypeId()) && categoryMap.containsKey(categoryMap.get(detail.getMaterialTypeId()).getParentId())) {
//                    categoryNames.add(categoryMap.get(categoryMap.get(detail.getMaterialTypeId()).getParentId()).getName());
//                }
            }

            //调拨申请生效 向项目经理、物资发布人
            PushMsgParameter parameter = new PushMsgParameter();
            StringBuilder content = new StringBuilder();
            content.append("【").append(order.getBillCode()).append("】");
            if(StringUtils.isNotEmpty(order.getCategoryNames())) {
                content.append("，【").append(order.getCategoryNames()).append("】");
            }
            content.append("已被【").append(order.getInProjectName()).append("】下单调货，请尽快处理！");

            parameter.setContent(content.toString());
            parameter.setPcUrl(BASE_HOST +  CommonConstants.调出订单PC详情 + order.getId().toString());
            parameter.setSubject("【物资调拨】，【"+order.getBillCode()+"】，【"+DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】闲置物资被下单，请尽快处理！");
            if (null != projectManagerId) {
                userIds.add(projectManagerId.toString());
            }
            String[] longs = userIds.toArray(new String[userIds.size()]);
            parameter.setReceivers(longs);
            sendMsg(parameter, order.getId(), "调拨申请生效 向项目经理、物资发布人发送消息");
        }
    }

    @Override
    public void deleteOrderByApply(Long allotApplyId) {
        logger.info("根据调拨单Id-{}删除对应订单信息", allotApplyId);

        QueryWrapper<AllotOrderEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("allot_apply_id", allotApplyId);
        countQuery.and(iq -> iq.gt("business_status", AllotOrderBusinessStatusEnums.调入方洽商已确认.getCode()).or().gt("edit_num", 0));
        int count = super.count(countQuery);
        if (count > 0) {
            throw new BusinessException("调拨订单已被下游引用");
        }

        QueryWrapper<AllotOrderEntity> query = new QueryWrapper<>();
        query.select("id");
        query.eq("allot_apply_id", allotApplyId);
        List<Long> orderIds = super.listObjs(query, (item) -> Long.valueOf(item.toString()));
        super.removeByIds(orderIds);
    }

    @Override
    public void checkAllotableNum(List<AllotOrderDetailEntity> allotOrderDetailList) {
        Map<Long, BigDecimal> goodsAllotableNumMap = goodsService.getAllotableNum(allotOrderDetailList.stream()
                .map(item -> item.getSourceId()).collect(Collectors.toList()));

        StringBuilder sp = new StringBuilder();
        for (AllotOrderDetailEntity detail : allotOrderDetailList) {
            if (detail.getAllotNum().compareTo(ComputeUtil.safeAdd(goodsAllotableNumMap.get(detail.getSourceId()), detail.getInitialAllotNum())) > 0) { //本次调拨量 <= 可下单量+初始调拨量
                sp.append("编码：").append(detail.getMaterialCode()).append("-").append("品牌：").append(detail.getBrandName()).append("、");
            }
        }
        if (sp.length() > 0) {
            throw new BusinessException("物资" + sp.substring(0, sp.length() - 1) + "调拨量超出可下单量");
        }
    }

    @Override
    public AllotOrderVO saveEditAllotOrderInfo(AllotOrderEntity entity) {
        //TODO 集市物资加锁

        //校验调拨量是否超过可下单量
        checkAllotableNum(entity.getAllotOrderDetailList());

        //改写占用调拨中数量
        goodsService.updateAllotNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "update", "allot"), true);

        //编辑 次数+1
        entity.setEditNum(entity.getEditNum() + 1);
        entity.setEditUserId(InvocationInfoProxy.getUserid());
        entity.setEditUserName(sessionManager.getUserContext().getUserName());

        //修改状态为待调入方确认
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方洽商待确认.getCode());

        //保存
        super.saveOrUpdate(entity, false);

        Long inProjetMgid =  getProjectManagerId(entity.getInProjectId());
        List<String> recIds = new ArrayList<>();
        if(null != inProjetMgid) {
            recIds.add(inProjetMgid.toString());
        }
        recIds.add(entity.getPurUserId().toString());

        //向调入方预订人、项目经理 发送消息：【您订购的物资{调出项目+物资分类名称}调出方已修改订单信息，请尽快确认。】
        StringBuilder content = new StringBuilder();
        content.append("您订购的物资【")
                .append(entity.getStoreType() == 1 ? "调出项目：" + entity.getOutProjectName() : "调出单位" + entity.getOutParentOrgName())
                .append("，物资分类：").append(entity.getCategoryNames())
                .append("】调出方已修改订单信息，请尽快确认。");

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(recIds.toArray(new String[recIds.size()]));
        parameter.setPcUrl(BASE_HOST + CommonConstants.调入订单PC详情 + entity.getId().toString());
        parameter.setSubject("【调入订单】【" + entity.getBillCode() + "】【" + sdf.format(entity.getCreateTime()) +"】");
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());

        sendMsg(parameter, entity.getId(), "调出方修改，向调入方预订人");
        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
    public List<GoodsVO> getUpdateGoodList(List<AllotOrderDetailEntity> allotOrderDetailList, String oprType, String allotType) {
        List<GoodsVO> resp = new ArrayList<>();
        allotOrderDetailList.stream().forEach(detail -> {
            GoodsVO g = new GoodsVO();
            g.setId(detail.getSourceId());
            if("alloted".equals(allotType)) {
                g.setAllotedNum(detail.getAllotNum());
            } else {
                if ("update".equals(oprType)) {
                    g.setAllotNum(ComputeUtil.safeSub(detail.getAllotNum(), detail.getInitialAllotNum()));
                } else {
                    g.setAllotNum(detail.getAllotNum());
                }
            }
            resp.add(g);
        });

        return resp;
    }

    @Override
    public void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("调拨订单id-{},{}发送消息失败，{}", allotOrderId, oprMsg, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("调拨订单id-{},{}发送消息成功！", allotOrderId, oprMsg);
        }
    }

    public void sendEmail(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("调拨订单id-{},{}发送消息失败，{}", allotOrderId, oprMsg, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("调拨订单id-{},{}发送消息成功！", allotOrderId, oprMsg);
        }
    }

    @Override
//    @GlobalTransactional(name = "AllotOrderServiceImpl_saveOrderInStore", rollbackFor = Exception.class)
    public AllotOrderVO saveOrderInStore(AllotOrderEntity entity) {
        //校验子表是否都已设置入库仓库
//        List<AllotOrderDetailEntity> detailList = entity.getAllotOrderDetailList().stream()
//                .filter(item -> null == item.getInStoreId()).collect(Collectors.toList());
//        if (detailList.size() > 0) {
//            throw new BusinessException("操作失败，存在物资未设置入库仓库！");
//        }

        //TODO 集市物资加锁

        //修改物资集市调拨中数量
        goodsService.updateAllotNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "allot"), false);
        goodsService.updateAllotedNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "alloted"), true);

        //设置订单状态
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.交易完成.getCode());
        super.saveOrUpdate(entity, false);

        //生成出库流水
        saveOrderOutStore(entity);

        //生成调拨单
        saveTransfor(entity);

        logger.info("调拨订单-{}生成调入方调入流水成功！", entity.getId());

        //向调出方上架人发送消息：
        // 标题：【物资调拨】，【单据编号】，【时间】订单完成交易！
        //内容：【单据编号】，【调入项目】已完成交易，并收货入库！
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        subject.append("【物资调拨】，【").append(entity.getBillCode()).append("】").append("，【").append(entity.getBillCode())
                .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单完成交易！");
        content.append("【").append(entity.getBillCode()).append("】，调入项目【")
                .append(entity.getInProjectName())
                .append("】，已完成交易，并收货入库！");

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{entity.getPurUserId().toString()});
        parameter.setPcUrl(BASE_HOST
                +  CommonConstants.调出订单PC详情
                + entity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        sendMsg(parameter, entity.getId(), "调入方收货入库完成，向调入方联系人");

        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
    public AllotOrderVO saveOrderInStoreEdit(AllotOrderEntity entity) {
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
//    @GlobalTransactional(name = "AllotOrderServiceImpl_saveOrderOutStore", rollbackFor = Exception.class)
    public void saveOrderOutStore(AllotOrderEntity entity) {

        //生成调出方出库流水
        sendOutStoreData(entity);
        logger.info("调拨订单-{}生成调出方出库流水成功！", entity.getId());



        super.saveOrUpdate(entity, false);
    }
    //生成调拨单
    @Override
    public void saveTransfor(AllotOrderEntity entity) {

        //生成调拨单
        TransferorderEntity transferorderEntity = new TransferorderEntity();

        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            transferorderEntity.setBillCode(billCode.getData());
        }
        transferorderEntity.setBillState(1);
        transferorderEntity.setApproveTime(new Date());
        transferorderEntity.setDialitemsId(entity.getOutProjectId());
        transferorderEntity.setDialItems(entity.getOutProjectName());
        transferorderEntity.setOrgId(entity.getOutParentOrgId());
        transferorderEntity.setOrgName(entity.getOutParentOrgName());
        transferorderEntity.setProjectDepartmentId(entity.getOutOrgId());

        transferorderEntity.setDialinitemsId(entity.getInProjectId());
        transferorderEntity.setDialInitems(entity.getInProjectName());
        transferorderEntity.setIncomingWarehouse(entity.getInStoreId());
        transferorderEntity.setIncomingWarehouseName(entity.getInStoreName());
        transferorderEntity.setProjectDepartmentIdEnter(entity.getInOrgId());
        transferorderEntity.setDialOrg(entity.getInParentOrgName());
        transferorderEntity.setDialOrgId(entity.getInParentOrgId());
        transferorderEntity.setSourceType(2);
        transferorderEntity.setDates(new Date());
        transferorderEntity.setProjectOrg(entity.getOutParentOrgName());
        transferorderEntity.setId(IdWorker.getId());
        transferorderEntity.setAgentId(entity.getPurUserId());
        transferorderEntity.setAgentName(entity.getPurUserName());

        //子表信息
        List<AllotOrderDetailEntity> allotOrderDetailList = entity.getAllotOrderDetailList();
        List<TransferorderdetailEntity> transferdetailEntityList = new ArrayList<>();
        for (AllotOrderDetailEntity allotOrderDetailEntity : allotOrderDetailList){
            TransferorderdetailEntity transferorderdetailEntity = new TransferorderdetailEntity();
            transferorderdetailEntity.setMid(transferorderEntity.getId());
            transferorderdetailEntity.setMaterialId(allotOrderDetailEntity.getMaterialId());
            transferorderdetailEntity.setMaterialCode(allotOrderDetailEntity.getMaterialCode());
            transferorderdetailEntity.setMaterialName(allotOrderDetailEntity.getMaterialName());
            transferorderdetailEntity.setMeasurementUnit(allotOrderDetailEntity.getUnitName());
            transferorderdetailEntity.setQuantity(allotOrderDetailEntity.getAllotNum());
            transferorderdetailEntity.setTransferAmount(allotOrderDetailEntity.getDetailAllotMny());
            transferorderdetailEntity.setHairStoreId(allotOrderDetailEntity.getOutStoreId());
            transferorderdetailEntity.setHairStoreName(allotOrderDetailEntity.getOutStoreName());
            transferorderdetailEntity.setMaterialCategoryId(allotOrderDetailEntity.getMaterialTypeId());
            transferorderdetailEntity.setMaterialCategoryName(allotOrderDetailEntity.getMaterialTypeName());
            transferorderdetailEntity.setMaterialCategoryCode(allotOrderDetailEntity.getMaterialTypeCode());
            transferorderdetailEntity.setEnterPrice(allotOrderDetailEntity.getSellTaxPrice());
            transferorderdetailEntity.setEnterUnitPrice(allotOrderDetailEntity.getSellPrice());
            transferorderdetailEntity.setEnterAmount(allotOrderDetailEntity.getDetailAllotTaxMny());
            transferorderdetailEntity.setEnterAmountExcluetax(allotOrderDetailEntity.getDetailAllotMny());
            transferdetailEntityList.add(transferorderdetailEntity);
        }
//        transferorderEntity.setTransferorderdetailEntities(transferdetailEntityList);

        transferorderService.saveOrUpdate(transferorderEntity);
        transferorderdetailService.saveBatch(transferdetailEntityList);

    }

    /**
     * 组装出库流水数据
     *
     * @param entity
     * @return
     */
    @Override
    public void sendOutStoreData(AllotOrderEntity entity) {
//        1、上架提交生产出库流水（自由态），实际完成交易后拆分出实际流水。比如 上架100，生成100的自由态流水，实际交易20,结果为80的自有太流水，20的生效流水。
//        2、资产下架时删除自由态流水，更新库存
        //查询出上架流水
        List<AllotOrderDetailEntity> allotOrderDetailList = entity.getAllotOrderDetailList();
        List<Long> goodIds = new ArrayList<>();
        Map<Long, AllotOrderDetailEntity> recordMap = allotOrderDetailList.stream().collect(Collectors.toMap(AllotOrderDetailEntity::getSourceId, Function.identity()));
        if (CollectionUtils.isNotEmpty(allotOrderDetailList)){
            goodIds = allotOrderDetailList.stream().map(AllotOrderDetailEntity::getSourceId).collect(Collectors.toList());
        }
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, goodIds);
        List<FlowmeterEntity> flowmeterList = flowmeterService.list(lambdaFlower);
        List<Long> storeIds = new ArrayList<>();
        for (FlowmeterEntity flowmeterEntity : flowmeterList){
            storeIds.add(flowmeterEntity.getStoreId());
            if (recordMap.containsKey(flowmeterEntity.getMid())){
                AllotOrderDetailEntity allotOrderDetailEntity = recordMap.get(flowmeterEntity.getMid());
                flowmeterEntity.setQuantity(ComputeUtil.safeSub(flowmeterEntity.getQuantity(),allotOrderDetailEntity.getAllotNum()));
                flowmeterEntity.setAmountExcluetax(ComputeUtil.safeMultiply(flowmeterEntity.getQuantity(),flowmeterEntity.getUnitPriceExcluetax()));
                flowmeterEntity.setAmountIncluetax(ComputeUtil.safeMultiply(flowmeterEntity.getQuantity(),flowmeterEntity.getUnitPriceIncluetax()));
            }
        }
        flowmeterService.updateBatchById(flowmeterList);

        //生成出库流水
        ArrayList<FlowmeterEntity> flowerList = new ArrayList<>();

        for (AllotOrderDetailEntity allotOrderDetailEntity : allotOrderDetailList){
            FlowmeterEntity flowmeterOutEntity = createrOutFlowmeter(entity, allotOrderDetailEntity);
            storeIds.add(flowmeterOutEntity.getStoreId());
            flowerList.add(flowmeterOutEntity);
            FlowmeterEntity flowmeterInEntity = createrInFlowmeter(entity, allotOrderDetailEntity);
            storeIds.add(flowmeterInEntity.getStoreId());
            flowerList.add(flowmeterInEntity);
        }

        flowmeterService.saveBatch(flowerList);

        //更新实时物资结存表
        for (Long storeId : storeIds){
            realtimebalanceService.updateRealtimeBalance(storeId);
        }
    }

    /**
     * 创建出库流水记录
     * @param entity  出库表子表信息
     * @return
     */
    private FlowmeterEntity createrOutFlowmeter(AllotOrderEntity allotOrderEntity,AllotOrderDetailEntity entity){
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(allotOrderEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setMaterialId(entity.getMaterialId());
        flowmeterEntity.setBillCode(allotOrderEntity.getBillCode());
        flowmeterEntity.setProjectId(allotOrderEntity.getOutProjectId());
        flowmeterEntity.setProjectName(allotOrderEntity.getOutProjectName());
        flowmeterEntity.setStoreId(entity.getOutStoreId());
        flowmeterEntity.setStoreType(entity.getAttrFlag());
        flowmeterEntity.setStoreName(entity.getOutStoreName());
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialTypeId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialTypeCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialTypeName());
        flowmeterEntity.setBillStatus(1);
        flowmeterEntity.setBillTime(allotOrderEntity.getCreateTime());
        flowmeterEntity.setOperationType("出库");
        flowmeterEntity.setAccessType("调出");
        flowmeterEntity.setTransferorderType("调拨出库");

        flowmeterEntity.setTime(new Date());
        flowmeterEntity.setQuantity(entity.getAllotNum());
        flowmeterEntity.setAmountIncluetax(entity.getDetailAllotTaxMny());
        flowmeterEntity.setAmountExcluetax(entity.getDetailAllotMny());
        flowmeterEntity.setApproveTime(new Date());

        flowmeterEntity.setUnitPriceIncluetax(entity.getSellTaxPrice());
        flowmeterEntity.setUnitPriceExcluetax(entity.getSellPrice());
        flowmeterEntity.setOrgId(allotOrderEntity.getOutParentOrgId());
        flowmeterEntity.setOrgName(allotOrderEntity.getOutParentOrgName());
        flowmeterEntity.setMeasurementUnit(entity.getUnitName());
        flowmeterEntity.setProjectDepartmentId(allotOrderEntity.getOutOrgId());
        //查询仓库类型
//        StoreEntity storeEntity = storeService.selectById(flowmeterEntity.getStoreId());
//        flowmeterEntity.setStoreType(storeEntity.getStoreType());
        flowmeterEntity.setBillType(2);
        flowmeterEntity.setSpecialModel(entity.getPropertyValue());
        return  flowmeterEntity;
    }
    /**
     * 创建入库流水记录
     */
    private FlowmeterEntity createrInFlowmeter(AllotOrderEntity allotOrderEntity,AllotOrderDetailEntity entity){
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(allotOrderEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setMaterialId(entity.getMaterialId());
        flowmeterEntity.setBillCode(allotOrderEntity.getBillCode());
        flowmeterEntity.setProjectId(allotOrderEntity.getInProjectId());
        flowmeterEntity.setProjectName(allotOrderEntity.getInProjectName());
        flowmeterEntity.setStoreId(allotOrderEntity.getInStoreId());
        flowmeterEntity.setStoreType(allotOrderEntity.getInStoreAttrFlag());
        flowmeterEntity.setStoreName(allotOrderEntity.getInStoreName());
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialTypeId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialTypeCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialTypeName());
        flowmeterEntity.setBillStatus(1);
        flowmeterEntity.setBillTime(allotOrderEntity.getCreateTime());
        flowmeterEntity.setOperationType("入库");
        flowmeterEntity.setAccessType("调入");
        flowmeterEntity.setTransferorderType("调拨入库");

        flowmeterEntity.setTime(new Date());
        flowmeterEntity.setQuantity(entity.getAllotNum());
        flowmeterEntity.setAmountIncluetax(entity.getDetailAllotTaxMny());
        flowmeterEntity.setAmountExcluetax(entity.getDetailAllotMny());
        flowmeterEntity.setApproveTime(new Date());

        flowmeterEntity.setUnitPriceIncluetax(entity.getSellTaxPrice());
        flowmeterEntity.setUnitPriceExcluetax(entity.getSellPrice());
        flowmeterEntity.setOrgId(allotOrderEntity.getInParentOrgId());
        flowmeterEntity.setOrgName(allotOrderEntity.getInParentOrgName());
        flowmeterEntity.setMeasurementUnit(entity.getUnitName());
        flowmeterEntity.setProjectDepartmentId(allotOrderEntity.getInOrgId());
        flowmeterEntity.setSpecialModel(entity.getPropertyValue());
        //查询仓库类型
//        StoreEntity storeEntity = storeService.selectById(flowmeterEntity.getStoreId());
//
//        flowmeterEntity.setStoreType(storeEntity.getStoreType());
        flowmeterEntity.setBillType(2);
        return  flowmeterEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelOrder(AllotOrderEntity order) {
        //查询的当前操作人信息
        CommonResponse<EmployeeVO> empResp = employeeApi.getById(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if (!empResp.isSuccess()) {
            logger.error("查询用户id-{}失败，{}", InvocationInfoProxy.getEmployeeId(), JSONObject.toJSONString(empResp));
            throw new BusinessException("操作失败，获取当前用户信息失败！");
        }

        EmployeeVO emp = empResp.getData();

        //记录当前操作人
        order.setCancelTime(new Date());
        order.setCancelUserCode(emp.getCode());
        order.setCancelUserId(emp.getId());
        order.setCancelUserName(emp.getUserName());

        //消息发送准备
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        String pcUrl = null, oprMsg = null;
        String[] receivers = null;
        Set<String> receiverList = null;
        Long projectManagerId = null;

        //更改订单状态
        switch (order.getBusinessStatus()) {
            case 1: //调出方待确认, 调出方取消
            case 3: //调入方洽商已确认, 调出方取消
                //向调入方联系人发消息：
                // 标题：【物资调拨】，【单据编号】，【时间】订单被调出方取消，请尽快处理！
                // 内容：【单据编号】，【调入项目】申请调拨的物资已被调出方取消，请尽快处理！
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方取消.getCode());
                projectManagerId = getProjectManagerId(order.getInProjectId());
                receivers = null != projectManagerId ? new String[]{order.getPurUserId().toString(),projectManagerId.toString()} : new String[]{order.getPurUserId().toString()};

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调出方取消，请尽快处理！");
                content.append("【").append(order.getBillCode()).append("】，【")
                        .append(order.getInProjectName()).append("】申请调拨的物资已被调出方取消，请尽快处理！");
                oprMsg = "订单调出方取消，向调入方联系人";
                pcUrl = BASE_HOST + CommonConstants.调入订单PC详情 + order.getId().toString();
                break;

            case 2: //调入方洽商待确认, 调入方取消
                //向调洽商修改人、调出方上架人、项目经理发送消息：【{订单编号+调入项目+材料分类}洽商被取消，请查看订单信息。】
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方取消.getCode());

                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                receiverList.add(order.getEditUserId().toString());
                //查询项目经理
                projectManagerId = getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调入方取消，请尽快处理！");
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("订单编号【").append(order.getBillCode()).append("】，调入项目【")
                        .append(order.getInProjectName())
                        .append("】，物资分类【").append(order.getCategoryNames())
                        .append("】调入方已取消订单，请查看。");
                oprMsg = "订单调入方方取消，向调洽商修改人、调出方上架人、项目经理";
                pcUrl = BASE_HOST + CommonConstants.调出订单PC详情 + order.getId().toString();

                break;
            case 5: //调入方待收货, 调入方取消
                //向调出方上架人、项目经理发送消息：
                //标题：【物资调拨】，【单据编号】，【时间】调入方拒绝入库，交易结束！
                //内容：【单据编号】，【调入项目】拒绝入库，交易结束！
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方取消.getCode());

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】调入方拒绝入库，交易结束！");
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                //查询项目经理
                projectManagerId = getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("【").append(order.getBillCode()).append("】，【")
                        .append(order.getInProjectName()).append("】调入方拒绝入库，交易结束！");
                oprMsg = "订单调入方调拨拒绝入库，向调出方上架人、项目经理";
                pcUrl = BASE_HOST + CommonConstants.调出订单PC详情 + order.getId().toString();

                //生出生成的调出方出库流水和闲置
                //生成调出方出库流水
//                sendOutStoreData(order, true);
//                logger.info("调拨订单-{}撤回调出方出库流水成功！", order.getId());

                //生成调出方闲置流水
//                sendIdleStoreData(order, true);
//                logger.info("调拨订单-{}撤回调出方闲置流水成功！", order.getId());

                break;
            default:
                throw new BusinessException("操作失败，订单状态为【" + AllotOrderBusinessStatusEnums.getNameByCode(order.getBusinessStatus()) + "】不支持此操作");
        }

        //释放调拨中占用量
        goodsService.updateAllotNum(getUpdateGoodList(order.getAllotOrderDetailList(), "release", "allot"), false);

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(pcUrl);
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        sendMsg(parameter, order.getId(), oprMsg);

        super.saveOrUpdate(order, false);
    }

    private Long getProjectManagerId(Long projectId) {
        CommonResponse<ProjectVO> commonResponse = zjkjProjectApi.queryDetailById(projectId);
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            ProjectVO data = commonResponse.getData();
            return data.getLeader();
        }
        return null;
    }

    private Map<Long, Long> getProjectManagerIdS(List<Long> projectId) {

        CommonResponse<JSONArray> jsonArrayCommonResponse = zjkjProjectApi.queryProjectArray(projectId);
        if (!jsonArrayCommonResponse.isSuccess() || jsonArrayCommonResponse.getData().size() == 0) {
            return null;
        }
        JSONArray jsonArrayCommonResponseData = jsonArrayCommonResponse.getData();
        List<ProjectVO> list = JSONObject.parseArray(jsonArrayCommonResponseData.toJSONString(),ProjectVO.class);
        Map<Long, Long> collect = list.stream().filter(e->null!=e.getLeader()).collect(Collectors.toMap(ProjectVO::getId, ProjectVO::getLeader));
        return collect;
    }

    @Override
    public void confirmOrder(Long id) {
        AllotOrderEntity order = super.selectById(id);
        //更改订单状态
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方洽商已确认.getCode());

        //发送消息 向调出方洽商修改人、上架联系人、项目经理发送消息：
        Set<String> receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
        receiverList.add(order.getEditUserId().toString());
        //查询项目经理
        Long projectManagerId = getProjectManagerId(order.getOutProjectId());
        if (null != projectManagerId) {
            receiverList.add(projectManagerId.toString());
        }
        String[] receivers = receiverList.toArray(new String[receiverList.size()]);
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("【物资调拨】，【").append(order.getBillCode()).append("】，【")
                .append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】调入方已确认订单，请查看。");

        content.append("订单编号【").append(order.getBillCode()).append("】，调入项目【")
                .append(order.getInProjectName())
                .append("】，物资分类【").append(order.getCategoryNames())
                .append("】调入方已确认订单，请查看。");

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(BASE_HOST + CommonConstants.调出订单PC详情+ order.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());

        sendMsg(parameter, order.getId(), "订单调入方确认订单，向调洽商修改人、调出方上架人、项目经理");

        super.saveOrUpdate(order, false);
    }

    /**
     * 根据调拨申请组装调拨订单子表信息
     *
     * @param allotApplyDetailVOS
     * @param order
     * @return
     */
    private List<AllotOrderDetailEntity> generateOrderDetailByApply(List<AllotApplyDetailVO> allotApplyDetailVOS, AllotOrderEntity order, Map<Long,GoodsEntity> shelfDetailMap) {
        List<AllotOrderDetailEntity> resp = BeanMapper.mapList(allotApplyDetailVOS, AllotOrderDetailEntity.class);

        BigDecimal totalAllotMny = BigDecimal.ZERO;
        BigDecimal totalAllotTaxMny = BigDecimal.ZERO;
        Map<Long, String> categoryMap = new HashMap<>();
        for (AllotOrderDetailEntity orderDetail : resp) {
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            clearBaseField(orderDetail);
            orderDetail.setOrderId(order.getId());
            orderDetail.setSellNum(shelfDetailMap.get(orderDetail.getSourceId()).getNum()); //设置出售数量
            orderDetail.setDetailAllotTaxMny(orderDetail.getAllotTaxMny());
            orderDetail.setDetailAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetMny(orderDetail.getDetailAllotMny());
            orderDetail.setInitialAssetTaxMny(orderDetail.getDetailAssetTaxMny());
            orderDetail.setInitialAssetMny(orderDetail.getDetailAssetMny());
            orderDetail.setInitialSellPrice(orderDetail.getSellPrice());
            orderDetail.setInitialSellTaxPrice(orderDetail.getSellTaxPrice());
            orderDetail.setInitialAllotNum(orderDetail.getAllotNum());
            orderDetail.setMemo(null);
            categoryMap.put(orderDetail.getMaterialTypeId(), orderDetail.getMaterialTypeName());
            totalAllotMny = ComputeUtil.safeAdd(totalAllotMny, orderDetail.getDetailAllotMny());
            totalAllotTaxMny = ComputeUtil.safeAdd(totalAllotTaxMny, orderDetail.getDetailAllotTaxMny());
        }

        order.setTotalAssetTaxMny(totalAllotTaxMny);
        order.setTotalAllotTaxMny(totalAllotTaxMny);
        order.setTotalAllotMny(totalAllotMny);
        order.setTotalAssetMny(totalAllotMny);
        order.setCategoryNames(StringUtils.join(categoryMap.values(), ","));

        return resp;
    }

    private void clearBaseField(BaseEntity base) {
        base.setId(null);
        base.setCreateTime(null);
        base.setCreateUserCode(null);
        base.setUpdateUserCode(null);
        base.setUpdateTime(null);
        base.setVersion(0);
    }

    /**
     * 根据调拨申请组装调拨订单主表信息
     *
     * @param allotApplyVO
     * @param allotApplyDetailVOs
     * @return
     */
    private AllotOrderEntity generateOrderByApply(AllotApplyVO allotApplyVO, List<AllotApplyDetailVO> allotApplyDetailVOs, Map<Long,GoodsEntity> shelfDetailMap) {
        AllotOrderEntity order = new AllotOrderEntity();
        AllotApplyDetailVO tmpApplyDetail = allotApplyDetailVOs.get(0);

        order.setId(IdWorker.getId());
        order.setAllotApplyId(allotApplyVO.getId());
        order.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()); //默认自由态
        order.setEditNum(0); //修改次数0
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方待确认.getCode()); //待调出方确认
        //调入方信息
        order.setInProjectCode(allotApplyVO.getInProjectCode());
        order.setInProjectId(allotApplyVO.getInProjectId());
        order.setInProjectName(allotApplyVO.getInProjectName());
        order.setInProjectAddress(allotApplyVO.getInProjectAddress());
        order.setInOrgId(allotApplyVO.getInOrgId());
        order.setInOrgCode(allotApplyVO.getInOrgCode());
        order.setInOrgName(allotApplyVO.getInOrgName());
        order.setInParentOrgCode(allotApplyVO.getInParentOrgCode());
        order.setInParentOrgId(allotApplyVO.getInParentOrgId());
        order.setInParentOrgName(allotApplyVO.getInParentOrgName());
        //调入方执行单位
        order.setInCorpCode(allotApplyVO.getCorpCode());
        order.setInCorpId(allotApplyVO.getCorpId());
        order.setInCorpName(allotApplyVO.getCorpName());
        //调入联系人、时间 取调拨申请生效日期
        order.setPurTime(allotApplyVO.getEffectDate());
        order.setPurUserCode(allotApplyVO.getPurUserCode());
        order.setPurUserId(allotApplyVO.getPurUserId());
        order.setPurUserName(allotApplyVO.getPurUserName());
        order.setPurUserPhone(allotApplyVO.getPurUserPhone());

        //调出方
        order.setOutProjectId(tmpApplyDetail.getOutProjectId());
        order.setOutProjectCode(tmpApplyDetail.getOutProjectCode());
        order.setOutProjectName(tmpApplyDetail.getOutProjectName());
        order.setOutOrgId(tmpApplyDetail.getOutOrgId());
        order.setOutOrgCode(tmpApplyDetail.getOutOrgCode());
        order.setOutOrgName(tmpApplyDetail.getOutOrgName());
        order.setOutParentOrgId(tmpApplyDetail.getOutParentOrgId());
        order.setOutParentOrgCode(tmpApplyDetail.getOutParentOrgCode());
        order.setOutParentOrgName(tmpApplyDetail.getOutParentOrgName());
        order.setStoreType(tmpApplyDetail.getStoreType());

        //生成编码
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(order, AllotOrderVO.class));
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            order.setBillCode(billCode.getData());
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }

        order.setAllotOrderDetailList(generateOrderDetailByApply(allotApplyDetailVOs, order, shelfDetailMap));

        return order;
    }




}
