package com.ejianc.business.panhuo.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.bean.ShelfDetailEntity;
import com.ejianc.business.panhuo.shelf.bean.ShelfEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.business.panhuo.shelf.service.IShelfService;
import com.ejianc.foundation.cons.PlanConstant;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.panhuo.shelf.vo.ShelfVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("shelf")
public class ShelfBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IShelfService service;

	@Autowired
	private IGoodsService goodsService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Value("${common.env.base-host}")
	private String baseHost;

	@Autowired
	private IStoreService storeService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ShelfEntity entity = service.selectById(billId);
		// 校验上架数量
		service.validateStoreNum(BeanMapper.map(entity, ShelfVO.class));
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ShelfEntity entity = service.selectById(billId);
		List<GoodsEntity> saveList = new ArrayList<>();
		for (ShelfDetailEntity detail : entity.getDetailList()){
			GoodsEntity vo = new GoodsEntity();
			vo.setId(IdWorker.getId());
			if (detail.getFileIds() != null) {
				CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(detail.getId()), "EJCBT202410000007", "imageUpload2", String.valueOf(vo.getId()), "EJCBT202410000008", "imageUpload2");
				logger.error("afterApprovalProcessor copy file result is " + JSONObject.toJSONString(response));
				String[] imgsPathArray = detail.getFileIds().split(",");
				CommonResponse<AttachmentVO> commonResponse = attachmentApi.queryDetail(imgsPathArray[0]);
				vo.setMainimgPath(baseHost + commonResponse.getData().getFilePath());
			}
			// 主表信息
			vo.setProjectId(entity.getProjectId());
			vo.setProjectCode(entity.getProjectCode());
			vo.setProjectName(entity.getProjectName());
			vo.setOrgId(entity.getOrgId());
			vo.setOrgCode(entity.getOrgCode());
			vo.setOrgName(entity.getOrgName());
			vo.setParentOrgId(entity.getParentOrgId());
			vo.setParentOrgCode(entity.getParentOrgCode());
			vo.setParentOrgName(entity.getParentOrgName());
			vo.setAddress(entity.getAddress());
			vo.setBillState(entity.getBillState());
			vo.setSellUserId(entity.getSellUserId());
			vo.setSellerUserCode(entity.getSellerUserCode());
			vo.setSellUserName(entity.getSellUserName());
			vo.setSellUserPhone(entity.getSellUserPhone());
			vo.setStatus(PlanConstant.GOODS_STATUS_ON);
			vo.setShelfTime(new Date());
			if (null != detail.getStoreId()) {
				vo.setStoreType(storeService.queryStoreType(detail.getStoreId()));
				vo.setStoreName(detail.getStoreName());
				vo.setStoreId(detail.getStoreId());
			}
			vo.setStoreType(entity.getStoreType());
			vo.setCloudStoreId(entity.getCloudStoreId());
			vo.setCloudStoreName(entity.getCloudStoreName());
			vo.setCorpId(entity.getCorpId());
			vo.setCorpCode(entity.getCorpCode());
			vo.setCorpName(entity.getCorpName());

			// 物料信息
			vo.setSourceId(detail.getId());
			vo.setMaterialTypeId(detail.getMaterialTypeId());
			vo.setMaterialTypeName(detail.getMaterialTypeName());
			vo.setMaterialTypeCode(detail.getMaterialTypeCode());
			vo.setMaterialId(detail.getMaterialId());
			vo.setMaterialCode(detail.getMaterialCode());
			vo.setMaterialName(detail.getMaterialName());
			vo.setSpec(detail.getPropertyValue());
			vo.setPropertyValue(detail.getPropertyValue());
			vo.setBrandId(detail.getBrandId());
			vo.setBrandName(detail.getBrandName());
			vo.setProductCode(detail.getProductCode());
			vo.setUnitId(detail.getUnitId());
			vo.setUnitName(detail.getUnitName());
			vo.setMemo(detail.getMemo());
			vo.setDiscount(detail.getDiscount());

			// 数量金额
			vo.setNum(detail.getNum());
			vo.setSurplusNum(detail.getNum());
			vo.setTaxRate(detail.getTaxRate());
			vo.setPrice(detail.getPrice());
			vo.setTaxPrice(null != detail.getTaxPrice() ? detail.getTaxPrice() : detail.getPrice());
			vo.setMny(detail.getMny());
			vo.setTaxMny(null != detail.getTaxMny() ? detail.getTaxMny() : detail.getMny());
			vo.setOriginalPrice(detail.getOriginalPrice());
			vo.setOriginalTaxPrice(null != detail.getOriginalTaxPrice() ? detail.getOriginalTaxPrice() : detail.getOriginalPrice());
			vo.setOriginalMny(detail.getOriginalMny());
			vo.setOriginalTaxMny(null != detail.getOriginalTaxMny() ? detail.getOriginalTaxMny() : detail.getOriginalMny());
			vo.setAttrFlag(detail.getAttrFlag());
			vo.setShelfType(detail.getShelfType());
			saveList.add(vo);
		}
		if(CollectionUtils.isNotEmpty(saveList)){
			goodsService.saveOrUpdateBatch(saveList);
			// 调用库存逻辑
			goodsService.inOutStore(saveList);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
