/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.ICheckService;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/check"})
public class CheckApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IMaterialWarehousingService materialWarehousingService;

    @RequestMapping(value={"/queryCheckByMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, CheckDetailVO>> queryCheckByMonth(Long projectId, String checkMonth) {
        this.logger.info("check-projectId----" + projectId);
        this.logger.info("check-checkMonth---" + checkMonth);
        Map<String, CheckDetailVO> stringCheckDetailVOMap = this.checkService.queryCheckByMonth(projectId, checkMonth);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", stringCheckDetailVOMap);
    }

    @RequestMapping(value={"/getCheckFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getCheckFlag(Long projectId, String checkMonth) {
        this.logger.info("getCheckFlag\u8fdb\u6765\u4e86:" + projectId + "@checkMonth" + checkMonth);
        String checkFlag = this.checkService.getCheckFlag(projectId, checkMonth);
        return CommonResponse.success((String)"\u66f4\u65b0\u5f52\u96c6\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"/updateSettlementState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateSettlementState(Long projectId, Integer state, String checkMonth) {
        this.checkService.updateSettlementState(projectId, state, checkMonth);
        return CommonResponse.success((String)"\u66f4\u65b0\u5f52\u96c6\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"/updateWareHousingUseStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateWareHousingUseStatus(@RequestBody GatherSendVO gatherSendVO) {
        this.materialWarehousingService.updateWareHousingUseStatus(gatherSendVO);
        return CommonResponse.success((String)"\u66f4\u65b0\u5f15\u7528\u72b6\u6001\u6210\u529f");
    }
}

