/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IEquipmentdetailService;
import com.ejianc.business.material.vo.EquipmentdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"equipmentdetailExport"})
public class ExcelEquipmentdetailController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentdetailService service;

    @RequestMapping(value={"/downloadEquipmentdetail"})
    @ResponseBody
    public void downloadEquipmentdetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Equipmentdetail-import.xlsx", (String)"\u5206\u516c\u53f8\u95f2\u7f6e\u8bbe\u5907\u7269\u8d44\u60c5\u51b5\u4e00\u89c8\u8868\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportEquipmentdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportEquipmentdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<EquipmentdetailVO> successList = new ArrayList<EquipmentdetailVO>();
        ArrayList<EquipmentdetailVO> errorList = new ArrayList<EquipmentdetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String sort = datas.get(0);
                String name = datas.get(1);
                String spec = datas.get(2);
                String manufacturerBrand = datas.get(3);
                String idleCount = datas.get(4);
                String depreciation = datas.get(5);
                String purchasePrice = datas.get(6);
                String residual = datas.get(7);
                String estimate = datas.get(8);
                String idleTime = datas.get(9);
                String remarks = datas.get(10);
                EquipmentdetailVO EquipmentdetailVO2 = new EquipmentdetailVO();
                EquipmentdetailVO2.setId(IdWorker.getId());
                EquipmentdetailVO2.setSort(StringUtils.isNotBlank((CharSequence)sort) ? sort : null);
                EquipmentdetailVO2.setName(StringUtils.isNotBlank((CharSequence)name) ? name : null);
                EquipmentdetailVO2.setSpec(StringUtils.isNotBlank((CharSequence)spec) ? spec : null);
                EquipmentdetailVO2.setManufacturerBrand(StringUtils.isNotBlank((CharSequence)manufacturerBrand) ? manufacturerBrand : null);
                EquipmentdetailVO2.setIdleTime(StringUtils.isNotBlank((CharSequence)idleTime) ? idleTime : null);
                EquipmentdetailVO2.setRemarks(StringUtils.isNotBlank((CharSequence)remarks) ? remarks : null);
                if (name == null || TextUtils.isEmpty((CharSequence)name)) {
                    EquipmentdetailVO2.setErrorMsg("\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!TextUtils.isEmpty((CharSequence)idleCount) && !NumberUtil.isNumber((String)idleCount)) {
                    EquipmentdetailVO2.setErrorMsg("\u9650\u5236\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9650\u5236\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    EquipmentdetailVO2.setIdleCount(StringUtils.isNotBlank((CharSequence)idleCount) ? new BigDecimal(idleCount) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)depreciation) && !NumberUtil.isNumber((String)depreciation)) {
                    EquipmentdetailVO2.setErrorMsg("\u6298\u65e7\u7387\uff08*%\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6298\u65e7\u7387\uff08*%\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    EquipmentdetailVO2.setDepreciation(StringUtils.isNotBlank((CharSequence)depreciation) ? new BigDecimal(depreciation) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)purchasePrice) && !NumberUtil.isNumber((String)purchasePrice)) {
                    EquipmentdetailVO2.setErrorMsg("\u91c7\u8d2d\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u91c7\u8d2d\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    EquipmentdetailVO2.setPurchasePrice(StringUtils.isNotBlank((CharSequence)purchasePrice) ? new BigDecimal(purchasePrice) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)residual) && !NumberUtil.isNumber((String)residual)) {
                    EquipmentdetailVO2.setErrorMsg("\u9884\u4f30\u6b8b\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u4f30\u6b8b\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    EquipmentdetailVO2.setResidual(StringUtils.isNotBlank((CharSequence)residual) ? new BigDecimal(residual) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)estimate) && !NumberUtil.isNumber((String)estimate)) {
                    EquipmentdetailVO2.setErrorMsg("\u9884\u4f30\u603b\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u4f30\u603b\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    EquipmentdetailVO2.setEstimate(StringUtils.isNotBlank((CharSequence)estimate) ? new BigDecimal(estimate) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(EquipmentdetailVO2);
                    continue;
                }
                successList.add(EquipmentdetailVO2);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        EquipmentdetailVO resVo = new EquipmentdetailVO();
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportEquipmentdetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentdetailFromDatabase(@RequestBody EquipmentdetailVO EquipmentdetailVO2, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)EquipmentdetailVO2.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.service.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Equipmentdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportEquipmentdetailExportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentdetailFromPage(@RequestBody List<EquipmentdetailVO> list, HttpServletResponse response) {
        ArrayList<EquipmentdetailVO> concatList = new ArrayList<EquipmentdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EquipmentdetailVO EquipmentdetailVO2 = list.get(i);
                switch (EquipmentdetailVO2.getSort()) {
                    case "K1667821075161": {
                        EquipmentdetailVO2.setSort("\u5de5\u7a0b\u7269\u8d44");
                        break;
                    }
                    case "K1667821144441": {
                        EquipmentdetailVO2.setSort("\u6d4b\u91cf\u8bbe\u5907");
                        break;
                    }
                    case "K1667821147488": {
                        EquipmentdetailVO2.setSort("\u884c\u653f\u7269\u8d44");
                    }
                }
                concatList.add(EquipmentdetailVO2);
            }
        }
        List<EquipmentdetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<EquipmentdetailVO>> beans = new HashMap<String, List<EquipmentdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Equipmentdetail-export.xlsx", beans, response);
    }

    private List<EquipmentdetailVO> handleList(List<EquipmentdetailVO> list, List<EquipmentdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            EquipmentdetailVO EquipmentdetailVO2 = list.get(i);
            List<EquipmentdetailVO> children = EquipmentdetailVO2.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

