/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.bean.GatherDetailEntity;
import com.ejianc.business.material.bean.GatherEntity;
import com.ejianc.business.material.mapper.GatherMapper;
import com.ejianc.business.material.service.IGatherDetailService;
import com.ejianc.business.material.service.IGatherService;
import com.ejianc.business.material.vo.GatherDetailVO;
import com.ejianc.business.material.vo.GatherVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gatherService")
public class GatherServiceImpl
extends BaseServiceImpl<GatherMapper, GatherEntity>
implements IGatherService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "GATHER_CODE";
    @Autowired
    private IGatherDetailService gatherDetailService;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @Override
    public void generation(String generateDate) {
        LocalDate today = LocalDate.now();
        if (StringUtils.isNotBlank((CharSequence)generateDate)) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            today = LocalDate.parse(generateDate, df);
        }
        this.logger.error("generation today" + JSONObject.toJSONString((Object)today));
        boolean isFirstDayOfQuarter = this.isFirstDayOfQuarter(today);
        this.logger.error("generation isFirstDayOfQuarter" + isFirstDayOfQuarter);
        if (isFirstDayOfQuarter) {
            int lastQuarterNumber;
            int lastQuarterYear;
            LocalDate firstDayOfLastQuarter = this.getFirstDayOfLastQuarter(today);
            LocalDate lastDayOfLastQuarter = this.getLastDayOfLastQuarter(today);
            LocalDateTime firstTime = firstDayOfLastQuarter.atStartOfDay();
            LocalDateTime lastTime = lastDayOfLastQuarter.atTime(23, 59, 59);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String beginDate = firstTime.format(formatter);
            String endDate = lastTime.format(formatter);
            int month = today.getMonthValue();
            if (month <= 3) {
                lastQuarterYear = today.getYear() - 1;
                lastQuarterNumber = 4;
            } else if (month <= 6) {
                lastQuarterYear = today.getYear();
                lastQuarterNumber = 1;
            } else if (month <= 9) {
                lastQuarterYear = today.getYear();
                lastQuarterNumber = 2;
            } else {
                lastQuarterYear = today.getYear();
                lastQuarterNumber = 3;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            ArrayList<GatherDetailEntity> detailResult = new ArrayList<GatherDetailEntity>();
            this.logger.error("generateDate beginDate" + beginDate);
            this.logger.error("generateDate endDate" + endDate);
            List<GatherDetailVO> recordVOs = ((GatherMapper)this.baseMapper).generationRecord(beginDate, endDate);
            if (CollectionUtils.isNotEmpty(recordVOs)) {
                Map<String, List<GatherDetailVO>> map = recordVOs.stream().collect(Collectors.groupingBy(x -> x.getParentOrgId() + "@" + x.getParentOrgName() + "@" + x.getOrgId() + "@" + x.getProjectId() + "@" + x.getProjectName()));
                for (String key : map.keySet()) {
                    Long gatherId = IdWorker.getId();
                    GatherVO gatherVO = new GatherVO();
                    gatherVO.setId(gatherId);
                    gatherVO.setGatherYear(String.valueOf(lastQuarterYear));
                    gatherVO.setGatherQuarter(String.valueOf(lastQuarterNumber));
                    String[] arr = key.split("@");
                    gatherVO.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                    gatherVO.setParentOrgId(Long.valueOf(arr[0]));
                    gatherVO.setParentOrgName(arr[1]);
                    gatherVO.setOrgId(Long.valueOf(arr[2]));
                    gatherVO.setProjectId(Long.valueOf(arr[3]));
                    gatherVO.setProjectName(arr[4]);
                    CommonResponse response = this.zjkjProjectApi.queryDetailById(gatherVO.getProjectId());
                    if (response.isSuccess() && null != response.getData()) {
                        gatherVO.setProjectCode(((ProjectVO)response.getData()).getBillCode());
                    }
                    BigDecimal totalMny = BigDecimal.ZERO;
                    for (GatherDetailVO detailVO : map.get(key)) {
                        totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)detailVO.getDealMny());
                        GatherDetailEntity detailEntity = (GatherDetailEntity)((Object)BeanMapper.map((Object)((Object)detailVO), GatherDetailEntity.class));
                        detailEntity.setGatherId(gatherId);
                        detailResult.add(detailEntity);
                    }
                    gatherVO.setTotalMny(totalMny);
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)gatherVO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    gatherVO.setBillCode((String)billCode.getData());
                    result.add(BeanMapper.map((Object)((Object)gatherVO), GatherEntity.class));
                }
                if (CollectionUtils.isNotEmpty(result)) {
                    this.saveOrUpdateBatch(result);
                }
                if (CollectionUtils.isNotEmpty(detailResult)) {
                    this.gatherDetailService.saveOrUpdateBatch(detailResult);
                }
            }
        }
    }

    private boolean isFirstDayOfQuarter(LocalDate date) {
        return date.getMonthValue() == 1 && date.getDayOfMonth() == 1 || date.getMonthValue() == 4 && date.getDayOfMonth() == 1 || date.getMonthValue() == 7 && date.getDayOfMonth() == 1 || date.getMonthValue() == 10 && date.getDayOfMonth() == 1;
    }

    private LocalDate getFirstDayOfLastQuarter(LocalDate date) {
        int month = date.getMonthValue();
        if (month <= 3) {
            return LocalDate.of(date.getYear() - 1, 10, 1);
        }
        if (month <= 6) {
            return LocalDate.of(date.getYear(), 1, 1);
        }
        if (month <= 9) {
            return LocalDate.of(date.getYear(), 4, 1);
        }
        return LocalDate.of(date.getYear(), 7, 1);
    }

    private LocalDate getLastDayOfLastQuarter(LocalDate date) {
        int month = date.getMonthValue();
        if (month <= 3) {
            return LocalDate.of(date.getYear() - 1, 12, 31);
        }
        if (month <= 6) {
            return LocalDate.of(date.getYear(), 3, 31);
        }
        if (month <= 9) {
            return LocalDate.of(date.getYear(), 6, 30);
        }
        return LocalDate.of(date.getYear(), 9, 30);
    }
}

