/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.TransferorderEntity;
import com.ejianc.business.material.bean.TransferorderdetailEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.business.material.service.ITransferorderdetailService;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.panhuo.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.panhuo.order.bean.AllotOrderEntity;
import com.ejianc.business.panhuo.order.mapper.AllotOrderMapper;
import com.ejianc.business.panhuo.order.service.IAllotOrderDetailService;
import com.ejianc.business.panhuo.order.service.IAllotOrderService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyDetailVO;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.foundation.panhuo.constants.CommonConstants;
import com.ejianc.foundation.panhuo.order.vo.AllotOrderVO;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allotOrderService")
public class AllotOrderServiceImpl
extends BaseServiceImpl<AllotOrderMapper, AllotOrderEntity>
implements IAllotOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "PANHUO_ORDER";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private AllotOrderMapper mapper;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IAllotOrderDetailService detailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IStoreService storeService;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;
    @Autowired
    private ITransferorderService transferorderService;
    @Autowired
    private ITransferorderdetailService transferorderdetailService;
    private static final String BILL_CODE_DB = "WZ_DBD";

    @Override
    public void saveNewOrderByApply(AllotApplyVO allotApplyVO) {
        ArrayList<AllotOrderEntity> newOrderList = new ArrayList<AllotOrderEntity>();
        ArrayList<AllotOrderDetailEntity> newOrderDetailList = new ArrayList<AllotOrderDetailEntity>();
        Map applyDetailMap = allotApplyVO.getDetailList().stream().collect(Collectors.groupingBy(AllotApplyDetailVO::getExceedOrgId, Collectors.toList()));
        List<Long> shelfDetailIds = allotApplyVO.getDetailList().stream().map(AllotApplyDetailVO::getSourceId).collect(Collectors.toList());
        List<GoodsEntity> goods = this.goodsService.getAllByIds(shelfDetailIds);
        Map<Long, GoodsEntity> shelfDetailMap = goods.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        AllotOrderEntity tmp = null;
        for (Long outOrgId : applyDetailMap.keySet()) {
            tmp = this.generateOrderByApply(allotApplyVO, applyDetailMap.get(outOrgId), shelfDetailMap);
            newOrderDetailList.addAll(tmp.getAllotOrderDetailList());
            newOrderList.add(tmp);
        }
        this.detailService.saveOrUpdateBatch(newOrderDetailList, newOrderDetailList.size(), false);
        super.saveOrUpdateBatch(newOrderList, newOrderList.size(), false);
        List<Long> projectIdS = newOrderList.stream().map(AllotOrderEntity::getOutProjectId).collect(Collectors.toList());
        Map<Long, Long> projectManagerIdS = this.getProjectManagerIdS(projectIdS);
        List categoryIds = newOrderDetailList.stream().map(AllotOrderDetailEntity::getMaterialTypeId).collect(Collectors.toList());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (AllotOrderEntity order : newOrderList) {
            Long projectManagerId = null;
            ArrayList<String> userIds = new ArrayList<String>();
            if (null != order.getOutProjectId() && projectManagerIdS.containsKey(order.getOutProjectId())) {
                projectManagerId = projectManagerIdS.get(order.getOutProjectId());
            }
            for (AllotOrderDetailEntity detail : order.getAllotOrderDetailList()) {
                if (userIds.contains(detail.getSellUserId().toString())) continue;
                userIds.add(detail.getSellUserId().toString());
            }
            PushMsgParameter parameter = new PushMsgParameter();
            StringBuilder content = new StringBuilder();
            content.append("\u3010").append(order.getBillCode()).append("\u3011");
            if (StringUtils.isNotEmpty((CharSequence)order.getCategoryNames())) {
                content.append("\uff0c\u3010").append(order.getCategoryNames()).append("\u3011");
            }
            content.append("\u5df2\u88ab\u3010").append(order.getInProjectName()).append("\u3011\u4e0b\u5355\u8c03\u8d27\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
            parameter.setContent(content.toString());
            parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString());
            parameter.setSubject("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010" + order.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u95f2\u7f6e\u7269\u8d44\u88ab\u4e0b\u5355\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
            if (null != projectManagerId) {
                userIds.add(projectManagerId.toString());
            }
            String[] longs = userIds.toArray(new String[userIds.size()]);
            parameter.setReceivers(longs);
            this.sendMsg(parameter, order.getId(), "\u8c03\u62e8\u7533\u8bf7\u751f\u6548 \u5411\u9879\u76ee\u7ecf\u7406\u3001\u7269\u8d44\u53d1\u5e03\u4eba\u53d1\u9001\u6d88\u606f");
        }
    }

    @Override
    public void deleteOrderByApply(Long allotApplyId) {
        this.logger.info("\u6839\u636e\u8c03\u62e8\u5355Id-{}\u5220\u9664\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f", (Object)allotApplyId);
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"allot_apply_id", (Object)allotApplyId);
        countQuery.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.gt((Object)"business_status", (Object)AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5df2\u786e\u8ba4.getCode())).or()).gt((Object)"edit_num", (Object)0));
        int count = super.count((Wrapper)countQuery);
        if (count > 0) {
            throw new BusinessException("\u8c03\u62e8\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528");
        }
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"id"});
        query.eq((Object)"allot_apply_id", (Object)allotApplyId);
        List orderIds = super.listObjs((Wrapper)query, item -> Long.valueOf(item.toString()));
        super.removeByIds((Collection)orderIds);
    }

    @Override
    public void checkAllotableNum(List<AllotOrderDetailEntity> allotOrderDetailList) {
        Map<Long, BigDecimal> goodsAllotableNumMap = this.goodsService.getAllotableNum(allotOrderDetailList.stream().map(item -> item.getSourceId()).collect(Collectors.toList()));
        StringBuilder sp = new StringBuilder();
        for (AllotOrderDetailEntity detail : allotOrderDetailList) {
            if (detail.getAllotNum().compareTo(ComputeUtil.safeAdd((BigDecimal)goodsAllotableNumMap.get(detail.getSourceId()), (BigDecimal)detail.getInitialAllotNum())) <= 0) continue;
            sp.append("\u7f16\u7801\uff1a").append(detail.getMaterialCode()).append("-").append("\u54c1\u724c\uff1a").append(detail.getBrandName()).append("\u3001");
        }
        if (sp.length() > 0) {
            throw new BusinessException("\u7269\u8d44" + sp.substring(0, sp.length() - 1) + "\u8c03\u62e8\u91cf\u8d85\u51fa\u53ef\u4e0b\u5355\u91cf");
        }
    }

    @Override
    public AllotOrderVO saveEditAllotOrderInfo(AllotOrderEntity entity) {
        this.checkAllotableNum(entity.getAllotOrderDetailList());
        this.goodsService.updateAllotNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "update", "allot"), true);
        entity.setEditNum(entity.getEditNum() + 1);
        entity.setEditUserId(InvocationInfoProxy.getUserid());
        entity.setEditUserName(this.sessionManager.getUserContext().getUserName());
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5f85\u786e\u8ba4.getCode());
        super.saveOrUpdate((Object)entity, false);
        Long inProjetMgid = this.getProjectManagerId(entity.getInProjectId());
        ArrayList<String> recIds = new ArrayList<String>();
        if (null != inProjetMgid) {
            recIds.add(inProjetMgid.toString());
        }
        recIds.add(entity.getPurUserId().toString());
        StringBuilder content = new StringBuilder();
        content.append("\u60a8\u8ba2\u8d2d\u7684\u7269\u8d44\u3010").append(entity.getStoreType() == 1 ? "\u8c03\u51fa\u9879\u76ee\uff1a" + entity.getOutProjectName() : "\u8c03\u51fa\u5355\u4f4d" + entity.getOutParentOrgName()).append("\uff0c\u7269\u8d44\u5206\u7c7b\uff1a").append(entity.getCategoryNames()).append("\u3011\u8c03\u51fa\u65b9\u5df2\u4fee\u6539\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u5c3d\u5feb\u786e\u8ba4\u3002");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(recIds.toArray(new String[recIds.size()]));
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + entity.getId().toString());
        parameter.setSubject("\u3010\u8c03\u5165\u8ba2\u5355\u3011\u3010" + entity.getBillCode() + "\u3011\u3010" + sdf.format(entity.getCreateTime()) + "\u3011");
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        this.sendMsg(parameter, entity.getId(), "\u8c03\u51fa\u65b9\u4fee\u6539\uff0c\u5411\u8c03\u5165\u65b9\u9884\u8ba2\u4eba");
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    public List<GoodsVO> getUpdateGoodList(List<AllotOrderDetailEntity> allotOrderDetailList, String oprType, String allotType) {
        ArrayList<GoodsVO> resp = new ArrayList<GoodsVO>();
        allotOrderDetailList.stream().forEach(detail -> {
            GoodsVO g = new GoodsVO();
            g.setId(detail.getSourceId());
            if ("alloted".equals(allotType)) {
                g.setAllotedNum(detail.getAllotNum());
            } else if ("update".equals(oprType)) {
                g.setAllotNum(ComputeUtil.safeSub((BigDecimal)detail.getAllotNum(), (BigDecimal)detail.getInitialAllotNum()));
            } else {
                g.setAllotNum(detail.getAllotNum());
            }
            resp.add(g);
        });
        return resp;
    }

    @Override
    public void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{allotOrderId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)allotOrderId, (Object)oprMsg);
        }
    }

    public void sendEmail(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{allotOrderId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u8c03\u62e8\u8ba2\u5355id-{},{}\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)allotOrderId, (Object)oprMsg);
        }
    }

    @Override
    public AllotOrderVO saveOrderInStore(AllotOrderEntity entity) {
        this.goodsService.updateAllotNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "allot"), false);
        this.goodsService.updateAllotedNum(this.getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "alloted"), true);
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.\u4ea4\u6613\u5b8c\u6210.getCode());
        super.saveOrUpdate((Object)entity, false);
        this.saveOrderOutStore(entity);
        this.saveTransfor(entity);
        this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u5165\u65b9\u8c03\u5165\u6d41\u6c34\u6210\u529f\uff01", (Object)entity.getId());
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010").append(entity.getBillCode()).append("\u3011").append("\uff0c\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u5b8c\u6210\u4ea4\u6613\uff01");
        content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(entity.getInProjectName()).append("\u3011\uff0c\u5df2\u5b8c\u6210\u4ea4\u6613\uff0c\u5e76\u6536\u8d27\u5165\u5e93\uff01");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{entity.getPurUserId().toString()});
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 + entity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        this.sendMsg(parameter, entity.getId(), "\u8c03\u5165\u65b9\u6536\u8d27\u5165\u5e93\u5b8c\u6210\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba");
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    public AllotOrderVO saveOrderInStoreEdit(AllotOrderEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
    }

    @Override
    public void saveOrderOutStore(AllotOrderEntity entity) {
        this.sendOutStoreData(entity);
        this.logger.info("\u8c03\u62e8\u8ba2\u5355-{}\u751f\u6210\u8c03\u51fa\u65b9\u51fa\u5e93\u6d41\u6c34\u6210\u529f\uff01", (Object)entity.getId());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void saveTransfor(AllotOrderEntity entity) {
        TransferorderEntity transferorderEntity = new TransferorderEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            transferorderEntity.setBillCode((String)billCode.getData());
        }
        transferorderEntity.setBillState(1);
        transferorderEntity.setApproveTime(new Date());
        transferorderEntity.setDialitemsId(entity.getOutProjectId());
        transferorderEntity.setDialItems(entity.getOutProjectName());
        transferorderEntity.setOrgId(entity.getOutParentOrgId());
        transferorderEntity.setOrgName(entity.getOutParentOrgName());
        transferorderEntity.setProjectDepartmentId(entity.getOutOrgId());
        transferorderEntity.setDialinitemsId(entity.getInProjectId());
        transferorderEntity.setDialInitems(entity.getInProjectName());
        transferorderEntity.setIncomingWarehouse(entity.getInStoreId());
        transferorderEntity.setIncomingWarehouseName(entity.getInStoreName());
        transferorderEntity.setProjectDepartmentIdEnter(entity.getInOrgId());
        transferorderEntity.setDialOrg(entity.getInParentOrgName());
        transferorderEntity.setDialOrgId(entity.getInParentOrgId());
        transferorderEntity.setSourceType(2);
        transferorderEntity.setDates(new Date());
        transferorderEntity.setProjectOrg(entity.getOutParentOrgName());
        transferorderEntity.setId(IdWorker.getId());
        transferorderEntity.setAgentId(entity.getPurUserId());
        transferorderEntity.setAgentName(entity.getPurUserName());
        List<AllotOrderDetailEntity> allotOrderDetailList = entity.getAllotOrderDetailList();
        ArrayList<TransferorderdetailEntity> transferdetailEntityList = new ArrayList<TransferorderdetailEntity>();
        for (AllotOrderDetailEntity allotOrderDetailEntity : allotOrderDetailList) {
            TransferorderdetailEntity transferorderdetailEntity = new TransferorderdetailEntity();
            transferorderdetailEntity.setMid(transferorderEntity.getId());
            transferorderdetailEntity.setMaterialId(allotOrderDetailEntity.getMaterialId());
            transferorderdetailEntity.setMaterialCode(allotOrderDetailEntity.getMaterialCode());
            transferorderdetailEntity.setMaterialName(allotOrderDetailEntity.getMaterialName());
            transferorderdetailEntity.setMeasurementUnit(allotOrderDetailEntity.getUnitName());
            transferorderdetailEntity.setQuantity(allotOrderDetailEntity.getAllotNum());
            transferorderdetailEntity.setTransferAmount(allotOrderDetailEntity.getDetailAllotMny());
            transferorderdetailEntity.setHairStoreId(allotOrderDetailEntity.getOutStoreId());
            transferorderdetailEntity.setHairStoreName(allotOrderDetailEntity.getOutStoreName());
            transferorderdetailEntity.setMaterialCategoryId(allotOrderDetailEntity.getMaterialTypeId());
            transferorderdetailEntity.setMaterialCategoryName(allotOrderDetailEntity.getMaterialTypeName());
            transferorderdetailEntity.setMaterialCategoryCode(allotOrderDetailEntity.getMaterialTypeCode());
            transferorderdetailEntity.setEnterPrice(allotOrderDetailEntity.getSellTaxPrice());
            transferorderdetailEntity.setEnterUnitPrice(allotOrderDetailEntity.getSellPrice());
            transferorderdetailEntity.setEnterAmount(allotOrderDetailEntity.getDetailAllotTaxMny());
            transferorderdetailEntity.setEnterAmountExcluetax(allotOrderDetailEntity.getDetailAllotMny());
            transferdetailEntityList.add(transferorderdetailEntity);
        }
        this.transferorderService.saveOrUpdate((Object)transferorderEntity);
        this.transferorderdetailService.saveBatch(transferdetailEntityList);
    }

    @Override
    public void sendOutStoreData(AllotOrderEntity entity) {
        List<AllotOrderDetailEntity> allotOrderDetailList = entity.getAllotOrderDetailList();
        List<Object> goodIds = new ArrayList();
        Map recordMap = allotOrderDetailList.stream().collect(Collectors.toMap(AllotOrderDetailEntity::getSourceId, Function.identity()));
        if (CollectionUtils.isNotEmpty(allotOrderDetailList)) {
            goodIds = allotOrderDetailList.stream().map(AllotOrderDetailEntity::getSourceId).collect(Collectors.toList());
        }
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, goodIds);
        List flowmeterList = this.flowmeterService.list((Wrapper)lambdaFlower);
        ArrayList<Long> storeIds = new ArrayList<Long>();
        for (FlowmeterEntity flowmeterEntity : flowmeterList) {
            storeIds.add(flowmeterEntity.getStoreId());
            if (!recordMap.containsKey(flowmeterEntity.getMid())) continue;
            AllotOrderDetailEntity allotOrderDetailEntity = (AllotOrderDetailEntity)((Object)recordMap.get(flowmeterEntity.getMid()));
            flowmeterEntity.setQuantity(ComputeUtil.safeSub((BigDecimal)flowmeterEntity.getQuantity(), (BigDecimal)allotOrderDetailEntity.getAllotNum()));
            flowmeterEntity.setAmountExcluetax(ComputeUtil.safeMultiply((BigDecimal)flowmeterEntity.getQuantity(), (BigDecimal)flowmeterEntity.getUnitPriceExcluetax()));
            flowmeterEntity.setAmountIncluetax(ComputeUtil.safeMultiply((BigDecimal)flowmeterEntity.getQuantity(), (BigDecimal)flowmeterEntity.getUnitPriceIncluetax()));
        }
        this.flowmeterService.updateBatchById(flowmeterList);
        ArrayList<FlowmeterEntity> flowerList = new ArrayList<FlowmeterEntity>();
        for (AllotOrderDetailEntity allotOrderDetailEntity : allotOrderDetailList) {
            FlowmeterEntity flowmeterOutEntity = this.createrOutFlowmeter(entity, allotOrderDetailEntity);
            storeIds.add(flowmeterOutEntity.getStoreId());
            flowerList.add(flowmeterOutEntity);
            FlowmeterEntity flowmeterInEntity = this.createrInFlowmeter(entity, allotOrderDetailEntity);
            storeIds.add(flowmeterInEntity.getStoreId());
            flowerList.add(flowmeterInEntity);
        }
        this.flowmeterService.saveBatch(flowerList);
        for (Long storeId : storeIds) {
            this.realtimebalanceService.updateRealtimeBalance(storeId);
        }
    }

    private FlowmeterEntity createrOutFlowmeter(AllotOrderEntity allotOrderEntity, AllotOrderDetailEntity entity) {
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(allotOrderEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setMaterialId(entity.getMaterialId());
        flowmeterEntity.setBillCode(allotOrderEntity.getBillCode());
        flowmeterEntity.setProjectId(allotOrderEntity.getOutProjectId());
        flowmeterEntity.setProjectName(allotOrderEntity.getOutProjectName());
        flowmeterEntity.setStoreId(entity.getOutStoreId());
        flowmeterEntity.setStoreType(entity.getAttrFlag());
        flowmeterEntity.setStoreName(entity.getOutStoreName());
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialTypeId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialTypeCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialTypeName());
        flowmeterEntity.setBillStatus(1);
        flowmeterEntity.setBillTime(allotOrderEntity.getCreateTime());
        flowmeterEntity.setOperationType("\u51fa\u5e93");
        flowmeterEntity.setAccessType("\u8c03\u51fa");
        flowmeterEntity.setTransferorderType("\u8c03\u62e8\u51fa\u5e93");
        flowmeterEntity.setTime(new Date());
        flowmeterEntity.setQuantity(entity.getAllotNum());
        flowmeterEntity.setAmountIncluetax(entity.getDetailAllotTaxMny());
        flowmeterEntity.setAmountExcluetax(entity.getDetailAllotMny());
        flowmeterEntity.setApproveTime(new Date());
        flowmeterEntity.setUnitPriceIncluetax(entity.getSellTaxPrice());
        flowmeterEntity.setUnitPriceExcluetax(entity.getSellPrice());
        flowmeterEntity.setOrgId(allotOrderEntity.getOutParentOrgId());
        flowmeterEntity.setOrgName(allotOrderEntity.getOutParentOrgName());
        flowmeterEntity.setMeasurementUnit(entity.getUnitName());
        flowmeterEntity.setProjectDepartmentId(allotOrderEntity.getOutOrgId());
        flowmeterEntity.setBillType(2);
        flowmeterEntity.setSpecialModel(entity.getPropertyValue());
        return flowmeterEntity;
    }

    private FlowmeterEntity createrInFlowmeter(AllotOrderEntity allotOrderEntity, AllotOrderDetailEntity entity) {
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(allotOrderEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setMaterialId(entity.getMaterialId());
        flowmeterEntity.setBillCode(allotOrderEntity.getBillCode());
        flowmeterEntity.setProjectId(allotOrderEntity.getInProjectId());
        flowmeterEntity.setProjectName(allotOrderEntity.getInProjectName());
        flowmeterEntity.setStoreId(allotOrderEntity.getInStoreId());
        flowmeterEntity.setStoreType(allotOrderEntity.getInStoreAttrFlag());
        flowmeterEntity.setStoreName(allotOrderEntity.getInStoreName());
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialTypeId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialTypeCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialTypeName());
        flowmeterEntity.setBillStatus(1);
        flowmeterEntity.setBillTime(allotOrderEntity.getCreateTime());
        flowmeterEntity.setOperationType("\u5165\u5e93");
        flowmeterEntity.setAccessType("\u8c03\u5165");
        flowmeterEntity.setTransferorderType("\u8c03\u62e8\u5165\u5e93");
        flowmeterEntity.setTime(new Date());
        flowmeterEntity.setQuantity(entity.getAllotNum());
        flowmeterEntity.setAmountIncluetax(entity.getDetailAllotTaxMny());
        flowmeterEntity.setAmountExcluetax(entity.getDetailAllotMny());
        flowmeterEntity.setApproveTime(new Date());
        flowmeterEntity.setUnitPriceIncluetax(entity.getSellTaxPrice());
        flowmeterEntity.setUnitPriceExcluetax(entity.getSellPrice());
        flowmeterEntity.setOrgId(allotOrderEntity.getInParentOrgId());
        flowmeterEntity.setOrgName(allotOrderEntity.getInParentOrgName());
        flowmeterEntity.setMeasurementUnit(entity.getUnitName());
        flowmeterEntity.setProjectDepartmentId(allotOrderEntity.getInOrgId());
        flowmeterEntity.setSpecialModel(entity.getPropertyValue());
        flowmeterEntity.setBillType(2);
        return flowmeterEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrder(AllotOrderEntity order) {
        CommonResponse empResp = this.employeeApi.getById(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if (!empResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u7528\u6237id-{}\u5931\u8d25\uff0c{}", (Object)InvocationInfoProxy.getEmployeeId(), (Object)JSONObject.toJSONString((Object)empResp));
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        order.setCancelTime(new Date());
        order.setCancelUserCode(emp.getCode());
        order.setCancelUserId(emp.getId());
        order.setCancelUserName(emp.getUserName());
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        String pcUrl = null;
        String oprMsg = null;
        String[] receivers = null;
        Set<String> receiverList = null;
        Long projectManagerId = null;
        switch (order.getBusinessStatus()) {
            case 1: 
            case 3: {
                String[] stringArray;
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u53d6\u6d88.getCode());
                projectManagerId = this.getProjectManagerId(order.getInProjectId());
                if (null != projectManagerId) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = order.getPurUserId().toString();
                    stringArray = stringArray2;
                    stringArray2[1] = projectManagerId.toString();
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = order.getPurUserId().toString();
                }
                receivers = stringArray;
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                content.append("\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(order.getInProjectName()).append("\u3011\u7533\u8bf7\u8c03\u62e8\u7684\u7269\u8d44\u5df2\u88ab\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                oprMsg = "\u8ba2\u5355\u8c03\u51fa\u65b9\u53d6\u6d88\uff0c\u5411\u8c03\u5165\u65b9\u8054\u7cfb\u4eba";
                pcUrl = this.BASE_HOST + CommonConstants.\u8c03\u5165\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString();
                break;
            }
            case 2: {
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u53d6\u6d88.getCode());
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                receiverList.add(order.getEditUserId().toString());
                projectManagerId = this.getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8ba2\u5355\u88ab\u8c03\u5165\u65b9\u53d6\u6d88\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01");
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("\u8ba2\u5355\u7f16\u53f7\u3010").append(order.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(order.getInProjectName()).append("\u3011\uff0c\u7269\u8d44\u5206\u7c7b\u3010").append(order.getCategoryNames()).append("\u3011\u8c03\u5165\u65b9\u5df2\u53d6\u6d88\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
                oprMsg = "\u8ba2\u5355\u8c03\u5165\u65b9\u65b9\u53d6\u6d88\uff0c\u5411\u8c03\u6d3d\u5546\u4fee\u6539\u4eba\u3001\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406";
                pcUrl = this.BASE_HOST + CommonConstants.\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString();
                break;
            }
            case 5: {
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u53d6\u6d88.getCode());
                subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011,\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8c03\u5165\u65b9\u62d2\u7edd\u5165\u5e93\uff0c\u4ea4\u6613\u7ed3\u675f\uff01");
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                projectManagerId = this.getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(order.getInProjectName()).append("\u3011\u8c03\u5165\u65b9\u62d2\u7edd\u5165\u5e93\uff0c\u4ea4\u6613\u7ed3\u675f\uff01");
                oprMsg = "\u8ba2\u5355\u8c03\u5165\u65b9\u8c03\u62e8\u62d2\u7edd\u5165\u5e93\uff0c\u5411\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406";
                pcUrl = this.BASE_HOST + CommonConstants.\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString();
                break;
            }
            default: {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u4e3a\u3010" + AllotOrderBusinessStatusEnums.getNameByCode((Integer)order.getBusinessStatus()) + "\u3011\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
            }
        }
        this.goodsService.updateAllotNum(this.getUpdateGoodList(order.getAllotOrderDetailList(), "release", "allot"), false);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(pcUrl);
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.sendMsg(parameter, order.getId(), oprMsg);
        super.saveOrUpdate((Object)order, false);
    }

    private Long getProjectManagerId(Long projectId) {
        CommonResponse commonResponse = this.zjkjProjectApi.queryDetailById(projectId);
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            ProjectVO data = (ProjectVO)commonResponse.getData();
            return data.getLeader();
        }
        return null;
    }

    private Map<Long, Long> getProjectManagerIdS(List<Long> projectId) {
        CommonResponse jsonArrayCommonResponse = this.zjkjProjectApi.queryProjectArray(projectId);
        if (!jsonArrayCommonResponse.isSuccess() || ((JSONArray)jsonArrayCommonResponse.getData()).size() == 0) {
            return null;
        }
        JSONArray jsonArrayCommonResponseData = (JSONArray)jsonArrayCommonResponse.getData();
        List list = JSONObject.parseArray((String)jsonArrayCommonResponseData.toJSONString(), ProjectVO.class);
        Map<Long, Long> collect = list.stream().filter(e -> null != e.getLeader()).collect(Collectors.toMap(BaseVO::getId, ProjectVO::getLeader));
        return collect;
    }

    @Override
    public void confirmOrder(Long id) {
        AllotOrderEntity order = (AllotOrderEntity)((Object)super.selectById((Serializable)id));
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5df2\u786e\u8ba4.getCode());
        Set<String> receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
        receiverList.add(order.getEditUserId().toString());
        Long projectManagerId = this.getProjectManagerId(order.getOutProjectId());
        if (null != projectManagerId) {
            receiverList.add(projectManagerId.toString());
        }
        String[] receivers = receiverList.toArray(new String[receiverList.size()]);
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("\u3010\u7269\u8d44\u8c03\u62e8\u3011\uff0c\u3010").append(order.getBillCode()).append("\u3011\uff0c\u3010").append(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date())).append("\u3011\u8c03\u5165\u65b9\u5df2\u786e\u8ba4\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
        content.append("\u8ba2\u5355\u7f16\u53f7\u3010").append(order.getBillCode()).append("\u3011\uff0c\u8c03\u5165\u9879\u76ee\u3010").append(order.getInProjectName()).append("\u3011\uff0c\u7269\u8d44\u5206\u7c7b\u3010").append(order.getCategoryNames()).append("\u3011\u8c03\u5165\u65b9\u5df2\u786e\u8ba4\u8ba2\u5355\uff0c\u8bf7\u67e5\u770b\u3002");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u8c03\u51fa\u8ba2\u5355PC\u8be6\u60c5 + order.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        this.sendMsg(parameter, order.getId(), "\u8ba2\u5355\u8c03\u5165\u65b9\u786e\u8ba4\u8ba2\u5355\uff0c\u5411\u8c03\u6d3d\u5546\u4fee\u6539\u4eba\u3001\u8c03\u51fa\u65b9\u4e0a\u67b6\u4eba\u3001\u9879\u76ee\u7ecf\u7406");
        super.saveOrUpdate((Object)order, false);
    }

    private List<AllotOrderDetailEntity> generateOrderDetailByApply(List<AllotApplyDetailVO> allotApplyDetailVOS, AllotOrderEntity order, Map<Long, GoodsEntity> shelfDetailMap) {
        List resp = BeanMapper.mapList(allotApplyDetailVOS, AllotOrderDetailEntity.class);
        BigDecimal totalAllotMny = BigDecimal.ZERO;
        BigDecimal totalAllotTaxMny = BigDecimal.ZERO;
        HashMap<Long, String> categoryMap = new HashMap<Long, String>();
        for (AllotOrderDetailEntity orderDetail : resp) {
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            this.clearBaseField(orderDetail);
            orderDetail.setOrderId(order.getId());
            orderDetail.setSellNum(shelfDetailMap.get(orderDetail.getSourceId()).getNum());
            orderDetail.setDetailAllotTaxMny(orderDetail.getAllotTaxMny());
            orderDetail.setDetailAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetMny(orderDetail.getDetailAllotMny());
            orderDetail.setInitialAssetTaxMny(orderDetail.getDetailAssetTaxMny());
            orderDetail.setInitialAssetMny(orderDetail.getDetailAssetMny());
            orderDetail.setInitialSellPrice(orderDetail.getSellPrice());
            orderDetail.setInitialSellTaxPrice(orderDetail.getSellTaxPrice());
            orderDetail.setInitialAllotNum(orderDetail.getAllotNum());
            orderDetail.setMemo(null);
            categoryMap.put(orderDetail.getMaterialTypeId(), orderDetail.getMaterialTypeName());
            totalAllotMny = ComputeUtil.safeAdd((BigDecimal)totalAllotMny, (BigDecimal)orderDetail.getDetailAllotMny());
            totalAllotTaxMny = ComputeUtil.safeAdd((BigDecimal)totalAllotTaxMny, (BigDecimal)orderDetail.getDetailAllotTaxMny());
        }
        order.setTotalAssetTaxMny(totalAllotTaxMny);
        order.setTotalAllotTaxMny(totalAllotTaxMny);
        order.setTotalAllotMny(totalAllotMny);
        order.setTotalAssetMny(totalAllotMny);
        order.setCategoryNames(StringUtils.join(categoryMap.values(), (String)","));
        return resp;
    }

    private void clearBaseField(BaseEntity base) {
        base.setId(null);
        base.setCreateTime(null);
        base.setCreateUserCode(null);
        base.setUpdateUserCode(null);
        base.setUpdateTime(null);
        base.setVersion(Integer.valueOf(0));
    }

    private AllotOrderEntity generateOrderByApply(AllotApplyVO allotApplyVO, List<AllotApplyDetailVO> allotApplyDetailVOs, Map<Long, GoodsEntity> shelfDetailMap) {
        AllotOrderEntity order = new AllotOrderEntity();
        AllotApplyDetailVO tmpApplyDetail = allotApplyDetailVOs.get(0);
        order.setId(IdWorker.getId());
        order.setAllotApplyId(allotApplyVO.getId());
        order.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        order.setEditNum(0);
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u5f85\u786e\u8ba4.getCode());
        order.setInProjectCode(allotApplyVO.getInProjectCode());
        order.setInProjectId(allotApplyVO.getInProjectId());
        order.setInProjectName(allotApplyVO.getInProjectName());
        order.setInProjectAddress(allotApplyVO.getInProjectAddress());
        order.setInOrgId(allotApplyVO.getInOrgId());
        order.setInOrgCode(allotApplyVO.getInOrgCode());
        order.setInOrgName(allotApplyVO.getInOrgName());
        order.setInParentOrgCode(allotApplyVO.getInParentOrgCode());
        order.setInParentOrgId(allotApplyVO.getInParentOrgId());
        order.setInParentOrgName(allotApplyVO.getInParentOrgName());
        order.setInCorpCode(allotApplyVO.getCorpCode());
        order.setInCorpId(allotApplyVO.getCorpId());
        order.setInCorpName(allotApplyVO.getCorpName());
        order.setPurTime(allotApplyVO.getEffectDate());
        order.setPurUserCode(allotApplyVO.getPurUserCode());
        order.setPurUserId(allotApplyVO.getPurUserId());
        order.setPurUserName(allotApplyVO.getPurUserName());
        order.setPurUserPhone(allotApplyVO.getPurUserPhone());
        order.setOutProjectId(tmpApplyDetail.getOutProjectId());
        order.setOutProjectCode(tmpApplyDetail.getOutProjectCode());
        order.setOutProjectName(tmpApplyDetail.getOutProjectName());
        order.setOutOrgId(tmpApplyDetail.getOutOrgId());
        order.setOutOrgCode(tmpApplyDetail.getOutOrgCode());
        order.setOutOrgName(tmpApplyDetail.getOutOrgName());
        order.setOutParentOrgId(tmpApplyDetail.getOutParentOrgId());
        order.setOutParentOrgCode(tmpApplyDetail.getOutParentOrgCode());
        order.setOutParentOrgName(tmpApplyDetail.getOutParentOrgName());
        order.setStoreType(tmpApplyDetail.getStoreType());
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)order), AllotOrderVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        order.setBillCode((String)billCode.getData());
        order.setAllotOrderDetailList(this.generateOrderDetailByApply(allotApplyDetailVOs, order, shelfDetailMap));
        return order;
    }
}

