/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.MonthOrgDetailEntity;
import com.ejianc.business.material.bean.MonthProjectDetailEntity;
import com.ejianc.business.material.bean.MonthProjectEntity;
import com.ejianc.business.material.mapper.MonthProjectMapper;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IMaterialsreturnService;
import com.ejianc.business.material.service.IMaterialsreturndetailService;
import com.ejianc.business.material.service.IMonthOrgDetailService;
import com.ejianc.business.material.service.IMonthProjectDetailService;
import com.ejianc.business.material.service.IMonthProjectService;
import com.ejianc.business.material.utils.ComputeUtil;
import com.ejianc.business.material.vo.BigScreenVO;
import com.ejianc.business.material.vo.MonthOrgDetailVO;
import com.ejianc.business.material.vo.MonthProjectDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthProjectService")
public class MonthProjectServiceImpl
extends BaseServiceImpl<MonthProjectMapper, MonthProjectEntity>
implements IMonthProjectService {
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IMaterialsreturnService materialsreturnService;
    @Autowired
    private IMaterialsreturndetailService materialsreturndetailService;
    @Autowired
    private IMonthProjectDetailService monthProjectDetailService;
    @Autowired
    private IMonthOrgDetailService orgDetailService;
    @Autowired
    private MonthProjectMapper monthProjectMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<MonthProjectDetailVO> queryDataById(Long projectId, String month) {
        ArrayList<MonthProjectDetailVO> projectDetailList = new ArrayList<MonthProjectDetailVO>();
        MonthProjectDetailVO monthProjectDetailHntVO = new MonthProjectDetailVO();
        MonthProjectDetailVO monthProjectDetailGjVO = new MonthProjectDetailVO();
        String code = "WL103";
        String codeGj = "WL10101";
        String unit = "\u5e73\u65b9\u7c73";
        String unitGj = "\u5428";
        this.getDataByCode(code, projectId, monthProjectDetailHntVO, month, unit);
        this.getDataByCode(codeGj, projectId, monthProjectDetailGjVO, month, unitGj);
        projectDetailList.add(monthProjectDetailHntVO);
        projectDetailList.add(monthProjectDetailGjVO);
        return projectDetailList;
    }

    private void getDataByCode(String code, Long projectId, MonthProjectDetailVO monthProjectDetailHntVO, String month, String unit) {
        String previousMonth = MonthProjectServiceImpl.getPreviousMonth(month);
        String previousLastMonth = MonthProjectServiceImpl.getPreviousMonth(previousMonth);
        CommonResponse hntMaterial = this.shareMaterialApi.queryCategoryByCode(code);
        if (!hntMaterial.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5206\u7c7b\u4fe1\u606f\u5931\u8d25");
        }
        MaterialCategoryVO hntMaterialData = (MaterialCategoryVO)hntMaterial.getData();
        List<Long> listBycategoryHntId = this.monthProjectMapper.getListBycategoryId(hntMaterialData.getId());
        BigDecimal planHntNum = this.monthProjectMapper.getPlanNum(null, projectId, listBycategoryHntId, previousMonth);
        monthProjectDetailHntVO.setId(IdWorker.getId());
        monthProjectDetailHntVO.setMonthPlanNum(planHntNum);
        monthProjectDetailHntVO.setMaterialCategoryId(hntMaterialData.getId());
        monthProjectDetailHntVO.setMaterialCategoryName(hntMaterialData.getName());
        monthProjectDetailHntVO.setMaterialSpec("\u7efc\u5408");
        monthProjectDetailHntVO.setMaterialUnit(unit);
        LambdaQueryWrapper lastMonthProLambda = Wrappers.lambdaQuery();
        lastMonthProLambda.in(MonthProjectEntity::getBillState, new Object[]{1, 3});
        lastMonthProLambda.orderByDesc(MonthProjectEntity::getMonth);
        List monthProjectEntities = super.list((Wrapper)lastMonthProLambda);
        Map<Object, Object> monthDetailLastMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)monthProjectEntities)) {
            MonthProjectEntity monthProjectEntity = (MonthProjectEntity)((Object)monthProjectEntities.stream().findFirst().get());
            LambdaQueryWrapper lastMonthProDetailLambda = Wrappers.lambdaQuery();
            lastMonthProDetailLambda.eq(MonthProjectDetailEntity::getMid, (Object)monthProjectEntity.getId());
            List monthProjectDetailEntities = this.monthProjectDetailService.list((Wrapper)lastMonthProDetailLambda);
            monthDetailLastMap = monthProjectDetailEntities.stream().collect(Collectors.toMap(MonthProjectDetailEntity::getMaterialCategoryId, Function.identity()));
        }
        if (monthDetailLastMap.containsKey(monthProjectDetailHntVO.getMaterialCategoryId())) {
            MonthProjectDetailEntity monthProjectDetailHntEntity = (MonthProjectDetailEntity)((Object)monthDetailLastMap.get(monthProjectDetailHntVO.getMaterialCategoryId()));
            monthProjectDetailHntVO.setLastStoreNum(monthProjectDetailHntEntity.getStoreNum());
        }
        LambdaQueryWrapper lastFlowhntLambda = Wrappers.lambdaQuery();
        lastFlowhntLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
        lastFlowhntLambda.eq(FlowmeterEntity::getProjectId, (Object)projectId);
        lastFlowhntLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        lastFlowhntLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'", new Object[0]);
        List flowmeterhntEntities = this.flowmeterService.list((Wrapper)lastFlowhntLambda);
        BigDecimal currentstoreNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)flowmeterhntEntities)) {
            BigDecimal inNum = flowmeterhntEntities.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outNum = flowmeterhntEntities.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentstoreNum = ComputeUtil.safeSub(inNum, outNum);
            monthProjectDetailHntVO.setInNum(inNum);
        }
        LambdaQueryWrapper preFlowLambda = Wrappers.lambdaQuery();
        preFlowLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
        preFlowLambda.eq(FlowmeterEntity::getProjectId, (Object)projectId);
        preFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        preFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') <= '" + previousLastMonth + "'", new Object[0]);
        List flowmeterPreEntities = this.flowmeterService.list((Wrapper)preFlowLambda);
        BigDecimal lastNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)flowmeterPreEntities)) {
            BigDecimal inNum = flowmeterhntEntities.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outNum = flowmeterhntEntities.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastNum = ComputeUtil.safeSub(inNum, outNum);
        }
        monthProjectDetailHntVO.setStoreNum(ComputeUtil.safeAdd(lastNum, currentstoreNum));
        LambdaQueryWrapper transforFlowLambda = Wrappers.lambdaQuery();
        transforFlowLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
        transforFlowLambda.eq(FlowmeterEntity::getProjectId, (Object)projectId);
        transforFlowLambda.eq(FlowmeterEntity::getTransferorderType, (Object)"\u8c03\u62e8\u51fa\u5e93");
        transforFlowLambda.eq(FlowmeterEntity::getOperationType, (Object)"\u51fa\u5e93");
        transforFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        transforFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'", new Object[0]);
        List flowmeterTransfor = this.flowmeterService.list((Wrapper)preFlowLambda);
        BigDecimal outNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)flowmeterTransfor)) {
            outNum = flowmeterTransfor.stream().map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            monthProjectDetailHntVO.setOutNum(outNum);
        }
        LambdaQueryWrapper dealFlowLambda = Wrappers.lambdaQuery();
        dealFlowLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
        dealFlowLambda.eq(FlowmeterEntity::getProjectId, (Object)projectId);
        dealFlowLambda.eq(FlowmeterEntity::getAccessType, (Object)"\u5904\u7f6e");
        dealFlowLambda.eq(FlowmeterEntity::getOperationType, (Object)"\u51fa\u5e93");
        dealFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        dealFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'", new Object[0]);
        List flowmeterDeal = this.flowmeterService.list((Wrapper)preFlowLambda);
        BigDecimal dealNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)flowmeterDeal)) {
            dealNum = flowmeterDeal.stream().map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            monthProjectDetailHntVO.setDealNum(dealNum);
        }
        BigDecimal bigDecimal = ComputeUtil.safeAdd(monthProjectDetailHntVO.getLastStoreNum(), monthProjectDetailHntVO.getInNum());
        BigDecimal bigDecimal1 = ComputeUtil.safeSub(bigDecimal, monthProjectDetailHntVO.getStoreNum());
        BigDecimal bigDecimal2 = ComputeUtil.safeSub(bigDecimal1, monthProjectDetailHntVO.getOutNum());
        BigDecimal useNum = ComputeUtil.safeSub(bigDecimal2, monthProjectDetailHntVO.getDealNum());
        monthProjectDetailHntVO.setUseNum(useNum);
        monthProjectDetailHntVO.setDiffNum(ComputeUtil.safeSub(BigDecimal.ZERO, monthProjectDetailHntVO.getUseNum()));
        monthProjectDetailHntVO.setDiffRate(ComputeUtil.safeSub(monthProjectDetailHntVO.getDiffNum(), BigDecimal.ZERO));
        monthProjectDetailHntVO.setSumInRate(ComputeUtil.safeDiv(monthProjectDetailHntVO.getInNum(), monthProjectDetailHntVO.getMonthPlanNum()));
    }

    @Override
    public List<Long> getListByCode(String code) {
        return null;
    }

    @Override
    public List<MonthOrgDetailVO> queryDetailByOrgId(Long orgId, String month) {
        List<Long> orgIds = this.getOrgIds();
        List<MonthOrgDetailVO> list = this.monthProjectMapper.queryDetailByOrgId(orgIds, month);
        for (MonthOrgDetailVO monthOrgDetailVO : list) {
            monthOrgDetailVO.setId(IdWorker.getId());
        }
        return list;
    }

    @Override
    public List<BigScreenVO> getInNumByOrgId() {
        List<Long> orgIds = this.getOrgIds();
        ArrayList<BigScreenVO> codeList = new ArrayList<BigScreenVO>();
        this.getBigScreenList(codeList);
        for (BigScreenVO bigScreenVO : codeList) {
            List<Long> categoryIds = this.getCategoryIds(bigScreenVO.getMaterialCode());
            LambdaQueryWrapper inFlowLambda = Wrappers.lambdaQuery();
            ArrayList<String> operationType = new ArrayList<String>();
            operationType.add("\u5165\u5e93");
            operationType.add("\u51fa\u5e93");
            ArrayList<String> accessType = new ArrayList<String>();
            accessType.add("\u76f4\u5165\u76f4\u51fa\u9000\u4f9b\u5e94\u5546");
            accessType.add("\u9000\u4f9b\u5e94\u5546");
            inFlowLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
            inFlowLambda.in(FlowmeterEntity::getProjectDepartmentId, orgIds);
            inFlowLambda.in(FlowmeterEntity::getOperationType, operationType);
            inFlowLambda.in(FlowmeterEntity::getAccessType, accessType);
            inFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, categoryIds);
            List flowmeterInList = this.flowmeterService.list((Wrapper)inFlowLambda);
            BigDecimal inNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)flowmeterInList)) {
                inNum = flowmeterInList.stream().map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            bigScreenVO.setInNum(inNum);
            BigDecimal totalPlanNum = this.monthProjectMapper.getTotalPlanNum(orgIds, categoryIds);
            bigScreenVO.setTotalPlanNum(totalPlanNum);
        }
        return codeList;
    }

    private void getBigScreenList(List<BigScreenVO> codeList) {
        BigScreenVO bigScreenVO1 = new BigScreenVO();
        bigScreenVO1.setMaterialName("\u6df7\u51dd\u571f(\u7acb\u65b9\u7c73)");
        bigScreenVO1.setMaterialCode("WL103");
        BigScreenVO bigScreenVO2 = new BigScreenVO();
        bigScreenVO2.setMaterialName("\u94a2\u7b4b(\u5428)");
        bigScreenVO2.setMaterialCode("WL10101");
        BigScreenVO bigScreenVO3 = new BigScreenVO();
        bigScreenVO3.setMaterialName("\u780c\u5757(\u7acb\u65b9\u7c73)");
        bigScreenVO3.setMaterialCode("WL10603");
        BigScreenVO bigScreenVO4 = new BigScreenVO();
        bigScreenVO4.setMaterialName("\u7535\u7f06\u7ebf(\u7c73/m)");
        bigScreenVO4.setMaterialCode("WL11002");
        BigScreenVO bigScreenVO5 = new BigScreenVO();
        bigScreenVO5.setMaterialName("\u914d\u7535\u7bb1(\u53f0)");
        bigScreenVO5.setMaterialCode("WL11028");
        codeList.add(bigScreenVO1);
        codeList.add(bigScreenVO2);
        codeList.add(bigScreenVO3);
        codeList.add(bigScreenVO4);
        codeList.add(bigScreenVO5);
    }

    @Override
    public List<BigScreenVO> getPlanRateByOrgId(Integer type, String month) {
        List<Long> orgIds = this.getOrgIds();
        ArrayList<BigScreenVO> codeList = new ArrayList<BigScreenVO>();
        this.getBigScreenList(codeList);
        for (BigScreenVO bigScreenVO : codeList) {
            BigDecimal inNum;
            BigDecimal orderNum;
            List<Long> categoryIds = this.getCategoryIds(bigScreenVO.getMaterialCode());
            if (type == 1) {
                BigDecimal totalPlanNum = this.monthProjectMapper.getTotalPlanNum(orgIds, categoryIds);
                bigScreenVO.setTotalPlanNum(totalPlanNum);
                orderNum = this.monthProjectMapper.getOrderNum(orgIds, categoryIds, null);
                bigScreenVO.setOrderNum(orderNum);
                inNum = BigDecimal.ZERO;
                inNum = this.getFlowNum(type, month, orgIds, categoryIds, inNum);
                bigScreenVO.setCheckNum(inNum);
            }
            if (type == 2) {
                BigDecimal monthPlanNum = this.monthProjectMapper.getPlanNum(orgIds, null, categoryIds, month);
                bigScreenVO.setTotalPlanNum(monthPlanNum);
                orderNum = this.monthProjectMapper.getOrderNum(orgIds, categoryIds, month);
                bigScreenVO.setOrderNum(orderNum);
                inNum = BigDecimal.ZERO;
                inNum = this.getFlowNum(type, month, orgIds, categoryIds, inNum);
                bigScreenVO.setCheckNum(inNum);
            }
            bigScreenVO.setRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(bigScreenVO.getCheckNum(), bigScreenVO.getTotalPlanNum()), new BigDecimal(100)));
        }
        return codeList;
    }

    @Override
    public List<BigScreenVO> getDiffRateOrgId(String month) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(2);
        CommonResponse orgByType = this.iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        if (!orgByType.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> orgIds = this.getOrgIds();
        List orgByTypeData = (List)orgByType.getData();
        ArrayList<String> shortNameList = new ArrayList<String>();
        shortNameList.add("\u534e\u5357\u516c\u53f8");
        shortNameList.add("\u534e\u4e1c\u516c\u53f8");
        shortNameList.add("\u534e\u5317\u516c\u53f8");
        shortNameList.add("\u897f\u90e8\u516c\u53f8");
        shortNameList.add("\u4e2d\u5efa\u96c6\u6210");
        shortNameList.add("\u4f4e\u78b3\u667a\u6167\u57ce\u5e02\u516c\u53f8");
        List orgVOList = orgByTypeData.stream().filter(s -> orgIds.contains(s.getId()) && shortNameList.contains(s.getShortName())).sorted(Comparator.comparing(OrgVO::getSequence)).collect(Collectors.toList());
        List<BigScreenVO> list = this.monthProjectMapper.getMonthOrgByMonth(orgIds, month);
        Map<Object, Object> dataMap = new HashMap();
        Map<Object, Object> dataListMap = new HashMap();
        ArrayList<BigScreenVO> list1 = new ArrayList<BigScreenVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            dataMap = list.stream().collect(Collectors.groupingBy(score -> score.getOrgId() + "_" + score.getMaterialCategoryName(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getRate()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            dataListMap = list.stream().collect(Collectors.groupingBy(score -> score.getOrgId() + "_" + score.getMaterialCategoryName()));
        }
        for (OrgVO orgVO : orgVOList) {
            List bigScreenVOList;
            BigScreenVO bigScreenVO = new BigScreenVO();
            bigScreenVO.setId(orgVO.getId());
            bigScreenVO.setOrgName(orgVO.getName());
            String keyHnt = orgVO.getId() + "_\u6df7\u51dd\u571f";
            String keyGj = orgVO.getId() + "_\u94a2\u7b4b";
            if (dataMap.containsKey(keyHnt)) {
                BigDecimal hntRate = (BigDecimal)dataMap.get(keyHnt);
                bigScreenVO.setHntRate(hntRate);
            }
            if (dataListMap.containsKey(keyHnt)) {
                bigScreenVOList = (List)dataListMap.get(keyHnt);
                bigScreenVO.setId(((BigScreenVO)((Object)bigScreenVOList.stream().findFirst().get())).getId());
            }
            if (dataMap.containsKey(keyGj)) {
                BigDecimal gjRate = (BigDecimal)dataMap.get(keyGj);
                bigScreenVO.setGjRate(gjRate);
            }
            if (dataListMap.containsKey(keyGj)) {
                bigScreenVOList = (List)dataListMap.get(keyGj);
                bigScreenVO.setId(((BigScreenVO)((Object)bigScreenVOList.stream().findFirst().get())).getId());
            }
            list1.add(bigScreenVO);
        }
        return list1;
    }

    @Override
    public List<BigScreenVO> getDiffRateProjectId(Long id) {
        LambdaQueryWrapper inDetailLambda = Wrappers.lambdaQuery();
        inDetailLambda.eq(MonthOrgDetailEntity::getMid, (Object)id);
        List monthOrgDetailEntities = this.orgDetailService.list((Wrapper)inDetailLambda);
        ArrayList<BigScreenVO> screenVOArrayList = new ArrayList<BigScreenVO>();
        if (CollectionUtils.isNotEmpty((Collection)monthOrgDetailEntities)) {
            Map<Long, List<MonthOrgDetailEntity>> listMap = monthOrgDetailEntities.stream().collect(Collectors.groupingBy(score -> score.getProjectId()));
            listMap.forEach((projectId, details) -> {
                BigScreenVO bigScreenVO = new BigScreenVO();
                bigScreenVO.setProjectId((Long)projectId);
                bigScreenVO.setProjectName(((MonthOrgDetailEntity)((Object)((Object)details.stream().findFirst().get()))).getProjectName());
                List listHnt = details.stream().filter(s -> s.getMaterialCategoryName().equals("\u6df7\u51dd\u571f")).collect(Collectors.toList());
                bigScreenVO.setHntRate(((MonthOrgDetailEntity)((Object)((Object)listHnt.stream().findFirst().get()))).getDiffRate());
                List listGj = details.stream().filter(s -> s.getMaterialCategoryName().equals("\u94a2\u7b4b")).collect(Collectors.toList());
                bigScreenVO.setGjRate(((MonthOrgDetailEntity)((Object)((Object)listGj.stream().findFirst().get()))).getDiffRate());
                screenVOArrayList.add(bigScreenVO);
            });
        }
        return screenVOArrayList;
    }

    @Override
    public List<BigScreenVO> getQuarterData(String year) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(2);
        CommonResponse orgByType = this.iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        if (!orgByType.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> orgIds = this.getOrgIds();
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childrenByParentId.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        List orgAll = (List)childrenByParentId.getData();
        List orgByTypeData = (List)orgByType.getData();
        ArrayList<String> shortNameList = new ArrayList<String>();
        shortNameList.add("\u534e\u5357\u516c\u53f8");
        shortNameList.add("\u534e\u4e1c\u516c\u53f8");
        shortNameList.add("\u534e\u5317\u516c\u53f8");
        shortNameList.add("\u897f\u90e8\u516c\u53f8");
        shortNameList.add("\u4e2d\u5efa\u96c6\u6210");
        shortNameList.add("\u4f4e\u78b3\u667a\u6167\u57ce\u5e02\u516c\u53f8");
        List orgVOList = orgByTypeData.stream().filter(s -> orgIds.contains(s.getId()) && shortNameList.contains(s.getShortName())).sorted(Comparator.comparing(OrgVO::getSequence)).collect(Collectors.toList());
        List<BigScreenVO> screenVOList = this.monthProjectMapper.getDealNum(orgIds, year);
        Map<Integer, List<BigScreenVO>> quarterlyData = screenVOList.stream().collect(Collectors.groupingBy(s -> {
            Date dealDate = s.getDealDate();
            LocalDate localDate = dealDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return (localDate.getMonthValue() - 1) / 3 + 1;
        }));
        List<BigScreenVO> q1 = quarterlyData.get(1);
        List<BigScreenVO> q2 = quarterlyData.get(2);
        List<BigScreenVO> q3 = quarterlyData.get(3);
        List<BigScreenVO> q4 = quarterlyData.get(4);
        ArrayList<BigScreenVO> list = new ArrayList<BigScreenVO>();
        for (OrgVO orgVO : orgVOList) {
            BigScreenVO bigScreenVO = new BigScreenVO();
            bigScreenVO.setOrgId(orgVO.getId());
            bigScreenVO.setOrgName(orgVO.getName());
            bigScreenVO.setId(IdWorker.getId());
            List childOrgIds = orgAll.stream().filter(s -> s.getInnerCode().contains(orgVO.getId().toString())).map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(q1)) {
                BigDecimal mny1 = q1.stream().filter(s -> childOrgIds.contains(s.getProjectDepartmentId())).map(BigScreenVO::getExMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                bigScreenVO.setOneMny(mny1);
                BigDecimal mny2 = q2.stream().filter(s -> childOrgIds.contains(s.getProjectDepartmentId())).map(BigScreenVO::getExMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                bigScreenVO.setOneMny(mny2);
                BigDecimal mny3 = q3.stream().filter(s -> childOrgIds.contains(s.getProjectDepartmentId())).map(BigScreenVO::getExMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                bigScreenVO.setOneMny(mny3);
                BigDecimal mny4 = q4.stream().filter(s -> childOrgIds.contains(s.getProjectDepartmentId())).map(BigScreenVO::getExMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                bigScreenVO.setOneMny(mny4);
            }
            list.add(bigScreenVO);
        }
        return list;
    }

    @Override
    public List<BigScreenVO> getSupplierTopTen(String month) {
        List<BigScreenVO> screenVOList = this.monthProjectMapper.getMonthScore(month);
        return screenVOList;
    }

    private BigDecimal getFlowNum(Integer type, String month, List<Long> orgIds, List<Long> categoryIds, BigDecimal inNum) {
        List flowmeterInList;
        LambdaQueryWrapper inFlowLambda = Wrappers.lambdaQuery();
        ArrayList<String> operationType = new ArrayList<String>();
        operationType.add("\u5165\u5e93");
        operationType.add("\u51fa\u5e93");
        ArrayList<String> accessType = new ArrayList<String>();
        accessType.add("\u76f4\u5165\u76f4\u51fa\u9000\u4f9b\u5e94\u5546");
        accessType.add("\u9000\u4f9b\u5e94\u5546");
        inFlowLambda.eq(FlowmeterEntity::getBillStatus, (Object)1);
        inFlowLambda.in(FlowmeterEntity::getProjectDepartmentId, orgIds);
        inFlowLambda.in(FlowmeterEntity::getOperationType, operationType);
        inFlowLambda.in(FlowmeterEntity::getAccessType, accessType);
        inFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, categoryIds);
        if (type == 2) {
            inFlowLambda.apply("DATE_FORMAT(time, '%Y-%m-%d') = '" + month + "'", new Object[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)(flowmeterInList = this.flowmeterService.list((Wrapper)inFlowLambda)))) {
            inNum = flowmeterInList.stream().map(FlowmeterEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return inNum;
    }

    private List<Long> getOrgIds() {
        CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childrenByParentId.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> orgIds = new ArrayList<Long>();
        List data = (List)childrenByParentId.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            orgIds = data.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return orgIds;
    }

    private List<Long> getCategoryIds(String code) {
        CommonResponse hntMaterial = this.shareMaterialApi.queryCategoryByCode(code);
        if (!hntMaterial.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5206\u7c7b\u4fe1\u606f\u5931\u8d25");
        }
        MaterialCategoryVO hntMaterialData = (MaterialCategoryVO)hntMaterial.getData();
        List<Long> listBycategoryId = this.monthProjectMapper.getListBycategoryId(hntMaterialData.getId());
        return listBycategoryId;
    }

    private static String getPreviousMonth(String month) {
        YearMonth yearMonth = YearMonth.parse(month);
        YearMonth previousMonth = yearMonth.minusMonths(1L);
        return previousMonth.toString();
    }
}

