/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.CompanyMonthChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthEntity;
import com.ejianc.business.outputValue.service.ICompanyMonthChangeService;
import com.ejianc.business.outputValue.service.ICompanyMonthProjectDetailChangeService;
import com.ejianc.business.outputValue.service.ICompanyMonthProjectDetailService;
import com.ejianc.business.outputValue.service.ICompanyMonthRecordService;
import com.ejianc.business.outputValue.service.ICompanyMonthService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaRecordVO;
import com.ejianc.business.outputValue.vo.CompanyMonthChangeVO;
import com.ejianc.business.outputValue.vo.CompanyMonthProjectDetailChangeVO;
import com.ejianc.business.outputValue.vo.CompanyMonthProjectDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"companyMonthChange"})
public class CompanyMonthChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICompanyMonthChangeService changeService;
    @Autowired
    private ICompanyMonthProjectDetailChangeService detailChangeService;
    @Autowired
    private ICompanyMonthService companyMonthService;
    @Autowired
    private ICompanyMonthProjectDetailService detailService;
    @Autowired
    private ICompanyMonthRecordService recordService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CompanyMonthChangeVO> saveOrUpdate(@RequestBody CompanyMonthChangeVO vo) {
        return this.changeService.saveChange(vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompanyMonthChangeVO> queryDetail(Long id) {
        CompanyMonthChangeEntity entity = (CompanyMonthChangeEntity)((Object)this.changeService.selectById(id));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"change_id", (Object)id);
        wrapper.orderByAsc((Object)"pc_factory");
        wrapper.orderByDesc((Object)"create_time");
        List list = this.detailChangeService.list((Wrapper)wrapper);
        entity.setDetailList(list);
        CompanyMonthChangeVO vo = (CompanyMonthChangeVO)((Object)BeanMapper.map((Object)((Object)entity), CompanyMonthChangeVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"company_month_id", (Object)id);
        List records = this.recordService.list((Wrapper)queryWrapper);
        if (records != null && records.size() > 0) {
            vo.setRecordList(BeanMapper.mapList((Iterable)records, CompanyBusinessQuotaRecordVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyMonthChangeVO> vos) {
        return this.changeService.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CompanyMonthChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("companyMonthId") == null) {
            throw new BusinessException("\u7f3a\u5c11\u516c\u53f8\u6708\u5ea6\u4ea7\u503c\u5f55\u5165id");
        }
        IPage page = this.changeService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyMonthChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailByCompanyMonthId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompanyMonthChangeVO> queryDetailByCompanyMonthId(@RequestParam(value="companyMonthId") Long companyMonthId) {
        CompanyMonthEntity entity = (CompanyMonthEntity)((Object)this.companyMonthService.selectById(companyMonthId));
        List<CompanyMonthProjectDetailVO> list = this.detailService.queryProjectByOrgId(entity.getOrgId(), entity.getYear(), entity.getMonth());
        CompanyMonthChangeVO changeVO = (CompanyMonthChangeVO)((Object)BeanMapper.map((Object)((Object)entity), CompanyMonthChangeVO.class));
        changeVO.setCompanyMonthId(companyMonthId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        if (list != null && list.size() > 0) {
            ArrayList<CompanyMonthProjectDetailChangeVO> vos = new ArrayList<CompanyMonthProjectDetailChangeVO>();
            for (CompanyMonthProjectDetailVO vo : list) {
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setId(IdWorker.getId());
                vo.setUpdateUserCode(null);
                vo.setRowState("add");
                vos.add((CompanyMonthProjectDetailChangeVO)((Object)BeanMapper.map((Object)((Object)vo), CompanyMonthProjectDetailChangeVO.class)));
            }
            changeVO.setDetailList(vos);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)((Object)changeVO));
    }
}

