/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.mapper.CompanyBusinessQuotaMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectSupplementMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectSupplementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="companyBusinessQuotaService")
public class CompanyBusinessQuotaServiceImpl
extends BaseServiceImpl<CompanyBusinessQuotaMapper, CompanyBusinessQuotaEntity>
implements ICompanyBusinessQuotaService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProjectSupplementMapper projectSupplementMapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;

    @Override
    public CompanyBusinessQuotaVO queryInfoByOrgId(Long orgId, String year) {
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 != org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        CompanyBusinessQuotaVO vo = new CompanyBusinessQuotaVO();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"org_id", (Object)orgId);
        String lastYear = String.valueOf(Integer.parseInt(year) - 1);
        wrapper.eq((Object)"year", (Object)year);
        wrapper.orderByDesc((Object)"create_time");
        List list = this.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            CompanyBusinessQuotaEntity lastEntity = (CompanyBusinessQuotaEntity)((Object)list.get(0));
            vo.setLastYearCompletedSpace(lastEntity.getThisYearCompleteCompletedSpace());
            vo.setLastYearProjectConfirmedOutputValue(lastEntity.getThisYearCompleteProjectConfirmedOutputValue());
            vo.setLastYearProjectCompletedOutputValue(lastEntity.getThisYearCompleteProjectOutputValue());
            vo.setLastYearStartWorkSpace(lastEntity.getThisYearCompleteStartWorkSpace());
            vo.setLastYearPcOutputValue(lastEntity.getThisYearCompletePcOutputValue());
            vo.setLastYearCompleteTotalOutputValue(lastEntity.getThisYearCompleteTotalOutputValue());
        } else {
            vo.setLastYearCompletedSpace(new BigDecimal(0));
            vo.setLastYearProjectConfirmedOutputValue(new BigDecimal(0));
            vo.setLastYearProjectCompletedOutputValue(new BigDecimal(0));
            vo.setLastYearStartWorkSpace(new BigDecimal(0));
            vo.setLastYearPcOutputValue(new BigDecimal(0));
            vo.setLastYearCompleteTotalOutputValue(new BigDecimal(0));
        }
        QueryWrapper projectWrapper = new QueryWrapper();
        projectWrapper.like((Object)"effect_last_date", (Object)lastYear);
        projectWrapper.in((Object)"bill_state", new Object[]{1, 3});
        projectWrapper.in((Object)"project_status", new Object[]{"\u7ae3\u5de5\u672a\u7ed3", "\u7ae3\u5de5\u5df2\u7ed3"});
        projectWrapper.in((Object)"org_id", commonOrgIds);
        Integer lastYearCompletedProjectNumber = this.projectSupplementService.count((Wrapper)projectWrapper);
        vo.setLastYearCompletedProjectNumber(Long.parseLong(lastYearCompletedProjectNumber.toString()));
        QueryWrapper projectWrapper2 = new QueryWrapper();
        projectWrapper2.like((Object)"effect_last_date", (Object)lastYear);
        projectWrapper2.in((Object)"bill_state", new Object[]{1, 3});
        projectWrapper2.in((Object)"project_status", new Object[]{"\u5728\u65bd"});
        projectWrapper2.in((Object)"org_id", commonOrgIds);
        Integer lastYearStartWorkProjectNumber = this.projectSupplementService.count((Wrapper)projectWrapper2);
        vo.setLastYearStartWorkProjectNumber(Long.parseLong(lastYearStartWorkProjectNumber.toString()));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("twoOrgId", orgId);
        param.put("year", year);
        ProjectMonthActualOutputValueVO projectData = this.projectMonthActualOutputValueMapper.selectSumData(param);
        if (projectData != null && projectData.getThisMonthActualOutputValue() != null) {
            vo.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthActualOutputValue(), 4));
            vo.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthConfirmedOutputValue(), 4));
        } else {
            vo.setThisYearCompleteProjectOutputValue(new BigDecimal(0));
            vo.setThisYearCompleteProjectConfirmedOutputValue(new BigDecimal(0));
        }
        PcMonthActualOutputValueVO pcData = this.pcMonthActualOutputValueMapper.selectSumData(param);
        if (pcData != null && pcData.getThisMonthCompletedTotalOutputValue() != null) {
            vo.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 4));
        } else {
            vo.setThisYearCompletePcOutputValue(new BigDecimal(0));
        }
        vo.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(vo.getThisYearCompleteProjectOutputValue(), vo.getThisYearCompletePcOutputValue()));
        QueryWrapper projectWrapper3 = new QueryWrapper();
        projectWrapper3.like((Object)"effect_last_date", (Object)year);
        projectWrapper3.in((Object)"bill_state", new Object[]{1, 3});
        projectWrapper3.in((Object)"project_status", new Object[]{"\u5728\u65bd"});
        projectWrapper3.in((Object)"org_id", commonOrgIds);
        Integer thisYearCompleteBuildingProjectNumber = this.projectSupplementService.count((Wrapper)projectWrapper3);
        vo.setThisYearCompleteBuildingProjectNumber(Long.parseLong(thisYearCompleteBuildingProjectNumber.toString()));
        ProjectSupplementVO building = this.projectSupplementMapper.selectSumData(commonOrgIds, year, "'\u5728\u65bd'");
        if (building != null) {
            vo.setThisYearCompleteStartWorkSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(), 4));
            vo.setThisYearCompleteBuildingSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(), 4));
            vo.setThisYearCompleteBuildingProjectContractSurplus(CommonUtils.parseDivide8(building.getContractAmount(), 4));
            vo.setThisYearCompleteBuildingProjectContractAmount(CommonUtils.parseDivide8(building.getContractAmount(), 4));
        } else {
            vo.setThisYearCompleteStartWorkSpace(new BigDecimal(0));
            vo.setThisYearCompleteBuildingSpace(new BigDecimal(0));
            vo.setThisYearCompleteBuildingProjectContractSurplus(new BigDecimal(0));
            vo.setThisYearCompleteBuildingProjectContractAmount(new BigDecimal(0));
        }
        ProjectSupplementVO finish = this.projectSupplementMapper.selectSumData(commonOrgIds, year, "'\u7ae3\u5de5\u672a\u7ed3','\u7ae3\u5de5\u5df2\u7ed3'");
        if (finish != null) {
            vo.setThisYearCompleteCompletedSpace(CommonUtils.parseDivide4(finish.getBuiltAllArea(), 4));
        } else {
            vo.setThisYearCompleteCompletedSpace(new BigDecimal(0));
        }
        return vo;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public void updateProjectPcInfo(Long orgId, String year) {
        QueryWrapper companyWrapper = new QueryWrapper();
        companyWrapper.eq((Object)"org_id", (Object)orgId);
        companyWrapper.eq((Object)"year", (Object)year);
        companyWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List companyList = this.list((Wrapper)companyWrapper);
        if (companyList != null && companyList.size() > 0) {
            CompanyBusinessQuotaEntity companyEntity = (CompanyBusinessQuotaEntity)((Object)companyList.get(0));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("twoOrgId", orgId);
            param.put("year", year);
            ProjectMonthActualOutputValueVO sumData = this.projectMonthActualOutputValueMapper.selectSumData(param);
            if (sumData != null) {
                companyEntity.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthActualOutputValue(), 4));
                companyEntity.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthConfirmedOutputValue(), 4));
            } else {
                companyEntity.setThisYearCompleteProjectOutputValue(new BigDecimal(0));
                companyEntity.setThisYearCompleteProjectConfirmedOutputValue(new BigDecimal(0));
            }
            PcMonthActualOutputValueVO pcData = this.pcMonthActualOutputValueMapper.selectSumData(param);
            if (pcData != null) {
                companyEntity.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 4));
            } else {
                companyEntity.setThisYearCompletePcOutputValue(new BigDecimal(0));
            }
            companyEntity.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(companyEntity.getThisYearCompleteProjectOutputValue(), companyEntity.getThisYearCompletePcOutputValue()));
            this.saveOrUpdate((Object)companyEntity, false);
        }
    }
}

