/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.bean.ShelfDetailEntity;
import com.ejianc.business.panhuo.shelf.bean.ShelfEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.business.panhuo.shelf.service.IShelfService;
import com.ejianc.foundation.cons.PlanConstant;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.panhuo.shelf.vo.ShelfVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="shelf")
public class ShelfBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShelfService service;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IStoreService storeService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ShelfEntity entity = (ShelfEntity)((Object)this.service.selectById(billId));
        this.service.validateStoreNum((ShelfVO)BeanMapper.map((Object)((Object)entity), ShelfVO.class));
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ShelfEntity entity = (ShelfEntity)((Object)this.service.selectById(billId));
        ArrayList<GoodsEntity> saveList = new ArrayList<GoodsEntity>();
        for (ShelfDetailEntity detail : entity.getDetailList()) {
            GoodsEntity vo = new GoodsEntity();
            vo.setId(IdWorker.getId());
            if (detail.getFileIds() != null) {
                CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(detail.getId()), "EJCBT202410000007", "imageUpload2", String.valueOf(vo.getId()), "EJCBT202410000008", "imageUpload2");
                this.logger.error("afterApprovalProcessor copy file result is " + JSONObject.toJSONString((Object)response));
                String[] imgsPathArray = detail.getFileIds().split(",");
                CommonResponse commonResponse = this.attachmentApi.queryDetail(imgsPathArray[0]);
                vo.setMainimgPath(this.baseHost + ((AttachmentVO)commonResponse.getData()).getFilePath());
            }
            vo.setProjectId(entity.getProjectId());
            vo.setProjectCode(entity.getProjectCode());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setParentOrgId(entity.getParentOrgId());
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setAddress(entity.getAddress());
            vo.setBillState(entity.getBillState());
            vo.setSellUserId(entity.getSellUserId());
            vo.setSellerUserCode(entity.getSellerUserCode());
            vo.setSellUserName(entity.getSellUserName());
            vo.setSellUserPhone(entity.getSellUserPhone());
            vo.setStatus(PlanConstant.GOODS_STATUS_ON);
            vo.setShelfTime(new Date());
            if (null != detail.getStoreId()) {
                vo.setStoreType(this.storeService.queryStoreType(detail.getStoreId()));
                vo.setStoreName(detail.getStoreName());
                vo.setStoreId(detail.getStoreId());
            }
            vo.setStoreType(entity.getStoreType());
            vo.setCloudStoreId(entity.getCloudStoreId());
            vo.setCloudStoreName(entity.getCloudStoreName());
            vo.setCorpId(entity.getCorpId());
            vo.setCorpCode(entity.getCorpCode());
            vo.setCorpName(entity.getCorpName());
            vo.setSourceId(detail.getId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialTypeCode(detail.getMaterialTypeCode());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getPropertyValue());
            vo.setPropertyValue(detail.getPropertyValue());
            vo.setBrandId(detail.getBrandId());
            vo.setBrandName(detail.getBrandName());
            vo.setProductCode(detail.getProductCode());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setMemo(detail.getMemo());
            vo.setDiscount(detail.getDiscount());
            vo.setNum(detail.getNum());
            vo.setSurplusNum(detail.getNum());
            vo.setTaxRate(detail.getTaxRate());
            vo.setPrice(detail.getPrice());
            vo.setTaxPrice(null != detail.getTaxPrice() ? detail.getTaxPrice() : detail.getPrice());
            vo.setMny(detail.getMny());
            vo.setTaxMny(null != detail.getTaxMny() ? detail.getTaxMny() : detail.getMny());
            vo.setOriginalPrice(detail.getOriginalPrice());
            vo.setOriginalTaxPrice(null != detail.getOriginalTaxPrice() ? detail.getOriginalTaxPrice() : detail.getOriginalPrice());
            vo.setOriginalMny(detail.getOriginalMny());
            vo.setOriginalTaxMny(null != detail.getOriginalTaxMny() ? detail.getOriginalTaxMny() : detail.getOriginalMny());
            vo.setAttrFlag(detail.getAttrFlag());
            vo.setShelfType(detail.getShelfType());
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.goodsService.saveOrUpdateBatch(saveList);
            this.goodsService.inOutStore(saveList);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

