/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.DeliveryrecordReportVO;
import com.ejianc.business.material.vo.DeliveryrecordSubVO;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.business.material.vo.DeliveryrecorddetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"deliveryrecord"})
public class DeliveryrecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDeliveryrecordService service;
    @Autowired
    private IDeliveryrecorddetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryrecordVO> saveOrUpdate(@RequestBody DeliveryrecordVO saveorUpdateVO) {
        DeliveryrecordVO vo = this.service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/afterApprovalProcessor"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> afterApprovalProcessor(Long billId) {
        this.deliveryrecordBpmService.afterApprovalProcessor(billId, null, null);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryrecordVO> queryDetail(Long id) {
        DeliveryrecordEntity entity = (DeliveryrecordEntity)((Object)this.service.selectById(id));
        DeliveryrecordVO vo = (DeliveryrecordVO)((Object)BeanMapper.map((Object)((Object)entity), DeliveryrecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryOutDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryrecordVO> queryOutDetail(Long warehousingEntityId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(DeliveryrecordEntity::getWarehousingId, (Object)warehousingEntityId);
        DeliveryrecordEntity entity = (DeliveryrecordEntity)((Object)this.service.getOne((Wrapper)lambda));
        DeliveryrecordVO vo = (DeliveryrecordVO)((Object)BeanMapper.map((Object)((Object)entity), DeliveryrecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryrecordVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryrecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pickingUnit");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryrecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeliveryrecordReportVO>> queryReport(Long projectId, String materialCode, String supplierName) {
        List<DeliveryrecordReportVO> resList = this.service.subDetail(projectId, materialCode, supplierName);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pickingUnit");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List deliveryrecordList = BeanMapper.mapList((Iterable)list, DeliveryrecordVO.class);
        for (int i = 0; i < deliveryrecordList.size(); ++i) {
            String billStateStr;
            DeliveryrecordVO deliveryrecordVO = (DeliveryrecordVO)((Object)deliveryrecordList.get(i));
            deliveryrecordVO.setNum(String.valueOf(i + 1));
            if (deliveryrecordVO.getCreateTime() != null) {
                deliveryrecordVO.setCreateTimeShow(DateUtils.dateSimple2(deliveryrecordVO.getCreateTime()));
            }
            if ((billStateStr = deliveryrecordVO.getBillState().toString()) != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                deliveryrecordVO.setBillStateStr(billStateStr);
            }
            if (deliveryrecordVO.getDeliveryType() != null) {
                if (deliveryrecordVO.getDeliveryType() == 1) {
                    deliveryrecordVO.setDeliveryTypeName("\u624b\u52a8\u51fa\u5e93");
                } else {
                    deliveryrecordVO.setDeliveryTypeName("\u81ea\u52a8\u51fa\u5e93");
                }
            }
            if (deliveryrecordVO.getDeliveryTypes() == null) continue;
            if (deliveryrecordVO.getDeliveryTypes() == 0) {
                deliveryrecordVO.setDeliveryTypesName("\u6210\u54c1\u51fa\u5e93");
            }
            if (deliveryrecordVO.getDeliveryTypes() == 1) {
                deliveryrecordVO.setDeliveryTypesName("\u6210\u54c1\u9000\u5e93");
            }
            if (deliveryrecordVO.getDeliveryTypes() == 4) {
                deliveryrecordVO.setDeliveryTypesName("\u8d44\u4ea7\u51fa\u5e93");
            }
            if (deliveryrecordVO.getDeliveryTypes() == 5) {
                deliveryrecordVO.setDeliveryTypesName("\u5e9f\u65e7\u7269\u8d44\u9000\u5e93");
            }
            if (deliveryrecordVO.getDeliveryTypes() == 6) {
                deliveryrecordVO.setDeliveryTypesName("\u8d44\u4ea7\u9000\u5e93");
            }
            if (deliveryrecordVO.getDeliveryTypes() == 7) {
                deliveryrecordVO.setDeliveryTypesName("\u76f4\u5165\u76f4\u51fa\u9000\u4f9b\u5e94\u5546");
            }
            if (deliveryrecordVO.getDeliveryTypes() != 8) continue;
            deliveryrecordVO.setDeliveryTypesName("\u65e0\u6765\u6e90\u9000\u5e93");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", deliveryrecordList);
        ExcelExport.getInstance().export("Deliveryrecord-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDeliveryrecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DeliveryrecordVO>> refDeliveryrecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"status") != null && _con.get((Object)"status").equals("1")) {
                param.getParams().put("deliveryType", new Parameter("in", (Object)"0,1"));
                param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
            }
            if (_con.get((Object)"types") != null) {
                if (_con.get((Object)"types").equals("1")) {
                    param.getParams().put("deliveryTypes", new Parameter("eq", (Object)0));
                }
                if (_con.get((Object)"types").equals("5")) {
                    param.getParams().put("deliveryTypes", new Parameter("in", (Object)"0,3,4"));
                }
                if (_con.get((Object)"types").equals("6")) {
                    param.getParams().put("deliveryTypes", new Parameter("eq", (Object)4));
                }
            }
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"orgId") != null) {
                UserContext userContextCache = this.sessionManager.getUserContext();
                String authOrgIds = userContextCache.getAuthOrgIds();
                List orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(_con.get((Object)"orgId").toString()))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                ArrayList commonOrgIds = new ArrayList();
                ArrayList departmentIds = new ArrayList();
                orgVOList.stream().forEach(org -> {
                    if (5 == org.getOrgType()) {
                        departmentIds.add(org.getId());
                    } else {
                        commonOrgIds.add(org.getId());
                    }
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    param.getParams().put("orgId", new Parameter("in", commonOrgIds));
                } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                    param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryrecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        List entityList = this.service.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)"1");
    }

    @RequestMapping(value={"/queryDeliverDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeliveryrecorddetailVO>> queryDeliverDetail(Long deliveryId, String status, Long id) {
        QueryWrapper queryWrapper;
        List list = new ArrayList();
        List<Object> materialapproachdetailEntities = new ArrayList();
        List deliveryrecorddetailVOS = new ArrayList();
        if (status.equals("0")) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"mid", (Object)deliveryId);
            list = this.detailService.list((Wrapper)queryWrapper);
        }
        if (status.equals("1")) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"warehousing_id", (Object)deliveryId);
            queryWrapper.eq((Object)"bill_state", (Object)3);
            DeliveryrecordEntity deliveryrecordEntity = (DeliveryrecordEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
            deliveryId = deliveryrecordEntity.getId();
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"mid", (Object)deliveryrecordEntity.getId());
            list = this.detailService.list((Wrapper)queryWrapper1);
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)deliveryId);
        List materialapproachdetailEntityList = this.detailService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)materialapproachdetailEntityList)) {
            List approachIds = materialapproachdetailEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper houseDetailScheme = Wrappers.lambdaQuery();
            houseDetailScheme.in(DeliveryrecorddetailEntity::getDeliveryDetailId, approachIds);
            if (id != null) {
                houseDetailScheme.ne(DeliveryrecorddetailEntity::getMid, (Object)id);
            }
            List materialWarehousingdetailEntities = this.detailService.list((Wrapper)houseDetailScheme);
            Map<Object, Object> checkMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)materialWarehousingdetailEntities)) {
                checkMap = materialWarehousingdetailEntities.stream().filter(s -> s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : list) {
                deliveryrecorddetailEntity.setDeliveryDetailId(deliveryrecorddetailEntity.getId());
                deliveryrecorddetailEntity.setDeliveryNum(deliveryrecorddetailEntity.getDeliveryQuantity());
                deliveryrecorddetailEntity.setAmountIncluetax(deliveryrecorddetailEntity.getAmountIncluetax().multiply(new BigDecimal(-1.0)));
                deliveryrecorddetailEntity.setAmountExcluetax(deliveryrecorddetailEntity.getAmountExcluetax().multiply(new BigDecimal(-1.0)));
                if (checkMap.containsKey(deliveryrecorddetailEntity.getId())) {
                    BigDecimal checkNum = (BigDecimal)checkMap.get(deliveryrecorddetailEntity.getId());
                    deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity().add(checkNum));
                } else {
                    deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity());
                }
                deliveryrecorddetailEntity.setId(IdWorker.getId());
                deliveryrecorddetailEntity.setDeliveryQuantity(deliveryrecorddetailEntity.getNotReturnedQuantity().multiply(new BigDecimal(-1.0)));
            }
            materialapproachdetailEntities = list.stream().filter(it -> it.getNotReturnedQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
            deliveryrecorddetailVOS = BeanMapper.mapList(materialapproachdetailEntities, DeliveryrecorddetailVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", deliveryrecorddetailVOS);
    }

    @RequestMapping(value={"/querySub"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeliveryrecordSubVO>> querySub(Long projectId, String materialCode) {
        List<DeliveryrecordSubVO> resList = this.service.selectSub(materialCode, String.valueOf(projectId));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }

    @PostMapping(value={"/updateSignStatus"})
    @ResponseBody
    public CommonResponse<String> updateSignStatus(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }
}

