/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.SurplusmaterialapproveEntity;
import com.ejianc.business.material.bean.SurplusmaterialapprovetailEntity;
import com.ejianc.business.material.bean.TenderEntity;
import com.ejianc.business.material.mapper.TenderMapper;
import com.ejianc.business.material.service.ISurplusmaterialapproveService;
import com.ejianc.business.material.service.ISurplusmaterialapprovetailService;
import com.ejianc.business.material.service.ITenderService;
import com.ejianc.business.material.vo.TenderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenderService")
public class TenderServiceImpl
extends BaseServiceImpl<TenderMapper, TenderEntity>
implements ITenderService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "MATERIAL_TENDER";
    @Autowired
    private ISurplusmaterialapproveService surplusmaterialapproveService;
    @Autowired
    private ISurplusmaterialapprovetailService surplusmaterialapprovetailService;

    @Override
    @Transactional
    public TenderVO saveOrUpdate(TenderVO saveOrUpdateVO) {
        TenderEntity entity = (TenderEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), TenderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(TenderEntity::getApproveId, (Object)saveOrUpdateVO.getApproveId());
        lambda.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List tenderEntities = super.list((Wrapper)lambda);
        List<Object> detailIds = new ArrayList<Long>();
        detailIds.add(saveOrUpdateVO.getApproveDetailId());
        if (CollectionUtils.isNotEmpty((Collection)tenderEntities)) {
            detailIds = tenderEntities.stream().map(TenderEntity::getApproveDetailId).collect(Collectors.toList());
        }
        SurplusmaterialapproveEntity surplusmaterialapproveEntity = (SurplusmaterialapproveEntity)((Object)this.surplusmaterialapproveService.selectById(saveOrUpdateVO.getApproveId()));
        List<SurplusmaterialapprovetailEntity> surplusmaterialapprovetailEntities = surplusmaterialapproveEntity.getSurplusmaterialapprovetailEntities();
        for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : surplusmaterialapprovetailEntities) {
            if (detailIds.contains(surplusmaterialapprovetailEntity.getId())) {
                surplusmaterialapprovetailEntity.setUseDetailStatus(2);
                continue;
            }
            surplusmaterialapprovetailEntity.setUseDetailStatus(1);
        }
        boolean anyMatch = surplusmaterialapprovetailEntities.stream().anyMatch(s -> s.getUseDetailStatus() == 1);
        if (anyMatch) {
            surplusmaterialapproveEntity.setUseStatus(1);
        } else {
            surplusmaterialapproveEntity.setUseStatus(2);
        }
        this.surplusmaterialapproveService.updateById((Object)surplusmaterialapproveEntity);
        this.surplusmaterialapprovetailService.updateBatchById(surplusmaterialapprovetailEntities);
        super.saveOrUpdate((Object)entity, false);
        TenderVO vo = (TenderVO)((Object)BeanMapper.map((Object)((Object)entity), TenderVO.class));
        return vo;
    }

    @Override
    public void delete(List<TenderVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper midLambda = Wrappers.lambdaQuery();
        midLambda.in(BaseEntity::getId, ids);
        List tenderEntities = super.list((Wrapper)midLambda);
        List detailIds = tenderEntities.stream().map(TenderEntity::getApproveDetailId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(BaseEntity::getId, detailIds);
        List surplusmaterialapprovetailEntityList = this.surplusmaterialapprovetailService.list((Wrapper)lambda);
        for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : surplusmaterialapprovetailEntityList) {
            surplusmaterialapprovetailEntity.setUseDetailStatus(1);
        }
        this.surplusmaterialapprovetailService.updateBatchById(surplusmaterialapprovetailEntityList);
        List approveIds = tenderEntities.stream().map(TenderEntity::getApproveId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper approveLambda = Wrappers.lambdaQuery();
        approveLambda.in(BaseEntity::getId, approveIds);
        List surplusmaterialapproveEntityList = this.surplusmaterialapproveService.list((Wrapper)approveLambda);
        for (SurplusmaterialapproveEntity surplusmaterialapprovetailEntity : surplusmaterialapproveEntityList) {
            surplusmaterialapprovetailEntity.setUseStatus(1);
        }
        this.surplusmaterialapproveService.updateBatchById(surplusmaterialapproveEntityList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

