/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.TransferorderEntity;
import com.ejianc.business.material.bean.TransferorderdetailEntity;
import com.ejianc.business.material.mapper.TransferorderMapper;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.business.material.service.impl.TransferorderBpmServiceImpl;
import com.ejianc.business.material.vo.TransferorderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transferorderService")
public class TransferorderServiceImpl
extends BaseServiceImpl<TransferorderMapper, TransferorderEntity>
implements ITransferorderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "WZ_DBD";
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private TransferorderBpmServiceImpl transferorderBpmService;

    @Override
    public TransferorderVO saveOrUpdate(TransferorderVO transferorderVO) {
        TransferorderEntity entity = (TransferorderEntity)((Object)BeanMapper.map((Object)((Object)transferorderVO), TransferorderEntity.class));
        entity.setSourceType(1);
        if (entity.getDialinitemsId().equals(entity.getDialitemsId())) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u4e0b\u4e0d\u80fd\u8fdb\u884c\u8c03\u62e8\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        for (TransferorderdetailEntity transferorderdetailEntity : entity.getTransferorderdetailEntities()) {
            transferorderdetailEntity.setEnterStoreId(entity.getIncomingWarehouse());
            transferorderdetailEntity.setEnterStoreName(entity.getIncomingWarehouseName());
            transferorderdetailEntity.setHairStoreId(entity.getIssuingWarehouse());
            transferorderdetailEntity.setHairStoreName(entity.getIssuingWarehouseName());
            transferorderdetailEntity.setPickingTime(entity.getDates());
        }
        this.saveOrUpdate((Object)entity, false);
        List materialIds = entity.getTransferorderdetailEntities().stream().map(TransferorderdetailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)entity.getIssuingWarehouse());
        lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
        if (transferorderVO.getId() != null) {
            lambdaFlow.ne(FlowmeterEntity::getMid, (Object)transferorderVO.getId());
        }
        List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
        Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal inNum = BigDecimal.ZERO;
        BigDecimal outNum = BigDecimal.ZERO;
        for (TransferorderdetailEntity materialWarehousingdetailEntity1 : entity.getTransferorderdetailEntities()) {
            inNum = BigDecimal.ZERO;
            outNum = BigDecimal.ZERO;
            if (numInMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())) {
                inNum = numInMap.get(materialWarehousingdetailEntity1.getMaterialId());
            }
            if (numOutMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())) {
                outNum = numOutMap.get(materialWarehousingdetailEntity1.getMaterialId());
            }
            BigDecimal subtract = inNum.subtract(outNum);
            BigDecimal qaty = new BigDecimal("-1");
            if (materialWarehousingdetailEntity1.getQuantity().compareTo(subtract) != 1) continue;
            throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + materialWarehousingdetailEntity1.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + materialWarehousingdetailEntity1.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u8c03\u62e8!");
        }
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid, (Object)entity.getId());
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        TransferorderEntity transferorderEntity = entity;
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList realList = new ArrayList();
        ArrayList realList1 = new ArrayList();
        ArrayList realList2 = new ArrayList();
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if (transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null) {
            for (TransferorderdetailEntity transferorderdetailEntity : transferorderdetailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper.eq((Object)"material_code", (Object)transferorderdetailEntity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)transferorderdetailEntity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity == null) continue;
                FlowmeterEntity flowmeterEntity = this.transferorderBpmService.createrFlowmeter(transferorderEntity, transferorderdetailEntity, 0);
                list.add(flowmeterEntity);
            }
            if (list.size() > 0) {
                this.logger.info(JSONObject.toJSONString(list));
                boolean flag = this.flowmeterService.saveBatch(list, list.size());
                if (flag) {
                    this.logger.info("\u6210\u529f");
                } else {
                    this.logger.info("\u5931\u8d25");
                }
                this.realtimebalanceService.updateRealtimeBalance(entity.getIssuingWarehouse());
            }
        }
        TransferorderVO vo = (TransferorderVO)((Object)BeanMapper.map((Object)((Object)entity), TransferorderVO.class));
        return vo;
    }

    @Override
    public boolean aggPush(TransferorderEntity transferorderEntity) {
        this.logger.info("\u8c03\u62e8\u63d0\u4ea4--------------");
        ArrayList<FlowmeterEntity> list1 = new ArrayList<FlowmeterEntity>();
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList1 = new ArrayList<RealtimebalanceEntity>();
        ArrayList<RealtimebalanceEntity> realList2 = new ArrayList<RealtimebalanceEntity>();
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if (transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null) {
            for (TransferorderdetailEntity entity : transferorderdetailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)transferorderEntity.getDialitemsId());
                queryWrapper.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity != null) {
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) == 0 || realtimebalanceEntity.getQuantity().compareTo(entity.getQuantity()) < 0) {
                        throw new BusinessException("\u7269\u8d44\u7f16\u7801:" + entity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + entity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u8c03\u62e8!");
                    }
                    FlowmeterEntity flowmeterEntity = this.transferorderBpmService.createrFlowmeter(transferorderEntity, entity, 0);
                    list.add(flowmeterEntity);
                    realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
                        realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    } else {
                        realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                    }
                    realList.add(realtimebalanceEntity);
                    FlowmeterEntity flowmeterEntity1 = this.transferorderBpmService.createrFlowmeter(transferorderEntity, entity, 1);
                    list1.add(flowmeterEntity1);
                    QueryWrapper queryWrapper1 = new QueryWrapper();
                    queryWrapper1.eq((Object)"project_id", (Object)transferorderEntity.getDialinitemsId());
                    queryWrapper1.eq((Object)"material_code", (Object)entity.getMaterialCode());
                    queryWrapper1.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                    queryWrapper1.eq((Object)"store_id", (Object)transferorderEntity.getIncomingWarehouse());
                    RealtimebalanceEntity realtimebalanceEntity1 = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper1));
                    if (realtimebalanceEntity1 != null) {
                        realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
                        realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getEnterAmount()));
                        realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getEnterAmountExcluetax()));
                        if (realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                            realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                            realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(), 8, 4));
                        } else {
                            realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.0));
                            realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.0));
                        }
                        realList2.add(realtimebalanceEntity1);
                        continue;
                    }
                    RealtimebalanceEntity realtimebalanceEntity2 = new RealtimebalanceEntity();
                    realtimebalanceEntity2.setProjectId(transferorderEntity.getDialinitemsId());
                    realtimebalanceEntity2.setProjectName(transferorderEntity.getDialInitems());
                    realtimebalanceEntity2.setMaterialCode(entity.getMaterialCode());
                    realtimebalanceEntity2.setMaterialName(entity.getMaterialName());
                    realtimebalanceEntity2.setMaterialCategoryId(entity.getMaterialCategoryId());
                    realtimebalanceEntity2.setMaterialCategoryCode(entity.getMaterialCategoryCode());
                    realtimebalanceEntity2.setMaterialCategoryName(entity.getMaterialCategoryName());
                    realtimebalanceEntity2.setStoreId(transferorderEntity.getIncomingWarehouse());
                    realtimebalanceEntity2.setStoreName(transferorderEntity.getIncomingWarehouseName());
                    realtimebalanceEntity2.setQuantity(entity.getQuantity());
                    realtimebalanceEntity2.setUnitPriceIncluetax(entity.getEnterPrice());
                    realtimebalanceEntity2.setUnitPriceExcluetax(entity.getEnterUnitPrice());
                    realtimebalanceEntity2.setAmountIncluetax(entity.getEnterAmount());
                    realtimebalanceEntity2.setAmountExcluetax(entity.getEnterAmountExcluetax());
                    realtimebalanceEntity2.setOrgId(transferorderEntity.getOrgId());
                    realtimebalanceEntity2.setOrgName(transferorderEntity.getOrgName());
                    realtimebalanceEntity2.setMeasurementUnit(entity.getMeasurementUnit());
                    realtimebalanceEntity2.setSpecialModel(entity.getSpecialModel());
                    realtimebalanceEntity2.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
                    realList1.add(realtimebalanceEntity2);
                    continue;
                }
                throw new BusinessException("\u8be5\u7269\u8d44\u7f16\u7801:" + entity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + entity.getMaterialName() + "\u6ca1\u6709\u5e93\u5b58,\u65e0\u6cd5\u8c03\u62e8!");
            }
            if (list1.size() > 0) {
                this.flowmeterService.saveBatch(list1, list1.size());
                this.realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
            }
            if (list.size() > 0) {
                for (FlowmeterEntity flowmeterEntity : list) {
                    this.flowmeterService.updateFlow(flowmeterEntity.getMid(), new Date(), 1);
                }
            }
        }
        return true;
    }

    @Override
    public List<TransferorderVO> queryTransList(Page<TransferorderVO> page, QueryWrapper<TransferorderEntity> wrapper, Integer type, List<Long> commonOrgIds, List<Long> departmentIds) {
        return ((TransferorderMapper)this.baseMapper).queryTransList(page, wrapper, type, commonOrgIds, departmentIds);
    }
}

