/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.controller;

import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.OutputValueReportEntity;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaService;
import com.ejianc.business.outputValue.service.IOutputValueReportService;
import com.ejianc.business.outputValue.utils.EasyExcelUtil;
import com.ejianc.business.outputValue.utils.ExcelFillCellMerge;
import com.ejianc.business.outputValue.vo.OutputValueReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outputValueReport"})
public class OutputValueReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutputValueReportService service;
    @Autowired
    private ICompanyUndertakeQuotaService companyUndertakeQuotaService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("projectStatus");
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        if (param.getParams().get("year") != null) {
            year = ((Parameter)param.getParams().get("year")).getValue().toString();
        } else {
            param.getParams().put("year", new Parameter("eq", (Object)year));
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("twoOrgSequence", "asc");
        param.getOrderMap().put("twoOrgId", "desc");
        param.getOrderMap().put("projectNum", "asc");
        param.getOrderMap().put("createTime", "desc");
        List entitys = this.service.queryList(param);
        List<OutputValueReportVO> vos = this.dealResultVOList(entitys, year);
        JSONObject margeData = this.getMargeData(vos);
        JSONObject result = new JSONObject();
        result.put("data", vos);
        result.put("margeData", (Object)margeData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    private JSONObject getMargeData(List<OutputValueReportVO> vos) {
        LinkedHashMap<String, Integer> colMarge = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Object> orgMarge = new LinkedHashMap<String, Object>();
        ArrayList<Integer> orgNameRowMarge = new ArrayList<Integer>();
        ArrayList<Integer> totalPlanIndex = new ArrayList<Integer>();
        JSONObject margeData = new JSONObject();
        Long twoOrgId = null;
        Integer twoOrgMargeIndex = 0;
        Integer twoOrgMargeRange = 0;
        Long orgId = null;
        Integer orgMargeIndex = 0;
        Integer orgMargeRange = 0;
        Long projectId = null;
        for (int i = 0; i < vos.size(); ++i) {
            JSONObject oMarge;
            Integer olMarge;
            OutputValueReportVO vo = vos.get(i);
            vo.setRowId(Long.valueOf(i));
            if (twoOrgId != null) {
                if (!vo.getTwoOrgId().equals(twoOrgId)) {
                    olMarge = new JSONObject();
                    olMarge.put("dataMargeIndex", i - twoOrgMargeRange - 1);
                    olMarge.put("dataMargeRange", twoOrgMargeRange);
                    colMarge.put("twoOrgId" + twoOrgId, olMarge);
                    twoOrgMargeIndex = i;
                    twoOrgMargeRange = 0;
                    twoOrgId = vo.getTwoOrgId();
                } else {
                    olMarge = twoOrgMargeRange;
                    Integer n = twoOrgMargeRange = Integer.valueOf(twoOrgMargeRange + 1);
                }
            } else {
                twoOrgId = vo.getTwoOrgId();
            }
            if (orgId != null) {
                Object arr;
                if (!vo.getOrgId().equals(orgId)) {
                    olMarge = new JSONObject();
                    olMarge.put("dataMargeIndex", i - orgMargeRange - 1);
                    olMarge.put("dataMargeRange", orgMargeRange);
                    if (orgMarge.get("orgId" + orgId) != null) {
                        arr = (List)orgMarge.get("orgId" + orgId);
                        arr.add(olMarge);
                        orgMarge.put("orgId" + orgId, arr);
                    } else {
                        arr = new ArrayList();
                        arr.add(olMarge);
                        orgMarge.put("orgId" + orgId, arr);
                    }
                    orgMargeIndex = i;
                    orgMargeRange = 0;
                    orgId = vo.getOrgId();
                } else {
                    olMarge = orgMargeRange;
                    orgMargeRange = orgMargeRange + 1;
                    arr = orgMargeRange;
                }
            } else {
                orgId = vo.getOrgId();
            }
            if ("\u9884\u8ba1\u65b0\u627f\u63a5\u9879\u76ee".equals(vo.getOrgName())) {
                olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 1);
                orgNameRowMarge.add(olMarge);
                oMarge = new JSONObject();
                oMarge.put("dataMargeIndex", (Object)(i - 2));
                oMarge.put("dataMargeRange", (Object)1);
                colMarge.put("projectId" + projectId, (Integer)oMarge);
                projectId = null;
                continue;
            }
            if ("\u5c0f\u8ba1".equals(vo.getOrgName())) {
                olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 4);
                orgNameRowMarge.add(olMarge);
                if ("\u8ba1\u5212".equals(vo.getDataType())) {
                    totalPlanIndex.add(i);
                    oMarge = new JSONObject();
                    oMarge.put("dataMargeIndex", (Object)i);
                    oMarge.put("dataMargeRange", (Object)1);
                    colMarge.put("projectId" + vo.getTwoOrgId(), (Integer)oMarge);
                }
                projectId = null;
                continue;
            }
            if (projectId != null) {
                if (vo.getProjectId().equals(projectId)) continue;
                projectId = vo.getProjectId();
                olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 1);
                colMarge.put("projectId" + projectId, olMarge);
                continue;
            }
            projectId = vo.getProjectId();
            olMarge = new JSONObject();
            olMarge.put("dataMargeIndex", i);
            olMarge.put("dataMargeRange", 1);
            colMarge.put("projectId" + projectId, olMarge);
        }
        if (colMarge.get(twoOrgId) == null) {
            JSONObject olMarge = new JSONObject();
            olMarge.put("dataMargeIndex", (Object)twoOrgMargeIndex);
            olMarge.put("dataMargeRange", (Object)twoOrgMargeRange);
            colMarge.put("twoOrgId" + twoOrgId, (Integer)olMarge);
        }
        if (orgMarge.get(orgId) == null) {
            JSONObject olMarge = new JSONObject();
            olMarge.put("dataMargeIndex", (Object)orgMargeIndex);
            olMarge.put("dataMargeRange", (Object)orgMargeRange);
            ArrayList<JSONObject> arr = new ArrayList<JSONObject>();
            arr.add(olMarge);
            orgMarge.put("orgId" + orgId, arr);
        }
        for (String key : orgMarge.keySet()) {
            List d;
            List arr = (List)orgMarge.get(key);
            if (margeData.get((Object)"orgNameColMarge") != null) {
                d = (List)margeData.get((Object)"orgNameColMarge");
                d.addAll(arr);
                margeData.put("orgNameColMarge", d);
                continue;
            }
            d = new ArrayList();
            d.addAll(arr);
            margeData.put("orgNameColMarge", d);
        }
        for (String key : colMarge.keySet()) {
            List d;
            if (key.startsWith("twoOrgId")) {
                if (margeData.get((Object)"twoOrgNameColMarge") != null) {
                    d = (List)margeData.get((Object)"twoOrgNameColMarge");
                    d.add(colMarge.get(key));
                    margeData.put("twoOrgNameColMarge", d);
                } else {
                    d = new ArrayList();
                    d.add(colMarge.get(key));
                    margeData.put("twoOrgNameColMarge", d);
                }
            }
            if (!key.startsWith("projectId")) continue;
            if (margeData.get((Object)"projectNameColMarge") != null) {
                d = (List)margeData.get((Object)"projectNameColMarge");
                d.add(colMarge.get(key));
                margeData.put("projectNameColMarge", d);
            } else {
                d = new ArrayList();
                d.add(colMarge.get(key));
                margeData.put("projectNameColMarge", d);
            }
            margeData.put("projectNumColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("actualStartDateColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("actualEndDateColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("planEndDateColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("contractAmountColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("provisionalAmountColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("builtAreaColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("lastYearAccumulateCompletedOutputValueColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("accumulateCompletedOutputValueColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("surplusOutputValueColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("projectStatusColMarge", margeData.get((Object)"projectNameColMarge"));
            margeData.put("thisYearProjectColMarge", margeData.get((Object)"projectNameColMarge"));
        }
        margeData.put("orgNameRowMarge", orgNameRowMarge);
        margeData.put("totalPlanIndex", totalPlanIndex);
        return margeData;
    }

    private List<OutputValueReportVO> dealResultVOList(List<OutputValueReportEntity> entitys, String year) {
        Long twoOrgId = null;
        String twoOrgName = null;
        ArrayList<OutputValueReportVO> vos = new ArrayList<OutputValueReportVO>();
        OutputValueReportVO allPlanVo = new OutputValueReportVO();
        OutputValueReportVO allActualVo = new OutputValueReportVO();
        for (OutputValueReportEntity entity : entitys) {
            if (twoOrgId != null) {
                if (!entity.getTwoOrgId().equals(twoOrgId)) {
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"year", (Object)year);
                    wrapper.in((Object)"bill_state", new Object[]{1, 3});
                    wrapper.eq((Object)"org_id", (Object)twoOrgId);
                    List list = this.companyUndertakeQuotaService.list((Wrapper)wrapper);
                    OutputValueReportVO undertakeQuota = new OutputValueReportVO();
                    undertakeQuota.setTwoOrgId(twoOrgId);
                    undertakeQuota.setTwoOrgName(twoOrgName);
                    undertakeQuota.setOrgId(twoOrgId + 2222L);
                    undertakeQuota.setOrgName("\u9884\u8ba1\u65b0\u627f\u63a5\u9879\u76ee");
                    undertakeQuota.setProjectName("\u9884\u8ba1\u65b0\u627f\u63a5\u9879\u76ee");
                    if (list != null && list.size() > 0) {
                        CompanyUndertakeQuotaEntity en = (CompanyUndertakeQuotaEntity)((Object)list.get(0));
                        undertakeQuota.setYearOutputValue(en.getContractQuota());
                        undertakeQuota.setJanuaryOutputValue(en.getJanuaryContractQuota());
                        undertakeQuota.setFebruaryOutputValue(en.getFebruaryContractQuota());
                        undertakeQuota.setMarchOutputValue(en.getMarchContractQuota());
                        undertakeQuota.setAprilOutputValue(en.getAprilContractQuota());
                        undertakeQuota.setMayOutputValue(en.getMayContractQuota());
                        undertakeQuota.setJuneOutputValue(en.getJuneContractQuota());
                        undertakeQuota.setJulyOutputValue(en.getJulyContractQuota());
                        undertakeQuota.setAugustOutputValue(en.getAugustContractQuota());
                        undertakeQuota.setSeptemberOutputValue(en.getSeptemberContractQuota());
                        undertakeQuota.setOctoberOutputValue(en.getOctoberContractQuota());
                        undertakeQuota.setNovemberOutputValue(en.getNovemberContractQuota());
                        undertakeQuota.setDecemberOutputValue(en.getDecemberContractQuota());
                    }
                    vos.add(undertakeQuota);
                    allPlanVo.setTwoOrgId(twoOrgId);
                    allPlanVo.setTwoOrgName(twoOrgName);
                    allPlanVo.setOrgId(twoOrgId + 1111L);
                    allPlanVo.setOrgName("\u5c0f\u8ba1");
                    allPlanVo.setProjectName("\u5c0f\u8ba1");
                    allPlanVo.setDataType("\u8ba1\u5212");
                    vos.add(allPlanVo);
                    allActualVo.setTwoOrgId(twoOrgId);
                    allActualVo.setTwoOrgName(twoOrgName);
                    allActualVo.setOrgId(twoOrgId + 1111L);
                    allActualVo.setOrgName("\u5c0f\u8ba1");
                    allActualVo.setProjectName("\u5c0f\u8ba1");
                    allActualVo.setDataType("\u5b9e\u9645");
                    vos.add(allActualVo);
                    twoOrgId = entity.getTwoOrgId();
                    twoOrgName = entity.getTwoOrgName();
                    allPlanVo = new OutputValueReportVO();
                    allActualVo = new OutputValueReportVO();
                } else {
                    twoOrgId = entity.getTwoOrgId();
                    twoOrgName = entity.getTwoOrgName();
                    allPlanVo.setContractAmount(CommonUtils.addBigDecimal(allPlanVo.getContractAmount(), entity.getContractAmount()));
                    allPlanVo.setProvisionalAmount(CommonUtils.addBigDecimal(allPlanVo.getProvisionalAmount(), entity.getProvisionalAmount()));
                    allPlanVo.setBuiltArea(CommonUtils.addBigDecimal(allPlanVo.getBuiltArea(), entity.getBuiltArea()));
                    allPlanVo.setThisYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getThisYearAccumulateCompletedOutputValue(), entity.getThisYearAccumulateCompletedOutputValue()));
                    allPlanVo.setAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAccumulateCompletedOutputValue(), entity.getAccumulateCompletedOutputValue()));
                    allPlanVo.setLastYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getLastYearAccumulateCompletedOutputValue(), entity.getLastYearAccumulateCompletedOutputValue()));
                    allPlanVo.setSurplusOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSurplusOutputValue(), entity.getSurplusOutputValue()));
                    allPlanVo.setYearOutputValue(CommonUtils.addBigDecimal(allPlanVo.getYearOutputValue(), entity.getYearPlanOutputValue()));
                    allPlanVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJanuaryOutputValue(), entity.getJanuaryPlanOutputValue()));
                    allPlanVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getFebruaryOutputValue(), entity.getFebruaryPlanOutputValue()));
                    allPlanVo.setMarchOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMarchOutputValue(), entity.getMarchPlanOutputValue()));
                    allPlanVo.setAprilOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAprilOutputValue(), entity.getAprilPlanOutputValue()));
                    allPlanVo.setMayOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMayOutputValue(), entity.getMayPlanOutputValue()));
                    allPlanVo.setJuneOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJuneOutputValue(), entity.getJunePlanOutputValue()));
                    allPlanVo.setJulyOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJulyOutputValue(), entity.getJulyPlanOutputValue()));
                    allPlanVo.setAugustOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAugustOutputValue(), entity.getAugustPlanOutputValue()));
                    allPlanVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSeptemberOutputValue(), entity.getSeptemberPlanOutputValue()));
                    allPlanVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getOctoberOutputValue(), entity.getOctoberPlanOutputValue()));
                    allPlanVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getNovemberOutputValue(), entity.getNovemberPlanOutputValue()));
                    allPlanVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getDecemberOutputValue(), entity.getDecemberPlanOutputValue()));
                    allActualVo.setContractAmount(allPlanVo.getContractAmount());
                    allActualVo.setProvisionalAmount(allPlanVo.getProvisionalAmount());
                    allActualVo.setBuiltArea(allPlanVo.getBuiltArea());
                    allActualVo.setThisYearAccumulateCompletedOutputValue(allPlanVo.getThisYearAccumulateCompletedOutputValue());
                    allActualVo.setAccumulateCompletedOutputValue(allPlanVo.getAccumulateCompletedOutputValue());
                    allActualVo.setLastYearAccumulateCompletedOutputValue(allPlanVo.getLastYearAccumulateCompletedOutputValue());
                    allActualVo.setSurplusOutputValue(allPlanVo.getSurplusOutputValue());
                    allActualVo.setYearOutputValue(CommonUtils.addBigDecimal(allActualVo.getYearOutputValue(), entity.getYearActualOutputValue()));
                    allActualVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getJanuaryOutputValue(), entity.getJanuaryActualOutputValue()));
                    allActualVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getFebruaryOutputValue(), entity.getFebruaryActualOutputValue()));
                    allActualVo.setMarchOutputValue(CommonUtils.addBigDecimal(allActualVo.getMarchOutputValue(), entity.getMarchActualOutputValue()));
                    allActualVo.setAprilOutputValue(CommonUtils.addBigDecimal(allActualVo.getAprilOutputValue(), entity.getAprilActualOutputValue()));
                    allActualVo.setMayOutputValue(CommonUtils.addBigDecimal(allActualVo.getMayOutputValue(), entity.getMayActualOutputValue()));
                    allActualVo.setJuneOutputValue(CommonUtils.addBigDecimal(allActualVo.getJuneOutputValue(), entity.getJuneActualOutputValue()));
                    allActualVo.setJulyOutputValue(CommonUtils.addBigDecimal(allActualVo.getJulyOutputValue(), entity.getJulyActualOutputValue()));
                    allActualVo.setAugustOutputValue(CommonUtils.addBigDecimal(allActualVo.getAugustOutputValue(), entity.getAugustActualOutputValue()));
                    allActualVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getSeptemberOutputValue(), entity.getSeptemberActualOutputValue()));
                    allActualVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allActualVo.getOctoberOutputValue(), entity.getOctoberActualOutputValue()));
                    allActualVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getNovemberOutputValue(), entity.getNovemberActualOutputValue()));
                    allActualVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getDecemberOutputValue(), entity.getDecemberActualOutputValue()));
                }
            } else {
                twoOrgId = entity.getTwoOrgId();
                twoOrgName = entity.getTwoOrgName();
                allPlanVo = new OutputValueReportVO();
                allActualVo = new OutputValueReportVO();
                allPlanVo.setContractAmount(CommonUtils.addBigDecimal(allPlanVo.getContractAmount(), entity.getContractAmount()));
                allPlanVo.setProvisionalAmount(CommonUtils.addBigDecimal(allPlanVo.getProvisionalAmount(), entity.getProvisionalAmount()));
                allPlanVo.setBuiltArea(CommonUtils.addBigDecimal(allPlanVo.getBuiltArea(), entity.getBuiltArea()));
                allPlanVo.setThisYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getThisYearAccumulateCompletedOutputValue(), entity.getThisYearAccumulateCompletedOutputValue()));
                allPlanVo.setAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAccumulateCompletedOutputValue(), entity.getAccumulateCompletedOutputValue()));
                allPlanVo.setLastYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getLastYearAccumulateCompletedOutputValue(), entity.getLastYearAccumulateCompletedOutputValue()));
                allPlanVo.setSurplusOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSurplusOutputValue(), entity.getSurplusOutputValue()));
                allPlanVo.setYearOutputValue(CommonUtils.addBigDecimal(allPlanVo.getYearOutputValue(), entity.getYearPlanOutputValue()));
                allPlanVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJanuaryOutputValue(), entity.getJanuaryPlanOutputValue()));
                allPlanVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getFebruaryOutputValue(), entity.getFebruaryPlanOutputValue()));
                allPlanVo.setMarchOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMarchOutputValue(), entity.getMarchPlanOutputValue()));
                allPlanVo.setAprilOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAprilOutputValue(), entity.getAprilPlanOutputValue()));
                allPlanVo.setMayOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMayOutputValue(), entity.getMayPlanOutputValue()));
                allPlanVo.setJuneOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJuneOutputValue(), entity.getJunePlanOutputValue()));
                allPlanVo.setJulyOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJulyOutputValue(), entity.getJulyPlanOutputValue()));
                allPlanVo.setAugustOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAugustOutputValue(), entity.getAugustPlanOutputValue()));
                allPlanVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSeptemberOutputValue(), entity.getSeptemberPlanOutputValue()));
                allPlanVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getOctoberOutputValue(), entity.getOctoberPlanOutputValue()));
                allPlanVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getNovemberOutputValue(), entity.getNovemberPlanOutputValue()));
                allPlanVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getDecemberOutputValue(), entity.getDecemberPlanOutputValue()));
                allActualVo.setContractAmount(allPlanVo.getContractAmount());
                allActualVo.setProvisionalAmount(allPlanVo.getProvisionalAmount());
                allActualVo.setBuiltArea(allPlanVo.getBuiltArea());
                allActualVo.setThisYearAccumulateCompletedOutputValue(allPlanVo.getThisYearAccumulateCompletedOutputValue());
                allActualVo.setAccumulateCompletedOutputValue(allPlanVo.getAccumulateCompletedOutputValue());
                allActualVo.setLastYearAccumulateCompletedOutputValue(allPlanVo.getLastYearAccumulateCompletedOutputValue());
                allActualVo.setSurplusOutputValue(allPlanVo.getSurplusOutputValue());
                allActualVo.setYearOutputValue(CommonUtils.addBigDecimal(allActualVo.getYearOutputValue(), entity.getYearActualOutputValue()));
                allActualVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getJanuaryOutputValue(), entity.getJanuaryActualOutputValue()));
                allActualVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getFebruaryOutputValue(), entity.getFebruaryActualOutputValue()));
                allActualVo.setMarchOutputValue(CommonUtils.addBigDecimal(allActualVo.getMarchOutputValue(), entity.getMarchActualOutputValue()));
                allActualVo.setAprilOutputValue(CommonUtils.addBigDecimal(allActualVo.getAprilOutputValue(), entity.getAprilActualOutputValue()));
                allActualVo.setMayOutputValue(CommonUtils.addBigDecimal(allActualVo.getMayOutputValue(), entity.getMayActualOutputValue()));
                allActualVo.setJuneOutputValue(CommonUtils.addBigDecimal(allActualVo.getJuneOutputValue(), entity.getJuneActualOutputValue()));
                allActualVo.setJulyOutputValue(CommonUtils.addBigDecimal(allActualVo.getJulyOutputValue(), entity.getJulyActualOutputValue()));
                allActualVo.setAugustOutputValue(CommonUtils.addBigDecimal(allActualVo.getAugustOutputValue(), entity.getAugustActualOutputValue()));
                allActualVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getSeptemberOutputValue(), entity.getSeptemberActualOutputValue()));
                allActualVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allActualVo.getOctoberOutputValue(), entity.getOctoberActualOutputValue()));
                allActualVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getNovemberOutputValue(), entity.getNovemberActualOutputValue()));
                allActualVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getDecemberOutputValue(), entity.getDecemberActualOutputValue()));
            }
            OutputValueReportVO vo = (OutputValueReportVO)((Object)BeanMapper.map((Object)((Object)entity), OutputValueReportVO.class));
            String actualStartDateString = null;
            String actualEndDateString = null;
            String planStartDateString = null;
            String planEndDateString = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            if (entity.getActualStartDate() != null) {
                actualStartDateString = sdf.format(entity.getActualStartDate());
            }
            if (entity.getActualEndDate() != null) {
                actualEndDateString = sdf.format(entity.getActualEndDate());
            }
            if (entity.getPlanStartDate() != null) {
                planStartDateString = sdf.format(entity.getPlanStartDate());
            }
            if (entity.getPlanEndDate() != null) {
                planEndDateString = sdf.format(entity.getPlanEndDate());
            }
            vo.setActualStartDateString(actualStartDateString);
            vo.setActualEndDateString(actualEndDateString);
            vo.setPlanStartDateString(planStartDateString);
            vo.setPlanEndDateString(planEndDateString);
            vo.setActualStartDate(entity.getActualStartDate());
            vo.setActualEndDate(entity.getActualEndDate());
            vo.setPlanStartDate(entity.getPlanStartDate());
            vo.setPlanEndDate(entity.getPlanEndDate());
            vo.setDataType("\u8ba1\u5212");
            vo.setYearOutputValue(entity.getYearPlanOutputValue());
            vo.setJanuaryOutputValue(entity.getJanuaryPlanOutputValue());
            vo.setFebruaryOutputValue(entity.getFebruaryPlanOutputValue());
            vo.setMarchOutputValue(entity.getMarchPlanOutputValue());
            vo.setAprilOutputValue(entity.getAprilPlanOutputValue());
            vo.setMayOutputValue(entity.getMayPlanOutputValue());
            vo.setJuneOutputValue(entity.getJunePlanOutputValue());
            vo.setJulyOutputValue(entity.getJulyPlanOutputValue());
            vo.setAugustOutputValue(entity.getAugustPlanOutputValue());
            vo.setSeptemberOutputValue(entity.getSeptemberPlanOutputValue());
            vo.setOctoberOutputValue(entity.getOctoberPlanOutputValue());
            vo.setNovemberOutputValue(entity.getNovemberPlanOutputValue());
            vo.setDecemberOutputValue(entity.getDecemberPlanOutputValue());
            vos.add(vo);
            OutputValueReportVO vo1 = (OutputValueReportVO)((Object)BeanMapper.map((Object)((Object)entity), OutputValueReportVO.class));
            vo1.setActualStartDateString(actualStartDateString);
            vo1.setActualEndDateString(actualEndDateString);
            vo1.setPlanStartDateString(planStartDateString);
            vo1.setPlanEndDateString(planEndDateString);
            vo1.setActualStartDate(entity.getActualStartDate());
            vo1.setActualEndDate(entity.getActualEndDate());
            vo1.setPlanStartDate(entity.getPlanStartDate());
            vo1.setPlanEndDate(entity.getPlanEndDate());
            vo1.setDataType("\u5b9e\u9645");
            vo1.setYearOutputValue(entity.getYearActualOutputValue());
            vo1.setJanuaryOutputValue(entity.getJanuaryActualOutputValue());
            vo1.setFebruaryOutputValue(entity.getFebruaryActualOutputValue());
            vo1.setMarchOutputValue(entity.getMarchActualOutputValue());
            vo1.setAprilOutputValue(entity.getAprilActualOutputValue());
            vo1.setMayOutputValue(entity.getMayActualOutputValue());
            vo1.setJuneOutputValue(entity.getJuneActualOutputValue());
            vo1.setJulyOutputValue(entity.getJulyActualOutputValue());
            vo1.setAugustOutputValue(entity.getAugustActualOutputValue());
            vo1.setSeptemberOutputValue(entity.getSeptemberActualOutputValue());
            vo1.setOctoberOutputValue(entity.getOctoberActualOutputValue());
            vo1.setNovemberOutputValue(entity.getNovemberActualOutputValue());
            vo1.setDecemberOutputValue(entity.getDecemberActualOutputValue());
            vos.add(vo1);
            if (entitys.indexOf((Object)entity) != entitys.size() - 1) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"year", (Object)year);
            wrapper.in((Object)"bill_state", new Object[]{1, 3});
            wrapper.eq((Object)"org_id", (Object)twoOrgId);
            List list = this.companyUndertakeQuotaService.list((Wrapper)wrapper);
            OutputValueReportVO undertakeQuota = new OutputValueReportVO();
            undertakeQuota.setTwoOrgId(twoOrgId);
            undertakeQuota.setTwoOrgName(twoOrgName);
            undertakeQuota.setOrgId(twoOrgId + 2222L);
            undertakeQuota.setOrgName("\u9884\u8ba1\u65b0\u627f\u63a5\u9879\u76ee");
            undertakeQuota.setProjectName("\u9884\u8ba1\u65b0\u627f\u63a5\u9879\u76ee");
            if (list != null && list.size() > 0) {
                CompanyUndertakeQuotaEntity en = (CompanyUndertakeQuotaEntity)((Object)list.get(0));
                undertakeQuota.setYearOutputValue(en.getContractQuota());
                undertakeQuota.setJanuaryOutputValue(en.getJanuaryContractQuota());
                undertakeQuota.setFebruaryOutputValue(en.getFebruaryContractQuota());
                undertakeQuota.setMarchOutputValue(en.getMarchContractQuota());
                undertakeQuota.setAprilOutputValue(en.getAprilContractQuota());
                undertakeQuota.setMayOutputValue(en.getMayContractQuota());
                undertakeQuota.setJuneOutputValue(en.getJuneContractQuota());
                undertakeQuota.setJulyOutputValue(en.getJulyContractQuota());
                undertakeQuota.setAugustOutputValue(en.getAugustContractQuota());
                undertakeQuota.setSeptemberOutputValue(en.getSeptemberContractQuota());
                undertakeQuota.setOctoberOutputValue(en.getOctoberContractQuota());
                undertakeQuota.setNovemberOutputValue(en.getNovemberContractQuota());
                undertakeQuota.setDecemberOutputValue(en.getDecemberContractQuota());
            }
            vos.add(undertakeQuota);
            allPlanVo.setTwoOrgId(twoOrgId);
            allPlanVo.setTwoOrgName(twoOrgName);
            allPlanVo.setOrgId(twoOrgId + 1111L);
            allPlanVo.setOrgName("\u5c0f\u8ba1");
            allPlanVo.setProjectName("\u5c0f\u8ba1");
            allPlanVo.setDataType("\u8ba1\u5212");
            vos.add(allPlanVo);
            allActualVo.setTwoOrgId(twoOrgId);
            allActualVo.setTwoOrgName(twoOrgName);
            allActualVo.setOrgId(twoOrgId + 1111L);
            allActualVo.setOrgName("\u5c0f\u8ba1");
            allActualVo.setProjectName("\u5c0f\u8ba1");
            allActualVo.setDataType("\u5b9e\u9645");
            vos.add(allActualVo);
        }
        return vos;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("projectStatus");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        if (param.getParams().get("year") != null) {
            year = ((Parameter)param.getParams().get("year")).getValue().toString();
        } else {
            param.getParams().put("year", new Parameter("eq", (Object)year));
        }
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("twoOrgSequence", "asc");
        param.getOrderMap().put("twoOrgId", "desc");
        param.getOrderMap().put("orgId", "desc");
        param.getOrderMap().put("projectNum", "asc");
        param.getOrderMap().put("createTime", "desc");
        List entitys = this.service.queryList(param);
        List<OutputValueReportVO> vos = this.dealResultVOList(entitys, year);
        JSONObject margeData = this.getMargeData(vos);
        ExcelFillCellMerge mergePrevCol = new ExcelFillCellMerge();
        List totalPlanIndex = (List)margeData.get((Object)"totalPlanIndex");
        HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>();
        colIndexMap.put("projectNumColMarge", 0);
        colIndexMap.put("twoOrgNameColMarge", 1);
        colIndexMap.put("orgNameColMarge", 2);
        colIndexMap.put("projectNameColMarge", 3);
        colIndexMap.put("actualStartDateColMarge", 4);
        colIndexMap.put("actualEndDateColMarge", 5);
        colIndexMap.put("planEndDateColMarge", 6);
        colIndexMap.put("contractAmountColMarge", 7);
        colIndexMap.put("provisionalAmountColMarge", 8);
        colIndexMap.put("builtAreaColMarge", 9);
        colIndexMap.put("lastYearAccumulateCompletedOutputValueColMarge", 10);
        colIndexMap.put("accumulateCompletedOutputValueColMarge", 11);
        colIndexMap.put("surplusOutputValueColMarge", 12);
        colIndexMap.put("projectStatusColMarge", 13);
        colIndexMap.put("thisYearProjectColMarge", 14);
        for (String key : margeData.keySet()) {
            List colMarge;
            Integer colIndex;
            Integer dataMargeRange;
            Object dataMargeIndex;
            if (key.contains("RowMarge") || !key.contains("ColMarge")) continue;
            if ("orgNameColMarge".equals(key)) {
                if (margeData.get((Object)"orgNameRowMarge") != null) {
                    List orgNameRowMarge = (List)margeData.get((Object)"orgNameRowMarge");
                    HashMap<String, Integer> margeRowMap = new HashMap<String, Integer>();
                    for (JSONObject data : orgNameRowMarge) {
                        dataMargeIndex = data.getInteger("dataMargeIndex");
                        dataMargeRange = data.getInteger("dataMargeRange");
                        margeRowMap.put("orgName" + dataMargeIndex, dataMargeRange);
                    }
                    List colMarge2 = (List)margeData.get((Object)key);
                    HashMap margeColMap = new HashMap();
                    dataMargeIndex = colMarge2.iterator();
                    while (dataMargeIndex.hasNext()) {
                        JSONObject data = (JSONObject)dataMargeIndex.next();
                        Integer dataMargeIndex2 = data.getInteger("dataMargeIndex");
                        Integer dataMargeRange2 = data.getInteger("dataMargeRange");
                        if (margeRowMap.get("orgName" + dataMargeIndex2) != null) {
                            if (dataMargeRange2 > 0 && (Integer)margeRowMap.get("orgName" + dataMargeIndex2) > 0) {
                                mergePrevCol.addAll(dataMargeIndex2 + 3, 2, (Integer)margeRowMap.get("orgName" + dataMargeIndex2), dataMargeRange2);
                                continue;
                            }
                            if (dataMargeRange2 <= 0 && (Integer)margeRowMap.get("orgName" + dataMargeIndex2) > 0) {
                                mergePrevCol.addRow(dataMargeIndex2 + 3, 2, (Integer)margeRowMap.get("orgName" + dataMargeIndex2));
                                continue;
                            }
                            if (dataMargeRange2 <= 0 || (Integer)margeRowMap.get("orgName" + dataMargeIndex2) > 0) continue;
                            mergePrevCol.addCol(dataMargeIndex2 + 3, 2, dataMargeRange2);
                            continue;
                        }
                        mergePrevCol.addCol(dataMargeIndex2 + 3, 2, dataMargeRange2);
                    }
                    continue;
                }
                colIndex = (Integer)colIndexMap.get(key);
                colMarge = (List)margeData.get((Object)key);
                for (JSONObject data : colMarge) {
                    dataMargeIndex = data.getInteger("dataMargeIndex");
                    dataMargeRange = data.getInteger("dataMargeRange");
                    mergePrevCol.addCol((Integer)dataMargeIndex + 3, colIndex, dataMargeRange);
                }
                continue;
            }
            colIndex = (Integer)colIndexMap.get(key);
            colMarge = (List)margeData.get((Object)key);
            for (JSONObject data : colMarge) {
                dataMargeIndex = data.getInteger("dataMargeIndex");
                dataMargeRange = data.getInteger("dataMargeRange");
                if (totalPlanIndex.contains(dataMargeIndex) && (colIndex == 2 || colIndex == 3 || colIndex == 4 || colIndex == 5 || colIndex == 6)) continue;
                mergePrevCol.addCol((Integer)dataMargeIndex + 3, colIndex, dataMargeRange);
            }
        }
        EasyExcelUtil excelExport = new EasyExcelUtil();
        List<String> heardKey = Arrays.asList("projectNum", "twoOrgName", "orgName", "projectName", "actualStartDateString", "actualEndDateString", "planEndDateString", "contractAmount", "provisionalAmount", "builtArea", "lastYearAccumulateCompletedOutputValue", "accumulateCompletedOutputValue", "surplusOutputValue", "projectStatus", "thisYearProject", "dataType", "yearOutputValue", "januaryOutputValue", "februaryOutputValue", "marchOutputValue", "aprilOutputValue", "mayOutputValue", "juneOutputValue", "julyOutputValue", "augustOutputValue", "septemberOutputValue", "octoberOutputValue", "novemberOutputValue", "decemberOutputValue");
        ArrayList heardListData = ListUtils.newArrayList();
        List<String> heardKey1 = Arrays.asList("\u5e8f\u53f7", "\u5e8f\u53f7");
        List<String> heardKey2 = Arrays.asList("\u533a\u57df", "\u533a\u57df");
        List<String> heardKey3 = Arrays.asList("\u5206\uff08\u5b50\uff09\u516c\u53f8\u540d\u79f0", "\u5206\uff08\u5b50\uff09\u516c\u53f8\u540d\u79f0");
        List<String> heardKey4 = Arrays.asList("\u5de5\u5382/\u5de5\u7a0b\u540d\u79f0\uff08\u5168\u79f0\uff09", "\u5de5\u5382/\u5de5\u7a0b\u540d\u79f0\uff08\u5168\u79f0\uff09");
        List<String> heardKey5 = Arrays.asList("\u5b9e\u9645\u5f00\u5de5", "\u5b9e\u9645\u5f00\u5de5");
        List<String> heardKey6 = Arrays.asList("\u5408\u540c\u7ae3\u5de5", "\u5408\u540c\u7ae3\u5de5");
        List<String> heardKey7 = Arrays.asList("\u8ba1\u5212\u7ae3\u5de5", "\u8ba1\u5212\u7ae3\u5de5");
        List<String> heardKey8 = Arrays.asList("\u5408\u540c\u989d", "\u5408\u540c\u989d\uff08\u4e07\u5143\uff09");
        List<String> heardKey9 = Arrays.asList("\u6682\u5217\u91d1", "\u6682\u5217\u91d1\uff08\u4e07\u5143\uff09");
        List<String> heardKey10 = Arrays.asList("\u5efa\u7b51\u89c4\u6a21", "\u5efa\u7b51\u89c4\u6a21");
        Integer lastYear = Integer.valueOf(year) - 1;
        String t = lastYear + "\u5e74\u5168\u5e74\u5b8c\u6210\u4ea7\u503c";
        List<String> heardKey11 = Arrays.asList(t, t);
        String a = "\u622a\u6b62" + lastYear + "\u5e74\u5e74\u672b\u9879\u76ee\u5b8c\u6210\u4ea7\u503c";
        List<String> heardKey12 = Arrays.asList(a, a);
        String s = "\u622a\u6b62" + lastYear + "\u5e74\u5e74\u672b\u9879\u76ee\u5269\u4f59\u4ea7\u503c";
        List<String> heardKey13 = Arrays.asList(s, s);
        List<String> heardKey14 = Arrays.asList("\u72b6\u6001", "\u72b6\u6001");
        List<String> heardKey15 = Arrays.asList("\u662f\u5426\u672c\u5e74\u65b0\u9879\u76ee", "\u662f\u5426\u672c\u5e74\u65b0\u9879\u76ee");
        List<String> heardKey16 = Arrays.asList("\u7c7b\u578b", "\u7c7b\u578b");
        List<String> heardKey17 = Arrays.asList("\u5e74\u5ea6\u9884\u8ba1\u5b8c\u6210\u4ea7\u503c", "\u5e74\u5ea6\u9884\u8ba1\u5b8c\u6210\u4ea7\u503c");
        List<String> heardKey18 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "1\u6708");
        List<String> heardKey19 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "2\u6708");
        List<String> heardKey20 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "3\u6708");
        List<String> heardKey21 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "4\u6708");
        List<String> heardKey22 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "5\u6708");
        List<String> heardKey23 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "6\u6708");
        List<String> heardKey24 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "7\u6708");
        List<String> heardKey25 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "8\u6708");
        List<String> heardKey26 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "9\u6708");
        List<String> heardKey27 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "10\u6708");
        List<String> heardKey28 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "11\u6708");
        List<String> heardKey29 = Arrays.asList("\u5e74\u5ea6\u6708\u5ea6\u8ba1\u5212\u4ea7\u503c", "12\u6708");
        heardListData.add(heardKey1);
        heardListData.add(heardKey2);
        heardListData.add(heardKey3);
        heardListData.add(heardKey4);
        heardListData.add(heardKey5);
        heardListData.add(heardKey6);
        heardListData.add(heardKey7);
        heardListData.add(heardKey8);
        heardListData.add(heardKey9);
        heardListData.add(heardKey10);
        heardListData.add(heardKey11);
        heardListData.add(heardKey12);
        heardListData.add(heardKey13);
        heardListData.add(heardKey14);
        heardListData.add(heardKey15);
        heardListData.add(heardKey16);
        heardListData.add(heardKey17);
        heardListData.add(heardKey18);
        heardListData.add(heardKey19);
        heardListData.add(heardKey20);
        heardListData.add(heardKey21);
        heardListData.add(heardKey22);
        heardListData.add(heardKey23);
        heardListData.add(heardKey24);
        heardListData.add(heardKey25);
        heardListData.add(heardKey26);
        heardListData.add(heardKey27);
        heardListData.add(heardKey28);
        heardListData.add(heardKey29);
        List<String> fieldFormat = Arrays.asList("string", "string", "string", "string", "yyyy-MM-dd", "yyyy-MM-dd", "yyyy-MM-dd", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "string", "string", "string", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers", "fourDecimalNumbers");
        excelExport.setHeardListData(heardListData);
        excelExport.setData(BeanMapper.mapList(vos, JSONObject.class));
        if (ListUtil.isNotEmpty(heardKey)) {
            excelExport.setHeardKey(heardKey);
            excelExport.setFontSize(12);
            excelExport.setFieldFormat(fieldFormat);
            excelExport.setSheetName("\u4ea7\u503c\u5206\u6790\u8868");
            excelExport.setMergePrevCol(mergePrevCol);
            excelExport.exportExport(request, response);
        }
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> refreshData(@RequestParam(required=false) String year) {
        this.service.refreshData(year);
        return CommonResponse.success((String)"\u5237\u65b0\u6570\u636e\u6210\u529f");
    }
}

