/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.material.utils.ComputeUtil;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.OutputValueReportEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.mapper.OutputValueIndexMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectPcYearBusinessQuotaMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IOutputValueIndexService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outputValueIndexService")
public class OutputValueIndexServiceImpl
implements IOutputValueIndexService {
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private OutputValueIndexMapper mapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private ProjectPcYearBusinessQuotaMapper projectPcYearBusinessQuotaMapper;
    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;

    @Override
    public JSONObject queryData() {
        JSONObject result = new JSONObject();
        LocalDate today = LocalDate.now();
        String year = String.valueOf(today.getYear());
        CompanyBusinessQuotaEntity sumAllCompany = this.mapper.queryCompanySum(year);
        BigDecimal thisYearRevenueQuota = sumAllCompany != null ? sumAllCompany.getThisYearRevenueQuota() : new BigDecimal(0);
        BigDecimal thisYearPlanTotalOutputValue = sumAllCompany != null ? sumAllCompany.getThisYearPlanTotalOutputValue() : new BigDecimal(0);
        BigDecimal thisYearCompleteTotalOutputValue = sumAllCompany != null ? sumAllCompany.getThisYearCompleteTotalOutputValue() : new BigDecimal(0);
        BigDecimal thisYearCompleteProjectOutputValue = sumAllCompany != null ? sumAllCompany.getThisYearCompleteProjectOutputValue() : new BigDecimal(0);
        BigDecimal thisYearCompletePcOutputValue = sumAllCompany != null ? sumAllCompany.getThisYearCompletePcOutputValue() : new BigDecimal(0);
        result.put("thisYearRevenueQuota", (Object)thisYearRevenueQuota);
        result.put("thisYearPlanTotalOutputValue", (Object)thisYearPlanTotalOutputValue);
        result.put("thisYearCompleteTotalOutputValue", (Object)thisYearCompleteTotalOutputValue);
        result.put("thisYearCompleteProjectOutputValue", (Object)thisYearCompleteProjectOutputValue);
        result.put("thisYearCompletePcOutputValue", (Object)thisYearCompletePcOutputValue);
        ProjectPcYearBusinessQuotaEntity planProjectAll = this.mapper.queryPlanSum(year, 0);
        BigDecimal projectYearPlanOutputValue = planProjectAll != null ? planProjectAll.getYearPlanOutputValue() : new BigDecimal(0);
        projectYearPlanOutputValue = CommonUtils.parseDivide4(projectYearPlanOutputValue, 4);
        result.put("projectYearPlanOutputValue", (Object)projectYearPlanOutputValue);
        ProjectPcYearBusinessQuotaEntity planPcAll = this.mapper.queryPlanSum(year, 1);
        BigDecimal pcYearPlanOutputValue = planPcAll != null ? planPcAll.getYearPlanOutputValue() : new BigDecimal(0);
        pcYearPlanOutputValue = CommonUtils.parseDivide4(pcYearPlanOutputValue, 4);
        result.put("pcYearPlanOutputValue", (Object)pcYearPlanOutputValue);
        CompanyUndertakeQuotaEntity companyUndertakeSum = this.mapper.queryCompanyUndertakeSum(year);
        BigDecimal contractQuota = companyUndertakeSum != null ? companyUndertakeSum.getContractQuota() : new BigDecimal(0);
        contractQuota = CommonUtils.parseDivide4(contractQuota, 4);
        result.put("contractQuota", (Object)contractQuota);
        Integer buildingProjectNum = this.mapper.queryProjectNum(year, "\u5728\u65bd");
        result.put("buildingProjectNum", (Object)buildingProjectNum);
        OutputValueReportEntity reportSum = this.mapper.queryReportSum(year, "\u5728\u65bd", null);
        BigDecimal contractAmount = reportSum != null ? reportSum.getContractAmount() : new BigDecimal(0);
        contractAmount = CommonUtils.parseDivide4(contractAmount, 4);
        result.put("contractAmount", (Object)contractAmount);
        BigDecimal thisYearAccumulateCompletedOutputValue = reportSum != null ? reportSum.getThisYearAccumulateCompletedOutputValue() : new BigDecimal(0);
        BigDecimal surplusOutputValue = reportSum != null ? reportSum.getSurplusOutputValue() : new BigDecimal(0);
        BigDecimal contractBalance = CommonUtils.subtractBigDecimal(surplusOutputValue, thisYearAccumulateCompletedOutputValue);
        contractBalance = CommonUtils.parseDivide4(contractBalance, 4);
        result.put("contractBalance", (Object)contractBalance);
        BigDecimal yearValueProportion = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, thisYearRevenueQuota, 2);
        result.put("yearValueProportion", (Object)yearValueProportion);
        OutputValueReportEntity nowYearReportSum = this.mapper.queryReportSum(year, null, "\u662f");
        BigDecimal nowYearContractAmount = nowYearReportSum != null ? nowYearReportSum.getContractAmount() : new BigDecimal(0);
        nowYearContractAmount = nowYearContractAmount.multiply(new BigDecimal(0.2));
        Integer lastYear = today.getYear() - 1;
        OutputValueReportEntity lastYearReportSum = this.mapper.queryReportSum(String.valueOf(lastYear), null, "\u662f");
        BigDecimal lastYearContractAmount = lastYearReportSum != null ? lastYearReportSum.getContractAmount() : new BigDecimal(0);
        lastYearContractAmount = lastYearContractAmount.multiply(new BigDecimal(0.5));
        Integer last2Year = today.getYear() - 2;
        OutputValueReportEntity last2YearReportSum = this.mapper.queryReportSum(String.valueOf(last2Year), null, "\u662f");
        BigDecimal last2nowYearContractAmount = last2YearReportSum != null ? last2YearReportSum.getContractAmount() : new BigDecimal(0);
        last2nowYearContractAmount = last2nowYearContractAmount.multiply(new BigDecimal(0.3));
        BigDecimal allContractAmount = nowYearContractAmount.add(lastYearContractAmount).add(last2nowYearContractAmount);
        allContractAmount = CommonUtils.parseDivide4(allContractAmount, 4);
        BigDecimal contractOutputValueCompletionRate = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, allContractAmount, 2);
        result.put("allContractAmount", (Object)allContractAmount);
        result.put("contractOutputValueCompletionRate", (Object)contractOutputValueCompletionRate);
        BigDecimal buildingBuiltArea = reportSum != null ? reportSum.getBuiltArea() : new BigDecimal(0);
        buildingBuiltArea = CommonUtils.parseDivide4(buildingBuiltArea, 4);
        result.put("buildingBuiltArea", (Object)buildingBuiltArea);
        OutputValueReportEntity buildingThisYearSum = this.mapper.queryReportSum(year, "\u5728\u65bd", "\u662f");
        BigDecimal yearStartBuiltArea = buildingThisYearSum != null ? buildingThisYearSum.getBuiltArea() : new BigDecimal(0);
        yearStartBuiltArea = CommonUtils.parseDivide4(yearStartBuiltArea, 4);
        result.put("yearStartBuiltArea", (Object)yearStartBuiltArea);
        OutputValueReportEntity finishReportSum = this.mapper.queryReportSum(year, "\u7ae3\u5de5\u672a\u7ed3", null);
        BigDecimal finishBuiltArea = finishReportSum != null ? finishReportSum.getBuiltArea() : new BigDecimal(0);
        finishBuiltArea = CommonUtils.parseDivide4(finishBuiltArea, 4);
        result.put("finishBuiltArea", (Object)finishBuiltArea);
        List<OutputValueReportEntity> outputValueTop10 = this.mapper.queryReportOutputValueTop10(year);
        result.put("outputValueTop10", outputValueTop10);
        ProjectSupplementEntity personNum = this.mapper.queryPersonNum(year);
        Integer managementPersonNum = personNum != null ? personNum.getManagementPersonNum() : 0;
        BigDecimal managementPerCapita = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, new BigDecimal(managementPersonNum), 6);
        managementPerCapita = managementPerCapita.multiply(new BigDecimal(10000));
        result.put("managementPerCapita", (Object)managementPerCapita);
        Integer laborPersonNum = personNum != null ? personNum.getLaborPersonNum() : 0;
        BigDecimal laborPerCapita = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, new BigDecimal(laborPersonNum).multiply(new BigDecimal(12)), 6);
        laborPerCapita = laborPerCapita.multiply(new BigDecimal(10000));
        result.put("laborPerCapita", (Object)laborPerCapita);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"year", (Object)year);
        List companyList = this.companyBusinessQuotaService.list((Wrapper)wrapper);
        HashMap companyMap = new HashMap();
        if (companyList != null && companyList.size() > 0) {
            companyList.forEach(item -> companyMap.put(item.getOrgId(), item));
        }
        QueryWrapper lastYearWrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"year", (Object)String.valueOf(lastYear));
        List lastYearCompanyList = this.companyBusinessQuotaService.list((Wrapper)lastYearWrapper);
        HashMap lastYearCompanyMap = new HashMap();
        if (lastYearCompanyList != null && lastYearCompanyList.size() > 0) {
            lastYearCompanyList.forEach(item -> lastYearCompanyMap.put(item.getOrgId(), item));
        }
        LinkedHashMap<Long, BigDecimal> planTotalMap = new LinkedHashMap<Long, BigDecimal>();
        LinkedHashMap<Long, BigDecimal> actualTotalMap = new LinkedHashMap<Long, BigDecimal>();
        LinkedHashMap<Long, BigDecimal> lastYearActualTotalMap = new LinkedHashMap<Long, BigDecimal>();
        LinkedList<String> orgNameList = new LinkedList<String>();
        CommonResponse defResrones = this.iDefdocApi.getDefDocByDefCode("zjkj_output_portal_org");
        for (DefdocDetailVO defdocDetailVO : (List)defResrones.getData()) {
            orgNameList.add(defdocDetailVO.getName());
            Long orgId = Long.valueOf(defdocDetailVO.getCode());
            if (companyMap != null && companyMap.size() > 0 && companyMap.get(orgId) != null) {
                planTotalMap.put(orgId, ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearPlanTotalOutputValue());
                actualTotalMap.put(orgId, ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearCompleteTotalOutputValue());
            } else {
                planTotalMap.put(orgId, new BigDecimal(0));
                actualTotalMap.put(orgId, new BigDecimal(0));
            }
            if (lastYearCompanyMap != null && lastYearCompanyMap.size() > 0 && lastYearCompanyMap.get(orgId) != null) {
                lastYearActualTotalMap.put(orgId, ((CompanyBusinessQuotaEntity)((Object)lastYearCompanyMap.get(orgId))).getThisYearCompleteTotalOutputValue());
                continue;
            }
            lastYearActualTotalMap.put(orgId, new BigDecimal(0));
        }
        JSONObject yearPlanActualCompare = new JSONObject();
        JSONArray yearPlanActualCompareArray = new JSONArray();
        JSONObject yearPlanCompare = new JSONObject();
        yearPlanCompare.put("name", (Object)"\u8ba1\u5212\u603b\u4ea7\u503c(\u4ebf\u5143)");
        yearPlanCompare.put("data", new ArrayList(planTotalMap.values()));
        yearPlanCompare.put("color", (Object)"#4688FA");
        yearPlanActualCompareArray.add((Object)yearPlanCompare);
        JSONObject yearActualCompare = new JSONObject();
        yearActualCompare = new JSONObject();
        yearActualCompare.put("name", (Object)"\u603b\u5b8c\u6210\u4ea7\u503c(\u4ebf\u5143)");
        yearActualCompare.put("data", new ArrayList(actualTotalMap.values()));
        yearActualCompare.put("color", (Object)"#FFA355");
        yearPlanActualCompareArray.add((Object)yearActualCompare);
        yearPlanActualCompare.put("ladyList", (Object)yearPlanActualCompareArray);
        yearPlanActualCompare.put("legendData", orgNameList);
        result.put("yearPlanActualCompare", (Object)yearPlanActualCompare);
        JSONObject yearAndLastYearActualCompare = new JSONObject();
        JSONArray yearAndLastYearActualCompareArray = new JSONArray();
        yearAndLastYearActualCompareArray.add((Object)yearActualCompare);
        JSONObject lastYearActualCompare = new JSONObject();
        lastYearActualCompare.put("name", (Object)"\u53bb\u5e74\u540c\u671f\u4ea7\u503c(\u4ebf\u5143)");
        lastYearActualCompare.put("data", new ArrayList(lastYearActualTotalMap.values()));
        lastYearActualCompare.put("color", (Object)"#4688FA");
        yearAndLastYearActualCompareArray.add((Object)lastYearActualCompare);
        yearAndLastYearActualCompare.put("ladyList", (Object)yearAndLastYearActualCompareArray);
        yearAndLastYearActualCompare.put("legendData", orgNameList);
        result.put("yearAndLastYearActualCompare", (Object)yearAndLastYearActualCompare);
        String month = String.valueOf(today.getMonthValue());
        if (month.length() == 1) {
            month = "0" + month;
        }
        month = month + "\u6708";
        JSONArray companyValueList = new JSONArray();
        for (DefdocDetailVO defdocDetailVO : (List)defResrones.getData()) {
            Long orgId = Long.valueOf(defdocDetailVO.getCode());
            JSONObject data = new JSONObject();
            data.put("orgName", (Object)defdocDetailVO.getName());
            data.put("year", (Object)year);
            data.put("month", (Object)month);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("twoOrgId", orgId);
            param.put("year", year);
            param.put("month", '\"' + month + '\"');
            ProjectMonthActualOutputValueVO projectData = this.projectMonthActualOutputValueMapper.selectSumData(param);
            BigDecimal projectMonth = projectData != null ? projectData.getThisMonthActualOutputValue() : new BigDecimal(0);
            PcMonthActualOutputValueVO pcData = this.pcMonthActualOutputValueMapper.selectSumData(param);
            BigDecimal pcMonth = pcData != null ? pcData.getThisMonthCompletedTotalOutputValue() : new BigDecimal(0);
            BigDecimal monthActualValue = projectMonth.add(pcMonth);
            HashMap<String, Object> param2 = new HashMap<String, Object>();
            param2.put("twoOrgId", orgId);
            param2.put("year", year);
            ProjectPcYearBusinessQuotaVO projectPcYearData = this.projectPcYearBusinessQuotaMapper.selectSumData(param2);
            BigDecimal monthPlanValue = this.getMonthValue(projectPcYearData, month);
            BigDecimal monthValueRate = ComputeUtil.bigDecimalPercent(monthActualValue, monthPlanValue, 2);
            data.put("monthPlanValue", (Object)monthPlanValue);
            data.put("monthActualValue", (Object)monthActualValue);
            data.put("monthValueRate", (Object)monthValueRate);
            BigDecimal yearTargetValue = new BigDecimal(0);
            BigDecimal yearPlanValue = new BigDecimal(0);
            BigDecimal yearActualValue = new BigDecimal(0);
            BigDecimal yearProjectPlanValue = new BigDecimal(0);
            BigDecimal yearPcPlanValue = new BigDecimal(0);
            BigDecimal yearUndertakePlanValue = new BigDecimal(0);
            if (companyMap != null && companyMap.size() > 0 && companyMap.get(orgId) != null) {
                yearTargetValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearRevenueQuota();
                yearPlanValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearPlanTotalOutputValue();
                yearActualValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearCompleteTotalOutputValue();
                yearProjectPlanValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearPlanBuildingOutputValue();
                yearPcPlanValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearPlanPcOutputValue();
                yearUndertakePlanValue = ((CompanyBusinessQuotaEntity)((Object)companyMap.get(orgId))).getThisYearPlanUndertakeOutputValue();
            }
            BigDecimal yearValueRate = ComputeUtil.bigDecimalPercent(yearActualValue, yearPlanValue, 2);
            BigDecimal yearTargetRate = ComputeUtil.bigDecimalPercent(yearActualValue, yearTargetValue, 2);
            data.put("yearTargetValue", (Object)yearTargetValue);
            data.put("yearPlanValue", (Object)yearPlanValue);
            data.put("yearActualValue", (Object)yearActualValue);
            data.put("yearValueRate", (Object)yearValueRate);
            data.put("yearTargetRate", (Object)yearTargetRate);
            data.put("yearProjectPlanValue", (Object)yearProjectPlanValue);
            data.put("yearPcPlanValue", (Object)yearPcPlanValue);
            data.put("yearUndertakePlanValue", (Object)yearUndertakePlanValue);
            data.put("yearInHandValueRate", (Object)yearValueRate);
            data.put("monthInHandValueRate", (Object)monthValueRate);
            companyValueList.add((Object)data);
        }
        result.put("companyValueList", (Object)companyValueList);
        return result;
    }

    private BigDecimal getMonthValue(ProjectPcYearBusinessQuotaVO projectPcYearData, String month) {
        BigDecimal monthPlanValue = null;
        switch (month) {
            case "1\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getJanuaryPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "2\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getFebruaryPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "3\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getMarchPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "4\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getAprilPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "5\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getMayPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "6\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getJunePlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "7\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getJulyPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "8\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getAugustPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "9\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getSeptemberPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "10\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getOctoberPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "11\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getNovemberPlanOutputValue() : new BigDecimal(0);
                break;
            }
            case "12\u6708": {
                monthPlanValue = projectPcYearData != null ? projectPcYearData.getDecemberPlanOutputValue() : new BigDecimal(0);
                break;
            }
        }
        return monthPlanValue;
    }
}

