package com.ejianc.business.fill.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周进度计划填报
 * 
 * @author generator
 * 
 */
public class WeekFillVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectControlLevel; // 项目管控级别(自定义档案)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillDate; // 填报日期
    private Long fillUserId; // 填报人主键
    private String fillUserName; // 填报人名称
    private Integer finishFlag; // 是否按时完成(≥0时按时完成，<0时延期多少天)
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Long sourceId; // 执行计划单据主键
    private String calendarUid; // 日历主键
    private String calendars; // 日历
    private Long corpId; // 区域公司
    private String corpCode; // 区域公司编码
    private String corpName; // 区域公司名称
    private String projectManagerName; // 项目经理名称
    private Long projectManagerId; // 项目经理主键
    private String planCode; // 计划编号
    private Long weekId; // 周计划主键
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBeginDate; // 计划开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划结束日期
    private Boolean importFlag; // 是否导入

    private List<WeekFillDetailVO> progressDetailList = new ArrayList<>();

    private List<WeekFillDetailVO> removedTasks = new ArrayList<>();

    private List<WeekFillDetailVO> tasks = new ArrayList<>();
    
    private List<WeekFillDetailVO> weekFillDetailList = new ArrayList<>(); // 周进度计划填报详情

    private Integer signDays; // 工期签证天数
    private Integer waitDays; // 待批工期签证
    private String imageShows; // 形象进度
    private String reason; // 原因分析
    private String measure; // 拟采取措施


    public Integer getSignDays() {
        return signDays;
    }

    public void setSignDays(Integer signDays) {
        this.signDays = signDays;
    }

    public Integer getWaitDays() {
        return waitDays;
    }

    public void setWaitDays(Integer waitDays) {
        this.waitDays = waitDays;
    }

    public String getImageShows() {
        return imageShows;
    }

    public void setImageShows(String imageShows) {
        this.imageShows = imageShows;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }
    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    public Date getFillDate() {
        return fillDate;
    }

    public void setFillDate(Date fillDate) {
        this.fillDate = fillDate;
    }

    public Long getFillUserId() {
        return fillUserId;
    }

    public void setFillUserId(Long fillUserId) {
        this.fillUserId = fillUserId;
    }

    public String getFillUserName() {
        return fillUserName;
    }

    public void setFillUserName(String fillUserName) {
        this.fillUserName = fillUserName;
    }

    public Integer getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getCalendarUid() {
        return calendarUid;
    }

    public void setCalendarUid(String calendarUid) {
        this.calendarUid = calendarUid;
    }

    public String getCalendars() {
        return calendars;
    }

    public void setCalendars(String calendars) {
        this.calendars = calendars;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    @ReferSerialTransfer(referCode="week-plan")
    public Long getWeekId() {
        return weekId;
    }
    @ReferDeserialTransfer
    public void setWeekId(Long weekId) {
        this.weekId = weekId;
    }

    public List<WeekFillDetailVO> getWeekFillDetailList() {
        return weekFillDetailList;
     }

     public void setWeekFillDetailList(List<WeekFillDetailVO> weekFillDetailList) {
        this.weekFillDetailList = weekFillDetailList;
     }

    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public List<WeekFillDetailVO> getProgressDetailList() {
        return progressDetailList;
    }

    public void setProgressDetailList(List<WeekFillDetailVO> progressDetailList) {
        this.progressDetailList = progressDetailList;
    }

    public List<WeekFillDetailVO> getRemovedTasks() {
        return removedTasks;
    }

    public void setRemovedTasks(List<WeekFillDetailVO> removedTasks) {
        this.removedTasks = removedTasks;
    }

    public List<WeekFillDetailVO> getTasks() {
        return tasks;
    }

    public void setTasks(List<WeekFillDetailVO> tasks) {
        this.tasks = tasks;
    }
}
