/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.utils;

import java.math.BigDecimal;

public class MathUtil {
    public static int precision = 18;
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    public static final Integer INTZERO = new Integer(0);

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        }
        return decimal1.divide(decimal2, precision, 6);
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.add(decimal2);
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.multiply(decimal2).setScale(precision, 6);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.subtract(decimal2);
    }

    public static int safeCompareTo(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.compareTo(decimal2);
    }

    public static boolean ge(Integer num1, Integer num2) {
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1 >= num2;
    }

    public static boolean lt(Integer num1, Integer num2) {
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1 < num2;
    }

    public static boolean ge(BigDecimal num1, Integer num2) {
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1.compareTo(new BigDecimal(num2)) >= 0;
    }

    public static boolean lt(BigDecimal num1, Integer num2) {
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1.compareTo(new BigDecimal(num2)) < 0;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? src : src.setScale(2, 6);
    }

    public static BigDecimal safeAdd(BigDecimal ... decimal) {
        BigDecimal res = BigDecimal.ZERO;
        for (BigDecimal dec : decimal) {
            res = MathUtil.safeAdd(res, dec);
        }
        return res;
    }
}

