package com.ejianc.business.progress.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 推送设置实体
 * 
 * @author generator
 * 
 */
public class PushSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 所属组织
    private String orgName; // 组织名称
    private String orgInnerCode; // 组织内码
    private Long industryTypeId; // 行业类型主键
    private String industryTypeName; // 行业类型名称
    private String fillType; // 推送周期 1-每天 2-每周 3-每月
    private String fillTime; // 推送日期
    private String description; // 推送备注
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private String createUserName; // 创建人名称
    private Long projectControl; // 项目管控级别
    private String projectControlName; // 项目管控级别名称
    
    private List<PushSetLevelVO> levelList = new ArrayList<>(); // 推送设置层级实体

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织内码
     */
    public String getOrgInnerCode() {
        return orgInnerCode;
    }

    /**
     * 组织内码
     */
    public void setOrgInnerCode(String orgInnerCode) {
        this.orgInnerCode = orgInnerCode;
    }
    /**
     * 行业类型主键
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getIndustryTypeId() {
        return industryTypeId;
    }

    /**
     * 行业类型主键
     */
    @ReferDeserialTransfer
    public void setIndustryTypeId(Long industryTypeId) {
        this.industryTypeId = industryTypeId;
    }
    /**
     * 行业类型名称
     */
    public String getIndustryTypeName() {
        return industryTypeName;
    }

    /**
     * 行业类型名称
     */
    public void setIndustryTypeName(String industryTypeName) {
        this.industryTypeName = industryTypeName;
    }
    /**
     * 推送周期 1-每天 2-每周 3-每月
     */
    public String getFillType() {
        return fillType;
    }

    /**
     * 推送周期 1-每天 2-每周 3-每月
     */
    public void setFillType(String fillType) {
        this.fillType = fillType;
    }
    /**
     * 推送日期
     */
    public String getFillTime() {
        return fillTime;
    }

    /**
     * 推送日期
     */
    public void setFillTime(String fillTime) {
        this.fillTime = fillTime;
    }
    /**
     * 推送备注
     */
    public String getDescription() {
        return description;
    }

    /**
     * 推送备注
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    
     /**
      * 推送设置层级实体
      */
     public List<PushSetLevelVO> getLevelList() {
        return levelList;
     }

     /**
      * 推送设置层级实体
      */
     public void setLevelList(List<PushSetLevelVO> levelList) {
        this.levelList = levelList;
     }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectControl() {
        return projectControl;
    }
    @ReferDeserialTransfer
    public void setProjectControl(Long projectControl) {
        this.projectControl = projectControl;
    }

    public String getProjectControlName() {
        return projectControlName;
    }

    public void setProjectControlName(String projectControlName) {
        this.projectControlName = projectControlName;
    }
}
