package com.ejianc.business.probuilddiary.ledger.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 日志台账-进度情况（施工员）
 *
 * @author baipengyan
 */
public class LedgerScheduleVO extends BaseVO {
	private static final long serialVersionUID = 7827422664413537406L;

	private Long personId; // 个人日志id
	private String scheduleMemo; // 工作描述
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private Long projectLogId; // 项目日志id
	private Long ledgerId; // 日志台账id
	private String templateContent; // 模版内容，#分隔开的字段名称，例如：commitUserName#commitDate#workMemo，输出：张三 16：00 完成1号楼基础部分基坑支护
	private String fileType; // 文件类型
	private String logNumber; // 日志项编码
	private Boolean projectManagerFlag; // 项目经理标识

	private Long scheduleId; // 任务主键
	private String scheduleName; // 工序/工作/作业名称
	private String scheduleCode; // 结构码
	private BigDecimal diffValue; // 完成情况
	private String diffResson; // 滞后原因
	private String riskSetp; // 措施
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date predictFinish; // 预计完成日期


	public Long getScheduleId() {
		return scheduleId;
	}

	public void setScheduleId(Long scheduleId) {
		this.scheduleId = scheduleId;
	}

	public String getScheduleName() {
		return scheduleName;
	}

	public void setScheduleName(String scheduleName) {
		this.scheduleName = scheduleName;
	}

	public String getScheduleCode() {
		return scheduleCode;
	}

	public void setScheduleCode(String scheduleCode) {
		this.scheduleCode = scheduleCode;
	}

	public BigDecimal getDiffValue() {
		return diffValue;
	}

	public void setDiffValue(BigDecimal diffValue) {
		this.diffValue = diffValue;
	}

	public String getDiffResson() {
		return diffResson;
	}

	public void setDiffResson(String diffResson) {
		this.diffResson = diffResson;
	}

	public String getRiskSetp() {
		return riskSetp;
	}

	public void setRiskSetp(String riskSetp) {
		this.riskSetp = riskSetp;
	}

	public Date getPredictFinish() {
		return predictFinish;
	}

	public void setPredictFinish(Date predictFinish) {
		this.predictFinish = predictFinish;
	}

	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public String getScheduleMemo() {
		return scheduleMemo;
	}

	public void setScheduleMemo(String scheduleMemo) {
		this.scheduleMemo = scheduleMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public Long getLedgerId() {
		return ledgerId;
	}

	public void setLedgerId(Long ledgerId) {
		this.ledgerId = ledgerId;
	}

	public String getTemplateContent() {
		return templateContent;
	}

	public void setTemplateContent(String templateContent) {
		this.templateContent = templateContent;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}
}
