package com.ejianc.business.probuilddiary.ledger.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 日志台账-施工内容（施工员）
 *
 * @author baipengyan
 */
public class LedgerDetailVO extends BaseVO {
	private static final long serialVersionUID = 7617568946079455436L;

	private Long personId; // 个人日志id
	private Long constructId; // 任务主键
	private String constructName; // 工序/工作/作业名称
	private String constructCode; // 结构码
	private String teamName; // 主要分包商或作业队
	private Integer workNum; // 工作人数
	private String workMemo; // 工作描述
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private Long projectLogId; // 项目日志id
	private Long ledgerId; // 日志台账id
	private String templateContent; // 模版内容，#分隔开的字段名称，例如：commitUserName#commitDate#workMemo，输出：张三 16：00 完成1号楼基础部分基坑支护
	private String fileType; // 文件类型
	private String logNumber; // 日志项编码
	private Boolean projectManagerFlag; // 项目经理标识
	private String dutyId; // 责任人id
	private String dutyName; // 责任人名称
	private String dutyCode; // 责任人编码

	private Long planId; // 进度计划主键
	private String planCode; // 进度计划编号


	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

	public String getPlanCode() {
		return planCode;
	}

	public void setPlanCode(String planCode) {
		this.planCode = planCode;
	}

	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public Long getConstructId() {
		return constructId;
	}

	public void setConstructId(Long constructId) {
		this.constructId = constructId;
	}

	public String getConstructName() {
		return constructName;
	}

	public void setConstructName(String constructName) {
		this.constructName = constructName;
	}

	public String getConstructCode() {
		return constructCode;
	}

	public void setConstructCode(String constructCode) {
		this.constructCode = constructCode;
	}

	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public Integer getWorkNum() {
		return workNum;
	}

	public void setWorkNum(Integer workNum) {
		this.workNum = workNum;
	}

	public String getWorkMemo() {
		return workMemo;
	}

	public void setWorkMemo(String workMemo) {
		this.workMemo = workMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public Long getLedgerId() {
		return ledgerId;
	}

	public void setLedgerId(Long ledgerId) {
		this.ledgerId = ledgerId;
	}

	public String getTemplateContent() {
		return templateContent;
	}

	public void setTemplateContent(String templateContent) {
		this.templateContent = templateContent;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}

	public String getDutyId() {
		return dutyId;
	}

	public void setDutyId(String dutyId) {
		this.dutyId = dutyId;
	}

	public String getDutyName() {
		return dutyName;
	}

	public void setDutyName(String dutyName) {
		this.dutyName = dutyName;
	}

	public String getDutyCode() {
		return dutyCode;
	}

	public void setDutyCode(String dutyCode) {
		this.dutyCode = dutyCode;
	}
}
