package com.ejianc.business.bim.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.mapper.BimMapper;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.util.ParamUtil;
import com.ejianc.business.bim.util.ZipCompress;
import com.ejianc.business.bim.vo.*;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * BIM模型
 * 
 * @author generator
 * 
 */
@Service("bimService")
public class BimServiceImpl extends BaseServiceImpl<BimMapper, BimEntity> implements IBimService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZJKJ_BIM_CODE";//此处需要根据实际修改

    private final static Base64.Encoder encoder = Base64.getEncoder();

    private final static Base64.Decoder decoder = Base64.getDecoder();

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IBimDetailService detailService;

    @Autowired
    private IExecPlanService execService;

    @Autowired
    private IExecPlanDetailService execDetailService;

    @Autowired
    private IBimDetailExecService bimExecService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    private final static String PROJECT_TYPE_PARAM = "P-l00WYH0188";
    private final static String LONG_PROJECT_VALUE_PARAM = "P-g2Jo4i0190";
    private final static String SHORT_PROJECT_VALUE_PARAM = "P-92i8590189";

    @Override
    public BimVO saveOrUpdate(BimVO saveOrUpdateVO) {
        LambdaQueryWrapper<BimEntity> ew = new LambdaQueryWrapper<>();
        ew.eq(BimEntity::getDr, 0);
        ew.eq(BimEntity::getProjectId, saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), BimEntity::getId, saveOrUpdateVO.getId());
        List<BimEntity> list = super.list(ew);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目已存在BIM模型");
        }
        BimEntity entity = BeanMapper.map(saveOrUpdateVO, BimEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
//            Long tenantId = InvocationInfoProxy.getTenantid();
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String date = sdf.format(new Date());
            entity.setBillCode("MX" + date);
        } else {
            // 同步删除大象云模型列表
            List<Long> detailIds = entity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && x.getId() != null).
                    map(BimDetailEntity::getId).collect(Collectors.toList());
            BimEntity data = super.selectById(saveOrUpdateVO.getId());
//            List<String> delPaths = data.getDetailList().stream().filter(x->!detailIds.contains(x.getId())).
//                    map(BimDetailEntity::getPath).collect(Collectors.toList());
//            for(String path : delPaths){
//                TokenHelper.delFile(path);
//            }
            List<String> delPaths = data.getDetailList().stream().filter(x->!detailIds.contains(x.getId())
                    && StringUtils.isNotEmpty(x.getModleId())).map(BimDetailEntity::getModleId).collect(Collectors.toList());
            TokenHelper.delFileBatch(delPaths.toArray(new String[0]));
            // 同步删除bim关联关系
            List<Long> delIds = data.getDetailList().stream().filter(x->!detailIds.contains(x.getId())).
                    map(BimDetailEntity::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(delIds)){
                QueryWrapper<BimDetailExecEntity> wrapper = new QueryWrapper<>();
                wrapper.in("bim_detail_id", delIds);
                bimExecService.remove(wrapper);
            }
        }
        OrgVO orgVO = orgUtil.findById(entity.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        entity.setState(0);
        for(BimDetailEntity detail : entity.getDetailList()){
            if(!"del".equals(detail.getRowState()) && (detail.getModle() != null && detail.getModle() == 1)
                    && (detail.getState() != null && detail.getState() == 1)){
                entity.setState(1);
            }
        }
        // 旧主模型
        BimDetailEntity oldModel = null;
        if(entity.getId() != null){
            BimEntity data = super.selectById(entity.getId());
            oldModel = data.getDetailList().stream().filter(x->x.getModle() == 1).findAny().orElse(null);
        }

        super.saveOrUpdate(entity, false);

        // 同步旧模型关联关系
        this.syncBimExecList(entity, oldModel);

        // 同步大象云文件列表
        List<String> modelIds = entity.getDetailList().stream().map(BimDetailEntity::getModleId).filter(Objects::nonNull).collect(Collectors.toList());
        this.syncDxyModelList(entity.getProjectId(), modelIds);

        BimVO vo = BeanMapper.map(entity, BimVO.class);
        for(BimDetailVO detail : vo.getDetailList()){
            if(detail.getModleId() != null){
                detail.setViewerToken(this.getViewerToken(detail.getModleId(), detail.getPath()));
            }
        }
        return vo;
    }

    /**
     * 未关联新主模型自动同步旧主模型关联关系
     * 只处理这几种继承：rvt(同名)->rvt，rvt->asm,asm->asm
     * @param entity
     * @param oldModel
     */
    private void syncBimExecList(BimEntity entity, BimDetailEntity oldModel) {
        BimDetailEntity newModel = entity.getDetailList().stream().filter(x->x.getModle() == 1).findAny().orElse(null);
        if(oldModel == null || newModel == null || oldModel.getId().equals(newModel.getId()) || newModel.getState() != 0) {
            return;
        }
        // rvt文件不继承asm文件
        if(oldModel.getFormat().equals("asm") && !newModel.getFormat().equals("asm")){
            return;
        }
        List<String> pathList = new ArrayList<>();
        // 同为rvt文件，但是名称没有继承关系也不继承
        if(!oldModel.getFormat().equals("asm") && !newModel.getFormat().equals("asm")){
            String str1 = oldModel.getName().split("\\s+")[0];
            String str2 = newModel.getName().split("\\s+")[0];
            if(!str1.equals(str2)){
                return;
            }
            pathList.add(oldModel.getPath());
        }
        // asm文件组件数组
        JSONArray paths = new JSONArray();
        JSONArray oldPaths = new JSONArray();
//        // 新模型asm文件的GUID对应序号
//        Map<String, Integer> index = new HashMap<>();
        if(newModel.getFormat().equals("asm")){
            JSONObject json = TokenHelper.getFile(newModel.getModleId(), newModel.getPath());
            paths = json.getJSONArray("refs");
//            index = this.getAsmItemMap(paths);
            if(oldModel.getFormat().equals("asm")){
                JSONObject oldJson = TokenHelper.getFile(oldModel.getModleId(), oldModel.getPath());
                oldPaths = oldJson.getJSONArray("refs");
            }
            pathList.addAll(paths.stream().map(x->((JSONObject)x).getString("ref")).collect(Collectors.toList()));
        }
        if(CollectionUtils.isEmpty(pathList)){
            return;
        }
        QueryParam param = new QueryParam();
//        param.getParams().put("bim_detail_id", new Parameter(QueryParam.EQ, oldModel.getId()));
        ComplexParam c4 = ParamUtil.getOrParam("bim_detail_id", new Parameter(QueryParam.EQ, oldModel.getId()), "path", new Parameter(QueryParam.IN, pathList));
        param.getComplexParams().add(c4);
        List<BimDetailExecEntity> oldList = bimExecService.queryList(param);
        // 上次模型数据优先，去重
        Map<Long, BimDetailExecEntity> oldMap = oldList.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, x -> x, (v1, v2) -> {
            if(v1.getPath().equals(oldModel.getPath())){
                return v1;
            }
            return v2;
        }));
//        // 获取rvt文件在asm构件数组中的下标
//        Integer index = this.getRvtIndex(oldModel, paths);
        if(MapUtil.isNotEmpty(oldMap)) {
            for(BimDetailExecEntity old : oldMap.values()){
                // 处理rvt->asm文件，继承所有构件的关联关系
                if(!newModel.getFormat().equals(oldModel.getFormat())){
//                    this.replaceRvtGuid(index, old);
//                    this.replaceRvtGuid(index, old, newModel.getFormat());
                    this.replaceRvtGuid(paths, old);
                }
                // 同为asm文件，序号替换成新的序号
                if(CollectionUtils.isNotEmpty(oldPaths)) {
                    this.replaceAsmGuid(paths, oldPaths, old);
                }
                old.setId(null);
                old.setVersion(null);
                old.setBimDetailId(newModel.getId());
                old.setName(newModel.getName());
                old.setPath(newModel.getPath());
                old.setCreateUserCode(null);
                old.setCreateTime(null);
                old.setUpdateUserCode(null);
                old.setUpdateTime(null);
            }
            bimExecService.saveOrUpdateBatch(oldMap.values());
            // 设置已关联
            newModel.setState(1);
            detailService.saveOrUpdate(newModel);
            entity.setState(1);
            super.saveOrUpdate(entity);
        }
    }

//    /**
//     * 获取asm文件GUID对应序号
//     * @param paths
//     * @return
//     */
//    private Map<String, Integer> getAsmItemMap(JSONArray paths) {
//        Map<String, Integer> items = new HashMap<>();
//        // 多线程查询asm文件
//        List<String> asmPath = paths.stream().map(x->((JSONObject)x).getString("ref")).collect(Collectors.toList());
//        Map<String, JSONObject> itemMap = this.getItemJSONMap(asmPath);
//        for(int i=0; i < paths.size(); i++){
//            String path = paths.getJSONObject(i).getString("ref");
//            String name = paths.getJSONObject(i).getString("name");
//            if(!itemMap.containsKey(path)){
//                continue;
//            }
//            JSONObject json = itemMap.get(path);
//            name = name.split("\\s+")[0];
//            String root = encoder.encodeToString((name + " Root " + i).getBytes());
//            items.put(root, i);
//            if(json.containsKey("Children")){
//                for(Object o : json.getJSONArray("Children")){
//                    this.getItemIndexMap(JSONObject.parseObject(o.toString()), items, i);
//                }
//            }
//        }
//        return items;
//    }
//
//
//    /**
//     * 获取asm文件GUID对应序号
//     * @param json
//     * @param items
//     * @param index
//     */
//    private static void getItemIndexMap(JSONObject json, Map<String, Integer> items, Integer index) {
//        if(StringUtils.isNotEmpty(json.getString("Guid"))){
//            String Guid = json.getString("Guid");
//            items.put(Guid, index);
//        }
//        if(json.containsKey("Children")){
//            for(Object o : json.getJSONArray("Children")){
//                getItemIndexMap(JSONObject.parseObject(o.toString()), items, index);
//            }
//        }
//    }

//    /**
//     * 获取rvt文件在asm构件数组中的下标
//     * @param oldModel
//     * @param paths
//     * @return
//     */
//    private Integer getRvtIndex(BimDetailEntity oldModel, JSONArray paths) {
//        Integer index = null;
//        for(int i=0; i< paths.size(); i++){
//            String path = paths.getJSONObject(i).getString("ref");
//            String name = paths.getJSONObject(i).getString("name");
//            if(path.equals(oldModel.getPath())){
//                index = i;
//            } else {// 不同模型使用名称匹配
//                String str1 = name.split("\\s+")[0];
//                String str2 = oldModel.getName().split("\\s+")[0];
//                if(str1.equals(str2)){
//                    index = i;
//                }
//            }
//        }
//        return index;
//    }

//    /**
//     * 处理不同类型模型文件继承下，构件id特殊处理
//     * @param index
//     * @param old
//     */
//    private void replaceRvtGuid(Integer index, BimDetailExecEntity old) {
//        String[] oldIds = old.getBimIds().split(",");
//        List<String> bimIds = new ArrayList<>();
//        for(String id : oldIds){
//            id = new String(decoder.decode(id));// 解码
//            if(index != null){
//                id = !id.contains(".") ? index + "." + id : id;// asm继承rvt，加上序号
//            } else {
//                id = id.contains(".") ? id.split("\\.")[1] : id;// rvt继承asm，去除序号
//            }
//            id = encoder.encodeToString(id.getBytes());// 编码
//            bimIds.add(id);
//        }
//        old.setBimIds(StringUtils.join(bimIds, ","));
//    }

//    /**
//     * 处理不同类型模型文件继承下，构件id特殊处理
//     * @param index
//     * @param old
//     */
//    private void replaceRvtGuid(Map<String, Integer> index, BimDetailExecEntity old, String format) {
//        String[] oldIds = old.getBimIds().split(",");
//        List<String> bimIds = new ArrayList<>();
//        for(String id : oldIds){
//            id = new String(decoder.decode(id));// 解码
//            id = id.contains(".") ? id.split("\\.")[1] : id;// rvt继承asm，去除序号
//            if(format.equals("asm") && index.containsKey(id)){
//                id = index.get(id) + "." + id;// asm继承rvt，加上序号
//            }
//            id = encoder.encodeToString(id.getBytes());// 编码
//            bimIds.add(id);
//        }
//        old.setBimIds(StringUtils.join(bimIds, ","));
//    }

    /**
     * 处理rvt->asm文件，继承所有构件的关联关系
     * @param paths
     * @param old
     */
    private void replaceRvtGuid(JSONArray paths, BimDetailExecEntity old) {
        String[] oldIds = old.getBimIds().split(",");
        Map<String, String> bimIds = Arrays.asList(oldIds).stream().collect(Collectors.toMap(x->x, x->x, (v1, v2)->v1));
        for(int i=0; i < paths.size(); i++){
            String path = paths.getJSONObject(i).getString("ref");
            if(!old.getPath().equals(path)){
                continue;
            }
            String name = paths.getJSONObject(i).getString("name");
            for(String bimId : bimIds.keySet()){
                String id = new String(decoder.decode(bimId));// 解码
                // asm文件组件id特殊处理
                if(id.contains("Root")){
                    id = name + " Root " + i;
                } else {
                    id = i + "." + id;
                }
                id = encoder.encodeToString(id.getBytes());// 编码
                bimIds.put(bimId, id);
            }
        }
        old.setBimIds(StringUtils.join(bimIds.values(), ","));
    }

//    /**
//     * 同为asm文件，序号替换成新的序号
//     * @param paths
//     * @param oldPaths
//     * @param old
//     */
//    private void replaceAsmGuid(JSONArray paths, JSONArray oldPaths, BimDetailExecEntity old) {
//        String[] oldIds = old.getBimIds().split(",");
//        Map<String, String> bimIds = Arrays.asList(oldIds).stream().collect(Collectors.toMap(x->x, x->x, (v1, v2)->v1));
//        for(int i=0; i < paths.size(); i++){
//            String path = paths.getJSONObject(i).getString("ref");
//            String name = paths.getJSONObject(i).getString("name");
//            Integer j = null;
//            for(int k=0; k < oldPaths.size(); k++){
//                String kpath = oldPaths.getJSONObject(k).getString("ref");
//                String kname = oldPaths.getJSONObject(k).getString("name");
//                if(kpath.equals(path)){
//                    j = k;
//                } else {// 不同模型使用名称匹配
//                    String str1 = name.split("\\s+")[0];
//                    String str2 = kname.split("\\s+")[0];
//                    if(str1.equals(str2)){
//                        j = k;
//                    }
//                }
//            }
//            if(j == null){// 没有匹配到
//                continue;
//            }
//            for(String bimId : bimIds.keySet()){
//                String id = new String(decoder.decode(bimId));// 解码
//                if(id.startsWith(j + ".")){
//                    id = i + "." + id.split("\\.")[1];
//                    id = encoder.encodeToString(id.getBytes());// 编码
//                    bimIds.put(bimId, id);
//                }
//                // asm文件组件id特殊处理
//                if(id.endsWith("Root " + j)){
////                    id = id.replace("Root " + j, "Root " + i);
//                    id = name + " Root " + i;
//                    id = encoder.encodeToString(id.getBytes());// 编码
//                    bimIds.put(bimId, id);
//                }
//            }
//        }
//        old.setBimIds(StringUtils.join(bimIds.values(), ","));
//    }

    /**
     * 同为asm文件，序号替换成新的序号
     * @param paths
     * @param oldPaths
     * @param old
     */
    private void replaceAsmGuid(JSONArray paths, JSONArray oldPaths, BimDetailExecEntity old) {
        String[] oldIds = old.getBimIds().split(",");
        Map<String, String> bimIds = Arrays.asList(oldIds).stream().collect(Collectors.toMap(x->x, x->x, (v1, v2)->v1));
        for(int i=0; i < paths.size(); i++){
            String path = paths.getJSONObject(i).getString("ref");
            String name = paths.getJSONObject(i).getString("name");
            Integer j = null;
            for(int k=0; k < oldPaths.size(); k++){
                String kpath = oldPaths.getJSONObject(k).getString("ref");
                String kname = oldPaths.getJSONObject(k).getString("name");
                if(kpath.equals(path)){
                    j = k;
                } else {// 不同模型使用名称匹配
                    String str1 = name.split("\\s+")[0];
                    String str2 = kname.split("\\s+")[0];
                    if(str1.equals(str2)){
                        j = k;
                    }
                }
            }
            for(String bimId : bimIds.keySet()){
                String id = new String(decoder.decode(bimId));// 解码
                if(j != null && id.startsWith(j + ".")){
                    id = i + "." + id.split("\\.")[1];
                    id = encoder.encodeToString(id.getBytes());// 编码
                    bimIds.put(bimId, id);
                }
                // asm文件组件id特殊处理
                if(j != null && id.endsWith("Root " + j)){
                    id = name + " Root " + i;
                    id = encoder.encodeToString(id.getBytes());// 编码
                    bimIds.put(bimId, id);
                }
                // 新增rvt文件的关联关系加上序号
                if(j == null && !id.contains(".")){
                    id = i + "." + id;
                    id = encoder.encodeToString(id.getBytes());// 编码
                    bimIds.put(bimId, id);
                }
            }
        }
        old.setBimIds(StringUtils.join(bimIds.values(), ","));
    }

    @Override
    public BimVO syncDetail(Long id) {
        BimEntity entity = super.selectById(id);
        List<BimDetailEntity> detailList = entity.getDetailList();
        List<BimDetailEntity> saveList = new ArrayList<>();
        for(BimDetailEntity detail : detailList){
            if(detail.getStatus() == 1){
                continue;
            }
            JSONObject fileStatus = TokenHelper.getFileStatus(detail.getPath());
            if(fileStatus != null && "Ready".equals(fileStatus.getString("status"))){
                detail.setStatus(1);
                saveList.add(detail);
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            detailService.updateBatchById(saveList);
        }
//        // 同步大象云文件列表
//        List<String> modelIds = entity.getDetailList().stream().map(BimDetailEntity::getModleId).filter(Objects::nonNull).collect(Collectors.toList());
//        this.syncDxyModelList(entity.getProjectId(), modelIds);
        BimVO vo = BeanMapper.map(entity, BimVO.class);
        for(BimDetailVO detail : vo.getDetailList()){
            if(detail.getModleId() != null){
                detail.setViewerToken(this.getViewerToken(detail.getModleId(), detail.getPath()));
            }
        }
        return vo;
    }

    /**
     * 同步大象云文件列表
     * @param projectId
     * @param modelIds
     */
    private void syncDxyModelList(Long projectId, List<String> modelIds) {
        String parentId = "";
        if(String.valueOf(projectId).length() > 15){
            parentId = ("" + projectId + projectId).substring(0, 32);
        } else {
            return;
        }
        JSONObject json = TokenHelper.getFileList(parentId);
        JSONArray array = json.getJSONArray("model_list");
        List<String> fileIds = array.stream().map(x->((JSONObject) x).getString("id")).collect(Collectors.toList());
        fileIds.removeAll(modelIds);
        if(CollectionUtils.isNotEmpty(fileIds)){
            for(String fileId : fileIds){
                TokenHelper.delFileBatch(new String[]{fileId});
            }
            logger.info("同步删除大象云未保存模型文件：{}", JSONObject.toJSONString(fileIds));
        }
    }

//    @Override
//    public Boolean syncState(Long projectId) {
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        BimEntity bim = super.queryList(queryParam).stream().findAny().orElse(null);
//        ExecPlanEntity exec = execService.queryList(queryParam).stream().findAny().orElse(null);
//        if(bim == null || exec == null) {
//            return true;
//        }
//        Boolean oldFlag = new Integer(1).equals(bim.getState()) ? true : false;
//        List<BimDetailEntity> detailList = detailService.list(new QueryWrapper<BimDetailEntity>().eq("bim_id", bim.getId()));
//        List<ExecPlanDetailEntity> execDetailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>().eq("progress_id", exec.getId()));
//        List<String> bimDetailIds = execDetailList.stream().map(x->x.getBimDetailIds()).filter(x->StringUtils.isNotEmpty(x)).
//                flatMap(x->Stream.of(x.split(","))).collect(Collectors.toList());
//        List<BimDetailEntity> saveList = new ArrayList<>();
//        boolean flag = false;
//        for(BimDetailEntity detail : detailList){
//            if(bimDetailIds.contains(String.valueOf(detail.getId()))){
//                if(!new Integer(1).equals(detail.getState())){
//                    detail.setState(1);
//                    saveList.add(detail);
//                }
//            } else {
//                if(new Integer(1).equals(detail.getState())){
//                    detail.setState(0);
//                    saveList.add(detail);
//                }
//            }
//            if(new Integer(1).equals(detail.getState())){
//                flag = true;
//            }
//        }
//        if(CollectionUtils.isNotEmpty(saveList)){
//            detailService.updateBatchById(saveList);
//        }
//        if(oldFlag != flag){
//            bim.setState(flag ? 1 : 0);
//            super.saveOrUpdate(bim);
//        }
//        return true;
//    }

    @Override
    public JSONObject getHiddenItems(BimQureyVO queryVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, queryVO.getProjectId()));
        // 查询bim模型关联主模型路径
        BimEntity entity = super.queryList(queryParam).stream().findAny().orElse(null);
        if(entity == null){
            throw new BusinessException("未查询到该项目下BIM模型！");
        }
        entity = super.selectById(entity.getId());
        // 主模型
        BimDetailEntity model = entity.getDetailList().stream().filter(x->x.getModle() != null && x.getModle() == 1).findAny().orElse(new BimDetailEntity());
        // asm文件组件数组
        JSONArray array = new JSONArray();
        if(StringUtils.isNotEmpty(model.getFormat()) && model.getFormat().equals("asm")){
            JSONObject json = TokenHelper.getFile(model.getModleId(), model.getPath());
            array = json.getJSONArray("refs");
        }
        if(CollectionUtils.isEmpty(queryVO.getAsmPaths())){
            if(StringUtils.isNotEmpty(model.getFormat()) && model.getFormat().equals("asm")){
                queryVO.setAsmPaths(array.stream().map(x->((JSONObject)x).getString("ref")).collect(Collectors.toList()));
            } else {
                queryVO.setAsmPaths(new ArrayList<>(Arrays.asList(model.getPath())));
            }
        }
        if(CollectionUtils.isEmpty(queryVO.getAsmPaths()) || model.getId() == null){
            throw new BusinessException("未查询到BIM下主模型路径！");
        }
        // 图元ID与已关联执行计划任务进行匹配
        ExecPlanEntity exec = execService.queryList(queryParam).stream().findAny().orElse(null);
        if(exec == null){
            throw new BusinessException("未查询到该项目下的执行计划！");
        }
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", exec.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execDetailService.list(ew);

        QueryParam param = new QueryParam();
        param.getParams().put("bim_detail_id", new Parameter(QueryParam.EQ, model.getId()));
        List<BimDetailExecEntity> execList = bimExecService.queryList(param);
        Map<Long, List<BimDetailExecEntity>> execMap = execList.stream().collect(Collectors.groupingBy(BimDetailExecEntity::getExecDetailId));
        // 根据路径查询图元ID
//        List<String> items = new ArrayList<>();
        Map<String, String> items = new HashMap<>();
        List<ItemVO> parents = new ArrayList<>();
        // rvt文件
        if(queryVO.getAsmPaths().size() == 1){
            JSONObject json = TokenHelper.getFileTree(queryVO.getAsmPaths().get(0));
            ItemVO parent = this.getItems(json, items, null);
            parents.add(parent);
        }
        // asm文件
        if(queryVO.getAsmPaths().size() > 1){
            Map<String, String> pathNameMap = entity.getDetailList().stream().collect(Collectors.toMap(x->x.getPath(), x->x.getName()));
            // 多线程查询asm文件
            Map<String, JSONObject> itemMap = this.getItemJSONMap(queryVO.getAsmPaths());
            for(int i=0; i < array.size(); i++){
                String path = array.getJSONObject(i).getString("ref");
                if(!itemMap.containsKey(path)){
                    continue;
                }
                JSONObject json = itemMap.get(path);
                ItemVO parent = this.getItems(json, items, i);
//                parents.add(parent);
                // asm文件装配文件的uid需要重新组装
                if(pathNameMap.containsKey(json.getString("Path"))){
                    String root = pathNameMap.get(json.getString("Path")) + " " + json.getString("Guid") + " " + i;
                    root = encoder.encodeToString(root.getBytes());
                    // 替换
                    items.remove(parent.getUid());
                    items.put(root, root);
                    parent.setUid(root);
                    List<ItemVO> children = parent.getChildren();
                    for(ItemVO child : children){
                        child.setParentId(root);
                    }
                    parent.setChildren(children);
                }
                parents.add(parent);
            }
        }
        // 获取未开始将逾期时间阈值
        Integer value = this.getParamValue(exec.getPlanBeginDate(), exec.getPlanEndDate());

        // 获取颜色数组
        JSONObject colors = this.getColors();
        JSONArray hiddenItems = new JSONArray();// 隐藏图元
        JSONArray acturalItems = new JSONArray();// 实际图元
        JSONArray states = new JSONArray();// 上色图元
        JSONArray translucentBim = new JSONArray();// 透明图元
//        List<String> unItems = new ArrayList<>(items);// 未关联图元
        Map<String, String> connectIitems = new HashMap<>();// 已关联图元
        for(ExecPlanDetailEntity detail : detailList){
            if(execMap.containsKey(detail.getId())){
                List<String> bimIds = execMap.get(detail.getId()).stream().map(BimDetailExecEntity::getBimIds).flatMap(x->Stream.of(x.split(","))).collect(Collectors.toList());
                for(String bimId : bimIds){
                    if(items.containsKey(bimId)){
                        // 隐藏图元
                        JSONObject obj = new JSONObject();
                        obj.put("id", bimId);
                        obj.put("time", detail.getStart());
                        obj.put("duration", detail.getDuration());
                        obj.put("uid", detail.getId());
                        obj.put("name", detail.getName());
                        hiddenItems.add(obj);
                        // 实际图元
                        if(detail.getActualStart() != null){
                            JSONObject obj2 = new JSONObject();
                            obj2.put("id", bimId);
                            obj2.put("time", detail.getActualStart());
                            obj2.put("duration", detail.getDuration());
                            obj2.put("uid", detail.getId());
                            obj2.put("name", detail.getName());
                            acturalItems.add(obj2);
                        }
                        // 上色图元
                        JSONArray state = new JSONArray();
                        state.add(bimId);
//                        if (new Integer(1).equals(detail.getFinishState())){
//                            state.add(colors.getJSONArray("blue"));// 已经完成
//                        } else if (new Integer(2).equals(detail.getFinishState()) &&
//                                DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0) {
//                            state.add(colors.getJSONArray("red"));// 进行中已逾期
//                        } else if (new Integer(2).equals(detail.getFinishState()) &&
//                                ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)) {
//                            state.add(colors.getJSONArray("yellow"));// 进行中预计预期
//                        } else if (new Integer(2).equals(detail.getFinishState()) &&
//                                ComputeUtil.isLessOrEqual(detail.getDiffValue(), BigDecimal.ZERO)) {
//                            state.add(colors.getJSONArray("green"));// 进行中
//                        } else {
//                            state.add(colors.getJSONArray("white"));// 未开始
//                            // 透明图元
//                            translucentBim.add(bimId);
//                        }
                        if (new Integer(1).equals(detail.getFinishState())) {
                            state.add(colors.getJSONArray("blue"));// 已经完成
                        } else if (new Integer(2).equals(detail.getFinishState())) {
                            if(DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0){
                                if(ComputeUtil.isLessOrEqual(detail.getDiffValue(), BigDecimal.ZERO) ){
                                    state.add(colors.getJSONArray("green"));// 进行中晚开工但进度正常
                                } else {
                                    state.add(colors.getJSONArray("red"));// 进行中已逾期
                                }
                            } else if (ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)){
                                state.add(colors.getJSONArray("yellow"));// 进行中预计预期
                            } else if (ComputeUtil.isLessOrEqual(detail.getDiffValue(), BigDecimal.ZERO)){
                                state.add(colors.getJSONArray("green"));// 进行中正常
                            }
                        } else {
                            // 任务状态为未开始，计划开始时间≤当前登录日期+30天，偏差值＞0，阈值等于0不预警
                            if(value != 0 && DateUtil.compareDate(detail.getPlanStart(), DateUtil.addDays(new Date(), value)) <= 0
                                    && ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)){
                                state.add(colors.getJSONArray("red"));// 未开始将逾期
                            } else {
                                state.add(colors.getJSONArray("white"));// 未开始
                            }
                            // 透明图元
                            translucentBim.add(bimId);
                        }
                        states.add(state);
//                        // 未关联图元
//                        unItems.remove(bimId);
                        // 已关联图元
                        connectIitems.put(bimId, bimId);
                    }
                }
            }
        }
        // 处理上色图元，如果关联的图元ID是模型树选择，且是父级，需所有子级赋值相同上色，且已关联图元上色重新覆盖
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x->((JSONArray)x).getString(0), x->((JSONArray)x).getJSONArray(1), (v1, v2)->v1));
        this.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x->{
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if(colorMap.containsKey(uid)){
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));

        // 子级按照父级显示未关联
//        List<String> unItems = new ArrayList<>();// 未关联图元
        Map<String, String> unItems = new HashMap<>();
        this.getUnItems(unItems, parents, connectIitems);

        hiddenItems = hiddenItems.stream().sorted(Comparator.comparing(x->((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        acturalItems = acturalItems.stream().sorted(Comparator.comparing(x->((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        JSONObject json = new JSONObject();
        json.put("hiddenItems", hiddenItems);// 隐藏图元
        json.put("acturalItems", acturalItems);// 实际图元
        json.put("states", newStates);// 上色图元
        json.put("translucentBim", translucentBim);// 透明图元
        // 根据条件显示，数据量太大，响应时间太长
        if(StringUtils.isNotEmpty(queryVO.getRange()) && queryVO.getRange().equals("tree")){
            json.put("unItems", new ArrayList<>(unItems.keySet()));// 未关联图元
//            json.put("treeItems", parents);// 树形所有图元
        }
        return json;
    }

    /**
     * 逾期任务提示
     * @param diffValue
     * @param state 0-进行中预计延期,1-进行中已逾期,2-未开始将逾期
     * @return
     */
    private String getContentByState(BigDecimal diffValue, Integer state) {
        JSONObject content = new JSONObject();
        StringBuilder str = new StringBuilder();
        if(state == 0){
            str.append("进行中预计延期");
        } else if(state == 1){
            str.append("进行中已逾期");
        } else if(state == 2){
            str.append("未开始将逾期");
        }
        Integer day = diffValue != null ? diffValue.intValue() : 0;
        str.append(day + "天");
        return str.toString();
    }

    /**
     * 未开始时间预警阈值
     * @param startDate
     * @param endDate
     * @return
     */
    private Integer getParamValue(Date startDate, Date endDate) {
        Integer year = DateUtil.getSubYear(startDate, endDate);
        if(year == null){
            return 0;
        }
        CommonResponse<ParamRegisterSetVO> typeResponse = paramConfigApi.getByCode(PROJECT_TYPE_PARAM);
        CommonResponse<ParamRegisterSetVO> longResponse = paramConfigApi.getByCode(LONG_PROJECT_VALUE_PARAM);
        CommonResponse<ParamRegisterSetVO> shortResponse = paramConfigApi.getByCode(SHORT_PROJECT_VALUE_PARAM);
        if (!typeResponse.isSuccess() || typeResponse.getData() == null) {
            throw new BusinessException("获取项目分类阈值设置(年)参数请求失败，失败原因：" + typeResponse.getMsg());
        }
        if (!longResponse.isSuccess() || longResponse.getData() == null) {
            throw new BusinessException("获取长时项目阈值设置(天)参数请求失败，失败原因：" + longResponse.getMsg());
        }
        if (!shortResponse.isSuccess() || shortResponse.getData() == null) {
            throw new BusinessException("获取一般项目阈值设置(天)参数请求失败，失败原因：" + shortResponse.getMsg());
        }
        Integer typeValue = Integer.valueOf(typeResponse.getData().getValueData());
        Integer longValue = Integer.valueOf(longResponse.getData().getValueData());
        Integer shortValue = Integer.valueOf(shortResponse.getData().getValueData());
        return year >= typeValue ? longValue : shortValue;
    }

    /**
     * 子级按照父级重新上色
     * @param newStates
     * @param parents
     * @param colorMap
     */
    private static void getNewStates(JSONArray newStates, List<ItemVO> parents, Map<String, JSONArray> colorMap){
        for(ItemVO parent : parents){
            String parentId = parent.getUid();
            List<ItemVO> children = parent.getChildren();
            if(colorMap.containsKey(parentId)){
                for(ItemVO item : children){
                    colorMap.put(item.getUid(), colorMap.get(parentId));
                }
                JSONArray vo = new JSONArray();
                vo.add(parentId);
                vo.add(colorMap.get(parentId));
                newStates.add(vo);
            }
            getNewStates(newStates, children, colorMap);
        }
    }

    /**
     * 子级按照父级显示未关联
     * @param unItems
     * @param parents
     * @param connectItems
     */
    private static void getUnItems(Map<String, String> unItems, List<ItemVO> parents, Map<String, String> connectItems){
        for(ItemVO parent : parents){
            String parentId = parent.getUid();
            List<ItemVO> children = parent.getChildren();
//            if(!unItems.containsKey(parentId) && !connectItems.containsKey(parentId)){
//                unItems.put(parentId, parentId);
//                getUnItems(unItems, children, connectItems);
//            }
            // 只取末级
            if(CollectionUtils.isNotEmpty(children)){
                getUnItems(unItems, children, connectItems);
            } else {
                if(!unItems.containsKey(parentId) && !connectItems.containsKey(parentId)){
                    unItems.put(parentId, parentId);
                }
            }
        }
    }

    /**
     * 递归查询子节点
     * @param root  父级主键
     * @param parent   父级
     * @return 根节点信息
     */
    private static List<ItemVO> getChildrens(String root, ItemVO parent) {
        List<ItemVO> children = new ArrayList<>();
        if(root.equals(parent.getUid())){
            children = parent.getChildren();
            List<ItemVO> childs = new ArrayList<>();
            for(ItemVO child : children){
                childs.addAll(getChildrens(child.getUid(), child));
            }
            children.addAll(childs);
        } else {
            for(ItemVO child : parent.getChildren()){
                children.addAll(getChildrens(root, child));
            }
        }
        parent.setChildren(new ArrayList<>());
        return children;
    }

    // 颜色数组
    private static JSONObject getColors() {
        JSONObject colors = new JSONObject();
        JSONArray blue = new JSONArray();
        blue.add(safeDiv(120, 255));
        blue.add(safeDiv(177, 255));
        blue.add(safeDiv(255, 255));
        colors.put("blue", blue);
        JSONArray red = new JSONArray();
        red.add(safeDiv(255, 255));
        red.add(safeDiv(105, 255));
        red.add(safeDiv(105, 255));
        colors.put("red", red);
        JSONArray yellow = new JSONArray();
        yellow.add(safeDiv(255, 255));
        yellow.add(safeDiv(193, 255));
        yellow.add(safeDiv(57, 255));
        colors.put("yellow", yellow);
        JSONArray green = new JSONArray();
        green.add(safeDiv(51, 255));
        green.add(safeDiv(196, 255));
        green.add(safeDiv(90, 255));
        colors.put("green", green);
        JSONArray white = new JSONArray();
        white.add(safeDiv(242, 255));
        white.add(safeDiv(242, 255));
        white.add(safeDiv(242, 255));
        colors.put("white", white);
        return colors;
    }

    private static BigDecimal safeDiv(Integer num1, Integer num2) {
        return safeDiv(new BigDecimal(num1.toString()), new BigDecimal(num2.toString()));
    }

    private static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        } else {
            return decimal1.divide(decimal2, 18, BigDecimal.ROUND_HALF_UP);
        }
    }

    // 解析图元id转base64编码，asm文件需要序号+guid
    private static ItemVO getItems(JSONObject json, Map<String, String> items, Integer index) {
        String Guid = null;
        if(StringUtils.isNotEmpty(json.getString("Guid"))){
            if(index != null){
                Guid = encoder.encodeToString((index + "." + json.getString("Guid")).getBytes());
            } else {
                Guid = encoder.encodeToString(json.getString("Guid").getBytes());
            }
            items.put(Guid, Guid);
        }
        List<ItemVO> children = new ArrayList<>();
        if(json.containsKey("Children")){
            for(Object o : json.getJSONArray("Children")){
                ItemVO child = getItems(JSONObject.parseObject(o.toString()), items, index);
                child.setParentId(Guid);
                children.add(child);
            }
        }
        ItemVO vo = new ItemVO();
        vo.setUid(Guid);
        vo.setChildren(children);
        return vo;
    }

    @Override
    public Boolean connect(BimConnectVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, vo.getProjectId()));
        BimEntity bim = super.queryList(queryParam).stream().findAny().orElse(null);
        if(bim == null) {
            return true;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bim_id", new Parameter(QueryParam.EQ, bim.getId()));
        param.getParams().put("modle", new Parameter(QueryParam.EQ, 1));
        List<BimDetailEntity> detailList = detailService.queryList(param);
        if(CollectionUtils.isEmpty(detailList)){
            return true;
        }
        QueryParam execParam = new QueryParam();
        execParam.getParams().put("id", new Parameter(QueryParam.EQ, vo.getExecDetailId()));
        List<ExecPlanDetailEntity> execList = execDetailService.queryList(execParam);
        if(CollectionUtils.isEmpty(execList)){
            return true;
        }
        ExecPlanDetailEntity exec = execList.get(0);

        BimDetailEntity model = detailList.get(0);
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("execDetailId", new Parameter(QueryParam.EQ, vo.getExecDetailId()));
        bimParam.getParams().put("bimDetailId", new Parameter(QueryParam.EQ, model.getId()));
        List<BimDetailExecEntity> list = bimExecService.queryList(bimParam);
        BimDetailExecEntity entity = new BimDetailExecEntity();
        if(CollectionUtils.isNotEmpty(list)){
            entity = list.get(0);
        }
        if(vo.getState()){
            entity.setBimId(model.getBimId());
            entity.setBimDetailId(model.getId());
            entity.setName(model.getName());
            entity.setPath(model.getPath());
            entity.setExecId(exec.getProgressId());
            entity.setExecDetailId(vo.getExecDetailId());
            entity.setBimIds(vo.getBimIds());
            bimExecService.saveOrUpdate(entity);
        } else if (entity.getId() != null){
            bimExecService.removeById(entity.getId());
        }
        QueryParam bimParam2 = new QueryParam();
        bimParam2.getParams().put("bimId", new Parameter(QueryParam.EQ, bim.getId()));
        List<BimDetailExecEntity> list2 = bimExecService.queryList(bimParam2);
        if(CollectionUtils.isNotEmpty(list2)){
            bim.setState(1);
            model.setState(1);
        } else {
            bim.setState(0);
            model.setState(0);
        }
        detailService.saveOrUpdate(model);
        super.saveOrUpdate(bim);
        return true;
    }

    @Override
    public Boolean oneUnConnect(Long bimDetailId) {
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("bimDetailId", new Parameter(QueryParam.EQ, bimDetailId));
        List<BimDetailExecEntity> list = bimExecService.queryList(bimParam);
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> ids = list.stream().map(BimDetailExecEntity::getId).collect(Collectors.toList());
            bimExecService.removeByIds(ids);
        }
        // 赋值为未关联
        BimDetailEntity model = detailService.selectById(bimDetailId);
        model.setState(0);
        detailService.saveOrUpdate(model);

        BimEntity bim = super.selectById(model.getBimId());
        bim.setState(0);
        super.saveOrUpdate(bim);
        return true;
    }

    @Override
    public Boolean batchDownload(List<BimDetailVO> vos, HttpServletResponse response) {
        String fileName = StringUtils.defaultString("附件包") + ".zip";
        try {
            Map<String, byte[]> fileBytes = new TreeMap<>();
            BufferedInputStream inputStream = null;
            ByteArrayOutputStream out = null;
            Map<String, Integer> fileNames = new HashMap<>();
            for (int i = 0; i < vos.size(); i++) {
                BimDetailVO vo = vos.get(i);
                // 处理文件名相同情况
                String filName = vo.getName() + "." + vo.getFormat();
                if (fileNames.get(filName) != null) {
                    Integer size = fileNames.get(filName) + 1;
                    filName = filName.replace(".", "(" + fileNames.get(filName) + ").");
                    fileNames.put(filName, size);
                } else {
                    fileNames.put(filName, 1);
                }
                try {
//                    ClassPathResource resource = new ClassPathResource("/data/dxystorage" + File.separator + vo.getPath());
                    String path = "/data/dxystorage" + File.separator + vo.getPath();
                    logger.info("文件地址：{}", path);
                    File file = new File(System.getProperty("user.dir") + path);
                    byte[] bytes = null;
                    // 如果文件不存在，则使用大象云下载功能
                    if(!file.exists()){
                        String content = TokenHelper.download(vo.getModleId());
                        bytes = content.getBytes();
                    } else {
                        InputStream in = new FileInputStream(System.getProperty("user.dir") + path);
                        inputStream = new BufferedInputStream(in);
                        out = new ByteArrayOutputStream();
                        IOUtils.copy(inputStream, out);
                        bytes = out.toByteArray();
                    }
                    fileBytes.put(filName, bytes);
                } catch (Exception e) {
                    logger.error("下载失败", e);
                    throw new BusinessException(filName + "下载失败");
                } finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            response.reset();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));

            ServletOutputStream outputStream = response.getOutputStream();
            ZipCompress zipCompress = new ZipCompress(outputStream);
            zipCompress.compress(fileBytes);
        } catch (Exception e) {
            logger.error("批量文件下載失败", e);
            throw new BusinessException("批量文件下載失败，Msg：" + e.getMessage());
        }
        return true;
    }

    @Override
    public String getViewerToken(String fileId, String path) {
        String key = TokenHelper.VIEWER_TOKEN + ":" + fileId;
        Object viewerToken = CacheHelper.get(key);
        if(viewerToken == null){
            TokenHelper.getViewerToken(fileId);
            viewerToken = CacheHelper.get(key);
            return String.valueOf(viewerToken);
        }
        JSONObject json = TokenHelper.getViewerStatus(path, String.valueOf(viewerToken));
        if(json != null && json.containsKey("code") && json.getInteger("code") != 0){
            TokenHelper.getViewerToken(fileId);
            viewerToken = CacheHelper.get(key);
        }
        return String.valueOf(viewerToken);
    }

    @Override
    public Map<Long, String> getBimIdsMap(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<BimEntity> bimList = super.queryList(queryParam);
        if(CollectionUtils.isEmpty(bimList)) {
            return new HashMap<>();
        }
        BimEntity entity = super.selectById(bimList.get(0).getId());
        List<BimDetailEntity> modelList = entity.getDetailList().stream().filter(x->x.getModle() != null && x.getModle() == 1).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(modelList)) {
            return new HashMap<>();
        }
        List<ExecPlanEntity> execList = execService.list(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        if(CollectionUtils.isEmpty(execList)) {
            return new HashMap<>();
        }
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("exec_id", new Parameter(QueryParam.EQ, execList.get(0).getId()));
        bimParam.getParams().put("bimDetailId", new Parameter(QueryParam.EQ, modelList.get(0).getId()));
        List<BimDetailExecEntity> list = bimExecService.queryList(bimParam);
        Map<Long, String> bimIdsMap = list.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, BimDetailExecEntity::getBimIds));
        return bimIdsMap;
    }

    @Override
    public Map<Long, String> getContentMap(Long id) {
        ExecPlanEntity exec = execService.getById(id);
        if(exec == null){
            return new HashMap<>();
        }
        // 获取未开始将逾期时间阈值
        Integer value = this.getParamValue(exec.getPlanBeginDate(), exec.getPlanEndDate());

        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", exec.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execDetailService.list(ew);

        Map<Long, String> map = new HashMap<>();
        for(ExecPlanDetailEntity detail : detailList){
            if (new Integer(2).equals(detail.getFinishState())) {
                if(DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0){
                    if(ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO) ){
                        String content = this.getContentByState(detail.getDiffValue(), 1);
                        map.put(detail.getId(), content);// 进行中已逾期
                    }
                } else if (ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)){
                    String content = this.getContentByState(detail.getDiffValue(), 0);
                    map.put(detail.getId(), content);// 进行中预计延期
                }
            } else {
                // 任务状态为未开始，计划开始时间≤当前登录日期+30天，偏差值＞0，阈值等于0不预警
                if(value != 0 && DateUtil.compareDate(detail.getPlanStart(), DateUtil.addDays(new Date(), value)) <= 0
                        && ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)){
                    String content = this.getContentByState(detail.getDiffValue(), 2);
                    map.put(detail.getId(), content);// 未开始将逾期
                }
            }
        }
        return map;
    }

    /**
     * 多线程查询asm文件
     * @param paths
     * @return
     */
    private Map<String, JSONObject> getItemJSONMap(List<String> paths) {
        if(CollectionUtils.isEmpty(paths)){
            return new HashMap<>();
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(paths.size() > 30 ? 30 : paths.size());
        Map<String, Future<JSONObject>> futureMap = new HashMap<>();
        for(String path : paths){
            Callable<JSONObject> callable = new BimCallable(path);
            Future<JSONObject> future = threadPool.submit(callable);
            futureMap.put(path, future);
        }
        Map<String, JSONObject> itemMap = new HashMap<>();
        try {
            for (String path : futureMap.keySet()) {
                Future<JSONObject> future = futureMap.get(path);
                JSONObject json = future.get(30, TimeUnit.SECONDS);
                itemMap.put(path, json);
            }
        } catch (Exception e) {
            throw new BusinessException(e.getMessage());
        } finally {
            threadPool.shutdown();
        }
        return itemMap;
    }

    static class BimCallable implements Callable<JSONObject> {
        private String path;

        public BimCallable(String path) {
            this.path = path;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject json = TokenHelper.getFileTree(path);
            return json;
        }
    }

    public static void main(String[] args) {
//        String str = "a6709281-c271-449c-8900-61a83693585d";
//        JSONObject json = new JSONObject();
//        json.put("Guid", str);
//        Base64.Encoder encoder = Base64.getEncoder();
//        try {
//            byte[] textByte = str.getBytes("UTF-8");
//            System.out.println(encoder.encodeToString(textByte));
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        System.out.println(encoder.encodeToString(json.getString("Guid").getBytes()));
//        String path = "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt";
//        JSONObject json = TokenHelper.getFileTree(path);
//        List<String> items = new ArrayList<>();
//        ItemVO parent = BimController.getItems(json, items, null);
//        System.out.println(JSONObject.toJSONString(items));
//        System.out.println(JSONObject.toJSONString(parent));


//        List<String> paths = new ArrayList<>();
//        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/7c6b1f21b7d349ef958301438497a4a1/7c6b1f21b7d349ef958301438497a4a1.rvt");
//        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/b4df9578f4a949f89c1dfe21fcb3a7ae/b4df9578f4a949f89c1dfe21fcb3a7ae.rvt");
//        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/5c872b5ec4de4f86875e7fb4aca79824/5c872b5ec4de4f86875e7fb4aca79824.rvt");
//        List<String> items = new ArrayList<>();
//        List<ItemVO> parents = new ArrayList<>();
//        for(int i=0; i < paths.size(); i++){
//            JSONObject json = TokenHelper.getFileTree(paths.get(i));
//            ItemVO parent = BimServiceImpl.getItems(json, items, i);
////            List<ItemVO> children = getChildrens("MS5mYjlkMmQ3Ni1lOTcxLTRmNjYtODhhMy0xMDAwMDAwMDAwMDA=", parent);
////            System.out.println(JSONObject.toJSONString(children));
//            parents.add(parent);
//        }
//        // 获取颜色数组
//        JSONObject colors = BimServiceImpl.getColors();
//        JSONArray states = new JSONArray();// 上色图元
//        JSONArray state = new JSONArray();
//        state.add("MS5mYjlkMmQ3Ni1lOTcxLTRmNjYtODhhMy0xMDAwMDAwMDAwMDA=");
//        state.add(colors.getJSONArray("blue"));// 已经完成
//        states.add(state);
//
//        // 处理上色图元，如果关联的图元ID是模型树选择，且是父级，需所有子级赋值相同上色，且已关联图元上色重新覆盖
//        JSONArray newStates = new JSONArray();
//        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x->((JSONArray)x).getString(0), x->((JSONArray)x).getJSONArray(1)));
//        BimServiceImpl.getNewStates(newStates, parents, colorMap);
//        newStates = newStates.stream().map(x->{
//            JSONArray vo = (JSONArray)x;
//            String uid = vo.getString(0);
//            if(colorMap.containsKey(uid)){
//                vo.remove(1);
//                vo.add(colorMap.get(uid));
//            }
//            return vo;
//        }).collect(Collectors.toCollection(JSONArray::new));
//        System.out.println(JSONObject.toJSONString(newStates));

//        String str = "OWI2MDNiNTYtOTE3Yi00ZTliLWE2MzgtZjY4ODE1MWM2ZTk1,OWI2MDNiNTYtOTE3Yi00ZTliLWE2MzgtZjY4ODE1MWM2ZjBl";
//        Integer index = 0;
//        String[] bimIds = str.split(",");
//        List<String> ids = new ArrayList<>();
//        for(String id : bimIds){
//            id = new String(decoder.decode(id));// 解码
//            if(index != null){
//                id = !id.contains(".") ? index + "." + id : id;// asm继承rvt，加上序号
//            } else {
//                id = id.contains(".") ? id.split("\\.")[1] : id;// rvt继承asm，去除序号
//            }
//            id = encoder.encodeToString(id.getBytes());// 编码
//            ids.add(id);
//        }
//        System.out.println(StringUtils.join(ids, ","));

        String id = "周边场地 现场工况 Root 11";
//        String[] strs = id.split("\\.");
//        System.out.println(strs[1]);

        // asm文件组件id特殊处理
        if(id.endsWith("Root " + 11)){
            id = id.replace("Root " + 11, "Root " + 9);
        }
        System.out.println(id);
    }
}
