package com.ejianc.business.fill.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.MonthFillDetailEntity;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.service.IMonthFillDetailService;
import com.ejianc.business.fill.vo.MonthFillDetailVO;
import com.ejianc.business.fill.vo.MonthFillVO;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fill.service.IMonthFillService;

/**
 * 月进度计划填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthFill")
public class MonthFillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_MONTH_FILL";//此处需要根据实际修改

    @Autowired
    private IMonthFillService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecPlanService execPlanService;

    @Autowired
    private IMonthFillDetailService detailService;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IMonthPlanService monthPlanService;

    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;

    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    @Autowired
    private IMonthFillDetailService monthFillDetailService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthFillVO> saveOrUpdate(@RequestBody MonthFillVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        MonthFillEntity entity = BeanMapper.map(saveOrUpdateVO, MonthFillEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            detailService.deleteByProgressId(entity.getId());
        }

        Integer subDay = DateUtil.getSubDay(new Date(), entity.getFillDate());
        entity.setFinishFlag(subDay);

        OrgVO orgVO = orgUtil.findById(saveOrUpdateVO.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        service.saveOrUpdate(entity, false);
        // 子表新增/修改
        List<MonthFillDetailVO> detailList = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<MonthFillDetailVO> voList = TreeHelper2.tree2List(detailList);
            List<MonthFillDetailEntity> saveList = new ArrayList<>();
            for (MonthFillDetailVO mvo : voList) {
                MonthFillDetailEntity detail = MonthFillDetailEntity.convertVoToEntity(mvo);
                detail.setProgressId(entity.getId());
                saveList.add(detail);
            }
            if(CollectionUtils.isNotEmpty(saveList)){
                detailService.saveOrUpdateBatch(saveList);
            }
        }
        return queryDetail(entity.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthFillVO> queryDetail(Long id) {
        MonthFillVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthFillVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MonthFillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MonthFillVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthFillVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("updateUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<MonthFillEntity> page = service.queryPage(param,false);
        IPage<MonthFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthFillVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthFillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthFill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMonthFillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthFillVO>> refMonthFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthFillEntity> page = service.queryPage(param,false);
        IPage<MonthFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthFillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    //获取周计划的计划详情
    @RequestMapping(value = "/getMonthFillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthFillVO> getMonthFillData(@RequestParam(value = "monthId") Long monthId,@RequestParam(required = false,value = "billId") Long billId) {
        //查询月计划
        MonthPlanEntity entity = monthPlanService.selectById(monthId);
        QueryWrapper<MonthPlanDetailEntity> qw = new QueryWrapper<>();
        qw.eq("progress_id", monthId);
        qw.orderByAsc("tid");
        List<MonthPlanDetailEntity> detailList = monthPlanDetailService.list(qw);
        List<MonthPlanDetailVO> monthDetailVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)) {
            for(MonthPlanDetailEntity detail : detailList) {
                monthDetailVOList.add(MonthPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        //查询执行计划
        ExecPlanEntity execEntity = execPlanService.selectById(entity.getSourceId());
        ExecPlanVO vo = BeanMapper.map(execEntity, ExecPlanVO.class);
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getSourceId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> execPlanDetail = execPlanDetailService.list(ew);
        List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(execPlanDetail)) {
            for(ExecPlanDetailEntity detail : execPlanDetail) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        //根据结构码匹配
        List<ExecPlanDetailVO> resultList = detailVOList.stream().filter(
                (ExecPlanDetailVO) -> monthDetailVOList.stream().map(MonthPlanDetailVO::getStructCode).collect(Collectors.toList()).contains(ExecPlanDetailVO.getStructCode())
        ).collect(Collectors.toList());
        //转换VO
        List<MonthFillDetailVO> mfList = new ArrayList<>();
        mfList = resultList.stream().map(ExecPlanDetailVO -> {
            MonthFillDetailVO mfvo = new MonthFillDetailVO();
            BeanUtils.copyProperties(ExecPlanDetailVO, mfvo);
            return mfvo;
        }).collect(Collectors.toList());
        mfList = TreeHelper2.list2Tree(mfList);
        mfList = TreeHelper2.tree2List(mfList,true);
        vo.setProgressDetailList(null);
        MonthFillVO fillVO = new MonthFillVO();
        BeanUtils.copyProperties(vo, fillVO);
        //查询最新本期完成比例
        QueryWrapper<MonthFillEntity> queryWrapper  = new QueryWrapper<MonthFillEntity>();
//        queryWrapper.eq("month_id", monthId);
        queryWrapper.eq("project_id", entity.getProjectId());
        if (billId != null){
            queryWrapper.ne("id",billId);
        }
        queryWrapper.orderByDesc("fill_date");
        queryWrapper.last("LIMIT 1");
        MonthFillEntity mfEntity = service.getOne(queryWrapper);
        List<MonthFillDetailEntity> fList = new ArrayList<>();
        Map<String, MonthFillDetailEntity> fMap = new HashMap<>();
        if(mfEntity!=null){
            fList = monthFillDetailService.list(new QueryWrapper<MonthFillDetailEntity>()
                    .eq("progress_id", mfEntity.getId())
                    .orderByAsc("tid")
            );
            fMap = fList.stream().collect(Collectors.toMap(MonthFillDetailEntity::getStructCode,a -> a,(k1,k2)->k1));
        }
        String name = "";
        String percentTask = "";
        String[] arr = new String[]{};
        BigDecimal complete = BigDecimal.ZERO;
        BigDecimal yx = BigDecimal.ZERO;
        BigDecimal cComplete = BigDecimal.ZERO;
        for(MonthFillDetailVO evo : mfList) {
            for (MonthPlanDetailEntity we : detailList) {
                if (evo.getStructCode().equals(we.getStructCode())){
                    evo.setPlanStart(we.getStart());
                    evo.setDuration(we.getDuration());
                    evo.setPlanFinish(we.getFinish());
                    evo.setNodeLevel(we.getNodeLevel());
                    //evo.setPredecessorLink(JSON.parseArray(we.getPredecessorLink()));
                    evo.setEmployeeId(we.getEmployeeId());
                    evo.setEmployeeName(we.getEmployeeName());
                    evo.setPlanNum(we.getPlanNum());
                    evo.setUnit(we.getUnit());
                    evo.setResourceName(we.getResourceName());
                    evo.setType(we.getType());
                    evo.setTypeUnit(we.getTypeUnit());
                    evo.setNeedNum(we.getNeedNum());
                    if (MapUtils.isNotEmpty(fMap)){
                        complete = ComputeUtil.safeSub(new BigDecimal(evo.getPercentComplete().toString()),fMap.get(we.getStructCode())!=null?fMap.get(we.getStructCode()).getCurrentComplete():BigDecimal.ZERO);
                    }else {
                        complete = new BigDecimal(evo.getPercentComplete().toString());
                    }
                    percentTask = we.getName().replace(evo.getName(),"");
                    if (StringUtils.isNotBlank(percentTask)){
                        arr = percentTask.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\-", ",").replaceAll("\\%","").split(",");
                        //处理yx为负数
                        if (arr.length > 2){
                            if (arr[0].equals("")){
                                arr[0] = "-"+arr[1];
                            }
                            if (arr[1].equals("")){
                                arr[1]= "-"+arr[2];
                            }
                            if (arr[2].equals("")){
                                arr[1] = "-"+arr[3];
                            }
                        }
                        yx = ComputeUtil.safeSub(new BigDecimal(arr[1]),new BigDecimal(arr[0]));
                    } else {
                        // 没有x、y的任务，默认取x=0%，y=100%
                        yx = new BigDecimal("100");
                    }
                    cComplete = ComputeUtil.bigDecimalPercent(complete,yx,0);
                    evo.setCurrentComplete(cComplete.compareTo(new BigDecimal("100"))==1?new BigDecimal("100"):cComplete.compareTo(BigDecimal.ZERO)==-1?BigDecimal.ZERO:cComplete);
                }
            }
            name = StringUtils.isNotBlank(percentTask)?evo.getName() + percentTask:evo.getName();
            evo.setName(name);
        }
        fillVO.setProgressDetailList(TreeHelper2.list2Tree(mfList));
        return CommonResponse.success("查询成功!",fillVO);
    }

    /**
     * @Description queryMonthFill 查询该项目下有没有的做填报
     * @param projectId 项目ID
     */
    @RequestMapping(value = "/queryMonthFill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> queryMonthFill(@RequestParam("projectId") Long projectId,@RequestParam(required = false,value = "billId") Long billId) {
        QueryWrapper<MonthFillEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.eq("dr",0);
        wrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        if (billId != null){
            wrapper.ne("id",billId);
        }
        wrapper.orderByDesc("fill_date");
        List<MonthFillEntity> list = service.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.success("校验通过！",list.get(0).getFillDate());
        }
        return CommonResponse.success("校验通过！");
    }
}
