package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.fill.service.IPlanFillWarnService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 *  计划/进度反馈预警
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("planFillWarn")
public class PlanFillWarnController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IPlanFillWarnService service;

    private static final String DAY_URL = "/ejc-zjkjprogress-frontend/#/dayFill/card";
    private static final String WEEK_URL = "/ejc-zjkjprogress-frontend/#/weekFill/card";
    private static final String MONTH_URL = "/ejc-zjkjprogress-frontend/#/monthFill/card";

    /**
     * 总计划预警
     * @Description totalPlanWarn 总计划预警
     */
    @RequestMapping(value = "/totalPlanWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> totalPlanWarn(@RequestBody JSONArray jsonParam) {
        return service.totalPlanWarn(jsonParam);
    }

    /**
     * 年计划预警
     * @Description yearPlanWarn 年计划预警
     */
    @RequestMapping(value = "/yearPlanWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> yearPlanWarn(@RequestBody JSONArray jsonParam) {
        return service.yearPlanWarn(jsonParam,0);
    }

    /**
     * 年计划预警
     * @Description yearPlanOneWarn 年计划预警
     */
    @RequestMapping(value = "/yearPlanOneWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> yearPlanOneWarn(@RequestBody JSONArray jsonParam) {
        return service.yearPlanWarn(jsonParam,1);
    }

    /**
     * 月计划预警
     * @Description monthPlanWarn 月计划预警
     */
    @RequestMapping(value = "/monthPlanWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> monthPlanWarn(@RequestBody JSONArray jsonParam) {
        return service.monthPlanWarn(jsonParam);
    }

    /**
     * 日进度完成情况报告预警
     * @Description dayFillWarn 日进度反馈预警
     */
    @RequestMapping(value = "/dayFillWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> dayFillWarn(@RequestBody JSONArray jsonParam) {
        return service.fillWarn(jsonParam,0,DAY_URL);
    }

    /**
     * 周进度完成情况报告预警
     * @Description weekFillWarn 周进度反馈预警
     */
    @RequestMapping(value = "/weekFillWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> weekFillWarn(@RequestBody JSONArray jsonParam) {
        return service.fillWarn(jsonParam,1,WEEK_URL);
    }

    /**
     * 月进度完成情况报告预警
     * @Description monthFillWarn 月进度反馈预警
     */
    @RequestMapping(value = "/monthFillWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> monthFillWarn(@RequestBody JSONArray jsonParam) {
        return service.fillWarn(jsonParam,2,MONTH_URL);
    }
}
