package com.ejianc.business.fill.service;

import com.ejianc.business.fill.consumer.TransferVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 工期预警
 * 
 * @author generator
 * 
 */
public interface IWarnService extends IBaseService<ExecPlanEntity> {

    CommonResponse light(HttpServletRequest request);

    CommonResponse process(TransferVO transferVO);

    CommonResponse pushNotice(HttpServletRequest request);

    Integer getLightType(LightRuleLevelEntity lightRuleLevelEntity, BigDecimal diffValue, BigDecimal finalValue, Boolean isContractLevel, Integer state);

    LightRuleLevelEntity getLightRuleLevel(Map<Long, LightRuleEntity> projectLightRuleMap, Long projectId, Integer level);

    CommonResponse<WarnProjectVO> queryProject(Long orgId);

}
