package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.fill.bean.*;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.mapper.ProjectLightMapper;
import com.ejianc.business.fill.service.*;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.fill.vo.ProjectDynamicVO;
import com.ejianc.business.fill.vo.ProjectLightVO;
import com.ejianc.business.fill.vo.ProjectTrendVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目亮灯关联实体
 *
 * @author generator
 */
@Service("projectLightService")
public class ProjectLightServiceImpl extends BaseServiceImpl<ProjectLightMapper, ProjectLightEntity> implements IProjectLightService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IProjectTrendService projectTrendService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IMonthLightService monthLightService;
    @Autowired
    private IContractLightService contractLightService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMonthFillService monthFillService;

    @Autowired
    private IBimDetailExecService bimExecService;

    @Autowired
    private ILightRuleService lightRuleService;

    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private WarnFeignUtil feignUtil;

    @Override
    public JSONObject projectList(QueryParam param) {
        int pageIndex = param.getPageIndex();//第几页
        int pageSize = param.getPageSize();//一页多少条
        String text = param.getSearchText();// 模糊查询
        Map<String, Parameter> params = param.getParams();//入参
        List<Integer> criticalPath = new ArrayList<>();
        if (params.get("criticalPath") != null) {
            String[] split = ((String) params.get("criticalPath").getValue()).split(",");
            for (String s : split) {
                criticalPath.add(Integer.parseInt(s));
            }
        }
        List<Integer> lightType = new ArrayList<>();
        if (params.get("lightType") != null) {
            String[] split = ((String) params.get("lightType").getValue()).split(",");
            for (String s : split) {
                lightType.add(Integer.parseInt(s));
            }
        }
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String ordetType = "asc";
        if (orderMap.containsKey("diffValue")) {
            ordetType = orderMap.get("diffValue");
        }

        int total = 0;//总条数
        int current = pageIndex;//第几页
        int size = pageSize;//一页几条
        int pages = 0;//有几页
        JSONObject page = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProjectVO> vos = getProjects(param);// 在建项目
        if (vos.size() < 1) {
            page.put("records", new ArrayList<>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        // 亮灯
        Map<Long, ProjectVO> projectMap = vos.stream().collect(Collectors.toMap(ProjectVO::getId, x->x));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, new ArrayList<>(projectMap.keySet())));
        List<ProjectLightEntity> list = super.queryList(queryParam);
        Map<Long, ProjectLightEntity> lightEntityMap = list.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, x->x));

        // 执行计划
        List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
        List<Long> execIds = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
        Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
        Map<Long, List<BimDetailExecEntity>> bimMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(execIds)){
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, execIds));
            List<ExecPlanDetailEntity> execDetailList = execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo->{
                if(execMap.containsKey(vo.getProjectId())){
                    List<ExecPlanDetailEntity> detail = execMap.get(vo.getProjectId()).getAllList();
                    detail.add(vo);
                }
            });

            // bim关联
            QueryParam bimParam = new QueryParam();
            bimParam.getParams().put("exec_id", new Parameter(QueryParam.IN, execIds));
            List<BimDetailExecEntity> bimList = bimExecService.queryList(bimParam);
            bimMap = bimList.stream().collect(Collectors.groupingBy(BimDetailExecEntity::getExecId));
        }

        // 月反馈
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<MonthFillEntity> monthList = monthFillService.queryList(queryParam);
        Map<Long, MonthFillEntity> monthMap = new HashMap<>();
        for(MonthFillEntity month : monthList){
            if(!monthMap.containsKey(month.getProjectId())){
                monthMap.put(month.getProjectId(), month);
            }
        }

        // 项目偏差趋势
        queryParam.getParams().remove("billState");
        queryParam.getOrderMap().put("create_time", QueryParam.ASC);
        List<ProjectTrendEntity> projectTrendList = projectTrendService.queryList(queryParam);
        Map<Long, List<ProjectTrendEntity>> trendMap = projectTrendList.stream().collect(Collectors.groupingBy(ProjectTrendEntity::getProjectId));

        List<ProjectLightVO> res1 = new ArrayList<>();
        for (Long projectId : projectMap.keySet()) {
            ProjectLightEntity entity = lightEntityMap.get(projectId);
            ProjectVO project = projectMap.get(projectId);
            ProjectLightVO projectLightVO = new ProjectLightVO();
            projectLightVO.setProjectDepartmentId(project.getProjectDepartmentId());
            projectLightVO.setProjectId(projectId);
            projectLightVO.setId(projectId);
            projectLightVO.setProjectName(project.getProjectName());
            projectLightVO.setProjectManager(project.getLeader());
            projectLightVO.setProjectManagerName(orgUtil.getCreateUserName(projectLightVO.getProjectManager()));
            projectLightVO.setProjectControlLevel(project.getProjectControlLevel());
            projectLightVO.setStartDate(project.getStartDate());// 开工日期
            projectLightVO.setEndDate(project.getEndDate());// 竣工日期
            projectLightVO.setActualStartDate(project.getActualStartDate());// 实际开工日期
            projectLightVO.setActualEndDate(project.getActualEndDate());// 实际竣工日期
            projectLightVO.setContractualModel(project.getContractualModel());// 项目类型
            projectLightVO.setBuiltArea(project.getBuiltArea());// 建筑面积
            projectLightVO.setSelfConstructionContractAmount(ComputeUtil.safeDiv(project.getSelfConstructionContractAmount(), new BigDecimal("10000")));// 合同额
            projectLightVO.setCriticalPath(entity == null ? PlanConstant.INTEGER_NO : entity.getCriticalPath());
            projectLightVO.setDiffValue(entity == null ? null : entity.getDiffValue());
            // 累计完成情况
            projectLightVO.setSumWarn(entity == null ? null : entity.getSumWarn());
            projectLightVO.setLightType(entity == null ? null : entity.getLightType());

            ExecPlanEntity exec = execMap.get(projectId);
            if (null != exec){
                List<ExecPlanDetailEntity> detailList = exec.getAllList();
                Date minPredictStart = detailList.stream().map(ExecPlanDetailEntity::getPredictStart).min(Comparator.comparing(e -> e)).get();
                Date maxPredictFinish = detailList.stream().map(ExecPlanDetailEntity::getPredictFinish).max(Comparator.comparing(e -> e)).get();
                projectLightVO.setMinPredictStart(minPredictStart);
                projectLightVO.setMaxPredictFinish(maxPredictFinish);
                projectLightVO.setPlanEndDate(exec.getPlanEndDate());// 计划竣工日期
//                String connectState = detailList.stream().filter(x->new Integer(1).equals(x.getState())).count() > 0 ? "已关联" : "未关联";
                String connectState = bimMap.containsKey(exec.getId()) && CollectionUtils.isNotEmpty(bimMap.get(exec.getId())) ? "已关联" : "未关联";
                projectLightVO.setConnectState(connectState);
            } else {
                continue;
            }

            MonthFillEntity month = monthMap.get(projectId);
            if(month != null){
                projectLightVO.setSignDays(month.getSignDays());// 工期签证天数
                projectLightVO.setWaitDays(month.getWaitDays());// 待批工期签证
                projectLightVO.setImageShows(month.getImageShows());// 形象进度
                projectLightVO.setReason(month.getReason());// 原因分析
                projectLightVO.setMeasure(month.getMeasure());// 拟采取措施
            }
            // 实际滞后天数=预警偏差-获批工期签证
            Integer diffDays = subInteger(projectLightVO.getDiffValue()!= null? projectLightVO.getDiffValue().intValue() : null, projectLightVO.getSignDays());
            projectLightVO.setDiffDays(diffDays);
            // 预计滞后天数=实际滞后天数-待批工期签证
            Integer planDays = subInteger(diffDays, projectLightVO.getWaitDays());
            projectLightVO.setPlanDays(planDays);
            // 项目合同工期履约率=1-实际滞后天数/（合同竣工时间-合同开工时间+1）
            Integer days = DateUtil.getSubDay(projectLightVO.getEndDate(), projectLightVO.getStartDate());
            BigDecimal performanceRate = ComputeUtil.safeMultiply(new BigDecimal("100"), ComputeUtil.safeSub(new BigDecimal("1"),
                    ComputeUtil.safeDiv(diffDays != null ? new BigDecimal(diffDays.toString()): null, days != null ? new BigDecimal(days.toString()) : null)));
            projectLightVO.setDuration(days);// 工期
            projectLightVO.setPerformanceRate(performanceRate);

            List<ProjectTrendEntity> trendList = trendMap.get(projectId);
            if (CollectionUtils.isNotEmpty(trendList)){
                List<ProjectTrendVO> projectTrendVOS = BeanMapper.mapList(trendList, ProjectTrendVO.class);
                projectLightVO.setProjectTrendList(projectTrendVOS);
            }

            boolean flag = false;
            // 是否关联模型
            if (StringUtils.isNotBlank(text) && !flag) {
                if (projectLightVO.getProjectName().indexOf(text) == -1
                        && (StringUtils.isBlank(projectLightVO.getCorpName()) || projectLightVO.getCorpName().indexOf(text) == -1)
                        ) {
                    flag = true;
                }
            }
            if (criticalPath.size() > 0 && !criticalPath.contains(projectLightVO.getCriticalPath())) {
                flag = true;
            }
            if (lightType.size() > 0 && !lightType.contains(projectLightVO.getLightType())) {
                flag = true;
            }
            if (!flag) {
                res1.add(projectLightVO);
            }
        }
        orderMapToSort(res1, ordetType);
        List<Long> deptIds = new ArrayList<>();
        for (int i = 0; i < res1.size(); i++) {
            deptIds.add(res1.get(i).getProjectDepartmentId());
        }
        Map<Long, OrgVO> listByIds = orgUtil.findListByIds(deptIds);
        res1.stream().forEach(vo -> {
            OrgVO orgVO = listByIds.get(vo.getProjectDepartmentId());
            vo.setCorpId(orgVO == null ? null : orgVO.getId());
            vo.setCorpName(orgVO == null ? null : orgVO.getName());
        });
        if (size == -1) {
            page.put("records", res1);
            page.put("total", res1.size());
            page.put("current", 1);
            page.put("size", -1);
            page.put("pages", 1);
            return page;
        }

        total = res1.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        // 要查第几页
        //要查的这一页有几条数据
        int num = 0;
        if ((current - 1) * size + size > total) {
            num = total - ((current - 1) * size);
        } else {
            num = size;
        }
        List<ProjectLightVO> res = new ArrayList<>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; i++) {
            res.add(res1.get(i));
        }
        page.put("records", res);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;
    }

    private List<ProjectVO> getProjects(QueryParam param) {
        param.getParams().put("project_status", new Parameter(QueryParam.EQ, 1)); // 在建
//        param.getParams().put("state", new Parameter(QueryParam.EQ, 1)); // 启用
        param.getParams().remove("criticalPath"); // 关键路径是否延误
        param.getParams().remove("lightType"); // 亮灯状态
        param.getOrderMap().clear();
        param.setPageIndex(-1);
        return feignUtil.queryProjects(param);
    }

    public List<ProjectLightVO> orderMapToSort(List<ProjectLightVO> list, String orderType) {
        list.sort((o1, o2) -> {
            BigDecimal preNum = o1.getDiffValue() == null ? BigDecimal.ZERO : o1.getDiffValue();
            BigDecimal sufNum = o2.getDiffValue() == null ? BigDecimal.ZERO : o2.getDiffValue();
            if (orderType.equals("asc")) {
                if (preNum.compareTo(sufNum) > 0) {
                    return 1;
                } else if (preNum.compareTo(sufNum) < 0) {
                    return -1;
                }
                return 0;
            } else {
                if (preNum.compareTo(sufNum) > 0) {
                    return -1;
                } else if (preNum.compareTo(sufNum) < 0) {
                    return 1;
                }
                return 0;
            }
        });
        return list;
    }

    /**
     * 获取项目信息不含亮灯信息
     * @param projectId
     * @return
     */
    public ProjectLightVO getProjectInfoNotLight(Long projectId){

        ProjectLightVO projectLightVO = new ProjectLightVO();

        LambdaQueryWrapper<ProjectLightEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectLightEntity::getProjectId,projectId);
        ProjectLightEntity projectLightEntity = super.getOne(queryWrapper);
        if (null != projectLightEntity){
            projectLightVO = BeanMapper.map(projectLightEntity,ProjectLightVO.class);
        }

        ProjectVO projectVO = projectApi.queryDetailById(projectId).getData();

        // 联系电话
        EmployeeVO employee = new EmployeeVO();
        if(projectVO != null && projectVO.getLeader() != null) {
            Long userId = projectVO.getLeader();
            //userId = userId.equals(1247777316689256450L) ? 303581417601122400L : userId;
            CommonResponse<EmployeeVO> userResp = employeeApi.queryEmployeByUserId(userId);
            if(!userResp.isSuccess()){
                throw new BusinessException(userResp.getMsg());
            }
            if(userResp.getData() != null){
                employee = userResp.getData();
            }
        }

        projectLightVO.setProjectId(projectVO.getId());
        projectLightVO.setProjectName(projectVO.getProjectName());
        projectLightVO.setProjectCode(projectVO.getBillCode());
        projectLightVO.setProjectCategory(projectVO.getProjectCategory());
        projectLightVO.setProjectManager(employee.getId());
        projectLightVO.setProjectManagerName(employee.getUserName());
        projectLightVO.setMobilePhone(employee.getMobilePhone());
        projectLightVO.setEndDate(projectVO.getEndDate());
        projectLightVO.setActualEndDate(projectVO.getActualEndDate());
        projectLightVO.setProjectControlLevel(projectVO.getProjectControlLevel());

        return projectLightVO;

    }

    @Override
    public JSONObject numMap(Long orgId, Integer orgType) {

        Map<Long, ProjectLightEntity> blueProjectLightMap = new TreeMap<>();
        Map<Long, ProjectLightEntity> yellowProjectLightMap = new TreeMap<>();
        Map<Long, ProjectLightEntity> redProjectLightMap = new TreeMap<>();
        List<Map> areaList = new ArrayList<>();
        List<ProjectVO> projectList = feignUtil.queryProjectsByOrgId(orgId);

        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)){
            // 根据执行计划过滤
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
            List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
            projectList = projectList.stream().filter(x->execMap.containsKey(x.getId())).collect(Collectors.toList());
            List<ProjectLightEntity> projectLightList = projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x->execMap.containsKey(x.getProjectId())).collect(Collectors.toList());

            if (CollectionUtils.isNotEmpty(projectLightList)){
                List<ProjectLightEntity> blueProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.蓝灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List<ProjectLightEntity> yellowProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.黄灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List<ProjectLightEntity> redProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.红灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(blueProjectLightList)){
                    blueProjectLightMap = blueProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
                if (CollectionUtils.isNotEmpty(yellowProjectLightList)){
                    yellowProjectLightMap = yellowProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
                if (CollectionUtils.isNotEmpty(redProjectLightList)){
                    redProjectLightMap = redProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
            }
        } else {
            projectList = new ArrayList<>();
        }
        if (CollectionUtils.isNotEmpty(projectList)){
            for (ProjectVO projectVO : projectList){
                Map areaMap = new HashMap<>(); //地址
                areaMap.put("lat", projectVO.getLat());
                areaMap.put("lng", projectVO.getLng());
                areaMap.put("projectName", projectVO.getProjectName());
                areaMap.put("id", projectVO.getId());
                if (blueProjectLightMap.keySet().contains(projectVO.getId())){
                    areaMap.put("light",LightTypeEnum.蓝灯.getCode());
                }
                if (yellowProjectLightMap.keySet().contains(projectVO.getId())){
                    areaMap.put("light",LightTypeEnum.黄灯.getCode());
                }
                if (redProjectLightMap.keySet().contains(projectVO.getId())){
                    areaMap.put("light",LightTypeEnum.红灯.getCode());
                }
                areaList.add(areaMap);
            }
        }

        // 查询亮灯规则
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        queryParam.getOrderMap().put("create_time", QueryParam.ASC);
        List<LightRuleEntity> lightRuleList = lightRuleService.queryList(queryParam);
        LightRuleLevelEntity level = null;
        if(CollectionUtils.isNotEmpty(lightRuleList)){
            LightRuleEntity rule = lightRuleService.selectById(lightRuleList.get(0).getId());
            level = rule.getDetailList().stream().filter(x->x.getLevel() == 4).findAny().orElse(null);
        }
        String buleContent = "";
        String yellowContent = "";
        String redContent = "";
        if(level != null){
            buleContent = "蓝色预警：";
            yellowContent = "黄色预警：";
            redContent = "红色预警：";
            //蓝灯判断
            if (level.getBlueDiffSelect() == PlanConstant.INTEGER_YES){
                buleContent = buleContent + "偏差日期/节点剩余工期 ＞ " + level.getBlueDiffMin() + "；";
            }
            if (level.getBlueLightSelect() == PlanConstant.INTEGER_YES){
                buleContent = buleContent + level.getBlueSumMin() + " =＜ 偏差日期 ＜ " + level.getBlueLightMin() + "；";
            }
            //黄灯判断
            if (level.getYellowDiffSelect() == PlanConstant.INTEGER_YES){
                yellowContent = yellowContent + "偏差日期/节点剩余工期 ＞ " + level.getYellowDiffMin() + "；";
            }
            if (level.getYellowLightSelect() == PlanConstant.INTEGER_YES){
                yellowContent = yellowContent + level.getYellowSumMin() + " =＜ 偏差日期 ＜ " + level.getYellowLightMin() + "；";
            }
            //红灯判断
            if (level.getRedDiffSelect() == PlanConstant.INTEGER_YES){
                redContent = redContent + "偏差日期/节点剩余工期 ＞ " + level.getRedDiffMin() + "；";
            }
            if (level.getRedLightSelect() == PlanConstant.INTEGER_YES){
                redContent = redContent + level.getRedLightMin() + " =＜ 偏差日期；";
            }
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("construction", projectList.size());//在建
        jsonObject.put("normal", projectList.size() - blueProjectLightMap.keySet().size() - yellowProjectLightMap.keySet().size() - redProjectLightMap.keySet().size());//正常项目
        jsonObject.put("blueLight", blueProjectLightMap.keySet().size());//蓝色预警
        jsonObject.put("yellowLight", yellowProjectLightMap.keySet().size());//黄色预警
        jsonObject.put("redLight", redProjectLightMap.keySet().size());//红色预警
        jsonObject.put("projects", areaList);//项目
        jsonObject.put("buleContent", buleContent);// 蓝色预警规则
        jsonObject.put("yellowContent", yellowContent);// 黄色预警规则
        jsonObject.put("redContent", redContent);// 红色预警规则
        return jsonObject;
    }

    @Override
    public JSONObject getProjectLightInfo(Long orgId, Integer orgType){

        List<WarnProjectVO> focusProjectList = new ArrayList<>();
        List<WarnProjectVO> keySupervisionProjectList = new ArrayList<>();
        List<Map> focusContractList = new ArrayList<>();

        // 获取所有项目信息
        List<ProjectVO> projectList = feignUtil.queryProjectsByOrgId(orgId);
        if (CollectionUtils.isNotEmpty(projectList)){
            // 取当前组织下所有亮灯的项目
            Map<Long, OrgVO> orgMap = orgApi.findChildrenByParentId(orgId).getData().stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

            // 根据执行计划过滤
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, new ArrayList<>(orgMap.keySet())));
            List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
            List<Long> execIds = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
            projectList = projectList.stream().filter(x->execMap.containsKey(x.getId())).collect(Collectors.toList());
            Map<Long, ProjectVO> projectMap = projectList.stream().collect(Collectors.toMap(ProjectVO::getId, Function.identity()));
            List<ProjectLightEntity> projectLightList = projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x->execMap.containsKey(x.getProjectId())).collect(Collectors.toList());

            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, execIds));
            detailParam.getParams().put("node_level", new Parameter(QueryParam.EQ, PlanConstant.LEVEL_CONTRACT));
            List<ExecPlanDetailEntity> execDetailList = execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo->{
                if(execMap.containsKey(vo.getProjectId())){
                    List<ExecPlanDetailEntity> detail = execMap.get(vo.getProjectId()).getAllList();
                    detail.add(vo);
                }
            });


            if (CollectionUtils.isNotEmpty(projectLightList)){

                List<ProjectLightEntity> focusProjectLightList = projectLightList.stream().filter(e -> "重点项目".equals(getDefDocById(e.getProjectType()).getName())).collect(Collectors.toList());
                List<ProjectLightEntity> keySupervisionProjectLightList = projectLightList.stream().filter(e -> "重点监管项目".equals(getDefDocById(e.getProjectType()).getName())).collect(Collectors.toList());

                if (CollectionUtils.isNotEmpty(focusProjectLightList)){
                    for (ProjectLightEntity projectLight : focusProjectLightList){
                        if (projectMap.containsKey(projectLight.getProjectId())){
                            WarnProjectVO warnProjectVO = new WarnProjectVO();

                            ProjectVO projectVO = projectMap.get(projectLight.getProjectId());
                            Integer contractSurplusDays = DateUtil.getBetweenDays(projectVO.getEndDate(), new Date());
                            Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                            MonthLightEntity monthLightEntity = monthLightService.getOne(new LambdaQueryWrapper<MonthLightEntity>()
                                    .eq(MonthLightEntity::getProjectId,projectVO.getId())
                                    .eq(MonthLightEntity::getPlanMonth,monthFirstDate));

                            warnProjectVO.setProjectName(projectVO.getProjectName());
                            warnProjectVO.setProjectId(projectVO.getId());
                            warnProjectVO.setOrgId(projectVO.getProjectDepartmentId());
                            warnProjectVO.setOrgName(orgMap.get(projectVO.getProjectDepartmentId()).getName());
                            warnProjectVO.setProjectLight(projectLight.getLightType());
                            warnProjectVO.setProjectDays(projectLight.getDiffValue());
                            if (null != monthLightEntity){
                                warnProjectVO.setMonthLight(monthLightEntity.getLightType());
                                warnProjectVO.setMonthDays(monthLightEntity.getDiffValue());
                            }
                            warnProjectVO.setContractSurplusDays(contractSurplusDays != null ? new BigDecimal(contractSurplusDays) : null);

                            focusProjectList.add(warnProjectVO);

                            /**  重点里程碑节点预警汇总开始  */
                            Integer allSum = 0;
                            Integer normalSum = 0;
                            Integer blueSum = 0;
                            Integer yellowSum = 0;
                            Integer redSum = 0;
                            Integer violetSum = 0;
                            if(!execMap.containsKey(projectVO.getId())){
                                continue;
                            }
                            List<ExecPlanDetailEntity> detailList = execMap.get(projectVO.getId()).getAllList();
                            if (CollectionUtils.isEmpty(detailList)) {
                                continue;
                            }
                            allSum = detailList.size();
                            List<ExecPlanDetailEntity> blueDetailList = detailList.stream().filter(e -> LightTypeEnum.蓝灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                            List<ExecPlanDetailEntity> yellowDetailList = detailList.stream().filter(e -> LightTypeEnum.黄灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                            List<ExecPlanDetailEntity> redDetailList = detailList.stream().filter(e -> LightTypeEnum.红灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                            List<ExecPlanDetailEntity> violetDetailList = detailList.stream().filter(e -> LightTypeEnum.紫灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                            blueSum = CollectionUtils.isNotEmpty(blueDetailList) ? blueDetailList.size() : 0;
                            yellowSum = CollectionUtils.isNotEmpty(yellowDetailList) ? yellowDetailList.size() : 0;
                            redSum = CollectionUtils.isNotEmpty(redDetailList) ? redDetailList.size() : 0;
                            violetSum = CollectionUtils.isNotEmpty(violetDetailList) ? violetDetailList.size() : 0;

                            Map<String,Object> map = new HashMap<>();
                            map.put("projectId",projectVO.getId());
                            map.put("projectName",projectVO.getProjectName());
                            map.put("allSum",allSum);
                            map.put("normalSum",allSum - blueSum - yellowSum - redSum - violetSum); //正常个数
                            map.put("blueSum",blueSum); //蓝灯个数
                            map.put("yellowSum",yellowSum); //黄灯个数
                            map.put("redSum",redSum); //红灯个数
                            map.put("violetSum",violetSum); //紫灯个数

                            List<ExecPlanDetailEntity> normalDetailList = detailList.stream().filter(e -> !LightTypeEnum.蓝灯.getCode().equals(e.getLightType())
                                    && !LightTypeEnum.黄灯.getCode().equals(e.getLightType()) && !LightTypeEnum.红灯.getCode().equals(e.getLightType())
                                    && !LightTypeEnum.紫灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                            map.put("normalDetailList", normalDetailList); // 正常列表
                            map.put("blueDetailList", blueDetailList); // 蓝灯列表
                            map.put("yellowDetailList", yellowDetailList); // 黄灯列表
                            map.put("redDetailList", redDetailList); // 红灯列表
                            map.put("violetDetailList", violetDetailList); // 紫灯列表

                            focusContractList.add(map);
                            /**  重点里程碑节点预警汇总结束  */
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(keySupervisionProjectLightList)){
                    for (ProjectLightEntity projectLight : keySupervisionProjectLightList){
                        if (projectMap.containsKey(projectLight.getProjectId())){
                            WarnProjectVO warnProjectVO = new WarnProjectVO();

                            ProjectVO projectVO = projectMap.get(projectLight.getProjectId());
                            Integer contractSurplusDays = DateUtil.getBetweenDays(projectVO.getEndDate(), new Date());
                            Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                            MonthLightEntity monthLightEntity = monthLightService.getOne(new LambdaQueryWrapper<MonthLightEntity>()
                                    .eq(MonthLightEntity::getProjectId,projectVO.getId())
                                    .eq(MonthLightEntity::getPlanMonth,monthFirstDate));

                            warnProjectVO.setProjectName(projectVO.getProjectName());
                            warnProjectVO.setProjectId(projectVO.getId());
                            warnProjectVO.setOrgId(projectVO.getProjectDepartmentId());
                            warnProjectVO.setOrgName(orgMap.get(projectVO.getProjectDepartmentId()).getName());
                            warnProjectVO.setProjectLight(projectLight.getLightType());
                            warnProjectVO.setProjectDays(projectLight.getDiffValue());
                            if (null != monthLightEntity){
                                warnProjectVO.setMonthLight(monthLightEntity.getLightType());
                                warnProjectVO.setMonthDays(monthLightEntity.getDiffValue());
                            }
                            warnProjectVO.setContractSurplusDays(new BigDecimal(contractSurplusDays));

                            keySupervisionProjectList.add(warnProjectVO);
                        }
                    }
                }

            }
        }


        JSONObject result = new JSONObject();
        result.put("focusProjectList",focusProjectList); // 重点项目
        result.put("keySupervisionProjectList",keySupervisionProjectList); // 重点监管项目
        result.put("focusContractList",focusContractList); // 重点项目里程碑节点预报警
        return result;

    }

    /**
     * 根据id查询自定义档案
     * @param id
     * @return
     */
    public DefdocDetailVO getDefDocById(Long id){
        if(id == null) return new DefdocDetailVO();
        CommonResponse<DefdocDetailVO> resp = defdocApi.getDefDocById(id);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData();
    }

    @Override
    public List<Map> getCorpLightSum(Long orgId, Integer orgType){

        List<Map> result = new ArrayList<>();

        List<OrgVO> orgVOList = orgApi.findChildrenByParentId(orgId).getData();
        String root = orgVOList.stream().filter(x->orgId.equals(x.getId())).map(x->x.getInnerCode()).findAny().orElse(null);
        Integer level = StringUtils.countMatches(root, "|") + 1;
        if (CollectionUtils.isNotEmpty(orgVOList)){
            List<ProjectVO> projectVOList = feignUtil.queryProjectsByOrgId(orgId);
            Map<Long, OrgVO> orgMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

            // 根据执行计划过滤
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, new ArrayList<>(orgMap.keySet())));
            List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
            projectVOList = projectVOList.stream().filter(x->execMap.containsKey(x.getId())).collect(Collectors.toList());
            List<ProjectLightEntity> projectLightList = projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x->execMap.containsKey(x.getProjectId())).collect(Collectors.toList());

            // 查询执行计划明细
            List<Long> execIds = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(execIds)){
                QueryParam detailParam = new QueryParam();
                detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, execIds));
                List<ExecPlanDetailEntity> detailList = execPlanDetailService.queryList(detailParam);
                detailList.forEach(vo->{
                    if(execMap.containsKey(vo.getProjectId())){
                        List<ExecPlanDetailEntity> detail = execMap.get(vo.getProjectId()).getAllList();
                        detail.add(vo);
                    }
                });
            }

            List<ContractLightEntity> contractLightList = contractLightService.queryList(queryParam);
            ArrayList<ContractLightEntity> violetLightContractList = contractLightList.stream().filter(e -> LightTypeEnum.紫灯.getCode().equals(e.getLightType()))
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(s -> s.getProjectId()))), ArrayList::new));
            // 分子公司且传入组织直属下级
            List<OrgVO> corpOrgList = orgVOList.stream().filter(e -> 2 == e.getOrgType() && level == StringUtils.countMatches(e.getInnerCode(), "|")).collect(Collectors.toList());
            for (OrgVO cropOrg : corpOrgList){
                List<Long> cropChildrenOrgIdList = orgVOList.stream().filter(e -> e.getInnerCode().contains(cropOrg.getId().toString())).map(OrgVO::getId).collect(Collectors.toList());

                Integer allSum = 0;
                Integer normalSum = 0;
                Integer blueSum = 0;
                Integer yellowSum = 0;
                Integer redSum = 0;
                Integer violetSum = 0;

                List<ProjectVO> corpProjectList = projectVOList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getProjectDepartmentId())).collect(Collectors.toList());
                if(CollectionUtils.isEmpty(corpProjectList)){
                    continue;
                }
                List<ProjectLightEntity> lightList = projectLightList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).collect(Collectors.toList());
                List<ProjectLightEntity> blueLightList = lightList.stream().filter(e -> LightTypeEnum.蓝灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List<ProjectLightEntity> yellowLightList = lightList.stream().filter(e -> LightTypeEnum.黄灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List<ProjectLightEntity> redLightList = lightList.stream().filter(e -> LightTypeEnum.红灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List<ContractLightEntity> violetLightList = violetLightContractList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).collect(Collectors.toList());
                blueSum = CollectionUtils.isNotEmpty(blueLightList) ? blueLightList.size() : 0;
                yellowSum = CollectionUtils.isNotEmpty(yellowLightList) ? yellowLightList.size() : 0;
                redSum = CollectionUtils.isNotEmpty(redLightList) ? redLightList.size() : 0;
                violetSum = CollectionUtils.isNotEmpty(violetLightList) ? violetLightList.size() : 0;
                allSum = CollectionUtils.isNotEmpty(corpProjectList) ? corpProjectList.size() : 0;

                // ● 里程碑节点总数=该二级公司下所有项目的执行计划中里程碑节点的任务总数
                // ● 里程碑应完成节点数=该二级公司下所有项目的执行计划中里程碑节点的任务中，在当前时间应该完成的任务总数（即，该任务的预测完成时间<=当前时间）
                // ● 里程碑实际完成节点数=该二级公司下所有项目的执行计划中里程碑节点的任务中，已经完成的任务总数（即，“实际完成日期”有值，且“实际完成日期”<=当前时间）
                // ● 完成率=(里程碑实际完成节点数/里程碑应完成节点数)*100
                List<ExecPlanDetailEntity> contList = execMap.values().stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).
                        map(e ->e.getAllList()).flatMap(Collection::stream).filter(e -> LevelEnum.四级.getCode().equals(e.getNodeLevel())).collect(Collectors.toList());
                List<ExecPlanDetailEntity> shouldList = contList.stream().filter(e -> WarnDateUtil.compareDate(e.getPredictFinish(), new Date()) <= 0).collect(Collectors.toList());
                List<ExecPlanDetailEntity> finishList = contList.stream().filter(e -> e.getActualFinish() != null && WarnDateUtil.compareDate(e.getActualFinish(), new Date()) <= 0).collect(Collectors.toList());
                Integer contNum = CollectionUtils.isNotEmpty(contList) ? contList.size() : 0;
                Integer shouldNum = CollectionUtils.isNotEmpty(shouldList) ? shouldList.size() : 0;
                Integer finishNum = CollectionUtils.isNotEmpty(finishList) ? finishList.size() : 0;
                BigDecimal finishRate = ComputeUtil.bigDecimalPercent(finishNum, shouldNum, 2);

                Map<String,Object> map = new HashMap<>();
                map.put("orgId",cropOrg.getId());
                map.put("orgName",cropOrg.getName());
                map.put("blueSum",blueSum); //蓝灯个数
                map.put("yellowSum",yellowSum); //黄灯个数
                map.put("redSum",redSum); //红灯个数
                map.put("violetSum",violetSum); //紫灯个数
                map.put("allSum",allSum); //全部个数
                map.put("normalSum",allSum - blueSum - yellowSum - redSum); //正常个数
                map.put("contNum", contNum); // 里程碑节点总数
                map.put("shouldNum", shouldNum); // 里程碑应完成节点数
                map.put("finishNum", finishNum); // 里程碑实际完成节点数
                map.put("finishRate", finishRate); // 完成率

                result.add(map);
            }
        }

        return result;
    }

    @Override
    public List<WarnProjectVO> getProjectLightSum(Long orgId, Integer orgType){
        List<WarnProjectVO> result = new ArrayList<>();
        List<OrgVO> orgVOList = orgApi.findChildrenByParentId(orgId).getData();
        if (CollectionUtils.isNotEmpty(orgVOList)){
            Map<Long, OrgVO> orgMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));
            // 过滤执行计划
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, new ArrayList<>(orgMap.keySet())));
            List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
            if(CollectionUtils.isEmpty(execList)){
                return result;
            }
            List<Long> execIds = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
            List<ProjectLightEntity> projectLightList = projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x->execMap.containsKey(x.getProjectId())).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, execIds));
            detailParam.getParams().put("node_level", new Parameter(QueryParam.EQ, PlanConstant.LEVEL_CONTRACT));
            List<ExecPlanDetailEntity> execDetailList = execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo->{
                if(execMap.containsKey(vo.getProjectId())){
                    List<ExecPlanDetailEntity> detail = execMap.get(vo.getProjectId()).getAllList();
                    detail.add(vo);
                }
            });

            for (ProjectLightEntity projectLight : projectLightList){
                List<ExecPlanDetailEntity> execContractDetailList = execMap.get(projectLight.getProjectId()).getAllList();
                List<ExecPlanDetailEntity> collect = execContractDetailList.stream().filter(e -> null == e.getActualStart() || null == e.getActualFinish() || null != e.getLightType()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    collect = collect.stream().sorted(Comparator.comparing(ExecPlanDetailEntity::getPredictStart)).collect(Collectors.toList());
                }
                List<ExecPlanDetailEntity> violetContractLevel = execContractDetailList.stream().filter(e -> LightTypeEnum.紫灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
                Integer sumWarn = CollectionUtils.isNotEmpty(violetContractLevel) ? violetContractLevel.size() : 0;

                Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                MonthLightEntity monthLightEntity = monthLightService.getOne(new LambdaQueryWrapper<MonthLightEntity>()
                        .eq(MonthLightEntity::getProjectId,projectLight.getProjectId())
                        .eq(MonthLightEntity::getPlanMonth,monthFirstDate));

                WarnProjectVO vo = new WarnProjectVO();
                vo.setProjectId(projectLight.getProjectId());
                vo.setProjectName(projectLight.getProjectName());
                vo.setProjectLight(projectLight.getLightType());
                if (null != monthLightEntity){
                    vo.setMonthLight(monthLightEntity.getLightType());
                }
                if (CollectionUtils.isNotEmpty(collect)){
                    vo.setContractLight(collect.get(0).getLightType());
                }
                vo.setSumWarn(new BigDecimal(sumWarn));
                vo.setDiffValue(projectLight.getDiffValue());
                result.add(vo);
            }
        }
        result = result.stream().sorted(Comparator.comparing(x->x.getDiffValue(), Comparator.nullsFirst(BigDecimal::compareTo).reversed())).collect(Collectors.toList());
        return result;
    }

    @Override
    public JSONObject getProjectInfo(Long orgId){

        JSONObject object = new JSONObject();

        CommonResponse<ProjectVO> response = projectApi.queryProjectByProjectDepartmentId(orgId);
        if (!response.isSuccess() || null == response.getData()){
            throw new BusinessException("获取项目信息失败！");
        }
        ProjectVO projectVO = response.getData();

        EmployeeVO employeeVO = new EmployeeVO();
        CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(projectVO.getLeader());
        if (employeeResponse.isSuccess() && null != employeeResponse.getData()){
            employeeVO = employeeResponse.getData();
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        // 【项目概况】的开工日期、完成日期的时间，如果有执行计划，则从【执行计划】中取值
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectVO.getId()));
        ExecPlanEntity exec = execPlanService.queryList(queryParam).stream().findAny().orElse(null);
        if(exec != null){
            projectVO.setStartDate(exec.getPlanBeginDate());
            projectVO.setEndDate(exec.getPlanEndDate());
        }

        object.put("projectId",projectVO.getId());
        object.put("projectName",projectVO.getProjectName());
        object.put("projectCode",projectVO.getBillCode());
        object.put("projectCategory",getDefDocById(projectVO.getProjectCategory()).getName());
        object.put("leader",employeeVO.getUserName());
        object.put("mobilePhone",employeeVO.getMobilePhone());
        object.put("startDate",sdf.format(projectVO.getStartDate()));
        object.put("endDate",sdf.format(projectVO.getEndDate()));
        object.put("projectControlLevel",getDefDocById(projectVO.getProjectControlLevel()).getName());
        object.put("projectStatus",projectVO.getStatus());

        return object;

    }

    public List<ExecPlanDetailVO> getMonthFirstLevel(Long orgId){

        List<ExecPlanDetailVO> result = new ArrayList<>();

        CommonResponse<ProjectVO> response = projectApi.queryProjectByProjectDepartmentId(orgId);
        if (!response.isSuccess() || null == response.getData()){
            throw new BusinessException("获取项目信息失败！");
        }
        ProjectVO projectVO = response.getData();

        Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
        LambdaQueryWrapper<MonthPlanEntity> monthQueryWrapper = new LambdaQueryWrapper<>();
        monthQueryWrapper.eq(MonthPlanEntity::getProjectId,projectVO.getId());
        monthQueryWrapper.eq(MonthPlanEntity::getPlanMonth,monthFirstDate);
        MonthPlanEntity monthPlanEntity = monthPlanService.getOne(monthQueryWrapper);
        if (null == monthPlanEntity){
            return result;
        }

        List<MonthPlanDetailEntity> monthDetailList = monthPlanDetailService.list(new QueryWrapper<MonthPlanDetailEntity>()
                        .eq("progress_id", monthPlanEntity.getId()).orderByAsc("tid"));

        List<MonthPlanDetailEntity> monthFirstLevelList = monthDetailList.stream().filter(e -> PlanConstant.LEVEL_FIRST == e.getNodeLevel()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(monthFirstLevelList)){
            return result;
        }

        Map<String, MonthPlanDetailEntity> monthFirstLevelMap = monthFirstLevelList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getStructCode, Function.identity()));
        ExecPlanEntity execPlanEntity = execPlanService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectVO.getId()));
        if (null != execPlanEntity){
            List<ExecPlanDetailEntity> execDetailList = execPlanDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                    .eq("progress_id", execPlanEntity.getId()).orderByAsc("tid"));
            List<ExecPlanDetailEntity> detailList = execDetailList.stream().filter(e -> null != monthFirstLevelMap.get(e.getStructCode())).collect(Collectors.toList());


            for (ExecPlanDetailEntity entity : detailList){
                ExecPlanDetailVO execPlanDetail = ExecPlanDetailEntity.convertEntityToVo(entity);
                Integer status = null;
                if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()){
                    status = FillConstant.NOT_STAR;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()){
                    status = FillConstant.UNDERWAY;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()){
                    status = FillConstant.FINISHED;
                }
                execPlanDetail.setFinishState(status);
                result.add(execPlanDetail);
            }
        }

        return result;
    }

    @Override
    public List<JSONObject> getMapProjectList(Long orgId, Integer lightType){
        List<JSONObject> result = new ArrayList<>();
        List<ProjectVO> data = feignUtil.queryProjectsByOrgId(orgId);
        List<Long> deptIds = data.stream().map(ProjectVO::getProjectDepartmentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(data)){
            Map<Long, OrgVO> corpMap = orgUtil.getCorpMapByIds(deptIds);
            List<OrgVO> orgVOList = orgApi.findChildrenByParentId(orgId).getData();
            Map<Long, OrgVO> orgMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));
            // 过滤执行计划
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, new ArrayList<>(orgMap.keySet())));
            List<ExecPlanEntity> execList = execPlanService.queryList(queryParam);
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x->x));
            List<ProjectLightEntity> projectLightList = projectLightService.queryList(queryParam);
            Map<Long, ProjectLightEntity> collect = projectLightList.stream().filter(x->execMap.containsKey(x.getProjectId())).
                    collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));

            for (ProjectVO vo : data){
                Integer light = null;
                BigDecimal diffValue = null;
                if (collect.containsKey(vo.getId())){
                    ProjectLightEntity projectLightEntity = collect.get(vo.getId());
                    light = projectLightEntity.getLightType();
                    diffValue = projectLightEntity.getDiffValue();
                } else {
                    continue;
                }

//                if (null != lightType && -1 == lightType && null != light){
//                    continue;
//                }
                if (null != lightType && light != lightType && null != light){
                    continue;
                }

                JSONObject object = new JSONObject();
                object.put("projectId",vo.getId());
                object.put("projectName",vo.getProjectName());
                object.put("orgName", corpMap.containsKey(vo.getProjectDepartmentId()) ? corpMap.get(vo.getProjectDepartmentId()).getName() : null);
                object.put("projectControlLevelName",getDefDocById(vo.getProjectControlLevel()).getName());
                object.put("projectCategory",getDefDocById(vo.getProjectCategory()).getName());
                object.put("lightType",light);
                object.put("diffValue",diffValue);
                result.add(object);
            }
        }
        result = result.stream().sorted(Comparator.comparing(x->x.getBigDecimal("diffValue"), Comparator.nullsFirst(BigDecimal::compareTo).reversed())).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<ProjectDynamicVO> projectDynamic(Long projectId) {
        return baseMapper.projectDynamic(projectId);
    }

    private static Integer subInteger(Integer num1, Integer num2){
        if(num1 == null){
            return num2;
        }
        if(num2 == null){
            return num1;
        }
        return num1 - num2;
    }

}
