package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.fill.util.PageUtil;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.utils.SeparatorUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 执行计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("execPlan")
public class ExecPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectApi;

    @Autowired
    private IExecPlanService service;

    @Autowired
    private IExecPlanDetailService detailService;

    @Autowired
    private IBimDetailExecService bimExecService;

    @Autowired
    private ITotalPlanService totalService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExecPlanVO> saveOrUpdate(@RequestBody ExecPlanVO saveOrUpdateVO) {
    	ExecPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetail(Long id) {
    	ExecPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecPlanVO> vos) {
        List<Long> ids = vos.stream().map(ExecPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.remove(new QueryWrapper<ExecPlanDetailEntity>().in("progress_id", ids));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExecPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExecPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> refExecPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 执行计划明细参照
     * @param projectId 项目主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划，默认向上兼容，即为3时，查询"1,2,3"
     *                  ，参照哪级计划传哪个，一般不会参照周计划
     * @param startDate 到天即可，会处理成当天00:00:00
     * @param endDate   到天即可，会处理成当天23:59:59
     * @return
     */
    @RequestMapping(value = "/refExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanDetail(@RequestParam("projectId") Long projectId,
            @RequestParam(value = "planState", required = false) Integer planState,
            @RequestParam(value = "startDate", required = false) Date startDate,
            @RequestParam(value = "endDate", required = false) Date endDate) {
        ExecPlanVO vo = service.queryRefDetail(projectId, planState, startDate, endDate);
        return CommonResponse.success("查询清单参照成功！", vo);
    }

    @RequestMapping(value = "/refExecPlanBimDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanBimDetail(@RequestParam("projectId") Long projectId,
            @RequestParam(value = "planState", required = false) Integer planState,
            @RequestParam(value = "startDate", required = false) Date startDate,
            @RequestParam(value = "endDate", required = false) Date endDate,
            @RequestParam("bimDetailId") Long bimDetailId) {
//        ExecPlanVO vo = service.queryRefDetail(projectId, planState, startDate, endDate);
        QueryWrapper<ExecPlanEntity> ew = new QueryWrapper<>();
        ew.eq("project_id", projectId);
        ExecPlanEntity entity = service.getOne(ew);
        ExecPlanVO vo = new ExecPlanVO();
        if(entity != null){
            vo = service.queryDetail(entity.getId());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("exec_id", new Parameter(QueryParam.EQ, vo.getId()));
        param.getParams().put("bimDetailId", new Parameter(QueryParam.EQ, bimDetailId));
        List<BimDetailExecEntity> execList = bimExecService.queryList(param);
        Map<Long, BimDetailExecEntity> execMap = execList.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, x->x));
        List<ExecPlanDetailVO> detailList = TreeHelper2.tree2List(vo.getProgressDetailList());
        if(CollectionUtils.isNotEmpty(detailList)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailVO detail : detailList) {
                detail.setState(0);
                if(execMap.containsKey(Long.valueOf(detail.getUid()))){
                    detail.setBimIds(execMap.get(Long.valueOf(detail.getUid())).getBimIds());
                    detail.setState(1);
                }
                detailVOList.add(detail);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success("查询清单参照成功！", vo);
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    /**
     * @param vo id 执行计划主键
     * @param vo planState 1-总计划、2-年计划、3-月计划、4-周计划，默认总计划
     * @param vo startDate 到天即可，会处理成当天00:00:00，默认总计划计划开始时间
     * @param vo endDate   到天即可，会处理成当天23:59:59，默认总计划计划结束时间
     * @return
     */
    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    /**
     * 推送执行计划
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlan(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlan(id, planState);
        return CommonResponse.success("推送执行计划成功！", vo);
    }

    /**
     * 推送执行计划回退
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlanRollBack", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlanRollBack(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlanRollBack(id, planState);
        return CommonResponse.success("推送执行计划回退成功！", vo);
    }

    /**
     * @Description validateProject 校验项目下是否存在未生效单据
     * @param projectId 项目ID
     * @param billId 单据主键
     */
    @RequestMapping(value = "/validateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam("projectId") Long projectId,
                                                  @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateProject(projectId, billId);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description validateProject 校验项目下是否存在未生效单据
     */
    @RequestMapping(value = "/initTable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> initTable() {
        String msg = service.initTable();
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @选择执行计划节点参照
     * @param projectId 项目主键
     * @return ExecPlanVO
     */
    @RequestMapping(value = "/referExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value = "projectId") Long projectId,
            @RequestParam("fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        ExecPlanEntity entity = service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if(entity.getId() == null){
            throw new BusinessException("未查询到执行计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);

        // 过滤后置任务已开始的任务
        List<ExecPlanDetailEntity> actualList = detailList.stream().filter(x->x.getActualStart() != null).collect(Collectors.toList());
        Map<Long, ExecPlanDetailEntity> preMap = new HashMap<>();
        for(ExecPlanDetailEntity actual : actualList){
            List<ExecPlanDetailEntity> preList = TreeUtils.getPreLinkList(detailList, actual.getStructCode());
            if(CollectionUtils.isEmpty(preList)){
                continue;
            }
            preMap.putAll(preList.stream().collect(Collectors.toMap(x->x.getId(), x->x)));
        }

        // 符合条件的末级及其所有上级
        List<ExecPlanDetailEntity> leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x->new Integer(1).equals(x.getFinishState()) && fillUserId.equals(x.getEmployeeId())).collect(Collectors.toList());
        leafList = leafList.stream().filter(x->!preMap.containsKey(x.getId())).collect(Collectors.toList());
        Set<String> structCodes = leafList.stream().flatMap(x->SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List<ExecPlanDetailEntity> result = detailList.stream().filter(x->structCodes.contains(x.getStructCode())).collect(Collectors.toList());

        // 转换VO
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(result)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description queryContractList 查询里程碑节点列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryContractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanDetailVO>> queryContractList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 */
        Long orgId = InvocationInfoProxy.getOrgId();
        if(param.getParams().containsKey("orgId")){
            orgId = Long.valueOf(String.valueOf(param.getParams().get("orgId").getValue()));
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExecPlanEntity> list = service.queryList(param,false);
        Map<Long, ExecPlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        // 查询里程碑节点子表
        List<ExecPlanDetailVO> array = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(map.keySet())){
            QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
            ew.in("progress_id", new ArrayList<>(map.keySet()));
            ew.eq("node_level", 4);
            List<ExecPlanDetailEntity> detailList = detailService.list(ew);
            for(ExecPlanDetailEntity detail : detailList) {
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
                vo.setProjectName(map.get(detail.getProgressId()).getProjectName());
                array.add(vo);
            }
        }
        List<Long> projectIds = list.stream().map(ExecPlanEntity::getProjectId).distinct().collect(Collectors.toList());
        Map<Long, TotalPlanEntity> totalMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectIds)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
            List<TotalPlanEntity> totalList = totalService.queryList(queryParam,false);
            totalMap = totalList.stream().collect(Collectors.toMap(x->x.getProjectId(), x->x));
        }
        // 分页
        int current = param.getPageIndex();//第几页
        int size = param.getPageSize();//一页几条
        int total = array.size();//总条数
        IPage<ExecPlanDetailVO> pageData = new Page<>(current, size, total);
        List<ExecPlanDetailVO> records = PageUtil.listToPage(array, current, size);
        for(ExecPlanDetailVO vo : records){
            if(totalMap.containsKey(vo.getProjectUID())){
                vo.setTotalPlanId(totalMap.get(vo.getProjectUID()).getId());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
