package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.DayFillDetailEntity;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Component
public class CommonHelper {

    @Autowired
    private IExecPlanService execService;

    @Autowired
    private IExecPlanDetailService execDetailService;

//    @Autowired
//    private IYearPlanService yearService;
//
//    @Autowired
//    private IYearPlanDetailService yearDetailService;
//
//    @Autowired
//    private IMonthPlanService monthService;
//
//    @Autowired
//    private IMonthPlanDetailService monthDetailService;
//
//    @Autowired
//    private IWeekPlanService weekService;
//
//    @Autowired
//    private IWeekPlanDetailService weekDetailService;

    @Autowired
    private IDayFillService fillService;

    @Autowired
    private IDayFillDetailService fillDetailService;

    /**
     * 获取计划明细主键对应关系
     * 如执行计划存在，则使用执行计划主键
     * 如执行计划不存在，使用重置后的主键
     * @param sourceList
     * @param detailList
     * @return
     */
    public static <T extends ProgressDetailEntity> Map<Long, Long> getIdMap(List<T> sourceList, List<ExecPlanDetailEntity> detailList) {
        Map<Long, String> sourceMap = sourceList.stream().collect(Collectors.toMap(x->x.getId(), x->x.getStructCode()));
        Map<String, Long> execMap = detailList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x.getId()));
        Map<Long, Long> idMap = new HashMap<>();
        String task = null;
        for(Long id : sourceMap.keySet()){
            task = sourceMap.get(id);
            if(execMap.containsKey(task)){
                idMap.put(id, execMap.get(task));
            } else {
                idMap.put(id, id);
            }
        }
        idMap.put(-1L, -1L);// 根目录父级为-1
        return idMap;
    }

    /**
     * 不删除明细
     * @param sourceList    不删除的明细
     * @param detailList    执行计划明细
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList,
            Long projectId, Integer planState) {
        return transferDelIds(sourceList, detailList, projectId, planState, false);
    }

//    /**
//     * 获取执行计划明细删除主键集合及是否下游引用校验
//     * @param sourceList
//     * @param detailList
//     * @param isDel true-sourceList(删除明细)，false-sourceList(不删除明细), null-只删除自己(撤回删除)
//     * @return
//     */
//    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList,
//                Long projectId, Integer planState, Boolean isDel) {
//        List<Long> delIds = new ArrayList<>();
//        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
//        Long sourceId = CollectionUtils.isNotEmpty(sourceList) ? sourceList.get(0).getProgressId() : null;
//        if(CollectionUtils.isNotEmpty(detailList)){
//            List<String> delTasks = new ArrayList<>();
//            List<ExecPlanDetailEntity> execList = new ArrayList<>();
//            if(isDel == null || !isDel) {// 4级计划变更删除后推送执行计划校验
//                execList = detailList.stream().filter(x->sourceId == null
//                        || x.getSourceId().equals(sourceId)).collect(Collectors.toList());
//                execList.forEach(item->{
//                    if(isDel == null ? sourceMap.containsKey(item.getStructCode()) : !sourceMap.containsKey(item.getStructCode())){
//                        delIds.add(item.getId());
//                        delTasks.add(item.getStructCode());
//                    }
//                });
//                List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
//                        && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
//                List<ExecPlanDetailEntity> parentList = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
//                        delTasks.contains(x.getStructCode())).collect(Collectors.toList());
//                if(CollectionUtils.isNotEmpty(parentList)) {
//                    StringBuilder msg = new StringBuilder();
//                    for(ExecPlanDetailEntity detail : parentList){
//                        msg.append("【" + detail.getName() + "】在执行计划中" + detail.getOutlineNumber() + "存在下级任务！");
//                    }
//                    throw new BusinessException(msg.toString());
//                }
//            } else {// 变更删除任务时下游引用校验
//                execList = detailList.stream().collect(Collectors.toList());
//                execList.forEach(item->{
//                    if(sourceMap.containsKey(item.getStructCode())){
//                        delIds.add(item.getId());
//                        delTasks.add(item.getStructCode());
//                    }
//                });
//                if(CollectionUtils.isNotEmpty(delTasks)){
//                    if(planState < PlanConstant.YEAR_PLAN){
//                        // 校验年计划引用
//                        this.validateYearPlan(projectId, delTasks);
//                    }
//                    if(planState < PlanConstant.MONTH_PLAN){
//                        // 校验月计划引用
//                        this.validateMonthPlan(projectId, delTasks);
//                    }
//                    if(planState < PlanConstant.WEEK_PLAN){
//                        // 校验周计划引用
//                        this.validateWeekPlan(projectId, delTasks);
//                    }
//                }
//            }
//            if(CollectionUtils.isNotEmpty(delTasks)){
//                // 校验日反馈引用
//                this.validateDayFill(projectId, delTasks);
//            }
//        }
//        return delIds;
//    }

    /**
     * 获取执行计划明细删除主键集合及是否下游引用校验
     * @param sourceList
     * @param detailList
     * @param isDel true-sourceList(删除明细)，false-sourceList(不删除明细), null-只删除自己(撤回删除)
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList,
            Long projectId, Integer planState, Boolean isDel) {
        List<Long> delIds = new ArrayList<>();
        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
        Long sourceId = CollectionUtils.isNotEmpty(sourceList) ? sourceList.get(0).getProgressId() : null;
        if(CollectionUtils.isEmpty(detailList)) {
            return new ArrayList<>();
        }
        List<String> delTasks = new ArrayList<>();
        List<ExecPlanDetailEntity> execList = new ArrayList<>();
        execList = detailList.stream().filter(x->sourceId == null
                || x.getSourceId().equals(sourceId)).collect(Collectors.toList());
        execList.forEach(item->{
            if(isDel == null || isDel? sourceMap.containsKey(item.getStructCode()) : !sourceMap.containsKey(item.getStructCode())){
                delIds.add(item.getId());
                delTasks.add(item.getStructCode());
            }
        });
        if(CollectionUtils.isEmpty(delTasks)){
            return new ArrayList<>();
        }
        List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
                && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
        List<ExecPlanDetailEntity> parentList = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
                delTasks.contains(x.getStructCode())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(parentList)) {
            StringBuilder msg = new StringBuilder();
            for(ExecPlanDetailEntity detail : parentList){
                msg.append("【" + detail.getName() + "】在执行计划中" + detail.getOutlineNumber() + "存在下级任务！");
            }
            throw new BusinessException(msg.toString());
        }
        // 校验日反馈引用
        this.validateDayFill(projectId, delTasks);
        return delIds;
    }

//    /**
//     * 变更单先查询执行计划，再引用校验
//     * @param sourceList    待删除明细
//     * @param projectId     待删除明细，所属项目id
//     * @param isDel null-变更新增下级使用，true-变更删除使用
//     * @return
//     */
//    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, Long projectId, Integer planState, Boolean isDel) {
//        // 执行计划
//        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
//        if(data == null) {
//            throw new BusinessException("未查询到项目下执行计划！");
//        }
//        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
//                .eq("progress_id", data.getId()).orderByAsc("tid"));
//        List<Long> delIds = new ArrayList<>();
//        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
//        if(CollectionUtils.isEmpty(detailList)) {
//            return new ArrayList<>();
//        }
//        List<String> delTasks = new ArrayList<>();
//        detailList.forEach(item->{
//            if(sourceMap.containsKey(item.getStructCode())){
//                delIds.add(item.getId());
//                delTasks.add(item.getStructCode());
//            }
//        });
//        if(CollectionUtils.isEmpty(delTasks)){
//            return new ArrayList<>();
//        }
//        if(isDel == null) {// 4级计划变更新增下级校验
//            List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
//                    && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
//            List<ExecPlanDetailEntity> parentList = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
//                    delTasks.contains(x.getStructCode())).collect(Collectors.toList());
//            if(CollectionUtils.isNotEmpty(parentList)) {
//                StringBuilder msg = new StringBuilder();
//                for(ExecPlanDetailEntity detail : parentList){
//                    msg.append("【" + detail.getName() + "】在执行计划中" + detail.getOutlineNumber() + "存在下级任务！");
//                }
//                throw new BusinessException(msg.toString());
//            }
//        } else {// 变更删除任务时下游引用校验
//            if(planState < PlanConstant.YEAR_PLAN){
//                // 校验年计划引用
//                this.validateYearPlan(projectId, delTasks);
//            }
//            if(planState < PlanConstant.MONTH_PLAN){
//                // 校验月计划引用
//                this.validateMonthPlan(projectId, delTasks);
//            }
//            if(planState < PlanConstant.WEEK_PLAN){
//                // 校验周计划引用
//                this.validateWeekPlan(projectId, delTasks);
//            }
//        }
//        // 校验日反馈引用
//        this.validateDayFill(projectId, delTasks);
//        return delIds;
//    }

    /**
     * 变更单先查询执行计划，再引用校验
     * @param sourceList    待删除明细
     * @param projectId     待删除明细，所属项目id
     * @param isDel null-变更新增下级使用，true-变更删除使用
     * @return
     */
    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, Long projectId, Integer planState, Boolean isDel) {
        // 执行计划
        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        if(data == null) {
            throw new BusinessException("未查询到项目下执行计划！");
        }
        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                .eq("progress_id", data.getId()).orderByAsc("tid"));
        List<Long> delIds = new ArrayList<>();
        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
        if(CollectionUtils.isEmpty(detailList)) {
            return new ArrayList<>();
        }
        List<String> delTasks = new ArrayList<>();
        detailList.forEach(item->{
            if(sourceMap.containsKey(item.getStructCode())){
                delIds.add(item.getId());
                delTasks.add(item.getStructCode());
            }
        });
        if(CollectionUtils.isEmpty(delTasks)){
            return new ArrayList<>();
        }
        List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
                && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
        List<ExecPlanDetailEntity> parentList = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
                delTasks.contains(x.getStructCode())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(parentList)) {
            StringBuilder msg = new StringBuilder();
            for(ExecPlanDetailEntity detail : parentList){
                msg.append("【" + detail.getName() + "】在执行计划中" + detail.getOutlineNumber() + "存在下级任务！");
            }
            throw new BusinessException(msg.toString());
        }
        // 校验日反馈引用
        this.validateDayFill(projectId, delTasks);
        return delIds;
    }

//    /**
//     * 校验年计划引用
//     * @param projectId
//     * @param delTasks
//     */
//    private void validateYearPlan(Long projectId, List<String> delTasks) {
//        List<YearPlanEntity> list = yearService.list(new QueryWrapper<YearPlanEntity>().eq("project_id", projectId));
//        List<Long> ids = list.stream().map(YearPlanEntity::getId).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(ids)){
//            QueryWrapper ew = new QueryWrapper();
//            ew.in("progress_id", ids);
//            ew.in("struct_code", delTasks);
//            List<YearPlanDetailEntity> detailList = yearDetailService.list(ew);
//            if(CollectionUtils.isNotEmpty(detailList)){
////                List<String> detailTasks = detailList.stream().map(YearPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
////                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
//                Map<Long, YearPlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
//                StringBuilder msg = new StringBuilder();
//                for(YearPlanDetailEntity detail : detailList){
//                    msg.append("【" + detail.getName() + "】已被年计划【" + map.get(detail.getProgressId()).getBillCode() + "】中" );
//                    msg.append(detail.getOutlineNumber() + "引用！");
//                }
//                throw new BusinessException(msg.toString());
//            }
//        }
//    }
//
//    /**
//     * 校验月计划引用
//     * @param projectId
//     * @param delTasks
//     */
//    private void validateMonthPlan(Long projectId, List<String> delTasks) {
//        List<MonthPlanEntity> list = monthService.list(new QueryWrapper<MonthPlanEntity>().eq("project_id", projectId));
//        List<Long> ids = list.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(ids)){
//            QueryWrapper ew = new QueryWrapper();
//            ew.in("progress_id", ids);
//            ew.in("struct_code", delTasks);
//            List<MonthPlanDetailEntity> detailList = monthDetailService.list(ew);
//            if(CollectionUtils.isNotEmpty(detailList)){
////                List<String> detailTasks = detailList.stream().map(MonthPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
////                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
//                Map<Long, MonthPlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
//                StringBuilder msg = new StringBuilder();
//                for(MonthPlanDetailEntity detail : detailList){
//                    msg.append("【" + detail.getName() + "】已被月计划【" + map.get(detail.getProgressId()).getBillCode() + "】中" );
//                    msg.append(detail.getOutlineNumber() + "引用！");
//                }
//                throw new BusinessException(msg.toString());
//            }
//        }
//    }
//
//    /**
//     * 校验周计划引用
//     * @param projectId
//     * @param delTasks
//     */
//    private void validateWeekPlan(Long projectId, List<String> delTasks) {
//        List<WeekPlanEntity> list = weekService.list(new QueryWrapper<WeekPlanEntity>().eq("project_id", projectId));
//        List<Long> ids = list.stream().map(WeekPlanEntity::getId).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(ids)){
//            QueryWrapper ew = new QueryWrapper();
//            ew.in("progress_id", ids);
//            ew.in("struct_code", delTasks);
//            List<WeekPlanDetailEntity> detailList = weekDetailService.list(ew);
//            if(CollectionUtils.isNotEmpty(detailList)){
////                List<String> detailTasks = detailList.stream().map(WeekPlanDetailEntity::getOutlineNumber).collect(Collectors.toList());
////                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被下游引用！");
//                Map<Long, WeekPlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
//                StringBuilder msg = new StringBuilder();
//                for(WeekPlanDetailEntity detail : detailList){
//                    msg.append("【" + detail.getName() + "】已被周计划【" + map.get(detail.getProgressId()).getBillCode() + "】中" );
//                    msg.append(detail.getOutlineNumber() + "引用！");
//                }
//                throw new BusinessException(msg.toString());
//            }
//        }
//    }

//    /**
//     * 校验日反馈引用
//     * @param projectId
//     * @param delTasks
//     */
//    private void validateDayFill(Long projectId, List<String> delTasks) {
//        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
//        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(ids)){
//            QueryWrapper ew = new QueryWrapper();
//            ew.in("progress_id", ids);
//            ew.in("struct_code", delTasks);
//            ew.eq("show_state", 1);// 显示即为引用
//            ew.gt("percent_complete", 0);// 百分比大于0即为有实际数据
//            List<DayFillDetailEntity> detailList = fillDetailService.list(ew);
//            if(CollectionUtils.isNotEmpty(detailList)){
////                List<String> detailTasks = detailList.stream().map(DayFillDetailEntity::getOutlineNumber).collect(Collectors.toList());
////                throw new BusinessException("【" + StringUtils.join(detailTasks, "，") + "】计划已被日进度反馈引用！");
//                Map<Long, DayFillEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
//                StringBuilder msg = new StringBuilder();
//                for(DayFillDetailEntity detail : detailList){
//                    msg.append("【" + detail.getName() + "】已被日反馈【" + map.get(detail.getProgressId()).getBillCode() + "】中" );
//                    msg.append(detail.getOutlineNumber() + "引用！");
//                }
//                throw new BusinessException(msg.toString());
//            }
//        }
//    }

    /**
     * 校验日反馈引用
     * @param projectId
     * @param delTasks
     */
    private void validateDayFill(Long projectId, List<String> delTasks) {
        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("progressId", new Parameter(QueryParam.IN, ids));
        // 非末级showState可能为0，用结构码右匹配查询是否显示
        ComplexParam c4 = new ComplexParam();
        c4.setLogic(ComplexParam.AND);
        for(String structCode : delTasks){
            ComplexParam c5 = new ComplexParam();
            c5.setLogic(ComplexParam.OR);
            c5.getParams().put("structCode", new Parameter(QueryParam.LIKE_RIGHT, structCode));
            c4.getComplexParams().add(c5);
        }
        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("showState", new Parameter(QueryParam.EQ, 1));
        queryParam.getParams().put("actualStart", new Parameter(QueryParam.NE, null));
        List<DayFillDetailEntity> detailList = fillDetailService.queryList(queryParam);

        Set<String> codeList = new HashSet<>();
        for(DayFillDetailEntity detail : detailList){
            codeList.addAll(delTasks.stream().filter(x->detail.getStructCode().startsWith(x)).collect(Collectors.toSet()));
        }
        if(CollectionUtils.isNotEmpty(codeList)){
            Map<Long, DayFillEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
//            List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
            List<DayFillDetailEntity> dataList = fillDetailService.list(new QueryWrapper<DayFillDetailEntity>().in("progress_id", ids));
            Map<String, DayFillDetailEntity> detailMap = dataList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x, (v1, v2)->v2));

            StringBuilder msg = new StringBuilder();
            for(String structCode : codeList){
                if(!detailMap.containsKey(structCode)) {
                    continue;
                }
                DayFillDetailEntity detail = detailMap.get(structCode);
                msg.append("【" + detail.getName() + "】已被日反馈【" + map.get(detail.getProgressId()).getBillCode() + "】中" );
                msg.append(detail.getOutlineNumber() + "引用！");
            }
            throw new BusinessException(msg.toString());
        }
    }

//    /**
//     * 获取被日反馈引用结构码集合
//     * @param sourceList    待校验明细
//     * @param projectId     待校验明细，所属项目id
//     * @return
//     */
//    public <T extends ProgressDetailEntity> List<String> transferUseIds(List<T> sourceList, Long projectId) {
//        // 执行计划
//        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
//        if(data == null) {
//            throw new BusinessException("未查询到项目下执行计划！");
//        }
//        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
//                .eq("progress_id", data.getId()).orderByAsc("tid"));
////        Map<String, T> sourceMap = sourceList.stream().collect(Collectors.toMap(T::getStructCode, x->x));
//        if(CollectionUtils.isEmpty(detailList)) {
//            return new ArrayList<>();
//        }
//        // 校验日反馈引用
//        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
//        if(CollectionUtils.isEmpty(list)) {
//            return new ArrayList<>();
//        }
//        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
//        List<String> sourceTasks = sourceList.stream().map(T::getStructCode).collect(Collectors.toList());
//        QueryWrapper ew = new QueryWrapper();
//        ew.in("progress_id", ids);
//        ew.in("struct_code", sourceTasks);
//        ew.eq("show_state", 1);// 显示即为引用
//        ew.gt("percent_complete", 0);// 百分比大于0即为有实际数据
//        List<DayFillDetailEntity> fillDetailList = fillDetailService.list(ew);
//        List<String> delTasks = fillDetailList.stream().map(DayFillDetailEntity::getStructCode).collect(Collectors.toList());
//        return delTasks;
//    }

    /**
     * 获取被日反馈引用结构码集合
     * @param sourceList    待校验明细
     * @param projectId     待校验明细，所属项目id
     * @return
     */
    public <T extends ProgressDetailEntity> List<String> transferUseIds(List<T> sourceList, Long projectId) {
        List<DayFillEntity> list = fillService.list(new QueryWrapper<DayFillEntity>().eq("project_id", projectId));
        if(CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        List<Long> ids = list.stream().map(DayFillEntity::getId).collect(Collectors.toList());
        List<String> structCodeList = sourceList.stream().map(T::getStructCode).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(structCodeList)) {
            return new ArrayList<>();
        }
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("progressId", new Parameter(QueryParam.IN, ids));
        // 非末级showState可能为0，用结构码右匹配查询是否显示
        ComplexParam c4 = new ComplexParam();
        c4.setLogic(ComplexParam.AND);
        for(String structCode : structCodeList){
            ComplexParam c5 = new ComplexParam();
            c5.setLogic(ComplexParam.OR);
            c5.getParams().put("structCode", new Parameter(QueryParam.LIKE_RIGHT, structCode));
            c4.getComplexParams().add(c5);
        }
        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("showState", new Parameter(QueryParam.EQ, 1));
        queryParam.getParams().put("actualStart", new Parameter(QueryParam.NE, null));
        List<DayFillDetailEntity> detailList = fillDetailService.queryList(queryParam);
        List<String> delTasks = detailList.stream().map(DayFillDetailEntity::getStructCode).distinct().collect(Collectors.toList());
        Set<String> codeList = new HashSet<>();
        for(String task : delTasks){
            codeList.addAll(structCodeList.stream().filter(task::startsWith).collect(Collectors.toSet()));
        }
        return new ArrayList<>(codeList);
    }

    public void getExecClandars(HashMap hashMap, Long projectId){
        ExecPlanVO execPlan = execService.queryRefDetail(projectId, null , null, null);
        hashMap.put("Calendars", JSONObject.parseArray(execPlan.getCalendars(), Map.class));
        hashMap.put("CalendarUID", execPlan.getCalendarUid());
    }

    public static void main(String[] args) {
        Boolean flag = null;
        System.out.println(!flag);
        List<ExecPlanDetailEntity> detailList = new ArrayList<>();
        ExecPlanDetailEntity vo1 = new ExecPlanDetailEntity();
        vo1.setId(Long.valueOf(1L));
        vo1.setParentId(Long.valueOf(-1));
        vo1.setStructCode("1");
        vo1.setOutlineNumber("1");
        detailList.add(vo1);
        ExecPlanDetailEntity vo2 = new ExecPlanDetailEntity();
        vo2.setId(Long.valueOf(2L));
        vo2.setParentId(Long.valueOf(1L));
        vo2.setStructCode("1&&2");
        vo2.setOutlineNumber("1.1");
        detailList.add(vo2);
        ExecPlanDetailEntity vo3 = new ExecPlanDetailEntity();
        vo3.setId(Long.valueOf(3L));
        vo3.setParentId(Long.valueOf(2L));
        vo3.setStructCode("1&&2&&3");
        vo3.setOutlineNumber("1.1.1");
        detailList.add(vo3);
        ExecPlanDetailEntity vo4 = new ExecPlanDetailEntity();
        vo4.setId(Long.valueOf(4L));
        vo4.setParentId(Long.valueOf(3L));
        vo4.setStructCode("1&&2&&3&&4");
        vo4.setOutlineNumber("1.1.1.1");
        detailList.add(vo4);
        List<Long> delIds = new ArrayList<>();
        delIds.add(1L);
//        delIds.add(2L);
//        delIds.add(3L);
//        delIds.add(4L);
        List<String> delTasks = new ArrayList<>();
        delTasks.add("1");
//        delTasks.add("1&&2");
//        delTasks.add("1&&2&&3");
//        delTasks.add("1&&2&&3&&4");
        List<Long> parentIds = detailList.stream().filter(x->x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId())
                && !delIds.contains(x.getId())).map(x->x.getParentId()).collect(Collectors.toList());
        List<String> parentTasks = detailList.stream().filter(x->parentIds.contains(x.getId()) &&
                delTasks.contains(x.getStructCode())).map(x->x.getOutlineNumber()).collect(Collectors.toList());
        System.out.println("【" + StringUtils.join(parentTasks, "，") + "】计划已被下游引用，无法删除！");
    }

    /**
     * 校验末级关联负责人
     * @param planDetailList
     * @param <T>
     */
    public <T extends BaseDetailVO> void validateEmployee(List<T> planDetailList){
        List<String> parentIds = planDetailList.stream().filter(e -> null != e.getParentTaskUID()).map(T::getParentTaskUID).distinct().collect(Collectors.toList());
        List<T> validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getUid())).collect(Collectors.toList());
        for (T t : validatePlanDetailList){
            Class<? extends BaseDetailVO> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId");
                invoke = getEmployeeId.invoke(t);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (null == invoke){
                throw new BusinessException("您的计划中存在末级任务未关联责任人");
            }
        }
    }

    /**
     * 校验末级关联负责人
     * @param planDetailList
     * @param <T>
     */
    public <T extends ProgressDetailEntity> void validateEmployeeEntity(List<T> planDetailList){
        List<Long> parentIds = planDetailList.stream().filter(e -> null != e.getParentId()).map(T::getParentId).distinct().collect(Collectors.toList());
        List<T> validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getId())).collect(Collectors.toList());
        for (T t : validatePlanDetailList){
            Class<? extends ProgressDetailEntity> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId");
                invoke = getEmployeeId.invoke(t);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (null == invoke){
                throw new BusinessException("您的计划中存在末级任务未关联责任人");
            }
        }
    }

    /**
     * 校验摘要任务的前置任务必须是FS或SS
     * @param planDetailList
     * @param <T>
     */
    public <T extends BaseDetailVO> void validatePredecessorLink(List<T> planDetailList, Long projectId){
        // 执行计划
        ExecPlanEntity data = execService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        if(data == null) {
            return;
        }
        List<ExecPlanDetailEntity> detailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                .eq("progress_id", data.getId()).orderByAsc("tid"));
        Map<String, ExecPlanDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x));
        List<T> sourceList = TreeHelper2.tree2List(planDetailList);
        List<String> parentIds = sourceList.stream().filter(e -> null != e.getParentTaskUID()).map(T::getParentTaskUID).distinct().collect(Collectors.toList());
        List<T> validateList = sourceList.stream().filter(e -> parentIds.contains(e.getUid())).collect(Collectors.toList());
        StringBuilder msg = new StringBuilder();
        Set<ExecPlanDetailEntity> errorList = new HashSet<>();
        for (T t : validateList){
            String structCode = String.valueOf(getValue(t, "structCode"));
            if(!detailMap.containsKey(structCode)){
                continue;
            }
            ExecPlanDetailEntity detail = detailMap.get(structCode);
            if (StringUtils.isEmpty(detail.getPredecessorLink())){
                continue;
            }
            JSONArray predecessorLink = JSON.parseArray(detail.getPredecessorLink());
            for(Object o : predecessorLink) {
                JSONObject obj = (JSONObject) o;
                // 0FF，1FS，2SF，3SS
                if (obj.getInteger("Type") == 0 || obj.getInteger("Type") == 2) {
                    errorList.add(detail);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(errorList)){
            for(ExecPlanDetailEntity detail : errorList){
                msg.append("【" + detail.getName() + "】在执行计划中" + detail.getOutlineNumber() + "前置任务设置为FF或者SF，");
            }
            throw new BusinessException(msg + "不允许分解下级任务！");
        }
    }

    /**
     * get方法
     * @param t
     * @param fieldName
     * @param <T>
     * @return
     */
    private static <T> Object getValue(T t, String fieldName) {
        Class<?> clazz = t.getClass() ;
        for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), (Class[]) null);
                try {
                    return m.invoke(t, (Object[]) null);
                } catch (IllegalAccessException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
                } catch (InvocationTargetException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
                }
            } catch (Exception e) {
                //这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
                //如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
            }
        }
        return null;
    }

    /**
     * 推荐，速度最快
     * 判断是否为整数
     * @param str 传入的字符串
     * @return 是整数返回true,否则返回false
     */
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

}
