package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.mapper.WeekPlanDetailMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.WeekPlanDetailVO;
import com.ejianc.business.plan.vo.WeekPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.WeekPlanMapper;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.service.IWeekPlanService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;

/**
 * 周计划
 * 
 * @author generator
 * 
 */
@Service("weekPlanService")
public class WeekPlanServiceImpl extends BaseServiceImpl<WeekPlanMapper, WeekPlanEntity> implements IWeekPlanService{

    @Autowired
    private IWeekPlanDetailService detailService;
    @Autowired
    private WeekPlanMapper progressMapper;
    @Autowired
    private WeekPlanDetailMapper progressDetailMapper;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMonthPlanService monthPlanService;

    @Autowired
    private IExecPlanService execPlanService;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private CommonHelper commonHelper;

    private static final String BILL_CODE = "ZJKJ_WEEK_PLAN";//此处需要根据实际修改
    
    @Override
    public CommonResponse<WeekPlanVO> saveOrUpdate(WeekPlanVO saveOrUpdateVO) {
        //同一个项目只能存在一个自由态或审批中的单据
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());
        commonHelper.validatePredecessorLink(saveOrUpdateVO.getTasks(), saveOrUpdateVO.getProjectId());
        queryMonthPlan(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getPlanMonth());
        // 主表新增/修改
        OrgVO orgVO = orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        Long tenantId = InvocationInfoProxy.getTenantid();
        WeekPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, WeekPlanEntity.class);
            progressMapper.updateById(progressEntity);
            //子表
            List<WeekPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<WeekPlanDetailVO> saveVOList = new ArrayList<WeekPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if(saveOrUpdateVO.getImportFlag()){
                    detailService.deleteByProgressId(progressEntity.getId());
                }
                for (WeekPlanDetailVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        WeekPlanDetailEntity progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailMapper.insert(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        WeekPlanDetailEntity progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailMapper.updateById(progressDetailEntity);
                    }
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
            //子表删除
            List<WeekPlanDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (WeekPlanDetailVO progressDetailVo : delDetailList) {
                    progressDetailMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            progressEntity = BeanMapper.map(saveOrUpdateVO, WeekPlanEntity.class);
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            progressMapper.insert(progressEntity);
            //子表
            List<WeekPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<WeekPlanDetailVO> saveVOList = new ArrayList<WeekPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,true);

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                for (WeekPlanDetailVO progressDetailVo : saveVOList) {
                    WeekPlanDetailEntity progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    progressDetailMapper.insert(progressDetailEntity);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
        }

        // 生效后更新执行计划
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())
                || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())){
            execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.WEEK_PLAN);
        }

        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    /**
     * 导出根据计划类型查询
     * @param id
     * @return
     */
    public WeekPlanVO queryDetail(Long id) {
        WeekPlanEntity entity = baseMapper.selectById(id);
        //查询子表
        QueryWrapper<WeekPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        List<WeekPlanDetailEntity> detailList = detailService.list(ew);
        WeekPlanVO vo = BeanMapper.map(entity, WeekPlanVO.class);
        if(CollectionUtils.isNotEmpty(detailList)) {
            List<WeekPlanDetailVO> detailVOList = new ArrayList<>();
            for(WeekPlanDetailEntity detail : detailList) {
                detailVOList.add(WeekPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }

    @Override
    public Map getDetail(Long id) {
        WeekPlanVO vo = this.queryDetail(id);
        Map map = new HashMap();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List<WeekPlanDetailVO> detailList = vo.getProgressDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> pkMap = new HashMap<>();
            List<WeekPlanDetailVO> saveVOList = new ArrayList<WeekPlanDetailVO>();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<Map> list = JSONObject.parseArray(jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") != null) {
                    List<Map> link = JSONObject.parseArray(JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                    m.put("PredecessorLink", link);
                }
            }
            key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = vo.getCalendars();
        if (StringUtils.isNotBlank(calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", vo.getPlanEndDate());
        map.put("Name", vo.getProjectName());
        map.put("StartDate", vo.getPlanBeginDate());
        map.put("CalendarUID", vo.getCalendarUid());
        map.put("UID", vo.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public String validateProject(Long projectId, Long billId) {
        //同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<WeekPlanEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前项目下存在非审批通过态的周计划，不允许操作!");
        }
        return "校验通过！";
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request){
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xml".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            HashMap read = PlusUtil.read(file, PlanCloumCons.WEEK_PLAN_CLOUM);
//            Map<String, Map> filed = new HashMap<>();
//            filed.put("taskLine", PlanConstant.TASK_LINE);
//            filed.put("nodeLevel", PlanConstant.NODE_LEVEL);
//            filed.put("unit", PlanConstant.UNIT);
//            filed.put("type", PlanConstant.RESOURCE_TYPE);
//            filed.put("typeUnit", PlanConstant.RESOURCE_UNIT);
            Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList) read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
            HashMap hashMap = PlusUtil.readMain(read, filed);
            Long projectId = Long.valueOf(request.getParameter("project"));
            String planBeginDate = request.getParameter("planBeginDate");
            String planEndDate = request.getParameter("planEndDate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date start = null;
            Date end = null;
            try {
                start = sdf.parse(planBeginDate);
                end = sdf.parse(planEndDate);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            Object tasks = hashMap.get("Tasks");
            Date startDate = DateUtil.beginOfDate(start);
            Date endDate = DateUtil.endOfDate(end);
            // 日历替换成执行计划日历
            commonHelper.getExecClandars(hashMap, projectId);
            Object o = execPlanService.converMap(tasks,startDate,endDate,projectId);
            hashMap.put("Tasks",o);
            return CommonResponse.success("导入成功！", hashMap);
        }
    }

    @Override
    public String queryMonthPlan(Long projectId,Date planMonth) {
        LocalDate date = LocalDate.now();
        LocalDate firstDayThisMonth = date.withDayOfMonth(1);
        QueryWrapper<MonthPlanEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.eq("dr",0);
        wrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        wrapper.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        if (planMonth != null){
            date = planMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1);
            wrapper.eq("plan_month",date);
        }else {
            date = firstDayThisMonth;
            wrapper.eq("plan_month",date);
        }
        List<MonthPlanEntity> list = monthPlanService.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("当前项目下无审批通过的" + date.getMonthValue() +"月份的月计划，无法新增周计划!");
        }
        return "校验通过！";
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            key2Value(map, "unit", PlanConstant.UNIT);
            key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap) dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }
}
