package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.YearPlanChangeMapper;
import com.ejianc.business.plan.mapper.YearPlanDetailChangeMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.TotalPlanChangeVO;
import com.ejianc.business.plan.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.plan.vo.YearPlanChangeVO;
import com.ejianc.business.plan.vo.YearPlanDetailChangeVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.YearPlanChangeMapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 年计划变更
 * 
 * @author generator
 * 
 */
@Service("yearPlanChangeService")
public class YearPlanChangeServiceImpl extends BaseServiceImpl<YearPlanChangeMapper, YearPlanChangeEntity> implements IYearPlanChangeService{

    @Autowired
    private YearPlanChangeMapper changeMapper;
    @Autowired
    private YearPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private IYearPlanDetailChangeService detailChangeService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IYearPlanDetailService yearPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<YearPlanChangeVO> saveOrUpdate(YearPlanChangeVO saveOrUpdateVO) {

        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());

        // todo 是否有校验
        Long tenantId = InvocationInfoProxy.getTenantid();
        YearPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, YearPlanChangeEntity.class);
            changeMapper.updateById(progressEntity);

            //子表
            List<YearPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<YearPlanDetailChangeVO> saveVOList = new ArrayList<YearPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if(saveOrUpdateVO.getImportFlag()){
                    detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }

                List<YearPlanDetailChangeEntity> planEntityList = new ArrayList<>();
                for (YearPlanDetailChangeVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        YearPlanDetailChangeEntity progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        YearPlanDetailChangeEntity progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.updateById(progressDetailEntity);
                    }
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            //子表删除
            List<YearPlanDetailChangeVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (YearPlanDetailChangeVO progressDetailVo : delDetailList) {
                    detailChangeMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            YearPlanEntity totalPlanEntity = yearPlanService.selectById(saveOrUpdateVO.getYearId());
            if(totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING){
                throw new BusinessException("存在变更中单据，不允许保存!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, YearPlanChangeEntity.class);
            progressEntity.setId(masterPkId);
            changeMapper.insert(progressEntity);

            //子表
            List<YearPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<YearPlanDetailChangeVO> saveVOList = new ArrayList<YearPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<YearPlanDetailChangeEntity> planEntityList = new ArrayList<>();
                for (YearPlanDetailChangeVO progressDetailVo : saveVOList) {
                    YearPlanDetailChangeEntity progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
            LambdaUpdateWrapper<YearPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(YearPlanEntity::getChangeId, progressEntity.getId());
            updateWrapper.set(YearPlanEntity::getChangeStatus, PlanConstant.CHANGE_ING);
            updateWrapper.set(YearPlanEntity::getChangeCode, progressEntity.getBillCode());
            updateWrapper.eq(YearPlanEntity::getId, progressEntity.getYearId());
            yearPlanService.update(updateWrapper);
        }
        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public YearPlanChangeVO queryDetail(Long id) {
        YearPlanChangeEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<YearPlanDetailChangeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<YearPlanDetailChangeEntity> progressDetailList = detailChangeService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        YearPlanChangeVO progressVo = BeanMapper.map(progressEntity, YearPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<YearPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (YearPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                YearPlanDetailChangeVO changeVO = YearPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public YearPlanChangeVO queryDetailChange(Long id) {
        YearPlanEntity progressEntity = yearPlanService.selectById(id);
        YearPlanChangeVO vo = BeanMapper.map(progressEntity, YearPlanChangeVO.class);
        //查询子表
        QueryWrapper<YearPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<YearPlanDetailEntity> progressDetailList = yearPlanDetailService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<YearPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (YearPlanDetailEntity progressDetailEntity : progressDetailList) {
                YearPlanDetailChangeEntity changeDetailEntity = BeanMapper.map(progressDetailEntity, YearPlanDetailChangeEntity.class);
                changeDetailEntity.setYearId(changeDetailEntity.getProgressId());
                changeDetailEntity.setYearBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                YearPlanDetailChangeVO changeVO = YearPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setYearId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(vo.getChangeVersion() + 1);
        return vo;
    }

    @Override
    public void deleteYearPlan(List<YearPlanChangeVO> vos) {
        for (YearPlanChangeVO vo : vos) {
            YearPlanChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<YearPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(YearPlanEntity::getChangeStatus, PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(YearPlanEntity::getChangeStatus, PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(YearPlanEntity::getId, changeEntity.getYearId());
            yearPlanService.update(updateWrapper);
            super.removeById(vo, false);
            detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<YearPlanChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<YearPlanChangeEntity> changeEntities = baseMapper.selectList(new QueryWrapper<YearPlanChangeEntity>()
                .eq("year_id", id)
                .in("bill_state", billStatus).orderByDesc("approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<YearPlanChangeVO> changeVos = BeanMapper.mapList(changeEntities, YearPlanChangeVO.class);
            for (YearPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(YearPlanChangeVO vo) {
        Long projectId = vo.getProjectId();
        List<Long> ids = vo.getIds();
        LambdaQueryWrapper<YearPlanDetailEntity> ylambd = new LambdaQueryWrapper<>();
        // 默认查询本下，解决父级删除和新增下级，只变更本计划数据，校验不通过的问题
        ylambd.and(x->x.in(YearPlanDetailEntity::getId, ids).or().in(YearPlanDetailEntity::getParentId, ids));
        List<YearPlanDetailEntity> list = yearPlanDetailService.list(ylambd);
        Boolean isDel = true;// 默认删除
        if ("addLower".equals(vo.getDelFlag())){
            isDel = null;// 新增下级
        }
        return commonHelper.transferDelIds(list, projectId, PlanConstant.YEAR_PLAN, isDel);
    }
    
}
