package com.ejianc.business.progress.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 风险纠偏
 * 
 * @author generator
 * 
 */
public interface IRiskCorrectionService extends IBaseService<RiskCorrectionEntity> {

    CommonResponse<RiskCorrectionVO> saveOrUpdate(RiskCorrectionVO saveorUpdateVO);

    RiskCorrectionVO queryDetail(Long id);

    Map<Long,RiskCorrectionVO> getRisk(Long yearId);

    CommonResponse<JSONObject> queryRiskList(QueryParam param);

    CommonResponse<String> drawTask(RiskCorrectionHistoryVO historyVO);

    CommonResponse<String> returnTask(RiskCorrectionHistoryVO historyVO);

    CommonResponse<String> acceptTask(List<RiskCorrectionHistoryVO> historyVOs);

    CommonResponse<String> progressTask(RiskCorrectionVO vo);

    CommonResponse<JSONObject> queryDrawRisk(QueryParam param);

    CommonResponse<JSONObject> dataCount(Boolean dataCountFlag);

    CommonResponse<JSONObject> queryRiskReport(QueryParam param);

    Map<Long, RiskCorrectionEntity> queryRiskByYearId(Long yearId);

    Map<Long,RiskCorrectionVO> getRiskByYearBid(List<Long> yearBidList);

    void handleTopData();

}
