package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.progress.bean.*;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.mapper.RiskCorrectionMapper;
import com.ejianc.business.progress.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 延误纠偏消息发送
 *
 * @author generator
 */
@Service("riskMsgService")
public class RiskMessageServiceImpl extends BaseServiceImpl<RiskCorrectionMapper, RiskCorrectionEntity> implements IRiskMessageService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IRiskCorrectionService riskService;

    @Autowired
    private IRiskCorrectionDetailService riskDetailService;

    @Autowired
    private IRiskCorrectionHistoryService historyService;

    @Autowired
    private IPushSetService pushSetService;

    @Autowired
    private IPushSetReceiveService receiveService;

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectPoolApi projectApi;

    @Autowired
    private WarnFeignUtil feignUtil;

    @Override
    public CommonResponse riskWarn(HttpServletRequest request) {
        logger.info("--> 纠偏预警开始");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.add(Calendar.DAY_OF_MONTH, 1);
        String nextDay = sf.format(c.getTime());

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("handleStatus", new Parameter(QueryParam.NE, "2"));
        queryParam.getParams().put("finishTime", new Parameter(QueryParam.LT, nextDay));
        List<RiskCorrectionDetailEntity> detailList = riskDetailService.queryList(queryParam);
        if(CollectionUtils.isEmpty(detailList)){
            logger.info("未查到待预警延误纠偏！");
            return CommonResponse.success("未查到待预警延误纠偏！");
        }
        List<Long> ids = detailList.stream().map(RiskCorrectionDetailEntity::getRiskId).distinct().collect(Collectors.toList());
        Collection<RiskCorrectionEntity> riskList = riskService.listByIds(ids);
        Map<Long, RiskCorrectionEntity> riskMap = riskList.stream().collect(Collectors.toMap(RiskCorrectionEntity::getId, Function.identity()));

        Map<Long, List<String>> senderMap = new HashMap<>();
        for(RiskCorrectionDetailEntity detail : detailList){
            Long riskId = detail.getRiskId();
            String createUserId = detail.getCreateUserId().toString();
            List<String> list = new ArrayList<>();
            if(!senderMap.containsKey(riskId)){
                list.add(createUserId);
                senderMap.put(riskId, list);
            } else {
                list = senderMap.get(riskId);
                if(!list.contains(createUserId)){
                    list.add(createUserId);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(senderMap)) {
            // 信息发送类型
            List<String> messageType = new ArrayList<>();
            messageType.add("sys");
//            messageType.add("weChat");
            String formurl = baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingList";
            for(Long key : senderMap.keySet()) {
                List<String> sender = senderMap.get(key);
                if(!riskMap.containsKey(key)){
                    continue;
                }
                RiskCorrectionEntity risk = riskMap.get(key);
                StringBuffer buffer = new StringBuffer();
                buffer.append("【" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + getLevelName(risk.getNodeLevel()) + "】");
                buffer.append("延误纠偏措施即将逾期，请登录PC端处理！");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            };
        }
        logger.info("执行成功！");
        return CommonResponse.success("执行成功！");
    }

    /**
     * 根据推送设置发送消息
     * @param risk 延误纠偏实体
     * @param orgId 待处理组织
     * @return
     */
    @Override
    public Boolean riskByPushSet(RiskCorrectionEntity risk, Long orgId) {
        logger.info("--> 推送设置发送消息开始");
        if(risk.getProjectId() == null){
            logger.info("项目为空！");
            return true;
        }
        CommonResponse<ProjectVO> projectResp = projectApi.queryDetailById(risk.getProjectId());
        if(!projectResp.isSuccess()){
            throw new BusinessException("网络问题，请重新查询！");
        }
        CommonResponse<List<OrgVO>> orgResp = orgApi.findParentsByOrgId(orgId);
        if(!orgResp.isSuccess()){
            throw new BusinessException("网络问题，请重新查询！");
        }
        // 推送设置
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("org_id", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));// 组织本上
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        List<PushSetEntity> setList = pushSetService.queryList(queryParam);
        if(CollectionUtils.isEmpty(setList)){
            logger.info("未查到推送设置！");
            return true;
        }
        Map<Long, PushSetEntity> setMap = setList.stream().collect(Collectors.toMap(PushSetEntity::getId, Function.identity()));
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("setId", new Parameter(QueryParam.IN, setList.stream().map(PushSetEntity::getId).collect(Collectors.toList())));
        List<PushSetReceiveEntity> receiveList = receiveService.queryList(queryParam2);

        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");

        String formurl = baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingList";
        for(PushSetReceiveEntity receive : receiveList){
            if(!LevelEnum.末级.getCode().equals(receive.getLevel()) || !LightTypeEnum.紫灯.getCode().equals(receive.getLightType())){
                continue;
            }
            PushSetEntity set = setMap.get(receive.getSetId());
//            if(set.getIndustryTypeId() != null && !set.getIndustryTypeId().equals(projectResp.getData().getEngineeringType())){
//                continue;
//            }
            StringBuffer str = new StringBuffer();
            str.append("【" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + getLevelName(risk.getNodeLevel()) + "】");
            str.append("延误纠偏措施即将逾期，请登录PC端处理！");

            List<String> sender = new ArrayList<>();
            if(receive.getReceiveType().equals("user")){
                sender = Arrays.asList(String.valueOf(receive.getReceiveId()));
            }
            if(receive.getReceiveType().equals("role")){
                CommonResponse<List<RoleUserRelationVO>> response = roleApi.getRoleUser(Arrays.asList(receive.getReceiveId()),Arrays.asList(orgId));
                if(!response.isSuccess()){
                    throw new BusinessException("网络问题，请重新查询！");
                }
                sender = response.getData().stream().map(RoleUserRelationVO:: getUserId).map(String::valueOf).collect(Collectors.toList());
            }

            if(CollectionUtils.isNotEmpty(sender)){
                String subject = str.toString();
                String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
        }
        logger.info("执行成功！");
        return true;
    }

    /**
     * 已完成消息推送
     * @param riskId
     * @return
     */
    @Override
    public Boolean riskFinish(Long riskId) {
        logger.info("--> 推送设置发送消息开始");
        RiskCorrectionEntity risk = riskService.selectById(riskId);
        if(!"3".equals(risk.getHandleStatus())){
            logger.info("延误纠偏未完成！");
            return true;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("risk_id", new Parameter(QueryParam.EQ, riskId));
        List<RiskCorrectionHistoryEntity> list = historyService.queryList(queryParam);
        List<Long> userIds = new ArrayList<>();
        list.forEach(vo->{
            if(!InvocationInfoProxy.getUserid().equals(vo.getUserId()) && !userIds.contains(vo.getUserId())){
                userIds.add(vo.getUserId());
            }
        });
        if(CollectionUtils.isNotEmpty(userIds)) {
            // 信息发送类型
            List<String> messageType = new ArrayList<>();
            messageType.add("sys");
//            messageType.add("weChat");

            StringBuffer str = new StringBuffer();
            str.append("【" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + getLevelName(risk.getNodeLevel()) + "】");
            str.append("纠偏已经完成，请登录PC端查看详情！");
            List<String> sender = userIds.stream().map(String::valueOf).collect(Collectors.toList());
            String subject = str.toString();
            String formurl = baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingDetail?id=" + riskId;
            String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        logger.info("执行成功！");
        return true;
    }

    private static String getLevelName(Integer level) {
        String levelName = "";
        if(level == null) return levelName;
        switch(level){
            case 1:
                levelName = "一级";
                break;
            case 2:
                levelName = "二级";
                break;
            case 3:
                levelName = "三级";
                break;
            case 4:
                levelName = "合同";
                break;
            case 5:
                levelName = "纠偏";
                break;
            default:
                levelName = "";
                break;
        }
        return levelName;
    }
}
