package com.ejianc.business.progress.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.vo.ProgressDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TreeHelper {
	
	public static List<ProgressDetailVO> list2Tree(List<ProgressDetailVO> list) {
		List<ProgressDetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, ProgressDetailVO> listMap = new HashMap<>();
		for(ProgressDetailVO progressDetailVo:list) {
			listMap.put(progressDetailVo.getUid().toString(), progressDetailVo);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ProgressDetailVO progressDetailVo = list.get(i);
        	String parentId = StringUtils.isNotBlank(progressDetailVo.getParentTaskUID()) ? progressDetailVo.getParentTaskUID():"";
        	ProgressDetailVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ProgressDetailVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(progressDetailVo);
        		}else{
        			List<ProgressDetailVO> children = new ArrayList<ProgressDetailVO>();
        			children.add(progressDetailVo);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(progressDetailVo.getUid().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

	public static void tree2List(List<ProgressDetailVO> tree){
		Map<String, Long> pkMap = new HashMap<>();
		List<ProgressDetailVO> list = new ArrayList<>();
		getPkMap(pkMap, tree);
		tree2List(pkMap, list, tree);
	}

	public static void tree2List(Map<String,Long> pkMap, List<ProgressDetailVO> list, List<ProgressDetailVO> tree){
		getPkMap(pkMap, tree);
		tree2List(pkMap, list, tree, null);
	}

	/**
	 * 循环遍历获取主键Map
	 * @param pkMap
	 * @param tree
	 */
	private static void getPkMap(Map<String,Long> pkMap, List<ProgressDetailVO> tree) {
		for (int i = 0, len = tree.size(); i < len; i++) {
			ProgressDetailVO progressVo = tree.get(i);
			Long pkId = IdWorker.getId();
			if(!"added".equals(progressVo.get_state())) {
				pkId = Long.valueOf(progressVo.getUid());
			}
			pkMap.put(progressVo.getUid(), pkId);
			List<ProgressDetailVO> children = progressVo.getChildren();
			if (children != null && children.size() > 0) {
				getPkMap(pkMap, children);
			}
		}
	}

	private static void tree2List(Map<String,Long> pkMap, List<ProgressDetailVO> list, List<ProgressDetailVO> tree, String parentCode) {
		List<String> codeSet = tree.stream().filter(x->StringUtils.isNotEmpty(x.getCode())).map(ProgressDetailVO::getCode).collect(Collectors.toList());
		for (int i = 0, len = tree.size(); i < len; i++) {
			ProgressDetailVO progressVo = tree.get(i);
			if(pkMap.containsKey(progressVo.getUid())){
				progressVo.setUid(pkMap.get(progressVo.getUid()).toString());
			}
			// 编码如果为空，默认等于序号，同级不能重复，如果重复取序号最大值加1
			if(StringUtils.isEmpty(progressVo.getCode())){
				String code = String.valueOf(progressVo.getId());
				if(codeSet.contains(code)){
					Integer maxCode = codeSet.stream().filter(x->isInteger(x)).map(x->Integer.valueOf(x)).max(Integer::compare).orElse(0);
					code = String.valueOf(maxCode + 1);
				}
				codeSet.add(code);
				progressVo.setCode(code);
			} else {
				Long count = codeSet.stream().filter(x->x.equals(progressVo.getCode())).count();
				if(count > 1){
					throw new BusinessException("存在重复编码！");
				}
			}
			// 结构码
			progressVo.setStructCode(parentCode != null ? parentCode + "@@" + progressVo.getCode() : progressVo.getCode());
			if(StringUtils.isNotBlank(progressVo.getParentTaskUID())) {
				if(pkMap.containsKey(progressVo.getParentTaskUID())) {
					progressVo.setParentTaskUID(pkMap.get(progressVo.getParentTaskUID()) + "");
				}
			}
			// 默认开始时间早上8点，结束时间下午5点
			progressVo.setStart(DateUtil.setHours(progressVo.getStart(), 8));
			progressVo.setFinish(DateUtil.setHours(progressVo.getFinish(), 17));
			// 限制时间
			if(progressVo.getConstraintDate() != null){
				progressVo.setConstraintDate(DurationUtil.getConstraintDate(progressVo.getStart(), progressVo.getFinish(), progressVo.getConstraintType()));
			}
			if(progressVo.getPredecessorLink() != null && progressVo.getPredecessorLink().size() > 0) {
				for(int j=0;j<progressVo.getPredecessorLink().size();j++) {
					JSONObject predecessorLinkObj = progressVo.getPredecessorLink().getJSONObject(j);
					String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
					if(pkMap.containsKey(PredecessorUID)) {
						predecessorLinkObj.put("PredecessorUID", pkMap.get(PredecessorUID));
					}
					String TaskUID = predecessorLinkObj.getString("TaskUID");
					if(pkMap.containsKey(TaskUID)) {
						predecessorLinkObj.put("TaskUID", pkMap.get(TaskUID));
					}
				}
			}
			if(progressVo.getAssignments() != null && progressVo.getAssignments().size() > 0) {
				for(int j=0;j<progressVo.getAssignments().size();j++) {
					JSONObject assignmentsObj = progressVo.getAssignments().getJSONObject(j);
					String TaskUID = assignmentsObj.getString("TaskUID");
					if(pkMap.containsKey(TaskUID)) {
						assignmentsObj.put("TaskUID", pkMap.get(TaskUID));
					}
				}
			}
			List<ProgressDetailVO> children = progressVo.getChildren();
			if (children != null && children.size() > 0) {
				tree2List(pkMap, list, children, progressVo.getStructCode());
			}
			progressVo.setChildren(null);
			list.add(progressVo);
		}
	}

	/**
	 * 推荐，速度最快
	 * 判断是否为整数
	 * @param str 传入的字符串
	 * @return 是整数返回true,否则返回false
	 */

	public static boolean isInteger(String str) {
		Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
		return pattern.matcher(str).matches();
	}
}
