/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.HttpDelTookit;
import com.ejianc.business.bim.helper.JSONHelper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenHelper {
    private static Logger logger = LoggerFactory.getLogger(TokenHelper.class);
    public static final String BASE_HOST = "https://xbase.ccstc-online.com:4433";
    private static final String APP_ID = "38ca8eb61b94d568577bba58902ce2e4";
    private static final String SECURITY_KEY = "a19b1b8b1ab43353bf29a4e241e1add5";
    public static final String TOKEN = "TOKEN";
    public static final String VIEWER_TOKEN = "VIEWER_TOKEN";
    private static TokenHelper helper;

    private TokenHelper() {
    }

    @PostConstruct
    public void init() {
        helper = this;
        if (logger == null) {
            logger = LoggerFactory.getLogger(TokenHelper.class);
        }
    }

    public static JSONObject getTokenData() throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("app_key", SECURITY_KEY);
        JSONObject json = null;
        try {
            String response = HttpTookit.postByJson((String)"https://xbase.ccstc-online.com:4433/api/xbase/v1/app/token", (String)JSONObject.toJSONString(params));
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        json = JSONHelper.castDataJson(json, JSONObject.class);
        TokenHelper.toLocalCache(json);
        return json;
    }

    public static JSONObject getViewerToken(String fileId) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", APP_ID);
        params.put("app_key", SECURITY_KEY);
        params.put("file_id", fileId);
        params.put("viewer_type", "model");
        JSONObject json = null;
        try {
            String response = HttpTookit.postByJson((String)"https://xbase.ccstc-online.com:4433/api/xbase/v1/viewer/token", (String)JSONObject.toJSONString(params));
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        json = JSONHelper.castDataJson(json, JSONObject.class);
        if (json == null || !json.containsKey((Object)"token")) {
            return json;
        }
        CacheHelper.put("VIEWER_TOKEN:" + fileId, "Bear " + json.getString("token"));
        return json;
    }

    private static void toLocalCache(JSONObject json) {
        CacheHelper.put(TOKEN, "Bear " + json.getString("token"));
    }

    public static JSONObject getFileStatus(String path) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/fs/status";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpTookit.get((String)url, params, headers);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.get((String)url, params, headers);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static JSONObject getTokenExpiry(String token) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/token/expiry";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        JSONObject json = null;
        try {
            String response = HttpTookit.postFormByJson((String)url, null, headers);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("\u8fd4\u56de\u5927\u8c61\u4e91\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)json);
        return json;
    }

    public static JSONObject getViewerStatus(String path, String viewerToken) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/viewer/model/status";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", path);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", viewerToken);
        JSONObject json = null;
        try {
            String response = HttpTookit.get((String)url, params, headers);
            response = JSONHelper.toJsonString(response);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("\u8fd4\u56de\u5927\u8c61\u4e91\u67e5\u8be2\u7ed3\u679c\uff1a{}", json);
        return json;
    }

    public static JSONObject delFile(String path) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/fs/dx/api/f/v1/file?path=" + path;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpDelTookit.deleteByJson(url, params);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return json;
    }

    public static JSONObject delFileBatch(String[] ids) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/batch";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", APP_ID);
        params.put("ids", ids);
        params.put("is_sure", true);
        JSONObject json = null;
        try {
            String response = HttpDelTookit.deleteByJson(url, params, headers);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpDelTookit.deleteByJson(url, params, headers);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("\u8fd4\u56de\u5927\u8c61\u4e91\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)json);
        return json;
    }

    public static JSONObject getFileTree(String path) throws BusinessException {
        return TokenHelper.getFileTree(path, "tree");
    }

    public static JSONObject getFileTree(String path, String format) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/fs/property/tree";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpTookit.get((String)url, params, headers);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.get((String)url, params, headers);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static JSONObject getFile(String fileId, String path) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/viewer/model";
        HashMap<String, String> headers = new HashMap<String, String>();
        String key = "VIEWER_TOKEN:" + fileId;
        headers.put("Authorization", String.valueOf(CacheHelper.get(key)));
        headers.put("extension", ".asm");
        headers.put("Content-Type", "text/plain; charset=utf-8");
        headers.put("maxFileSize", "-1");
        headers.put("maxFileSizeMob", "-1");
        headers.put("maxTriangleCount", "-1");
        headers.put("maxTriangleCountMobile", "-1");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpTookit.get((String)url, params, headers);
            response = JSONHelper.toJsonString(response);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10000010"))) {
                TokenHelper.getViewerToken(fileId);
                headers.put("Authorization", String.valueOf(CacheHelper.get(key)));
                response = HttpTookit.get((String)url, params, headers);
                response = JSONHelper.toJsonString(response);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return json;
    }

    public static JSONObject getFileCheck(String fileName, String parentId) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/name/check";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        JSONObject params = new JSONObject();
        params.put("app_id", (Object)APP_ID);
        params.put("is_folder", (Object)false);
        params.put("model_name", (Object)fileName);
        params.put("parent_id", (Object)(StringUtils.isNotBlank((CharSequence)parentId) ? parentId : APP_ID));
        JSONObject json = null;
        try {
            String response = HttpTookit.postByJson((String)url, (String)params.toJSONString(), headers, (Integer)10000, (Integer)10000);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.postByJson((String)url, (String)params.toJSONString(), headers, (Integer)10000, (Integer)10000);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return json;
    }

    public static String download(String modelId) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/download";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("model_id", modelId);
        String response = null;
        try {
            response = HttpTookit.get((String)url, params, headers);
            JSONObject json = JSONHelper.parseObject(response);
            if (json != null && json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.get((String)url, params, headers);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return response;
    }

    public static JSONObject getFileList(String parentId) throws BusinessException {
        String url = "https://xbase.ccstc-online.com:4433/api/xbase/v1/model/models";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parent_id", parentId);
        params.put("page_num", 1);
        params.put("page_size", 1000);
        params.put("order_by", 1);
        params.put("sort_by", 1);
        params.put("app_id", APP_ID);
        JSONObject json = null;
        try {
            String response = HttpTookit.get((String)url, params, headers);
            json = JSONObject.parseObject((String)response);
            if (json.getInteger("code").equals(new Integer("10010001"))) {
                TokenHelper.getTokenData();
                headers.put("Authorization", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.get((String)url, params, headers);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static void main(String[] args) {
        ArrayList<String> modelIds = new ArrayList<String>();
        modelIds.add("a657068f2b924913ac11aefd13d94c6a");
        JSONObject json1 = TokenHelper.getViewerToken("a901e0decd144e74bb8945c490442d7c");
        System.out.println(json1);
    }
}

