/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.fill.bean.ContractLightEntity;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.bean.MonthLightEntity;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.bean.ProjectTrendEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.mapper.ProjectLightMapper;
import com.ejianc.business.fill.service.IContractLightService;
import com.ejianc.business.fill.service.IMonthFillService;
import com.ejianc.business.fill.service.IMonthLightService;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.service.IProjectTrendService;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.fill.vo.ProjectDynamicVO;
import com.ejianc.business.fill.vo.ProjectLightVO;
import com.ejianc.business.fill.vo.ProjectTrendVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectLightService")
public class ProjectLightServiceImpl
extends BaseServiceImpl<ProjectLightMapper, ProjectLightEntity>
implements IProjectLightService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IProjectTrendService projectTrendService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IMonthLightService monthLightService;
    @Autowired
    private IContractLightService contractLightService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMonthFillService monthFillService;
    @Autowired
    private IBimDetailExecService bimExecService;
    @Autowired
    private ILightRuleService lightRuleService;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private WarnFeignUtil feignUtil;

    @Override
    public JSONObject projectList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        String text = param.getSearchText();
        Map params = param.getParams();
        ArrayList<Integer> criticalPath = new ArrayList<Integer>();
        if (params.get("criticalPath") != null) {
            String[] split;
            for (String s : split = ((String)((Parameter)params.get("criticalPath")).getValue()).split(",")) {
                criticalPath.add(Integer.parseInt(s));
            }
        }
        ArrayList<Integer> lightType = new ArrayList<Integer>();
        if (params.get("lightType") != null) {
            String[] split;
            for (String s : split = ((String)((Parameter)params.get("lightType")).getValue()).split(",")) {
                lightType.add(Integer.parseInt(s));
            }
        }
        LinkedHashMap orderMap = param.getOrderMap();
        String ordetType = "asc";
        if (orderMap.containsKey("diffValue")) {
            ordetType = (String)orderMap.get("diffValue");
        }
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        JSONObject page = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProjectVO> vos = this.getProjects(param);
        if (vos.size() < 1) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        Map<Long, ProjectVO> projectMap = vos.stream().collect(Collectors.toMap(BaseVO::getId, x -> x));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("in", new ArrayList<Long>(projectMap.keySet())));
        List list = super.queryList(queryParam);
        Map<Long, ProjectLightEntity> lightEntityMap = list.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, x -> x));
        List execList = this.execPlanService.queryList(queryParam);
        List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
        Map<Object, Object> bimMap = new HashMap();
        if (CollectionUtils.isNotEmpty(execIds)) {
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter("in", execIds));
            List execDetailList = this.execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo -> {
                if (execMap.containsKey(vo.getProjectId())) {
                    List<ExecPlanDetailEntity> detail = ((ExecPlanEntity)((Object)((Object)execMap.get(vo.getProjectId())))).getAllList();
                    detail.add((ExecPlanDetailEntity)((Object)vo));
                }
            });
            QueryParam bimParam = new QueryParam();
            bimParam.getParams().put("exec_id", new Parameter("in", execIds));
            List bimList = this.bimExecService.queryList(bimParam);
            bimMap = bimList.stream().collect(Collectors.groupingBy(BimDetailExecEntity::getExecId));
        }
        queryParam.getOrderMap().put("create_time", "desc");
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List monthList = this.monthFillService.queryList(queryParam);
        HashMap<Long, MonthFillEntity> monthMap = new HashMap<Long, MonthFillEntity>();
        for (MonthFillEntity month : monthList) {
            if (monthMap.containsKey(month.getProjectId())) continue;
            monthMap.put(month.getProjectId(), month);
        }
        queryParam.getParams().remove("billState");
        queryParam.getOrderMap().put("create_time", "asc");
        List projectTrendList = this.projectTrendService.queryList(queryParam);
        Map<Long, List<ProjectTrendEntity>> trendMap = projectTrendList.stream().collect(Collectors.groupingBy(ProjectTrendEntity::getProjectId));
        ArrayList<ProjectLightVO> res1 = new ArrayList<ProjectLightVO>();
        for (Long projectId : projectMap.keySet()) {
            ProjectLightEntity entity = lightEntityMap.get(projectId);
            ProjectVO project = projectMap.get(projectId);
            ProjectLightVO projectLightVO = new ProjectLightVO();
            projectLightVO.setProjectDepartmentId(project.getProjectDepartmentId());
            projectLightVO.setProjectId(projectId);
            projectLightVO.setId(projectId);
            projectLightVO.setProjectName(project.getProjectName());
            projectLightVO.setProjectManager(project.getLeader());
            projectLightVO.setProjectManagerName(this.orgUtil.getCreateUserName(projectLightVO.getProjectManager()));
            projectLightVO.setProjectControlLevel(project.getProjectControlLevel());
            projectLightVO.setStartDate(project.getStartDate());
            projectLightVO.setEndDate(project.getEndDate());
            projectLightVO.setActualStartDate(project.getActualStartDate());
            projectLightVO.setActualEndDate(project.getActualEndDate());
            projectLightVO.setContractualModel(project.getContractualModel());
            projectLightVO.setBuiltArea(project.getBuiltArea());
            projectLightVO.setSelfConstructionContractAmount(ComputeUtil.safeDiv((BigDecimal)project.getSelfConstructionContractAmount(), (BigDecimal)new BigDecimal("10000")));
            projectLightVO.setCriticalPath(entity == null ? PlanConstant.INTEGER_NO : entity.getCriticalPath());
            projectLightVO.setDiffValue(entity == null ? null : entity.getDiffValue());
            projectLightVO.setSumWarn(entity == null ? null : entity.getSumWarn());
            projectLightVO.setLightType(entity == null ? null : entity.getLightType());
            ExecPlanEntity exec = execMap.get(projectId);
            if (null == exec) continue;
            List<ExecPlanDetailEntity> detailList = exec.getAllList();
            Date minPredictStart = detailList.stream().map(ExecPlanDetailEntity::getPredictStart).min(Comparator.comparing(e -> e)).get();
            Date maxPredictFinish = detailList.stream().map(ExecPlanDetailEntity::getPredictFinish).max(Comparator.comparing(e -> e)).get();
            projectLightVO.setMinPredictStart(minPredictStart);
            projectLightVO.setMaxPredictFinish(maxPredictFinish);
            projectLightVO.setPlanEndDate(exec.getPlanEndDate());
            String connectState = bimMap.containsKey(exec.getId()) && CollectionUtils.isNotEmpty((Collection)((Collection)bimMap.get(exec.getId()))) ? "\u5df2\u5173\u8054" : "\u672a\u5173\u8054";
            projectLightVO.setConnectState(connectState);
            MonthFillEntity month = (MonthFillEntity)((Object)monthMap.get(projectId));
            if (month != null) {
                projectLightVO.setSignDays(month.getSignDays());
                projectLightVO.setWaitDays(month.getWaitDays());
                projectLightVO.setImageShows(month.getImageShows());
                projectLightVO.setReason(month.getReason());
                projectLightVO.setMeasure(month.getMeasure());
            }
            Integer diffDays = ProjectLightServiceImpl.subInteger(projectLightVO.getDiffValue() != null ? Integer.valueOf(projectLightVO.getDiffValue().intValue()) : null, projectLightVO.getSignDays());
            projectLightVO.setDiffDays(diffDays);
            Integer planDays = ProjectLightServiceImpl.subInteger(diffDays, projectLightVO.getWaitDays());
            projectLightVO.setPlanDays(planDays);
            Integer days = DateUtil.getSubDay(projectLightVO.getEndDate(), projectLightVO.getStartDate());
            BigDecimal performanceRate = ComputeUtil.safeMultiply((BigDecimal)new BigDecimal("100"), (BigDecimal)ComputeUtil.safeSub((BigDecimal)new BigDecimal("1"), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)(diffDays != null ? new BigDecimal(diffDays.toString()) : null), (BigDecimal)(days != null ? new BigDecimal(days.toString()) : null))));
            projectLightVO.setDuration(days);
            projectLightVO.setPerformanceRate(performanceRate);
            List<ProjectTrendEntity> trendList = trendMap.get(projectId);
            if (CollectionUtils.isNotEmpty(trendList)) {
                List projectTrendVOS = BeanMapper.mapList(trendList, ProjectTrendVO.class);
                projectLightVO.setProjectTrendList(projectTrendVOS);
            }
            boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)text) && !flag && projectLightVO.getProjectName().indexOf(text) == -1 && (StringUtils.isBlank((CharSequence)projectLightVO.getCorpName()) || projectLightVO.getCorpName().indexOf(text) == -1)) {
                flag = true;
            }
            if (criticalPath.size() > 0 && !criticalPath.contains(projectLightVO.getCriticalPath())) {
                flag = true;
            }
            if (lightType.size() > 0 && !lightType.contains(projectLightVO.getLightType())) {
                flag = true;
            }
            if (flag) continue;
            res1.add(projectLightVO);
        }
        this.orderMapToSort(res1, ordetType);
        ArrayList<Long> deptIds = new ArrayList<Long>();
        for (int i = 0; i < res1.size(); ++i) {
            deptIds.add(((ProjectLightVO)res1.get(i)).getProjectDepartmentId());
        }
        Map<Long, OrgVO> listByIds = this.orgUtil.findListByIds(deptIds);
        res1.stream().forEach(vo -> {
            OrgVO orgVO = (OrgVO)listByIds.get(vo.getProjectDepartmentId());
            vo.setCorpId(orgVO == null ? null : orgVO.getId());
            vo.setCorpName(orgVO == null ? null : orgVO.getName());
        });
        if (size == -1) {
            page.put("records", res1);
            page.put("total", (Object)res1.size());
            page.put("current", (Object)1);
            page.put("size", (Object)-1);
            page.put("pages", (Object)1);
            return page;
        }
        total = res1.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList res = new ArrayList();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            res.add(res1.get(i));
        }
        page.put("records", res);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    private List<ProjectVO> getProjects(QueryParam param) {
        param.getParams().put("project_status", new Parameter("eq", (Object)1));
        param.getParams().remove("criticalPath");
        param.getParams().remove("lightType");
        param.getOrderMap().clear();
        param.setPageIndex(-1);
        return this.feignUtil.queryProjects(param);
    }

    public List<ProjectLightVO> orderMapToSort(List<ProjectLightVO> list, String orderType) {
        list.sort((o1, o2) -> {
            BigDecimal sufNum;
            BigDecimal preNum = o1.getDiffValue() == null ? BigDecimal.ZERO : o1.getDiffValue();
            BigDecimal bigDecimal = sufNum = o2.getDiffValue() == null ? BigDecimal.ZERO : o2.getDiffValue();
            if (orderType.equals("asc")) {
                if (preNum.compareTo(sufNum) > 0) {
                    return 1;
                }
                if (preNum.compareTo(sufNum) < 0) {
                    return -1;
                }
                return 0;
            }
            if (preNum.compareTo(sufNum) > 0) {
                return -1;
            }
            if (preNum.compareTo(sufNum) < 0) {
                return 1;
            }
            return 0;
        });
        return list;
    }

    @Override
    public ProjectLightVO getProjectInfoNotLight(Long projectId) {
        ProjectLightVO projectLightVO = new ProjectLightVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProjectLightEntity::getProjectId, (Object)projectId);
        ProjectLightEntity projectLightEntity = (ProjectLightEntity)((Object)super.getOne((Wrapper)queryWrapper));
        if (null != projectLightEntity) {
            projectLightVO = (ProjectLightVO)BeanMapper.map((Object)((Object)projectLightEntity), ProjectLightVO.class);
        }
        ProjectVO projectVO = (ProjectVO)this.projectApi.queryDetailById(projectId).getData();
        EmployeeVO employee = new EmployeeVO();
        if (projectVO != null && projectVO.getLeader() != null) {
            Long userId = projectVO.getLeader();
            CommonResponse userResp = this.employeeApi.queryEmployeByUserId(userId);
            if (!userResp.isSuccess()) {
                throw new BusinessException(userResp.getMsg());
            }
            if (userResp.getData() != null) {
                employee = (EmployeeVO)userResp.getData();
            }
        }
        projectLightVO.setProjectId(projectVO.getId());
        projectLightVO.setProjectName(projectVO.getProjectName());
        projectLightVO.setProjectCode(projectVO.getBillCode());
        projectLightVO.setProjectCategory(projectVO.getProjectCategory());
        projectLightVO.setProjectManager(employee.getId());
        projectLightVO.setProjectManagerName(employee.getUserName());
        projectLightVO.setMobilePhone(employee.getMobilePhone());
        projectLightVO.setEndDate(projectVO.getEndDate());
        projectLightVO.setActualEndDate(projectVO.getActualEndDate());
        projectLightVO.setProjectControlLevel(projectVO.getProjectControlLevel());
        return projectLightVO;
    }

    @Override
    public JSONObject numMap(Long orgId, Integer orgType) {
        Object queryParam;
        Map<Object, Object> blueProjectLightMap = new TreeMap();
        Map<Object, Object> yellowProjectLightMap = new TreeMap();
        Map<Object, Object> redProjectLightMap = new TreeMap();
        ArrayList areaList = new ArrayList();
        List<Object> projectList = this.feignUtil.queryProjectsByOrgId(orgId);
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
            List list = this.execPlanService.queryList((QueryParam)queryParam);
            Map<Long, ExecPlanEntity> execMap = list.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
            projectList = projectList.stream().filter(x -> execMap.containsKey(x.getId())).collect(Collectors.toList());
            List projectLightList = this.projectLightService.queryList((QueryParam)queryParam);
            projectLightList = projectLightList.stream().filter(x -> execMap.containsKey(x.getProjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(projectLightList)) {
                List blueProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.\u84dd\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List yellowProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.\u9ec4\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List redProjectLightList = projectLightList.stream().filter(e -> LightTypeEnum.\u7ea2\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(blueProjectLightList)) {
                    blueProjectLightMap = blueProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
                if (CollectionUtils.isNotEmpty(yellowProjectLightList)) {
                    yellowProjectLightMap = yellowProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
                if (CollectionUtils.isNotEmpty(redProjectLightList)) {
                    redProjectLightMap = redProjectLightList.stream().collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
                }
            }
        } else {
            projectList = new ArrayList<ProjectVO>();
        }
        if (CollectionUtils.isNotEmpty(projectList)) {
            for (ProjectVO projectVO : projectList) {
                HashMap<String, Object> areaMap = new HashMap<String, Object>();
                areaMap.put("lat", projectVO.getLat());
                areaMap.put("lng", projectVO.getLng());
                areaMap.put("projectName", projectVO.getProjectName());
                areaMap.put("id", projectVO.getId());
                if (blueProjectLightMap.keySet().contains(projectVO.getId())) {
                    areaMap.put("light", LightTypeEnum.\u84dd\u706f.getCode());
                }
                if (yellowProjectLightMap.keySet().contains(projectVO.getId())) {
                    areaMap.put("light", LightTypeEnum.\u9ec4\u706f.getCode());
                }
                if (redProjectLightMap.keySet().contains(projectVO.getId())) {
                    areaMap.put("light", LightTypeEnum.\u7ea2\u706f.getCode());
                }
                areaList.add(areaMap);
            }
        }
        queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("create_time", "asc");
        List list = this.lightRuleService.queryList((QueryParam)queryParam);
        LightRuleLevelEntity level = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            LightRuleEntity rule = (LightRuleEntity)((Object)this.lightRuleService.selectById(((LightRuleEntity)((Object)list.get(0))).getId()));
            level = rule.getDetailList().stream().filter(x -> x.getLevel() == 4).findAny().orElse(null);
        }
        String buleContent = "";
        String yellowContent = "";
        String redContent = "";
        if (level != null) {
            buleContent = "\u84dd\u8272\u9884\u8b66\uff1a";
            yellowContent = "\u9ec4\u8272\u9884\u8b66\uff1a";
            redContent = "\u7ea2\u8272\u9884\u8b66\uff1a";
            if (level.getBlueDiffSelect() == PlanConstant.INTEGER_YES) {
                buleContent = buleContent + "\u504f\u5dee\u65e5\u671f/\u8282\u70b9\u5269\u4f59\u5de5\u671f \uff1e " + level.getBlueDiffMin() + "\uff1b";
            }
            if (level.getBlueLightSelect() == PlanConstant.INTEGER_YES) {
                buleContent = buleContent + level.getBlueSumMin() + " =\uff1c \u504f\u5dee\u65e5\u671f \uff1c " + level.getBlueLightMin() + "\uff1b";
            }
            if (level.getYellowDiffSelect() == PlanConstant.INTEGER_YES) {
                yellowContent = yellowContent + "\u504f\u5dee\u65e5\u671f/\u8282\u70b9\u5269\u4f59\u5de5\u671f \uff1e " + level.getYellowDiffMin() + "\uff1b";
            }
            if (level.getYellowLightSelect() == PlanConstant.INTEGER_YES) {
                yellowContent = yellowContent + level.getYellowSumMin() + " =\uff1c \u504f\u5dee\u65e5\u671f \uff1c " + level.getYellowLightMin() + "\uff1b";
            }
            if (level.getRedDiffSelect() == PlanConstant.INTEGER_YES) {
                redContent = redContent + "\u504f\u5dee\u65e5\u671f/\u8282\u70b9\u5269\u4f59\u5de5\u671f \uff1e " + level.getRedDiffMin() + "\uff1b";
            }
            if (level.getRedLightSelect() == PlanConstant.INTEGER_YES) {
                redContent = redContent + level.getRedLightMin() + " =\uff1c \u504f\u5dee\u65e5\u671f\uff1b";
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("construction", (Object)projectList.size());
        jsonObject.put("normal", (Object)(projectList.size() - blueProjectLightMap.keySet().size() - yellowProjectLightMap.keySet().size() - redProjectLightMap.keySet().size()));
        jsonObject.put("blueLight", (Object)blueProjectLightMap.keySet().size());
        jsonObject.put("yellowLight", (Object)yellowProjectLightMap.keySet().size());
        jsonObject.put("redLight", (Object)redProjectLightMap.keySet().size());
        jsonObject.put("projects", areaList);
        jsonObject.put("buleContent", (Object)buleContent);
        jsonObject.put("yellowContent", (Object)yellowContent);
        jsonObject.put("redContent", (Object)redContent);
        return jsonObject;
    }

    @Override
    public JSONObject getProjectLightInfo(Long orgId, Integer orgType) {
        ArrayList<WarnProjectVO> focusProjectList = new ArrayList<WarnProjectVO>();
        ArrayList<WarnProjectVO> keySupervisionProjectList = new ArrayList<WarnProjectVO>();
        ArrayList focusContractList = new ArrayList();
        List<Object> projectList = this.feignUtil.queryProjectsByOrgId(orgId);
        if (CollectionUtils.isNotEmpty(projectList)) {
            Map orgMap = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("in", new ArrayList<Long>(orgMap.keySet())));
            List execList = this.execPlanService.queryList(queryParam);
            List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
            projectList = projectList.stream().filter(x -> execMap.containsKey(x.getId())).collect(Collectors.toList());
            Map projectMap = projectList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            List projectLightList = this.projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x -> execMap.containsKey(x.getProjectId())).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter("in", execIds));
            detailParam.getParams().put("node_level", new Parameter("eq", (Object)PlanConstant.LEVEL_CONTRACT));
            List execDetailList = this.execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo -> {
                if (execMap.containsKey(vo.getProjectId())) {
                    List<ExecPlanDetailEntity> detail = ((ExecPlanEntity)((Object)((Object)execMap.get(vo.getProjectId())))).getAllList();
                    detail.add((ExecPlanDetailEntity)((Object)vo));
                }
            });
            if (CollectionUtils.isNotEmpty(projectLightList)) {
                MonthLightEntity monthLightEntity;
                Date monthFirstDate;
                Integer contractSurplusDays;
                ProjectVO projectVO;
                WarnProjectVO warnProjectVO;
                List focusProjectLightList = projectLightList.stream().filter(e -> "\u91cd\u70b9\u9879\u76ee".equals(this.getDefDocById(e.getProjectType()).getName())).collect(Collectors.toList());
                List keySupervisionProjectLightList = projectLightList.stream().filter(e -> "\u91cd\u70b9\u76d1\u7ba1\u9879\u76ee".equals(this.getDefDocById(e.getProjectType()).getName())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(focusProjectLightList)) {
                    for (ProjectLightEntity projectLight : focusProjectLightList) {
                        List<ExecPlanDetailEntity> detailList;
                        if (!projectMap.containsKey(projectLight.getProjectId())) continue;
                        warnProjectVO = new WarnProjectVO();
                        projectVO = (ProjectVO)projectMap.get(projectLight.getProjectId());
                        contractSurplusDays = DateUtil.getBetweenDays(projectVO.getEndDate(), new Date());
                        monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                        monthLightEntity = (MonthLightEntity)((Object)this.monthLightService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MonthLightEntity::getProjectId, (Object)projectVO.getId())).eq(MonthLightEntity::getPlanMonth, (Object)monthFirstDate)));
                        warnProjectVO.setProjectName(projectVO.getProjectName());
                        warnProjectVO.setProjectId(projectVO.getId());
                        warnProjectVO.setOrgId(projectVO.getProjectDepartmentId());
                        warnProjectVO.setOrgName(((OrgVO)orgMap.get(projectVO.getProjectDepartmentId())).getName());
                        warnProjectVO.setProjectLight(projectLight.getLightType());
                        warnProjectVO.setProjectDays(projectLight.getDiffValue());
                        if (null != monthLightEntity) {
                            warnProjectVO.setMonthLight(monthLightEntity.getLightType());
                            warnProjectVO.setMonthDays(monthLightEntity.getDiffValue());
                        }
                        warnProjectVO.setContractSurplusDays(contractSurplusDays != null ? new BigDecimal(contractSurplusDays) : null);
                        focusProjectList.add(warnProjectVO);
                        Integer allSum = 0;
                        Integer normalSum = 0;
                        Integer blueSum = 0;
                        Integer yellowSum = 0;
                        Integer redSum = 0;
                        Integer violetSum = 0;
                        if (!execMap.containsKey(projectVO.getId()) || CollectionUtils.isEmpty(detailList = execMap.get(projectVO.getId()).getAllList())) continue;
                        allSum = detailList.size();
                        List blueDetailList = detailList.stream().filter(e -> LightTypeEnum.\u84dd\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                        List yellowDetailList = detailList.stream().filter(e -> LightTypeEnum.\u9ec4\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                        List redDetailList = detailList.stream().filter(e -> LightTypeEnum.\u7ea2\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                        List violetDetailList = detailList.stream().filter(e -> LightTypeEnum.\u7d2b\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                        blueSum = CollectionUtils.isNotEmpty(blueDetailList) ? blueDetailList.size() : 0;
                        yellowSum = CollectionUtils.isNotEmpty(yellowDetailList) ? yellowDetailList.size() : 0;
                        redSum = CollectionUtils.isNotEmpty(redDetailList) ? redDetailList.size() : 0;
                        violetSum = CollectionUtils.isNotEmpty(violetDetailList) ? violetDetailList.size() : 0;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("projectId", projectVO.getId());
                        map.put("projectName", projectVO.getProjectName());
                        map.put("allSum", allSum);
                        map.put("normalSum", allSum - blueSum - yellowSum - redSum - violetSum);
                        map.put("blueSum", blueSum);
                        map.put("yellowSum", yellowSum);
                        map.put("redSum", redSum);
                        map.put("violetSum", violetSum);
                        List normalDetailList = detailList.stream().filter(e -> !LightTypeEnum.\u84dd\u706f.getCode().equals(e.getLightType()) && !LightTypeEnum.\u9ec4\u706f.getCode().equals(e.getLightType()) && !LightTypeEnum.\u7ea2\u706f.getCode().equals(e.getLightType()) && !LightTypeEnum.\u7d2b\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                        map.put("normalDetailList", normalDetailList);
                        map.put("blueDetailList", blueDetailList);
                        map.put("yellowDetailList", yellowDetailList);
                        map.put("redDetailList", redDetailList);
                        map.put("violetDetailList", violetDetailList);
                        focusContractList.add(map);
                    }
                }
                if (CollectionUtils.isNotEmpty(keySupervisionProjectLightList)) {
                    for (ProjectLightEntity projectLight : keySupervisionProjectLightList) {
                        if (!projectMap.containsKey(projectLight.getProjectId())) continue;
                        warnProjectVO = new WarnProjectVO();
                        projectVO = (ProjectVO)projectMap.get(projectLight.getProjectId());
                        contractSurplusDays = DateUtil.getBetweenDays(projectVO.getEndDate(), new Date());
                        monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                        monthLightEntity = (MonthLightEntity)((Object)this.monthLightService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MonthLightEntity::getProjectId, (Object)projectVO.getId())).eq(MonthLightEntity::getPlanMonth, (Object)monthFirstDate)));
                        warnProjectVO.setProjectName(projectVO.getProjectName());
                        warnProjectVO.setProjectId(projectVO.getId());
                        warnProjectVO.setOrgId(projectVO.getProjectDepartmentId());
                        warnProjectVO.setOrgName(((OrgVO)orgMap.get(projectVO.getProjectDepartmentId())).getName());
                        warnProjectVO.setProjectLight(projectLight.getLightType());
                        warnProjectVO.setProjectDays(projectLight.getDiffValue());
                        if (null != monthLightEntity) {
                            warnProjectVO.setMonthLight(monthLightEntity.getLightType());
                            warnProjectVO.setMonthDays(monthLightEntity.getDiffValue());
                        }
                        warnProjectVO.setContractSurplusDays(new BigDecimal(contractSurplusDays));
                        keySupervisionProjectList.add(warnProjectVO);
                    }
                }
            }
        }
        JSONObject result = new JSONObject();
        result.put("focusProjectList", focusProjectList);
        result.put("keySupervisionProjectList", keySupervisionProjectList);
        result.put("focusContractList", focusContractList);
        return result;
    }

    public DefdocDetailVO getDefDocById(Long id) {
        if (id == null) {
            return new DefdocDetailVO();
        }
        CommonResponse resp = this.defdocApi.getDefDocById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (DefdocDetailVO)resp.getData();
    }

    @Override
    public List<Map> getCorpLightSum(Long orgId, Integer orgType) {
        ArrayList<Map> result = new ArrayList<Map>();
        List orgVOList = (List)this.orgApi.findChildrenByParentId(orgId).getData();
        String root = orgVOList.stream().filter(x -> orgId.equals(x.getId())).map(x -> x.getInnerCode()).findAny().orElse(null);
        Integer level = StringUtils.countMatches((CharSequence)root, (CharSequence)"|") + 1;
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            List<Object> projectVOList = this.feignUtil.queryProjectsByOrgId(orgId);
            Map orgMap = orgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("in", new ArrayList<Long>(orgMap.keySet())));
            List execList = this.execPlanService.queryList(queryParam);
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
            projectVOList = projectVOList.stream().filter(x -> execMap.containsKey(x.getId())).collect(Collectors.toList());
            List projectLightList = this.projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x -> execMap.containsKey(x.getProjectId())).collect(Collectors.toList());
            List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(execIds)) {
                QueryParam detailParam = new QueryParam();
                detailParam.getParams().put("progress_id", new Parameter("in", execIds));
                List detailList = this.execPlanDetailService.queryList(detailParam);
                detailList.forEach(vo -> {
                    if (execMap.containsKey(vo.getProjectId())) {
                        List<ExecPlanDetailEntity> detail = ((ExecPlanEntity)((Object)((Object)execMap.get(vo.getProjectId())))).getAllList();
                        detail.add((ExecPlanDetailEntity)((Object)vo));
                    }
                });
            }
            List contractLightList = this.contractLightService.queryList(queryParam);
            ArrayList violetLightContractList = contractLightList.stream().filter(e -> LightTypeEnum.\u7d2b\u706f.getCode().equals(e.getLightType())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContractLightEntity>(Comparator.comparing(s -> s.getProjectId()))), ArrayList::new));
            List corpOrgList = orgVOList.stream().filter(e -> 2 == e.getOrgType() && level == StringUtils.countMatches((CharSequence)e.getInnerCode(), (CharSequence)"|")).collect(Collectors.toList());
            for (OrgVO cropOrg : corpOrgList) {
                List cropChildrenOrgIdList = orgVOList.stream().filter(e -> e.getInnerCode().contains(cropOrg.getId().toString())).map(BaseVO::getId).collect(Collectors.toList());
                Integer allSum = 0;
                Integer normalSum = 0;
                Integer blueSum = 0;
                Integer yellowSum = 0;
                Integer redSum = 0;
                Integer violetSum = 0;
                List corpProjectList = projectVOList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getProjectDepartmentId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(corpProjectList)) continue;
                List lightList = projectLightList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).collect(Collectors.toList());
                List blueLightList = lightList.stream().filter(e -> LightTypeEnum.\u84dd\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List yellowLightList = lightList.stream().filter(e -> LightTypeEnum.\u9ec4\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List redLightList = lightList.stream().filter(e -> LightTypeEnum.\u7ea2\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList());
                List violetLightList = violetLightContractList.stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).collect(Collectors.toList());
                blueSum = CollectionUtils.isNotEmpty(blueLightList) ? blueLightList.size() : 0;
                yellowSum = CollectionUtils.isNotEmpty(yellowLightList) ? yellowLightList.size() : 0;
                redSum = CollectionUtils.isNotEmpty(redLightList) ? redLightList.size() : 0;
                violetSum = CollectionUtils.isNotEmpty(violetLightList) ? violetLightList.size() : 0;
                allSum = CollectionUtils.isNotEmpty(corpProjectList) ? corpProjectList.size() : 0;
                List contList = execMap.values().stream().filter(e -> cropChildrenOrgIdList.contains(e.getOrgId())).map(e -> e.getAllList()).flatMap(Collection::stream).filter(e -> LevelEnum.\u56db\u7ea7.getCode().equals(e.getNodeLevel())).collect(Collectors.toList());
                List shouldList = contList.stream().filter(e -> WarnDateUtil.compareDate(e.getPredictFinish(), new Date()) <= 0).collect(Collectors.toList());
                List finishList = contList.stream().filter(e -> e.getActualFinish() != null && WarnDateUtil.compareDate(e.getActualFinish(), new Date()) <= 0).collect(Collectors.toList());
                Integer contNum = CollectionUtils.isNotEmpty(contList) ? contList.size() : 0;
                Integer shouldNum = CollectionUtils.isNotEmpty(shouldList) ? shouldList.size() : 0;
                Integer finishNum = CollectionUtils.isNotEmpty(finishList) ? finishList.size() : 0;
                BigDecimal finishRate = ComputeUtil.bigDecimalPercent((Integer)finishNum, (Integer)shouldNum, (int)2);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", cropOrg.getId());
                map.put("orgName", cropOrg.getName());
                map.put("blueSum", blueSum);
                map.put("yellowSum", yellowSum);
                map.put("redSum", redSum);
                map.put("violetSum", violetSum);
                map.put("allSum", allSum);
                map.put("normalSum", allSum - blueSum - yellowSum - redSum);
                map.put("contNum", contNum);
                map.put("shouldNum", shouldNum);
                map.put("finishNum", finishNum);
                map.put("finishRate", finishRate);
                result.add(map);
            }
        }
        return result;
    }

    @Override
    public List<WarnProjectVO> getProjectLightSum(Long orgId, Integer orgType) {
        ArrayList<WarnProjectVO> result = new ArrayList();
        List orgVOList = (List)this.orgApi.findChildrenByParentId(orgId).getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            Map orgMap = orgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("in", new ArrayList<Long>(orgMap.keySet())));
            List execList = this.execPlanService.queryList(queryParam);
            if (CollectionUtils.isEmpty((Collection)execList)) {
                return result;
            }
            List execIds = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
            List projectLightList = this.projectLightService.queryList(queryParam);
            projectLightList = projectLightList.stream().filter(x -> execMap.containsKey(x.getProjectId())).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter("in", execIds));
            detailParam.getParams().put("node_level", new Parameter("eq", (Object)PlanConstant.LEVEL_CONTRACT));
            List execDetailList = this.execPlanDetailService.queryList(detailParam);
            execDetailList.forEach(vo -> {
                if (execMap.containsKey(vo.getProjectId())) {
                    List<ExecPlanDetailEntity> detail = ((ExecPlanEntity)((Object)((Object)execMap.get(vo.getProjectId())))).getAllList();
                    detail.add((ExecPlanDetailEntity)((Object)vo));
                }
            });
            for (ProjectLightEntity projectLight : projectLightList) {
                List violetContractLevel;
                List<ExecPlanDetailEntity> execContractDetailList = execMap.get(projectLight.getProjectId()).getAllList();
                List collect = execContractDetailList.stream().filter(e -> null == e.getActualStart() || null == e.getActualFinish() || null != e.getLightType()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    collect = collect.stream().sorted(Comparator.comparing(ExecPlanDetailEntity::getPredictStart)).collect(Collectors.toList());
                }
                Integer sumWarn = CollectionUtils.isNotEmpty(violetContractLevel = execContractDetailList.stream().filter(e -> LightTypeEnum.\u7d2b\u706f.getCode().equals(e.getLightType())).collect(Collectors.toList())) ? violetContractLevel.size() : 0;
                Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
                MonthLightEntity monthLightEntity = (MonthLightEntity)((Object)this.monthLightService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MonthLightEntity::getProjectId, (Object)projectLight.getProjectId())).eq(MonthLightEntity::getPlanMonth, (Object)monthFirstDate)));
                WarnProjectVO vo2 = new WarnProjectVO();
                vo2.setProjectId(projectLight.getProjectId());
                vo2.setProjectName(projectLight.getProjectName());
                vo2.setProjectLight(projectLight.getLightType());
                if (null != monthLightEntity) {
                    vo2.setMonthLight(monthLightEntity.getLightType());
                }
                if (CollectionUtils.isNotEmpty(collect)) {
                    vo2.setContractLight(((ExecPlanDetailEntity)((Object)collect.get(0))).getLightType());
                }
                vo2.setSumWarn(new BigDecimal(sumWarn));
                vo2.setDiffValue(projectLight.getDiffValue());
                result.add(vo2);
            }
        }
        result = result.stream().sorted(Comparator.comparing(x -> x.getDiffValue(), Comparator.nullsFirst(BigDecimal::compareTo).reversed())).collect(Collectors.toList());
        return result;
    }

    @Override
    public JSONObject getProjectInfo(Long orgId) {
        JSONObject object = new JSONObject();
        CommonResponse response = this.projectApi.queryProjectByProjectDepartmentId(orgId);
        if (!response.isSuccess() || null == response.getData()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectVO projectVO = (ProjectVO)response.getData();
        EmployeeVO employeeVO = new EmployeeVO();
        CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(projectVO.getLeader());
        if (employeeResponse.isSuccess() && null != employeeResponse.getData()) {
            employeeVO = (EmployeeVO)employeeResponse.getData();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectVO.getId()));
        ExecPlanEntity exec = this.execPlanService.queryList(queryParam).stream().findAny().orElse(null);
        if (exec != null) {
            projectVO.setStartDate(exec.getPlanBeginDate());
            projectVO.setEndDate(exec.getPlanEndDate());
        }
        object.put("projectId", (Object)projectVO.getId());
        object.put("projectName", (Object)projectVO.getProjectName());
        object.put("projectCode", (Object)projectVO.getBillCode());
        object.put("projectCategory", (Object)this.getDefDocById(projectVO.getProjectCategory()).getName());
        object.put("leader", (Object)employeeVO.getUserName());
        object.put("mobilePhone", (Object)employeeVO.getMobilePhone());
        object.put("startDate", (Object)sdf.format(projectVO.getStartDate()));
        object.put("endDate", (Object)sdf.format(projectVO.getEndDate()));
        object.put("projectControlLevel", (Object)this.getDefDocById(projectVO.getProjectControlLevel()).getName());
        object.put("projectStatus", (Object)projectVO.getStatus());
        return object;
    }

    @Override
    public List<ExecPlanDetailVO> getMonthFirstLevel(Long orgId) {
        ArrayList<ExecPlanDetailVO> result = new ArrayList<ExecPlanDetailVO>();
        CommonResponse response = this.projectApi.queryProjectByProjectDepartmentId(orgId);
        if (!response.isSuccess() || null == response.getData()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectVO projectVO = (ProjectVO)response.getData();
        Date monthFirstDate = DateUtil.getMonthFirstDate(new Date());
        LambdaQueryWrapper monthQueryWrapper = new LambdaQueryWrapper();
        monthQueryWrapper.eq(MonthPlanEntity::getProjectId, (Object)projectVO.getId());
        monthQueryWrapper.eq(MonthPlanEntity::getPlanMonth, (Object)monthFirstDate);
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.getOne((Wrapper)monthQueryWrapper));
        if (null == monthPlanEntity) {
            return result;
        }
        List monthDetailList = this.monthPlanDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)monthPlanEntity.getId())).orderByAsc((Object)"tid"));
        List monthFirstLevelList = monthDetailList.stream().filter(e -> PlanConstant.LEVEL_FIRST == e.getNodeLevel()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(monthFirstLevelList)) {
            return result;
        }
        Map monthFirstLevelMap = monthFirstLevelList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, Function.identity()));
        ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectVO.getId())));
        if (null != execPlanEntity) {
            List execDetailList = this.execPlanDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)execPlanEntity.getId())).orderByAsc((Object)"tid"));
            List detailList = execDetailList.stream().filter(e -> null != monthFirstLevelMap.get(e.getStructCode())).collect(Collectors.toList());
            for (ExecPlanDetailEntity entity : detailList) {
                ExecPlanDetailVO execPlanDetail = ExecPlanDetailEntity.convertEntityToVo(entity);
                Integer status = null;
                if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()) {
                    status = FillConstant.NOT_STAR;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()) {
                    status = FillConstant.UNDERWAY;
                }
                if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()) {
                    status = FillConstant.FINISHED;
                }
                execPlanDetail.setFinishState(status);
                result.add(execPlanDetail);
            }
        }
        return result;
    }

    @Override
    public List<JSONObject> getMapProjectList(Long orgId, Integer lightType) {
        ArrayList<JSONObject> result = new ArrayList();
        List<ProjectVO> data = this.feignUtil.queryProjectsByOrgId(orgId);
        List<Long> deptIds = data.stream().map(ProjectVO::getProjectDepartmentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(data)) {
            Map<Long, OrgVO> corpMap = this.orgUtil.getCorpMapByIds(deptIds);
            List orgVOList = (List)this.orgApi.findChildrenByParentId(orgId).getData();
            Map orgMap = orgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("in", new ArrayList<Long>(orgMap.keySet())));
            List execList = this.execPlanService.queryList(queryParam);
            Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, x -> x));
            List projectLightList = this.projectLightService.queryList(queryParam);
            Map collect = projectLightList.stream().filter(x -> execMap.containsKey(x.getProjectId())).collect(Collectors.toMap(ProjectLightEntity::getProjectId, Function.identity()));
            for (ProjectVO vo : data) {
                Integer light = null;
                BigDecimal diffValue = null;
                if (!collect.containsKey(vo.getId())) continue;
                ProjectLightEntity projectLightEntity = (ProjectLightEntity)((Object)collect.get(vo.getId()));
                light = projectLightEntity.getLightType();
                diffValue = projectLightEntity.getDiffValue();
                if (null != lightType && light != lightType && null != light) continue;
                JSONObject object = new JSONObject();
                object.put("projectId", (Object)vo.getId());
                object.put("projectName", (Object)vo.getProjectName());
                object.put("orgName", corpMap.containsKey(vo.getProjectDepartmentId()) ? corpMap.get(vo.getProjectDepartmentId()).getName() : null);
                object.put("projectControlLevelName", (Object)this.getDefDocById(vo.getProjectControlLevel()).getName());
                object.put("projectCategory", (Object)this.getDefDocById(vo.getProjectCategory()).getName());
                object.put("lightType", (Object)light);
                object.put("diffValue", (Object)diffValue);
                result.add(object);
            }
        }
        result = result.stream().sorted(Comparator.comparing(x -> x.getBigDecimal("diffValue"), Comparator.nullsFirst(BigDecimal::compareTo).reversed())).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<ProjectDynamicVO> projectDynamic(Long projectId) {
        return ((ProjectLightMapper)this.baseMapper).projectDynamic(projectId);
    }

    private static Integer subInteger(Integer num1, Integer num2) {
        if (num1 == null) {
            return num2;
        }
        if (num2 == null) {
            return num1;
        }
        return num1 - num2;
    }
}

