/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IYearPlanDetailService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.plan.vo.YearPlanDetailVO;
import com.ejianc.business.plan.vo.YearPlanVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"yearPlan"})
public class YearPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IYearPlanService service;
    @Autowired
    private IYearPlanDetailService detailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<YearPlanVO> saveOrUpdate(@RequestBody YearPlanVO saveOrUpdateVO) {
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        YearPlanVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YearPlanVO> queryDetail(Long id) {
        YearPlanVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearPlanVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<YearPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List yearPlanVOS = BeanMapper.mapList((Iterable)page.getRecords(), YearPlanVO.class);
        yearPlanVOS.stream().forEach(vo -> {
            vo.setChangeStatusName((String)PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setChangeVersionName("\u7b2c" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "\u7248");
        });
        pageData.setRecords(yearPlanVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("YearPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refYearPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<YearPlanVO>> refYearPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YearPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getxml"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return this.service.getxml(request);
    }

    @RequestMapping(value={"/exportxml"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        this.service.exportxml(response, vo);
    }

    @RequestMapping(value={"/generateYearPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YearPlanVO> generateYearPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(value="planYear") Integer planYear, @RequestParam(value="id", required=false) Long id, @RequestParam(value="changeFlag", required=false) Boolean changeFlag, @RequestParam(value="sourceId", required=false) Long sourceId) {
        if (BooleanUtils.isNotTrue((Boolean)changeFlag)) {
            YearPlanVO yearPlanVO = new YearPlanVO();
            yearPlanVO.setProjectId(projectId);
            yearPlanVO.setPlanYear(planYear);
            yearPlanVO.setId(id);
            this.service.validateYearPlan(yearPlanVO);
        }
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, planYear);
        Date yearFirstDate = c1.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(1, planYear);
        c2.roll(6, -1);
        Date yearLastDate = c2.getTime();
        Integer planState = BooleanUtils.isTrue((Boolean)changeFlag) ? PlanConstant.YEAR_PLAN : PlanConstant.TOTAL_PLAN;
        ExecPlanVO execPlanVO = this.execPlanService.queryRefDetail(projectId, planState, yearFirstDate, yearLastDate, changeFlag, true);
        List execlDetailList = execPlanVO.getProgressDetailList();
        List allExeclDetailList = execPlanVO.getAllList();
        if (CollectionUtils.isEmpty((Collection)execlDetailList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u7684\u603b\u8ba1\u5212\u5728" + planYear + "\u5e74\u6ca1\u6709\u8ba1\u5212\u8be6\u60c5\uff01");
        }
        execPlanVO.setProgressDetailList(null);
        YearPlanVO planVO = new YearPlanVO();
        BeanUtils.copyProperties((Object)execPlanVO, (Object)planVO);
        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        ArrayList<YearPlanDetailVO> list = new ArrayList<YearPlanDetailVO>();
        for (ExecPlanDetailVO vo : progressDetailList) {
            if (PlanConstant.YEAR_PLAN.equals(vo.getPlanState()) && vo.getSourceId().equals(sourceId)) {
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPercentTask())) {
                vo.setName(vo.getName() + vo.getPercentTask());
            }
            YearPlanDetailVO monthPlanDetailVO = new YearPlanDetailVO();
            BeanUtils.copyProperties((Object)vo, (Object)monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(monthPlanDetailVO);
        }
        List<ExecPlanDetailVO> allProgressDetailList = TreeHelper2.tree2List(allExeclDetailList);
        ArrayList<YearPlanDetailVO> allList = new ArrayList<YearPlanDetailVO>();
        for (ExecPlanDetailVO vo : allProgressDetailList) {
            if (PlanConstant.YEAR_PLAN.equals(vo.getPlanState()) && vo.getSourceId().equals(sourceId)) {
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPercentTask())) {
                vo.setName(vo.getName() + vo.getPercentTask());
            }
            YearPlanDetailVO monthPlanDetailVO = new YearPlanDetailVO();
            BeanUtils.copyProperties((Object)vo, (Object)monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            allList.add(monthPlanDetailVO);
        }
        List yearPlanTree = TreeHelper2.list2Tree(list);
        List allYearPlanTree = TreeHelper2.list2Tree(allList);
        planVO.setProgressDetailList(yearPlanTree);
        planVO.setAllList(allYearPlanTree);
        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success((Object)planVO);
    }
}

