/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanLockUtil {
    private static RedissonLocker redissonLocker;
    private static final String LOCK_KEY = "PLANKEY";

    @Autowired
    public void setRedissonLocker(RedissonLocker redissonLocker) {
        PlanLockUtil.redissonLocker = redissonLocker;
    }

    public static Boolean getLock(Long id) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(LOCK_KEY + id, TimeUnit.SECONDS, 30);
        return true;
    }

    public static void releaseLock(Long id) {
        if (id == null) {
            return;
        }
        redissonLocker.unlock(LOCK_KEY + id);
    }
}

