/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.progress.bean.PushSetEntity;
import com.ejianc.business.progress.bean.PushSetReceiveEntity;
import com.ejianc.business.progress.bean.RiskCorrectionDetailEntity;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.mapper.RiskCorrectionMapper;
import com.ejianc.business.progress.service.IPushSetReceiveService;
import com.ejianc.business.progress.service.IPushSetService;
import com.ejianc.business.progress.service.IRiskCorrectionDetailService;
import com.ejianc.business.progress.service.IRiskCorrectionHistoryService;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.business.progress.service.IRiskMessageService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="riskMsgService")
public class RiskMessageServiceImpl
extends BaseServiceImpl<RiskCorrectionMapper, RiskCorrectionEntity>
implements IRiskMessageService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IRiskCorrectionService riskService;
    @Autowired
    private IRiskCorrectionDetailService riskDetailService;
    @Autowired
    private IRiskCorrectionHistoryService historyService;
    @Autowired
    private IPushSetService pushSetService;
    @Autowired
    private IPushSetReceiveService receiveService;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private WarnFeignUtil feignUtil;

    @Override
    public CommonResponse riskWarn(HttpServletRequest request) {
        this.logger.info("--> \u7ea0\u504f\u9884\u8b66\u5f00\u59cb");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        String nextDay = sf.format(c.getTime());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("handleStatus", new Parameter("ne", (Object)"2"));
        queryParam.getParams().put("finishTime", new Parameter("lt", (Object)nextDay));
        List detailList = this.riskDetailService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("\u672a\u67e5\u5230\u5f85\u9884\u8b66\u5ef6\u8bef\u7ea0\u504f\uff01");
            return CommonResponse.success((String)"\u672a\u67e5\u5230\u5f85\u9884\u8b66\u5ef6\u8bef\u7ea0\u504f\uff01");
        }
        List ids = detailList.stream().map(RiskCorrectionDetailEntity::getRiskId).distinct().collect(Collectors.toList());
        Collection riskList = this.riskService.listByIds(ids);
        Map riskMap = riskList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        HashMap<Long, List<String>> senderMap = new HashMap<Long, List<String>>();
        for (RiskCorrectionDetailEntity detail : detailList) {
            Long riskId = detail.getRiskId();
            String createUserId = detail.getCreateUserId().toString();
            List<String> list = new ArrayList<String>();
            if (!senderMap.containsKey(riskId)) {
                list.add(createUserId);
                senderMap.put(riskId, list);
                continue;
            }
            list = (List)senderMap.get(riskId);
            if (list.contains(createUserId)) continue;
            list.add(createUserId);
        }
        if (CollectionUtils.isNotEmpty(senderMap)) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingList";
            for (Long key : senderMap.keySet()) {
                List sender = (List)senderMap.get(key);
                if (!riskMap.containsKey(key)) continue;
                RiskCorrectionEntity risk = (RiskCorrectionEntity)((Object)riskMap.get(key));
                StringBuffer buffer = new StringBuffer();
                buffer.append("\u3010" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + RiskMessageServiceImpl.getLevelName(risk.getNodeLevel()) + "\u3011");
                buffer.append("\u5ef6\u8bef\u7ea0\u504f\u63aa\u65bd\u5373\u5c06\u903e\u671f\uff0c\u8bf7\u767b\u5f55PC\u7aef\u5904\u7406\uff01");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
        }
        this.logger.info("\u6267\u884c\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @Override
    public Boolean riskByPushSet(RiskCorrectionEntity risk, Long orgId) {
        this.logger.info("--> \u63a8\u9001\u8bbe\u7f6e\u53d1\u9001\u6d88\u606f\u5f00\u59cb");
        if (risk.getProjectId() == null) {
            this.logger.info("\u9879\u76ee\u4e3a\u7a7a\uff01");
            return true;
        }
        CommonResponse projectResp = this.projectApi.queryDetailById(risk.getProjectId());
        if (!projectResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\uff01");
        }
        CommonResponse orgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!orgResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("org_id", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List setList = this.pushSetService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)setList)) {
            this.logger.info("\u672a\u67e5\u5230\u63a8\u9001\u8bbe\u7f6e\uff01");
            return true;
        }
        Map setMap = setList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("setId", new Parameter("in", setList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
        List receiveList = this.receiveService.queryList(queryParam2);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingList";
        for (PushSetReceiveEntity receive : receiveList) {
            if (!LevelEnum.\u672b\u7ea7.getCode().equals(receive.getLevel()) || !LightTypeEnum.\u7d2b\u706f.getCode().equals(receive.getLightType())) continue;
            PushSetEntity set = (PushSetEntity)((Object)setMap.get(receive.getSetId()));
            StringBuffer str = new StringBuffer();
            str.append("\u3010" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + RiskMessageServiceImpl.getLevelName(risk.getNodeLevel()) + "\u3011");
            str.append("\u5ef6\u8bef\u7ea0\u504f\u63aa\u65bd\u5373\u5c06\u903e\u671f\uff0c\u8bf7\u767b\u5f55PC\u7aef\u5904\u7406\uff01");
            List<Object> sender = new ArrayList();
            if (receive.getReceiveType().equals("user")) {
                sender = Arrays.asList(String.valueOf(receive.getReceiveId()));
            }
            if (receive.getReceiveType().equals("role")) {
                CommonResponse response = this.roleApi.getRoleUser(Arrays.asList(receive.getReceiveId()), Arrays.asList(orgId));
                if (!response.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\uff01");
                }
                sender = ((List)response.getData()).stream().map(RoleUserRelationVO::getUserId).map(String::valueOf).collect(Collectors.toList());
            }
            if (!CollectionUtils.isNotEmpty(sender)) continue;
            String subject = str.toString();
            String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        this.logger.info("\u6267\u884c\u6210\u529f\uff01");
        return true;
    }

    @Override
    public Boolean riskFinish(Long riskId) {
        this.logger.info("--> \u63a8\u9001\u8bbe\u7f6e\u53d1\u9001\u6d88\u606f\u5f00\u59cb");
        RiskCorrectionEntity risk = (RiskCorrectionEntity)((Object)this.riskService.selectById(riskId));
        if (!"3".equals(risk.getHandleStatus())) {
            this.logger.info("\u5ef6\u8bef\u7ea0\u504f\u672a\u5b8c\u6210\uff01");
            return true;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("risk_id", new Parameter("eq", (Object)riskId));
        List list = this.historyService.queryList(queryParam);
        ArrayList userIds = new ArrayList();
        list.forEach(vo -> {
            if (!InvocationInfoProxy.getUserid().equals(vo.getUserId()) && !userIds.contains(vo.getUserId())) {
                userIds.add(vo.getUserId());
            }
        });
        if (CollectionUtils.isNotEmpty(userIds)) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            StringBuffer str = new StringBuffer();
            str.append("\u3010" + risk.getProjectName() + "-" + risk.getYearBname() + "-" + RiskMessageServiceImpl.getLevelName(risk.getNodeLevel()) + "\u3011");
            str.append("\u7ea0\u504f\u5df2\u7ecf\u5b8c\u6210\uff0c\u8bf7\u767b\u5f55PC\u7aef\u67e5\u770b\u8be6\u60c5\uff01");
            List<String> sender = userIds.stream().map(String::valueOf).collect(Collectors.toList());
            String subject = str.toString();
            String formurl = this.baseHost + "ejc-zjkjprogress-frontend/#/CorrectionPendingDetail?id=" + riskId;
            String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        this.logger.info("\u6267\u884c\u6210\u529f\uff01");
        return true;
    }

    private static String getLevelName(Integer level) {
        String levelName = "";
        if (level == null) {
            return levelName;
        }
        switch (level) {
            case 1: {
                levelName = "\u4e00\u7ea7";
                break;
            }
            case 2: {
                levelName = "\u4e8c\u7ea7";
                break;
            }
            case 3: {
                levelName = "\u4e09\u7ea7";
                break;
            }
            case 4: {
                levelName = "\u5408\u540c";
                break;
            }
            case 5: {
                levelName = "\u7ea0\u504f";
                break;
            }
            default: {
                levelName = "";
            }
        }
        return levelName;
    }
}

