package com.ejianc.business.fill.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.bean.WeekFillEntity;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.fill.service.IMonthFillService;
import com.ejianc.business.fill.service.IPlanFillWarnService;
import com.ejianc.business.fill.service.IWeekFillService;
import com.ejianc.business.fill.vo.DayFillVO;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.mapper.ExecPlanMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.vo.YearPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.business.market.api.IZjkjProjectApi;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 计划/进度反馈预警
 *
 * @author generator
 */
@Service("planFillWarnService")
public class PlanFillWarnServiceImpl extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity> implements IPlanFillWarnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String TOTAL_URL = "/ejc-zjkjprogress-frontend/#/totalPlan/card";
    private static final String YEAR_URL = "/ejc-zjkjprogress-frontend/#/yearPlan/card";
    private static final String MONTH_URL = "/ejc-zjkjprogress-frontend/#/monthPlan/card";

    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWeekFillService weekFillService;
    @Autowired
    private IMonthFillService monthFillService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IDayFillService dayFillService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IZjkjProjectApi projectApi;

    @Override
    public CommonResponse<String> fillWarn(JSONArray jsonParam, Integer type, String url) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        //查询计划结束时间大于当前时间的所有执行计划
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        LambdaQueryWrapper<ExecPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.gt(ExecPlanEntity::getPlanEndDate,time);
        List<ExecPlanEntity> execList = execPlanService.list(queryWrapper);
        if (execList.isEmpty()) {
            return CommonResponse.success("任务接受处理成功！");
        }
        //查询进度反馈
        List<Long> execIds = execList.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toList());
        List<DayFillVO> list = new ArrayList<>();
        if (type == 0){
            //日反馈
            LambdaQueryWrapper<DayFillEntity> lambda = Wrappers.lambdaQuery();
            lambda.in(DayFillEntity::getProjectId,execIds);
            List<DayFillEntity> dayFillList = dayFillService.list(lambda);
            Map<Long,List<DayFillEntity>> dayFillMaps = dayFillList.stream().filter(item-> item.getProjectId()!=null).collect(Collectors.groupingBy(DayFillEntity::getProjectId));
            List<DayFillEntity> dayFills;
            List<Date> dateList;
            DayFillVO dvo;
            for (ExecPlanEntity execPlanEntity : execList) {
                if (!dayFillMaps.containsKey(execPlanEntity.getProjectId())){
                    dvo = BeanMapper.map(execPlanEntity,DayFillVO.class);
                    dvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),execPlanEntity.getCreateTime())));
                    list.add(dvo);
                }
            }
            for (Map.Entry<Long, List<DayFillEntity>> entry : dayFillMaps.entrySet()) {
                dayFills = entry.getValue();
                dateList = dayFills.stream().map(DayFillEntity::getCreateTime).collect(Collectors.toList());
                Date date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (DayFillEntity fill : dayFills) {
                    if (fill.getCreateTime().getTime() == date.getTime()){
                        dvo = BeanMapper.map(fill,DayFillVO.class);
                        dvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),fill.getCreateTime())));
                        list.add(dvo);
                        break;
                    }
                }
            }
        }else if (type == 1){
            //周反馈
            LambdaQueryWrapper<WeekFillEntity> lambda = Wrappers.lambdaQuery();
            lambda.in(WeekFillEntity::getProjectId,execIds);
            List<WeekFillEntity> fillList = weekFillService.list(lambda);
            Map<Long,List<WeekFillEntity>> fillMaps = fillList.stream().filter(item-> item.getProjectId()!=null).collect(Collectors.groupingBy(WeekFillEntity::getProjectId));
            List<WeekFillEntity> fills;
            List<Date> dateList;
            DayFillVO wvo;
            for (ExecPlanEntity execPlanEntity : execList) {
                if (!fillMaps.containsKey(execPlanEntity.getProjectId())){
                    wvo = BeanMapper.map(execPlanEntity,DayFillVO.class);
                    wvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),execPlanEntity.getCreateTime())));
                    list.add(wvo);
                }
            }
            for (Map.Entry<Long, List<WeekFillEntity>> entry : fillMaps.entrySet()) {
                fills = entry.getValue();
                dateList = fills.stream().map(WeekFillEntity::getCreateTime).collect(Collectors.toList());
                Date date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (WeekFillEntity fill : fills) {
                    if (fill.getCreateTime().getTime() == date.getTime()){
                        wvo = BeanMapper.map(fill,DayFillVO.class);
                        wvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),fill.getCreateTime())));
                        list.add(wvo);
                        break;
                    }
                }
            }
        }else {
            //月反馈
            LambdaQueryWrapper<MonthFillEntity> lambda = Wrappers.lambdaQuery();
            lambda.in(MonthFillEntity::getProjectId,execIds);
            List<MonthFillEntity> fillList = monthFillService.list(lambda);
            Map<Long,List<MonthFillEntity>> fillMaps = fillList.stream().filter(item-> item.getProjectId()!=null).collect(Collectors.groupingBy(MonthFillEntity::getProjectId));
            List<MonthFillEntity> fills;
            List<Date> dateList;
            DayFillVO mvo;
            for (ExecPlanEntity execPlanEntity : execList) {
                if (!fillMaps.containsKey(execPlanEntity.getProjectId())){
                    mvo = BeanMapper.map(execPlanEntity,DayFillVO.class);
                    mvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),execPlanEntity.getCreateTime())));
                    list.add(mvo);
                }
            }
            for (Map.Entry<Long, List<MonthFillEntity>> entry : fillMaps.entrySet()) {
                fills = entry.getValue();
                dateList = fills.stream().map(MonthFillEntity::getCreateTime).collect(Collectors.toList());
                Date date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (MonthFillEntity fill : fills) {
                    if (fill.getCreateTime().getTime() == date.getTime()){
                        mvo = BeanMapper.map(fill,DayFillVO.class);
                        mvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),fill.getCreateTime())));
                        list.add(mvo);
                        break;
                    }
                }
            }
        }
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            if (ListUtil.isNotEmpty(list)) {
                for (DayFillVO cvo : list) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (Boolean.TRUE.equals(set.getBoolean("default"))) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
//                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle(type==0?"日进度反馈":type==1?"周进度反馈":"月进度反馈");
                            vo.setPcUrl(url);
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            // orgName不能为空，否则在插入预警中心时会被过滤掉
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#days#", String.valueOf(cvo.getDays().intValue()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#days#", String.valueOf(cvo.getDays().intValue()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#days#", String.valueOf(cvo.getDays().intValue()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @Override
    public CommonResponse<String> totalPlanWarn(JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        //查询所有项目
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
        param.getParams().put("valid_status", new Parameter(QueryParam.EQ, 0)); // 启用
        CommonResponse<List<ProjectVO>> resp = projectApi.queryProjects(param);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectVO> data = resp.getData();
        List<Long> ids = data.stream().map(ProjectVO::getId).collect(Collectors.toList());
        //查询所有总计划
        LambdaQueryWrapper<TotalPlanEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(TotalPlanEntity::getProjectId,ids);
        List<TotalPlanEntity> list = totalPlanService.list(lambda);
        Map<Long,TotalPlanEntity> map = list.stream().collect(Collectors.toMap(TotalPlanEntity::getProjectId, a -> a,(k1, k2)->k1));
        List<ProjectVO> projectVOS = new ArrayList<>();
        for (ProjectVO datum : data) {
            if (!map.containsKey(datum.getId())){
                //当前日期-开工日期 相差天数 优先实际开工日期
                if(datum.getActualStartDate() == null && datum.getStartDate() == null){
                    continue;
                }
                datum.setFix(new BigDecimal(DateUtil.getBetweenDays(new Date(),datum.getActualStartDate()!=null?datum.getActualStartDate():datum.getStartDate())));
                projectVOS.add(datum);
            }
        }
        SimpleDateFormat sff = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            if (ListUtil.isNotEmpty(projectVOS)) {
                for (ProjectVO cvo : projectVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (Boolean.TRUE.equals(set.getBoolean("default"))) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle("总计划");
                            vo.setPcUrl(TOTAL_URL);
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            // orgName不能为空，否则在插入预警中心时会被过滤掉
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#startDate#", cvo.getActualStartDate()!=null?
                                                        sff.format(cvo.getActualStartDate()):sff.format(cvo.getStartDate()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#startDate#", cvo.getActualStartDate()!=null?sff.format(cvo.getActualStartDate()):sff.format(cvo.getStartDate()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#startDate#", cvo.getActualStartDate()!=null?sff.format(cvo.getActualStartDate()):sff.format(cvo.getStartDate()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @Override
    public CommonResponse<String> yearPlanWarn(JSONArray jsonParam,Integer type) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        List<YearPlanVO> resList = new ArrayList<>();
        //查询所有项目
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
        param.getParams().put("valid_status", new Parameter(QueryParam.EQ, 0)); // 启用
        CommonResponse<List<ProjectVO>> resp = projectApi.queryProjects(param);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectVO> data = resp.getData();
        List<Long> ids = data.stream().map(ProjectVO::getId).collect(Collectors.toList());
        //查询所有已生效计划结束时间大于当前时间的总计划
        LambdaQueryWrapper<TotalPlanEntity> lambda = Wrappers.lambdaQuery();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        lambda.in(TotalPlanEntity::getProjectId,ids);
        lambda.in(TotalPlanEntity::getBillState,1,3);
        lambda.gt(TotalPlanEntity::getPlanEndDate,time);
        List<TotalPlanEntity> list = totalPlanService.list(lambda);
        Map<Long,TotalPlanEntity> map = list.stream().collect(Collectors.toMap(TotalPlanEntity::getProjectId, a -> a,(k1, k2)->k1));
        //查询所有年计划
        LambdaQueryWrapper<YearPlanEntity> query = Wrappers.lambdaQuery();
        query.in(YearPlanEntity::getProjectId,ids);
        List<YearPlanEntity> yearList = yearPlanService.list(query);
        List<YearPlanVO> yearPlanVoS = BeanMapper.mapList(yearList,YearPlanVO.class);
        Map<Long, List<YearPlanVO>> maps = yearPlanVoS.stream().collect(Collectors.groupingBy(YearPlanVO::getProjectId));
        YearPlanVO yearPlanVO;
        List<YearPlanVO> years;
        List<Integer> yearLists;
        for (TotalPlanEntity entity : list) {
            if (type==0){
                if (!maps.containsKey(entity.getProjectId())){
                    yearPlanVO = BeanMapper.map(entity,YearPlanVO.class);
                    yearPlanVO.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(),entity.getApprovedTime())));
                    resList.add(yearPlanVO);
                }
            }else {
                if (maps.containsKey(entity.getProjectId())) {
                    //存在年计划
                    years = maps.get(entity.getProjectId());
                    yearLists = years.stream().map(YearPlanVO::getPlanYear).collect(Collectors.toList());
                    Integer maxYear = yearLists.stream().max(Integer::compareTo).orElse(0);
                    for (YearPlanVO vo : years) {
                        if (vo.getPlanYear().equals(maxYear)) {
                            resList.add(vo);
                            break;
                        }
                    }
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (ListUtil.isNotEmpty(resList)) {
                for (YearPlanVO cvo : resList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (Boolean.TRUE.equals(set.getBoolean("default"))) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                //不存在年计划
                                if (type==0){
                                    if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        high = true;
                                        useSetHigh = set;
                                    }
                                }else{
                                    cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                                    if (cvo.getPlanYear()<=cal.get(Calendar.YEAR)){
                                        high = true;
                                        useSetHigh = set;
                                    }
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (type==0) {
                                    if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        meddle = true;
                                        useSetMeddle = set;
                                    }
                                }else {
                                    cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                                    if (cvo.getPlanYear()<=cal.get(Calendar.YEAR)){
                                        meddle = true;
                                        useSetMeddle = set;
                                    }
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (type==0) {
                                    if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        low = true;
                                        useSetLow = set;
                                    }
                                }else {
                                    cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                                    if (cvo.getPlanYear()<=cal.get(Calendar.YEAR)){
                                        low = true;
                                        useSetLow = set;
                                    }
                                }
                            }
                        }
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle("年计划");
                            vo.setPcUrl(YEAR_URL);
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            // orgName不能为空，否则在插入预警中心时会被过滤掉
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#year#", type==0?String.valueOf(cal.get(Calendar.YEAR)):String.valueOf(cvo.getPlanYear()+1))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#year#", type==0?String.valueOf(cal.get(Calendar.YEAR)):String.valueOf(cvo.getPlanYear()+1))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#year#", type==0?String.valueOf(cal.get(Calendar.YEAR)):String.valueOf(cvo.getPlanYear()+1))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @Override
    public CommonResponse<String> monthPlanWarn(JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        //查询计划结束时间大于当前时间的所有执行计划
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        LambdaQueryWrapper<ExecPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.gt(ExecPlanEntity::getPlanEndDate,time);
        List<ExecPlanEntity> execList = super.list(queryWrapper);
        if (execList.isEmpty()) {
            return CommonResponse.success("任务接受处理成功！");
        }
        List<Long> ids = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
        //查询所有月计划
        LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(MonthPlanEntity::getSourceId,ids);
        List<MonthPlanEntity> list = monthPlanService.list(lambda);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, 1);
        String yf = String.valueOf(cal.get(Calendar.MONTH)+1);
        String xysj = format.format(cal.getTime())+"-01";
        Date sDate = new Date();
        try {
            sDate = format.parse(xysj);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        List<MonthPlanEntity> result;
        List<Date> dateList;
        List<MonthPlanEntity> resultList = new ArrayList<>();
        List<MonthPlanEntity> zzList = new ArrayList<>();
        MonthPlanEntity monthPlanEntity;
        Map<Long, List<MonthPlanEntity>> maps = list.stream().collect(Collectors.groupingBy(MonthPlanEntity::getProjectId));
        for (ExecPlanEntity entity : execList) {
            if (!maps.containsKey(entity.getProjectId())) {
                monthPlanEntity = BeanMapper.map(entity,MonthPlanEntity.class);
                zzList.add(monthPlanEntity);
            }
        }
        for (Map.Entry<Long, List<MonthPlanEntity>> entry : maps.entrySet()) {
            result = entry.getValue();
            dateList = result.stream().map(MonthPlanEntity::getPlanMonth).collect(Collectors.toList());
            Date maxDate = dateList.stream().max(Date::compareTo).orElse(new Date());
            for (MonthPlanEntity entity : result) {
                if (entity.getPlanMonth().getTime()==maxDate.getTime()){
                    resultList.add(entity);
                    break;
                }
            }
        }
        for (MonthPlanEntity planEntity : resultList) {
            if (planEntity.getPlanMonth().getTime()!=sDate.getTime()){
                zzList.add(planEntity);
            }
        }
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            if (ListUtil.isNotEmpty(zzList)) {
                for (MonthPlanEntity cvo : zzList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (Boolean.TRUE.equals(set.getBoolean("default"))) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                high = true;
                                useSetHigh = set;
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                low = true;
                                useSetLow = set;
                            }
                        }
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle("月计划");
                            vo.setPcUrl(MONTH_URL);
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            // orgName不能为空，否则在插入预警中心时会被过滤掉
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#month#", yf)
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#month#", yf)
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", cvo.getProjectName())
                                                .replaceAll("#month#", yf)
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
