package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.mapper.WeekPlanChangeDetailMapper;
import com.ejianc.business.plan.mapper.WeekPlanChangeMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.WeekPlanChangeVO;
import com.ejianc.business.plan.vo.WeekPlanChangeDetailVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 周计划变更
 * 
 * @author generator
 * 
 */
@Service("weekPlanChangeService")
public class WeekPlanChangeServiceImpl extends BaseServiceImpl<WeekPlanChangeMapper, WeekPlanChangeEntity> implements IWeekPlanChangeService{

    @Autowired
    private WeekPlanChangeMapper changeMapper;
    @Autowired
    private WeekPlanChangeDetailMapper detailChangeMapper;
    @Autowired
    private IWeekPlanChangeDetailService detailChangeService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IWeekPlanDetailService weekPlanDetailService;
    @Autowired
    private IWeekPlanChangeDetailService changeDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<WeekPlanChangeVO> saveOrUpdate(WeekPlanChangeVO saveOrUpdateVO) {
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());
        // todo 是否有校验
        Long tenantId = InvocationInfoProxy.getTenantid();
        WeekPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, WeekPlanChangeEntity.class);
            changeMapper.updateById(progressEntity);
            //子表
            List<WeekPlanChangeDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<WeekPlanChangeDetailVO> saveVOList = new ArrayList<WeekPlanChangeDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if(saveOrUpdateVO.getImportFlag()){
                    changeDetailService.deleteDetailByProgressId(progressEntity.getId());
                }
                for (WeekPlanChangeDetailVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        WeekPlanChangeDetailEntity progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.insert(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        WeekPlanChangeDetailEntity progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.updateById(progressDetailEntity);
                    }
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
            //子表删除
            List<WeekPlanChangeDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (WeekPlanChangeDetailVO progressDetailVo : delDetailList) {
                    detailChangeMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            WeekPlanEntity weekPlanEntity = weekPlanService.selectById(saveOrUpdateVO.getWeekId());
            if(weekPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING){
                throw new BusinessException("存在变更中单据，不允许保存!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, WeekPlanChangeEntity.class);
            progressEntity.setId(masterPkId);
            changeMapper.insert(progressEntity);
            //子表
            List<WeekPlanChangeDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<WeekPlanChangeDetailVO> saveVOList = new ArrayList<WeekPlanChangeDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList,true);

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                for (WeekPlanChangeDetailVO progressDetailVo : saveVOList) {
                    WeekPlanChangeDetailEntity progressDetailEntity = WeekPlanChangeDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    detailChangeMapper.insert(progressDetailEntity);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
            LambdaUpdateWrapper<WeekPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(WeekPlanEntity::getChangeId, progressEntity.getId());
            updateWrapper.set(WeekPlanEntity::getChangeStatus, PlanConstant.CHANGE_ING);
            updateWrapper.set(WeekPlanEntity::getChangeCode, progressEntity.getBillCode());
            updateWrapper.eq(WeekPlanEntity::getId, progressEntity.getWeekId());
            weekPlanService.update(updateWrapper);
        }
        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public WeekPlanChangeVO queryDetail(Long id) {
        WeekPlanChangeEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<WeekPlanChangeDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<WeekPlanChangeDetailEntity> progressDetailList = detailChangeService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        WeekPlanChangeVO progressVo = BeanMapper.map(progressEntity, WeekPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<WeekPlanChangeDetailVO> progressDetailVoList = new ArrayList<>();
            for (WeekPlanChangeDetailEntity progressDetailEntity : progressDetailList) {
                WeekPlanChangeDetailVO changeVO = WeekPlanChangeDetailEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public WeekPlanChangeVO queryDetailChange(Long id) {
        WeekPlanEntity progressEntity = weekPlanService.selectById(id);
        WeekPlanChangeVO vo = BeanMapper.map(progressEntity, WeekPlanChangeVO.class);
        //查询子表
        QueryWrapper<WeekPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<WeekPlanDetailEntity> progressDetailList = weekPlanDetailService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<WeekPlanChangeDetailVO> progressDetailVoList = new ArrayList<>();
            for (WeekPlanDetailEntity progressDetailEntity : progressDetailList) {
                WeekPlanChangeDetailEntity changeDetailEntity = BeanMapper.map(progressDetailEntity, WeekPlanChangeDetailEntity.class);
                changeDetailEntity.setWeekId(changeDetailEntity.getProgressId());
                changeDetailEntity.setWeekBid(changeDetailEntity.getId());
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                changeDetailEntity.setProgressId(null);
                WeekPlanChangeDetailVO changeVO = WeekPlanChangeDetailEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setWeekId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(vo.getChangeVersion() + 1);
        return vo;
    }

    @Override
    public void deleteWeekPlan(List<WeekPlanChangeVO> vos) {
        for (WeekPlanChangeVO vo : vos) {
            WeekPlanChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<WeekPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(WeekPlanEntity::getChangeStatus, PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(WeekPlanEntity::getChangeStatus, PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(WeekPlanEntity::getId, changeEntity.getWeekId());
            weekPlanService.update(updateWrapper);
            super.removeById(vo, false);
            detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<WeekPlanChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<WeekPlanChangeEntity> changeEntities = baseMapper.selectList(new QueryWrapper<WeekPlanChangeEntity>()
                .eq("week_id", id)
                .in("bill_state", billStatus).orderByDesc("approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<WeekPlanChangeVO> changeVos = BeanMapper.mapList(changeEntities, WeekPlanChangeVO.class);
            for (WeekPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(Long projectId, List<Long> ids) {
        LambdaQueryWrapper<WeekPlanDetailEntity> wlambd = new LambdaQueryWrapper<>();
        wlambd.in(WeekPlanDetailEntity::getId, ids);
        List<WeekPlanDetailEntity> list = weekPlanDetailService.list(wlambd);
        return commonHelper.transferDelIds(list, projectId, PlanConstant.WEEK_PLAN);
    }
}
