package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.WeekPlanHistoryEntity;
import com.ejianc.business.plan.bean.WeekPlanHistoryDetailEntity;
import com.ejianc.business.plan.service.IWeekPlanHistoryDetailService;
import com.ejianc.business.plan.vo.WeekPlanHistoryVO;
import com.ejianc.business.plan.vo.WeekPlanHistoryDetailVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.WeekPlanHistoryMapper;
import com.ejianc.business.plan.service.IWeekPlanHistoryService;

import java.util.ArrayList;
import java.util.List;

/**
 * 周计划历史
 * 
 * @author generator
 * 
 */
@Service("weekPlanHistoryService")
public class WeekPlanHistoryServiceImpl extends BaseServiceImpl<WeekPlanHistoryMapper, WeekPlanHistoryEntity> implements IWeekPlanHistoryService{

    @Autowired
    private IWeekPlanHistoryDetailService historyDetailService;

    @Override
    public WeekPlanHistoryVO queryDetailHistory(Long id) {
        WeekPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<WeekPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            WeekPlanHistoryVO historyVo = BeanMapper.map(historyEntity, WeekPlanHistoryVO.class);
            //查询子表
            QueryWrapper<WeekPlanHistoryDetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("progress_id", historyVo.getId());
            queryWrapper.orderByAsc("tid");
            List<WeekPlanHistoryDetailEntity> progressDetailList = historyDetailService.list(queryWrapper);

            if (progressDetailList != null && progressDetailList.size() > 0) {
                List<WeekPlanHistoryDetailVO> progressDetailVoList = new ArrayList<>();
                for (WeekPlanHistoryDetailEntity progressDetailEntity : progressDetailList) {
                    progressDetailVoList.add(WeekPlanHistoryDetailEntity.convertEntityToVo(progressDetailEntity));
                }
                historyVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
            }
            return historyVo;
        }
        return null;
    }
}
